<?php class Solicitud extends CI_Controller{

	public function __construct(){
			
		parent::__construct();
		$this->load->model("chatbot_model");
		header('Content-Type: text/html; charset=utf-8');
		
	}


	public function index(){

	
	}//termina index


	public function guardarComprobante(){

		if($this->input->get("id_solicitud")){


			date_default_timezone_set('America/Tijuana');

			$id_solicitud = $this->input->get("id_solicitud");
			$curp         = $this->input->get("curp");
			$id_paquete   = $this->input->get("id_paquete");


			$solicitud = $this->chatbot_model->getSolicitud($id_solicitud);
			
		
			$fromCustomer = true;
			$tiempo       = date("Y-m-d H:i");

			
			if(!is_null($solicitud)){


				$ruta_temporal = $solicitud->ruta;
				$cel           = $solicitud->celular;
				$extension     = $solicitud->extension;
				

				$nombre_archivo = $id_paquete."-Comprobante.".$extension;
				$nueva_ruta     = "static/uploads/".$nombre_archivo;


				$comprobante = $this->comprobantePDF($ruta_temporal, $id_paquete, $nueva_ruta);

				$update_s            = array();
				$update_s["estatus"] = 1;
				$this->chatbot_model->updateSolicitudes($update_s, $id_solicitud);


				if($comprobante == 200){


					if($this->moverArchivo($ruta_temporal, $nueva_ruta)){
					
						$message = "🎉 ¡Maravilloso!, hemos terminado de subir los datos 👏. Si quieres realizar otro registro oprime el siguiente botón 👇.";
						$this->mensaje_bot($message,$cel,$fromCustomer);
	
						$cabecera = "";
						$mensaje  = "Oprime el botón para iniciar a registrar 👇";
						$pie      = "";
			
						$options[] = array('type' => 'text', 'title' => 'Comenzar', "encodeText" => true);
						$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);
	
						
						$update_p                 = array();
						$update_p["pregunta_1"]   = NULL;
						$update_p["pregunta_2"]   = NULL;
						$update_p["pregunta_3"]   = NULL;
						$update_p["pregunta_4"]   = NULL;
						$update_p["curp"]         = NULL;
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						
						$this->chatbot_model->updatePregunta($cel,$update_p);
	
						$getNss     = $this->getNss($curp, $id_paquete);
						$return_nss = $getNss["return"];
						
						if($return_nss == 200){
				
							$nss = $getNss["nss"];
							$this->getHistorialImss($curp, $nss);
			
						}


					}else{
					
						
						$update_p                 = array();
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);
	
						$message = "Ocurrio un error al guardar la *Constancia* por favor vuelve a intentarlo";
						$this->mensaje_bot($message,$cel,$fromCustomer);

					}


				}else{

					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);
	
					$message = "No pude leer el comprobante de domicilio, asegurate que sea un archivo correcto por favor.";
					$this->mensaje_bot($message,$cel,$fromCustomer);

				}

			}//termina !is_null solicitud

		}//termina input->get

	}//termina guardarComprobante

	public function guardarConstancia(){

		if($this->input->get("id_solicitud")){

			$id_paquete = $this->input->get("id_paquete");

			date_default_timezone_set('America/Tijuana');

			$id_solicitud = $this->input->get("id_solicitud");
			$solicitud    = $this->chatbot_model->getSolicitud($id_solicitud);
			
			$fromCustomer = true;
			$tiempo       = date("Y-m-d H:i");
			

			if(!is_null($solicitud)){

				$ruta_temporal = $solicitud->ruta;
				$cel           = $solicitud->celular;
				$extension     = $solicitud->extension;

				if($extension == "pdf"){
					$tipo = "pdf";
					$ext  = "pdf";
				}else{
					$tipo = "imagen";
					$ext  = "jpeg";
				}

				$constancia = $this->constanciaPDF($ruta_temporal, $id_paquete, $tipo, $ext);
				$return     = $constancia["return"];
				

				$update_s            = array();
				$update_s["estatus"] = 1;
				$this->chatbot_model->updateSolicitudes($update_s, $id_solicitud);

				if($return == 200){

					$nombre_archivo = $id_paquete."-Constancia.".$ext;
					$nueva_ruta     = "static/uploads/".$nombre_archivo;
	
					// if($this->fileDownload($url, $file_path)){
					
					if($this->moverArchivo($ruta_temporal, $nueva_ruta)){
					

						$message = "¡Perfecto! por último comparteme una foto o documento del *comprobante de domicilio* 📄👇.";
						$this->mensaje_bot($message,$cel,$fromCustomer);
	
						$update_p                 = array();
						$update_p["pregunta_3"]   = "COMPROBANTE";
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);

					}else{
					
						
						$update_p                 = array();
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);
	
						$message = "Ocurrio un error al guardar la *Constancia* por favor vuelve a intentarlo";
						$this->mensaje_bot($message,$cel,$fromCustomer);

					}


				}else{

					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

					$message = "No pudimos leer la constancia, por favor intentalo con un archivo valido 📄👇.";
					$this->mensaje_bot($message,$cel,$fromCustomer);

				}





			}//termina !is_null solicitud
		
		}//termina input->get 


	}//termina guardarConstancia


	public function guardarIne(){

		if($this->input->get("id_solicitud")){

			date_default_timezone_set('America/Tijuana');

			$id_solicitud = $this->input->get("id_solicitud");
			$solicitud    = $this->chatbot_model->getSolicitud($id_solicitud);
			
			$fromCustomer = true;
			$tiempo       = date("Y-m-d H:i");
			

			if(!is_null($solicitud)){


				$ruta_temporal = $solicitud->ruta;
				$cel           = $solicitud->celular;

				$escanear           = $this->escanearINE($ruta_temporal, $cel);
				$return             = $escanear["return"];
				$id_paquete_archivo = $escanear["id_paquete_archivo"];
				$curp               = $escanear["curp"];
				
				$update_s            = array();
				$update_s["estatus"] = 1;
				
				$this->chatbot_model->updateSolicitudes($update_s, $id_solicitud);

				if($return == 200){

					$nombre_archivo = $id_paquete_archivo."-INE.jpeg";
					$nueva_ruta     = "static/uploads/".$nombre_archivo;
					
					if($this->moverArchivo($ruta_temporal, $nueva_ruta)){

						$message = "¡Muy bien! ahora comparte la *constancia de situación* fiscal en PDF o IMAGEN 📄📷👇.";
						$this->mensaje_bot($message,$cel,$fromCustomer);
	
						$update_p                 = array();
						$update_p["pregunta_2"]   = "CONSTANCIA";
						$update_p["conversacion"] = 1;
						$update_p["id_paquete"]   = $id_paquete_archivo;
						$update_p["curp"]         = $curp;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);

				
					}else{

						$update_p                 = array();
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);
	
						$message = "Ocurrio un error al guardar la *INE* por favor intenta con una foto más clara.";
						$this->mensaje_bot($message,$cel,$fromCustomer);

					}


				}else{

					$message = "No pudimos leer la *INE* por favor intenta con una foto más clara.";
					$this->mensaje_bot($message,$cel,$fromCustomer);
	
					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);


				}


			}//termina !is_null


		}	

	}//termina guardarIne

	public function moverArchivo($ruta_temporal, $nueva_ruta){

		if (file_exists($ruta_temporal)) {
			if (rename($ruta_temporal, $nueva_ruta)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}

	}//termina moverArchivo



  public function mensaje_bot($message,$numero,$fromCustomer){

	$ch = curl_init();

	curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);

	$payload = [
		'channel' => 'whatsapp',
		'source' => '5216648841034',
		'destination' => ''.$numero.'',
		'src.name' => 'bdreclu',
		'message' => json_encode(array('type' => 'text', 'text' => $message))
	];

	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

	$headers = array();
	$headers[] = 'Cache-Control: no-cache';
	$headers[] = 'Content-Type: application/x-www-form-urlencoded';
	$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	$result = curl_exec($ch);
	if (curl_errno($ch)) {
		echo 'Error:' . curl_error($ch);
	}
	curl_close($ch);

	// $message = nl2br($message);

}//termina mensaje_bot

  	public function escanearINE($image, $cel){

	
		$data       = file_get_contents($image);

		$string_b64 = base64_encode($data);
		
		$username   = "factorx";
		$password   = "x_i.E4h18";
		
		$ch         = curl_init();

		$datos = "";
		$datos = array(
			'id' => $string_b64 //SE ENVIA FOTO EN FORMATO BASE64
		);

		curl_setopt($ch, CURLOPT_URL, 'https://ine.nubarium.com/ocr/obtener_datos'); //URL ENDPOINT
		//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Cache-Control: no-cache';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS

		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		
		$json = json_decode($result, true);

		curl_close($ch);

		$return         = 500;
		$id_colaborador = null;
		$curp_return    = null;
		$nombre_return  = null;

		$curp             = NULL;
		$nombres          = NULL;
		$primerApellido   = NULL;
		$segundoApellido  = NULL;
		$calle            = NULL;
		$colonia          = NULL;
		$ciudad           = NULL;
		$sexo_colaborador = NULL;
		$fecha_nacimiento = NULL;
		$clave_elector    = NULL;

		$id_paquete_archivo = 0;
		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if (!array_key_exists("curp", $json)) {
			
			$return         = 500;
			$id_colaborador = null;
			$curp_return    = null;
			$curp           = null;

		}else{

			// header('Content-Type: application/json');
			// print_r($json);
			// die();
			$insert_pa                     = array();
			$insert_pa["nombre"]           = "Paquete";
			$insert_pa["celular_registro"] = $cel;
			$id_paquete_archivo            = $this->chatbot_model->insertPaqueteArchivo($insert_pa);
			

			$insert_a                       = array();
			$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
			$insert_a["url_archivo"]        = "static/uploads/".$id_paquete_archivo."-INE.jpeg";
			$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);
			
			
			$curp             = $json["curp"];
			$nombres          = $json["nombres"];
			$primerApellido   = $json["primerApellido"];
			$segundoApellido  = $json["segundoApellido"];
			$calle            = $json["calle"];
			$colonia          = $json["colonia"];
			$ciudad           = $json["ciudad"];
			$sexo_colaborador = $json["sexo"];
			$fecha_nacimiento = $json["fechaNacimiento"];
			$clave_elector    = $json["claveElector"];
			$date             = str_replace('/', '-', $fecha_nacimiento);
			$fecha_nacimiento = date('Y-m-d', strtotime($date));
			
			$insert_ine                       = array();
			$insert_ine["curp"]               = $curp;
			$insert_ine["nombres"]            = $nombres;
			$insert_ine["primerApellido"]     = $primerApellido;
			$insert_ine["segundoApellido"]    = $segundoApellido;
			$insert_ine["calle"]              = $calle;
			$insert_ine["colonia"]            = $colonia;
			$insert_ine["ciudad"]             = $ciudad;
			$insert_ine["sexo"]               = $sexo_colaborador;
			$insert_ine["fechaNacimiento"]    = $fecha_nacimiento;
			$insert_ine["claveElector"]       = $clave_elector;
			$insert_ine["id_archivo"]         = $id_archivo;
			$insert_ine["id_paquete_archivo"] = $id_paquete_archivo;
			$insert_ine["celular_alta"]       = $cel;
			$insert_ine["estatus_cron"]       = 0;
			
			$insert_i = $this->chatbot_model->insertDatosIne($insert_ine);

			if(!is_null($insert_i)){
				$return = 200;
			}

		}//termina else isset

		// var_dump(array("return" => $return, "curp" => $curp, "id_paquete_archivo" => $id_paquete_archivo));
		// echo "código: ".$return." id_colaborador: ".$id_colaborador." curp: ".$curp_return;
		// echo "return: ".$return;
		return array("return" => $return, "curp" => $curp, "id_paquete_archivo" => $id_paquete_archivo);


	}//termina escanearINE


	  // public function constanciaPDF(){

	// 	$url                = "https://raasmex.com.mx/bd/static/uploads/temporal/constancia.pdf";
	// 	$id_paquete_archivo = 1;

	public function constanciaPDF($url, $id_paquete_archivo, $tipo, $ext){
			


		$data       = file_get_contents($url);
		
	
		$string_b64 = base64_encode($data);
		
		$username   = "factorx";
		$password   = "x_i.E4h18";
		
		$ch         = curl_init();

		$datos = "";
		$datos = array(
			'documento' => $string_b64, //SE ENVIA FOTO EN FORMATO BASE64
			'tipo' => $tipo //imagen o pdf
		);

		curl_setopt($ch, CURLOPT_URL, 'https://api.nubarium.com/sat/v1/consultar_cif'); //URL ENDPOINT
		//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Cache-Control: no-cache';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS
	
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}
		
		$json = json_decode($result, true);

		$return = 400;
		$curp   = null;


		$rfc                        = NULL;
		$apellidoMaterno            = NULL;
		$apellidoPaterno            = NULL;
		$curp                       = NULL;
		$fechaInicioOperaciones     = NULL;
		$fechaNacimiento            = NULL;
		$fechaUltimoCambioSituacion = NULL;
		$nombres                    = NULL;
		$situacionContribuyente     = NULL;
		$colonia                    = NULL;
		$correoElectronico          = NULL;
		$cp                         = NULL;
		$entidadFederativa          = NULL;
		$municipioDelegacion        = NULL;
		$nombreVialidad             = NULL;
		$numeroExterior             = NULL;
		$numeroInterior             = NULL;

		$insert_constancia = NULL;

		// header('Content-Type: application/json');
		// print_r($result);
		// die("fk");

		if(is_array($json)){

			if(array_key_exists("datosIdentificacion", $json)){

				$apellidoMaterno            = $json["datosIdentificacion"]["apellidoMaterno"];
				$apellidoPaterno            = $json["datosIdentificacion"]["apellidoPaterno"];
				$curp                       = $json["datosIdentificacion"]["curp"];
				$fechaInicioOperaciones     = $json["datosIdentificacion"]["fechaInicioOperaciones"];
				$fechaNacimiento            = $json["datosIdentificacion"]["fechaNacimiento"];
				$fechaUltimoCambioSituacion = $json["datosIdentificacion"]["fechaUltimoCambioSituacion"];
				$nombres                    = $json["datosIdentificacion"]["nombres"];
				$situacionContribuyente     = $json["datosIdentificacion"]["situacionContribuyente"];
	
				$return = 200;
	
			}else{
				$return = 400;
				$curp   = null;
			}
	
			if(array_key_exists("datosUbicacion", $json)){
	
				$colonia                    = $json["datosUbicacion"]["colonia"];
				$correoElectronico          = $json["datosUbicacion"]["correoElectronico"];
				$cp                         = $json["datosUbicacion"]["cp"];
				$entidadFederativa          = $json["datosUbicacion"]["entidadFederativa"];
				$municipioDelegacion        = $json["datosUbicacion"]["municipioDelegacion"];
				$nombreVialidad             = $json["datosUbicacion"]["nombreVialidad"];
				$numeroExterior             = $json["datosUbicacion"]["numeroExterior"];
				$numeroInterior             = $json["datosUbicacion"]["numeroInterior"];
				$return = 200;
	
			}else{
				$return = 400;
				$curp   = null;
			}
	
	
			if (array_key_exists("caracteristicasFiscales", $json)) {
	
	
				$insert_a                       = array();
				$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
				$insert_a["url_archivo"]        = "static/uploads/".$id_paquete_archivo."-Constancia.".$ext;
				$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);
	
				$datos = $json["caracteristicasFiscales"];
			
				// ✅ Validamos que sea array
				if (!is_array($datos)) {
					$datos = json_decode(json_encode($datos), true); // Convertir a array si es objeto
				}
			
				$getRegimen = $this->chatbot_model->getRegimenFiscal($id_paquete_archivo);
			
				if (is_null($getRegimen)) { // Si es null entonces insertamos
			
					foreach ($datos as $item) {
						if (is_array($item)) { // ✅ Validamos que $item sea array
							$codigo       = $item['codigo'] ?? null;
							$descripcion  = $item['regimen'] ?? null;
							$fechaAlta    = $item['fechaAlta'] ?? null;
			
							$insert_r = array(
								"regimen"            => $descripcion,
								"codigo"             => $codigo,
								"fechaAlta"          => $fechaAlta,
								"id_paquete_archivo" => $id_paquete_archivo
							);
			
							$this->chatbot_model->insertRegimenFiscal($insert_r);
						} else {
							// log_message('error', 'Elemento inválido en caracteristicasFiscales: ' . print_r($item, true));
						}
					} // foreach
				} // termina is_null
			}
			
	
			if(array_key_exists("rfc", $json)){
				$rfc = $json["rfc"];
			}
	
			if($return == 200){
	
				$insert_c = array();
	
				$fechaUltimoCambioSituacion       = str_replace('/', '-', $fechaUltimoCambioSituacion);
				$fechaUltimoCambioSituacion_final = date('Y-m-d', strtotime($fechaUltimoCambioSituacion));
				
				
				$fechaNacimiento       = str_replace('/', '-', $fechaNacimiento);
				$fechaNacimiento_final = date('Y-m-d', strtotime($fechaNacimiento));
				
				$fechaInicioOperaciones       = str_replace('/', '-', $fechaInicioOperaciones);
				$fechaInicioOperaciones_final = date('Y-m-d', strtotime($fechaInicioOperaciones));
	
				$insert_c["apellidoMaterno"]            = $apellidoMaterno;
				$insert_c["apellidoPaterno"]            = $apellidoPaterno;
				$insert_c["curp"]                       = $curp;
				$insert_c["fechaInicioOperaciones"]     = $fechaInicioOperaciones_final;
				$insert_c["fechaNacimiento"]            = $fechaNacimiento_final;
				$insert_c["fechaUltimoCambioSituacion"] = $fechaUltimoCambioSituacion_final;
				$insert_c["nombres"]                    = $nombres;
				$insert_c["situacionContribuyente"]     = $situacionContribuyente;
				$insert_c["colonia"]                    = $colonia;
				$insert_c["correoElectronico"]          = $correoElectronico;
				$insert_c["cp"]                         = $cp;
				$insert_c["entidadFederativa"]          = $entidadFederativa;
				$insert_c["municipioDelegacion"]        = $municipioDelegacion;
				$insert_c["nombreVialidad"]             = $nombreVialidad;
				$insert_c["numeroExterior"]             = $numeroExterior;
				$insert_c["numeroInterior"]             = $numeroInterior;
				$insert_c["rfc"]                        = $rfc;
				$insert_c["id_archivo"]                 = $id_archivo;
				$insert_c["id_paquete_archivo"]         = $id_paquete_archivo;
				
				$insert_constancia =  $this->chatbot_model->insertDatosConstancia($insert_c);
			}


		}else{
			$return = 400;
		}

		
		if(!is_null($insert_constancia)){
			$return = 200;
		}else{
			$return = 500;
		}

		return array("return" => $return, "rfc" => $rfc, "curp" => $curp);

	}//termina constanciaPDF


			  // public function getDatosConstancia($url, $id_paquete_archivo){
	  
	// public function getDatosConstancia(){

	// 	$url                = "https://raasmex.com.mx/bd/static/constancia.jpeg";
	// 	$id_paquete_archivo = 1;

	// 	$data       = file_get_contents($url);
		
	
	// 	$string_b64 = base64_encode($data);
		
	// 	$username   = "factorx";
	// 	$password   = "x_i.E4h18";
		
	// 	$ch         = curl_init();

	// 	$datos = "";
	// 	$datos = array(
	// 		'documento' => $string_b64, //SE ENVIA FOTO EN FORMATO BASE64
	// 		'tipo' => 'imagen'
	// 	);

	// 	curl_setopt($ch, CURLOPT_URL, 'https://api.nubarium.com/sat/v1/consultar_cif'); //URL ENDPOINT
	// 	//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

	// 	$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
	// 	curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
	// 	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	// 	curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

	// 	$headers = array();
	// 	$headers[] = 'Content-Type: application/json';
	// 	$headers[] = 'Accept: application/json';
	// 	$headers[] = 'Cache-Control: no-cache';
	// 	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

	// 	$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS
	
	// 	if (curl_errno($ch)) {
	// 	    echo 'Error:' . curl_error($ch);
	// 	}
		
	// 	$json = json_decode($result, true);

	// 	$return = 400;
	// 	$curp   = null;


	// 	$rfc                        = NULL;
	// 	$apellidoMaterno            = NULL;
	// 	$apellidoPaterno            = NULL;
	// 	$curp                       = NULL;
	// 	$fechaInicioOperaciones     = NULL;
	// 	$fechaNacimiento            = NULL;
	// 	$fechaUltimoCambioSituacion = NULL;
	// 	$nombres                    = NULL;
	// 	$situacionContribuyente     = NULL;
	// 	$colonia                    = NULL;
	// 	$correoElectronico          = NULL;
	// 	$cp                         = NULL;
	// 	$entidadFederativa          = NULL;
	// 	$municipioDelegacion        = NULL;
	// 	$nombreVialidad             = NULL;
	// 	$numeroExterior             = NULL;
	// 	$numeroInterior             = NULL;

	// 	$insert_constancia = NULL;

	// 	// header('Content-Type: application/json');
	// 	// print_r($result);
	// 	// die("");

	// 	if(is_array($json)){

	// 		if(array_key_exists("datosIdentificacion", $json)){

	// 			$apellidoMaterno            = $json["datosIdentificacion"]["apellidoMaterno"];
	// 			$apellidoPaterno            = $json["datosIdentificacion"]["apellidoPaterno"];
	// 			$curp                       = $json["datosIdentificacion"]["curp"];
	// 			$fechaInicioOperaciones     = $json["datosIdentificacion"]["fechaInicioOperaciones"];
	// 			$fechaNacimiento            = $json["datosIdentificacion"]["fechaNacimiento"];
	// 			$fechaUltimoCambioSituacion = $json["datosIdentificacion"]["fechaUltimoCambioSituacion"];
	// 			$nombres                    = $json["datosIdentificacion"]["nombres"];
	// 			$situacionContribuyente     = $json["datosIdentificacion"]["situacionContribuyente"];
	
	// 			$return = 200;
	
	// 		}else{
	// 			$return = 400;
	// 			$curp   = null;
	// 		}
	
	// 		if(array_key_exists("datosUbicacion", $json)){
	
	// 			$colonia                    = $json["datosUbicacion"]["colonia"];
	// 			$correoElectronico          = $json["datosUbicacion"]["correoElectronico"];
	// 			$cp                         = $json["datosUbicacion"]["cp"];
	// 			$entidadFederativa          = $json["datosUbicacion"]["entidadFederativa"];
	// 			$municipioDelegacion        = $json["datosUbicacion"]["municipioDelegacion"];
	// 			$nombreVialidad             = $json["datosUbicacion"]["nombreVialidad"];
	// 			$numeroExterior             = $json["datosUbicacion"]["numeroExterior"];
	// 			$numeroInterior             = $json["datosUbicacion"]["numeroInterior"];
	// 			$return = 200;
	
	// 		}else{
	// 			$return = 400;
	// 			$curp   = null;
	// 		}
	
	
	// 		if (array_key_exists("caracteristicasFiscales", $json)) {
	
	
	// 			$insert_a                       = array();
	// 			$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
	// 			$insert_a["url_archivo"]        = "static/uploads/".$id_paquete_archivo."-Constancia.pdf";
	// 			$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);
	
	// 			$datos = $json["caracteristicasFiscales"];
			
	// 			// ✅ Validamos que sea array
	// 			if (!is_array($datos)) {
	// 				$datos = json_decode(json_encode($datos), true); // Convertir a array si es objeto
	// 			}
			
	// 			$getRegimen = $this->chatbot_model->getRegimenFiscal($id_paquete_archivo);
			
	// 			if (is_null($getRegimen)) { // Si es null entonces insertamos
			
	// 				foreach ($datos as $item) {
	// 					if (is_array($item)) { // ✅ Validamos que $item sea array
	// 						$codigo       = $item['codigo'] ?? null;
	// 						$descripcion  = $item['regimen'] ?? null;
	// 						$fechaAlta    = $item['fechaAlta'] ?? null;
			
	// 						$insert_r = array(
	// 							"regimen"            => $descripcion,
	// 							"codigo"             => $codigo,
	// 							"fechaAlta"          => $fechaAlta,
	// 							"id_paquete_archivo" => $id_paquete_archivo
	// 						);
			
	// 						$this->chatbot_model->insertRegimenFiscal($insert_r);
	// 					} else {
	// 						// log_message('error', 'Elemento inválido en caracteristicasFiscales: ' . print_r($item, true));
	// 					}
	// 				} // foreach
	// 			} // termina is_null
	// 		}
			
	
	// 		if(array_key_exists("rfc", $json)){
	// 			$rfc = $json["rfc"];
	// 		}
	
	// 		if($return == 200){
	
	// 			$insert_c = array();
	
	// 			$fechaUltimoCambioSituacion       = str_replace('/', '-', $fechaUltimoCambioSituacion);
	// 			$fechaUltimoCambioSituacion_final = date('Y-m-d', strtotime($fechaUltimoCambioSituacion));
				
				
	// 			$fechaNacimiento       = str_replace('/', '-', $fechaNacimiento);
	// 			$fechaNacimiento_final = date('Y-m-d', strtotime($fechaNacimiento));
				
	// 			$fechaInicioOperaciones       = str_replace('/', '-', $fechaInicioOperaciones);
	// 			$fechaInicioOperaciones_final = date('Y-m-d', strtotime($fechaInicioOperaciones));
	
	// 			$insert_c["apellidoMaterno"]            = $apellidoMaterno;
	// 			$insert_c["apellidoPaterno"]            = $apellidoPaterno;
	// 			$insert_c["curp"]                       = $curp;
	// 			$insert_c["fechaInicioOperaciones"]     = $fechaInicioOperaciones_final;
	// 			$insert_c["fechaNacimiento"]            = $fechaNacimiento_final;
	// 			$insert_c["fechaUltimoCambioSituacion"] = $fechaUltimoCambioSituacion_final;
	// 			$insert_c["nombres"]                    = $nombres;
	// 			$insert_c["situacionContribuyente"]     = $situacionContribuyente;
	// 			$insert_c["colonia"]                    = $colonia;
	// 			$insert_c["correoElectronico"]          = $correoElectronico;
	// 			$insert_c["cp"]                         = $cp;
	// 			$insert_c["entidadFederativa"]          = $entidadFederativa;
	// 			$insert_c["municipioDelegacion"]        = $municipioDelegacion;
	// 			$insert_c["nombreVialidad"]             = $nombreVialidad;
	// 			$insert_c["numeroExterior"]             = $numeroExterior;
	// 			$insert_c["numeroInterior"]             = $numeroInterior;
	// 			$insert_c["rfc"]                        = $rfc;
	// 			$insert_c["id_archivo"]                 = $id_archivo;
	// 			$insert_c["id_paquete_archivo"]         = $id_paquete_archivo;
				
	// 			$insert_constancia =  $this->chatbot_model->insertDatosConstancia($insert_c);
	// 		}


	// 	}else{
	// 		$return = 400;
	// 	}

		
	// 	if(!is_null($insert_constancia)){
	// 		$return = 200;
	// 	}else{
	// 		$return = 500;
	// 	}

	// 	die(var_dump(array("return" => $return, "rfc" => $rfc, "curp" => $curp)));
	// 	return array("return" => $return, "rfc" => $rfc, "curp" => $curp);

	// }//termina getDatosConstancia

	public function comprobantePDF($url, $id_paquete_archivo, $url_archivo){
		// public function comprobantePDF(){
			// OCR COMPROBANTE DE DOMICILIO
			$curl = curl_init();
	
			// $url = "https://filemanager.gupshup.io/wa/bd0cba81-bacd-41b0-a160-2ae4c7b5efb3/wa/media/630098589888681?download=false&fileName=Constancia.pdf";
			$data = file_get_contents($url);
			$string_b64 = base64_encode($data);
	
	
			$method = 'POST';
			$headers = [
				'Content-Type: application/json',
				'Authorization: Basic ZmFjdG9yeDp4X2kuRTRoMTg='
			];
	
			$datos = array(
				'comprobante' => $string_b64
			);
	
			$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
	
			$options = [
				CURLOPT_URL => "https://ocr.nubarium.com/ocr/v2/comprobante_domicilio",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => $method,
				CURLOPT_POSTFIELDS => $payload,
				CURLOPT_HTTPHEADER => $headers,
			];
	
			curl_setopt_array($curl, $options);
	
			$response = curl_exec($curl);
	
			curl_close($curl);
	
			$json   = json_decode($response, true);
			$return = 400;
	
			// header('Content-Type: application/json');
			// print_r($json);
			// die();
	
			if(array_key_exists("QR", $json)){
	
				$qr               = $json["QR"];
				$adeudoAnterior   = $json["adeudoAnterior"];
				$calle            = $json["calle"];
				$ciudad           = $json["ciudad"];
				$colonia          = $json["colonia"];
				$cp               = $json["cp"];
				$fecha            = $json["fecha"];
				$fechaLimitePago  = $json["fechaLimitePago"];
				$nombre           = $json["nombre"];
				$referencia       = $json["referencia"];
				$periodoFacturado = $json["periodoFacturado"];
				$totalPagar       = $json["totalPagar"];
				
				if(array_key_exists("validaciones", $json)){
	
					$codigoNumerico = $json["validaciones"]["codigoNumerico"];
					$fecha          = $json["validaciones"]["fecha"];
					$numeroServicio = $json["validaciones"]["numeroServicio"];
					$rmu            = $json["validaciones"]["rmu"];
					$tarifa         = $json["validaciones"]["tarifa"];
					$totalPagar     = $json["validaciones"]["totalPagar"];
	
					$insert_c = array();
					
					$insert_a                       = array();
					$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
					$insert_a["url_archivo"]        = $url_archivo;
					$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);
					

					$insert_c["qr"]                 = $qr;
					$insert_c["adeudoAnterior"]     = $adeudoAnterior;
					$insert_c["calle"]              = $calle;
					$insert_c["ciudad"]             = $ciudad;
					$insert_c["colonia"]            = $colonia;
					$insert_c["cp"]                 = $cp;
					$insert_c["fecha"]              = $fecha;
					$insert_c["fechaLimitePago"]    = $fechaLimitePago;
					$insert_c["nombre"]             = $nombre;
					$insert_c["referencia"]         = $referencia;
					$insert_c["periodoFacturado"]   = $periodoFacturado;
					$insert_c["totalPagar"]         = $totalPagar;
					$insert_c["codigoNumerico"]     = $codigoNumerico;
					$insert_c["fecha"]              = $fecha;
					$insert_c["numeroServicio"]     = $numeroServicio;
					$insert_c["rmu"]                = $rmu;
					$insert_c["tarifa"]             = $tarifa;
					$insert_c["totalPagar"]         = $totalPagar;
					$insert_c["id_archivo"]         = $id_archivo;
					$insert_c["id_paquete_archivo"] = $id_paquete_archivo;
											
					$comprobante = $this->chatbot_model->insertDatosComprobante($insert_c);
	
					if(!is_null($comprobante)){
						$return = 200;
					}
	
				}
				
			}
	
			return $return;
	
			// header('Content-Type: application/json');
			// print_r($json);
			// die();
	
	}//termina comprobantePDF


	public function getNss($curp, $id_paquete_archivo){
		
		$curl = curl_init();

		// $curp = "LOID930710HQTPBN04";
		// $id_paquete_archivo = 1;

		$url = 'https://apimarket.mx/api/imss/grupo/localizar-nss';
		$method = 'POST';
		$queryParams = http_build_query(["curp" => $curp]);
		$headers = [
			'Authorization: Bearer badd8309-2da2-4810-b564-6c903326b5a1',
			'Accept: application/json'
		];
		
		$options = [
			CURLOPT_URL => "$url?$queryParams",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_HTTPHEADER => $headers,
		];
		
		curl_setopt_array($curl, $options);
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		
		$json   = json_decode($response, true);
		$return = 400;
		$nss    = null;

		if(array_key_exists("data", $json)){

			$data = $json["data"];

			if(array_key_exists("nss", $data)){

				$nss                            = $data["nss"];
				$return                         = 200;
				
				$update_p        = array();
				$update_p["nss"] = $nss;
				$this->chatbot_model->updatePaqueteArchivo($update_p, $id_paquete_archivo);

			}

		}//termina

		return array("return" => $return, "nss" => $nss);
		// header('Content-Type: application/json');
		// print_r($json);
		// die();
	}//termina getNss

	public function getHistorialImss($curp, $nss){

		$url_w = base_url()."index.php/GetDatosImss";

		$username   = "factorx";
		$password   = "x_i.E4h18";

		$curl = curl_init();

		// curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api.nubarium.com/mex/ss/v1/employment-info-imss',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_USERPWD => $username . ":" . $password,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS =>'{
		  "curp": "'.$curp.'",
		  "nss": "'.$nss.'",
		  "url": "'.$url_w.'"
		}',
		  CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		  ),
		));
		
		$response = curl_exec($curl);
		
		// echo "resp: ".$response;

		curl_close($curl);
		// echo $response;

		
	}//termina getHistorialImss


	public function mensaje_boton($numero, $cabecera, $mensaje, $pie, $options){

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5216648841034',
		    'destination' => ''.$numero.'',
		    'src.bdreclu',
		    'disablePreview' => 'false',
		    'encode' => 'false',
		    'message' => json_encode(array('content' => array('type' => 'text', 'header' => ''.$cabecera.'', 'text' => ''.$mensaje.'', 'caption' => ''.$pie.''), 'type' => 'quick_reply', 'msgid' => 'qr1', 'options' => $options))
		];

		$limpio = array();
	    for ($i = 0; $i < count($options); $i++) {
     		foreach ($options[$i] as $key => $op){
	            if ($key == "title") {
	                $new = array("options" => $op);
	           		array_push($limpio, $new);
	            }
	         }
	    }


		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);

		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		// var_dump($result);
		curl_close($ch);

	}//termina mensaje_boton

}//termina class solicitud