<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Archivos extends CI_Controller {

	
	public function __construct(){
		
		parent::__construct();
		// $this->load->library('encrypt');
		
		header("Cache-Control: no-store,no-cache,must-revalidate;");
		header("Cache-Control: post-check=0,pre-check=0", FALSE);
		header("Pragma:no-chache");
	 	
		if($this->session->userdata("usuario") == false){
		
			$this->session->set_flashdata("error","Acceso Restringido");
	
			redirect("login/");
	
		}
		$this->load->model("archivos_model", "model");		
	}

	public function index(){

		$data["_APP_TITTLE"] = "Archivos";
		$data["_TAB"]        = "addArchivos";
		$data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
		$data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
		$data["pdf"]    	 = $this->model->getPdf();
		$data["fragment"]    = $this->load->view('app/admin/fragments/agregar_archivos_view', $data, TRUE);
		$this->load->view('app/admin/main_view', $data, FALSE);
	
	}  //termina index
	
	public function misArchivos(){

		$data["_APP_TITTLE"]  = "Mis archivos";
		$data["_TAB"]         = "misArchivos";
		$data["main_menu"]    = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
		$data["nav"]          = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
		$data["paquetes"]     = $this->model->getPaquetesArchivos();
		$data["supervisores"] = $this->model->getCatalogoSupervisor();
		$data["puesto"]       = $this->model->getCatalogoPuesto();
		$data["fragment"]     = $this->load->view('app/admin/fragments/archivos_view', $data, TRUE);
		$this->load->view('app/admin/main_view', $data, FALSE);
	
	}  //termina misArchivos

	public function verDatos(){

		if($this->input->get("idp")){

			$id_paquete_archivo = $this->input->get("idp");
			$datos              = $this->model->getDatosArchivo($id_paquete_archivo);
			

			if(!is_null($datos)){
				
				$data["_APP_TITTLE"]        = "Mis archivos";
				$data["_TAB"]               = "misArchivos";
				$data["main_menu"]          = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
				$data["nav"]                = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
				$data["dato"]               = $datos;
				$data["ladas"]              = $this->model->getLadas();
				$data["id_paquete_archivo"] = $id_paquete_archivo;
				$data["fragment"]           = $this->load->view('app/admin/fragments/datos_archivos_view', $data, TRUE);
				$this->load->view('app/admin/main_view', $data, FALSE);

				return;
			}

			redirect("admin/archivos/misArchivos");
		}


	
	}  //termina verDatos
	

	public function filtrar(){

		$inicio = $this->input->post("inicio");
		$fin    = $this->input->post("fin");

		$filtro = $this->model->getFiltroPaquetesArchivos($inicio, $fin);

		$tabla     = NULL;
		$respuesta = 400;
		$cont      = 1;

		if(!is_null($filtro)){
			
			foreach ($filtro as $f) {

				if($f->messageCode == 0){
					$estatus_imss = "<h4><span class='label label-success'>Activo</span></h4>";
				}else if($f->messageCode == 1){
					$estatus_imss = "<h4><span class='label label-danger'>Inactivo</span></h4>";
				}

				$archivos  = explode(",", $f->archivos);

				$ine = $comprobante = $constancia = null;

				foreach ($archivos as $archivo) {
					if (strpos($archivo, 'INE') !== false) {
						$ine = $archivo;
					} elseif (strpos($archivo, 'Comprobante') !== false) {
						$comprobante = $archivo;
					} elseif (strpos($archivo, 'Constancia') !== false) {
						$constancia = $archivo;
					}
				}

				$tabla .= "<tr>";
				$tabla .= "<td>".$cont."</td>";
				$tabla .= "<td>".$f->fecha_registro."</td>";
				$tabla .= "<td>".$f->nombres."</td>";
				$tabla .= "<td>".$f->primerApellido."</td>";
				$tabla .= "<td>".$f->segundoApellido."</td>";
				$tabla .= "<td>".$f->correoElectronico."</td>";
				$tabla .= "<td>".$estatus_imss."</td>";
				$tabla .= "<td>".$f->rfc."</td>";
				$tabla .= "<td>".$f->curp."</td>";
				$tabla .= "<td>".$f->nss."</td>";

				$tabla .= "<td>";
				$tabla .= "<a href='verDatos?idp=".$f->id_paquete_archivo."' class='btn btn-success'>";
				$tabla .= "<i class='fa fa-eye'></i> Ver</a> ";

				$tabla .= "<button class='verArchivos btn btn-primary'  
					data-nombres='".$f->nombres."'
					data-primerApellido='".$f->primerApellido."'
					data-segundoApellido='".$f->segundoApellido."'
					data-rfc='".$f->rfc."'
					data-curp='".$f->curp."'
					data-nss='".$f->nss."'
					data-ine='".$ine."'
					data-comprobante='".$comprobante."'
					data-foto_candidato='".$f->foto_candidato."'
					data-constancia='".$constancia."'
					data-calle='".$f->calle."'
					data-colonia='".$f->colonia."'
					data-cp='".$f->cp."'>
					<i class='fa fa-file' aria-hidden='true'></i> archivos
				</button>";
				$tabla .= "</td>";

				$tabla .= "</tr>";



				$cont++;
			}

			
			$respuesta = 200;

		}

		
		echo json_encode(array("respuesta" => $respuesta, "tabla" => $tabla));


	}//termina filtrar

	public function actualizarDatos(){


		$id_paquete_archivo = 	$this->input->post("id_paquete_archivo");	
		// ================================
		// Datos INE
		// ================================
		$curp            = $this->input->post("curp");
		$nombres         = $this->input->post("nombres");
		$primerApellido  = $this->input->post("primerApellido");
		$segundoApellido = $this->input->post("segundoApellido");
		$sexo            = $this->input->post("sexo");
		$fechaNacimiento = $this->input->post("fechaNacimiento");
		$claveElector    = $this->input->post("claveElector");
		$celular_persona = $this->input->post("celular_persona");
		$lada_pais       = $this->input->post("lada_pais");

		// ================================
		// Constancia de situación fiscal
		// ================================
		$rfc                    = $this->input->post("rfc");
		$situacionContribuyente = $this->input->post("situacionContribuyente");
		$correoElectronico      = $this->input->post("correoElectronico");

		// ================================
		// Comprobante de domicilio
		// ================================
		$calle   = $this->input->post("calle");
		$colonia = $this->input->post("colonia");
		$cp      = $this->input->post("cp");

		// ================================
		// Historial trabajado
		// ================================
		$nss              = $this->input->post("nss");
		$registroPatronal = $this->input->post("registroPatronal");
		$modalidad        = $this->input->post("modalidad");
		$rfcPatron        = $this->input->post("rfcPatron");
		$razonSocial      = $this->input->post("razonSocial");
		$salarioBase      = $this->input->post("salarioBase");
		$dias             = $this->input->post("dias");
		$fechaRegistro    = $this->input->post("fechaRegistro");



		$respuesta = 400;
		$message   = NULL;

		$updateDI                    = array();
		$updateDI["curp"]            = $curp;
		$updateDI["nombres"]         = $nombres;
		$updateDI["primerApellido"]  = $primerApellido;
		$updateDI["segundoApellido"] = $segundoApellido;
		$updateDI["sexo"]            = $sexo;
		$updateDI["fechaNacimiento"] = $fechaNacimiento;
		$updateDI["claveElector"]    = $claveElector;
		


		$updateDC                           = array();
		$updateDC["rfc"]                    = $rfc;
		$updateDC["situacionContribuyente"] = $situacionContribuyente;
		$updateDC["correoElectronico"]      = $correoElectronico;



		$updateDCom            = array();
		$updateDCom["calle"]   = $calle;
		$updateDCom["colonia"] = $colonia;
		$updateDCom["cp"]      = $cp;

		$updatePa                    = array();
		$updatePa["celular_persona"] = $celular_persona;
		$updatePa["lada_pais"]       = $lada_pais;


		if($this->model->updateDatosINEPaquete($updateDI, $id_paquete_archivo)){
			
			if($this->model->updateDatosConstanciaPaquete($updateDC, $id_paquete_archivo)){

				if($this->model->updateDatosComprobantePaquete($updateDCom, $id_paquete_archivo)){

					if($this->model->updateDatosPaqueteArchivo($updatePa, $id_paquete_archivo)){
						$respuesta = 200;	
						$message   = "Datos actualizados correctamente";
					}else{
						$respuesta = 500;//Error en Comprobante	
						$message   = "Error al actualizar el celular";
					}

				}else{
					$respuesta = 500;//Error en Comprobante	
					$message   = "Error al actualizar los datos del comprobante";
				}	
			}else{
				$respuesta = 300;//Error en Constancia	
				$message   = "Error al actualizar los datos de la constancia";
			}
		}else{
			$respuesta = 100;//Error en Datos INE	
			$message   = "Error al actualizar los datos del INE";
		}
		
		
		$getDatosArchivo = $this->model->getHistorialTrabajado($id_paquete_archivo);


		if(!is_null($getDatosArchivo)){//primero obtenemos todos los datos

			$id_historial_trabajado = $getDatosArchivo->id_historial_trabajado;

			$datosHistorial                     = array();
			$datosHistorial["nss"]              = $nss;
			$datosHistorial["registroPatronal"] = $registroPatronal;
			$datosHistorial["modalidad"]        = $modalidad;
			$datosHistorial["rfcPatron"]        = $rfcPatron;
			$datosHistorial["razonSocial"]      = $razonSocial;
			$datosHistorial["salarioBase"]      = $salarioBase;
			$datosHistorial["dias"]             = $dias;
			$datosHistorial["fechaRegistro"]    = $fechaRegistro;
			$datosHistorial["nss"]              = $nss;
			$datosHistorial["curp"]             = $curp;

			$updatePaquete        = array();
			$updatePaquete["nss"] = $nss;

			if($id_historial_trabajado == ""){
				$this->model->insertHistorialTrabajo($datosHistorial);	
			}else{
				$this->model->updateHistorialLaboral($datosHistorial, $id_historial_trabajado);
				$this->model->updateDatosPaqueteArchivo($updatePaquete, $id_paquete_archivo);
			}

			
		}


		echo json_encode([
			'respuesta' => $respuesta,
			'message' => $message
		]);


	}//termina actualizarDatos

	public function cargarArchivos(){

        $this->load->library('upload');

        // Extensiones permitidas
        $allowed_extensions = [
            'ineFile' => ['pdf', 'jpg', 'jpeg', 'png'],
            'domicilioFile' => ['pdf'],
            'constanciaFile' => ['pdf']
        ];

		$upload_path        = 'static/uploads/';
		$errors             = [];
		$error_lectura      = [];                 //vamos a obtener los archivos para eliminar
		$error_dato         = [];                 //vamos a obtener los ids de archivos para eliminar
		$id_paquete_archivo = 0;
		$nombre_archivo     = NULL;
			
		if(count($_FILES) == 3){

			foreach ($_FILES as $key => $file) {
				if ($file['size'] > 0) {
					$file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));


					$nombre_archivo = "";
					// $nombre_archivo = ($key == "ineFile") ? "INE" : $nombre_archivo;
					// $nombre_archivo = ($key == "domicilioFile") ? "Comprobante" : $nombre_archivo;
					// $nombre_archivo = ($key == "constanciaFile") ? "Constancia" : $nombre_archivo;

					if($key == "ineFile"){
						if($file_ext == "png" || $file_ext == "jpg" || $file_ext == "jpeg"){
							$nombre_archivo = "INE";	
						}else{
							$errors[] = "La INE debe ser una imagen con extensión PNG o JPG.";
						}
					}

					if($key == "domicilioFile"){
						if($file_ext == "png" || $file_ext == "jpg" || $file_ext == "jpeg" || $file_ext == "pdf"){
							$nombre_archivo = "Comprobante";	
						}else{
							$errors[] = "El comprobante de domicilio debe ser una imagen con extensión PNG, JPG o PDF.";
						}
					}

					if($key == "constanciaFile"){
						if($file_ext == "png" || $file_ext == "jpg" || $file_ext == "jpeg" || $file_ext == "pdf"){
							$nombre_archivo = "Constancia";	
						}else{
							$errors[] = "La constancia de situación fiscal debe ser una imagen con extensión PNG, JPG o PDF.";
						}
					}

				}
			}

		}else{
			$errors[] = "Favor de ingresar los 3 archivos.";
		}

		$curp = null;

		// Subir archivos si no tiene errores
		if(count($errors) == 0){

			$insert_pa           = array();
			$insert_pa["nombre"] = "Paquete";
			$id_paquete_archivo  = $this->model->insertPaqueteArchivo($insert_pa);
			
			$rfc = null;

			if(!is_null($id_paquete_archivo)){

				foreach ($_FILES as $key => $file) {
					$file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
				
					// Inicializar un array vacío para cada archivo
					$insert_a = array();
					$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
					
					// Insertar el archivo y obtener su ID
					$id_archivo = $this->model->insertArchivo($insert_a);
				
					// Asignar el nombre del archivo según la clave
					$nombre_archivo = "";
					$nombre_archivo = ($key == "ineFile") ? "INE" : $nombre_archivo;
					$nombre_archivo = ($key == "domicilioFile") ? "Comprobante" : $nombre_archivo;
					$nombre_archivo = ($key == "constanciaFile") ? "Constancia" : $nombre_archivo;
		
					// Crear el nombre del archivo final (antes de moverlo)
					$archivo = "";
					$archivo = $upload_path . $id_paquete_archivo . "-" . $nombre_archivo . "." . $file_ext;
				
					// Preparar los datos para actualizar la URL del archivo
					$update_a                = array();
					$update_a["url_archivo"] = $archivo;
					$this->model->updateArchivo($update_a, $id_archivo);

					
					if(move_uploaded_file($file['tmp_name'], $archivo)){
						
						if ($key == "constanciaFile" && $file_ext == "pdf") {
							
							$respuesta_constancia = $this->constanciaPDF($archivo, $id_archivo, $id_paquete_archivo);
							$return_constancia    = $respuesta_constancia["return"];
							
							
							if($return_constancia == 200){
								// $curp = $respuesta_constancia["curp"];
								$rfc  = $respuesta_constancia["rfc"];
							}else{
								$errors[] = "No pudimos leer la constancia.";
							}

	
						}else if ($key == "ineFile" && ($file_ext == "png" || $file_ext == "jpg" || $file_ext == "jpeg")) {
							
							$respuesta_ine = $this->escanearINE($archivo, $id_archivo, $id_paquete_archivo);
							$return_ine    = $respuesta_ine["return"];
							
							if($return_ine == 200){
								$curp = $respuesta_ine["curp"];
							}else{
								$errors[] = "No pudimos leer la INE.";
							}


						}else if($key == "domicilioFile" && ($file_ext == "png" || $file_ext == "jpg" || $file_ext == "jpeg" || $file_ext == "pdf")){
							
							$respuesta_comprobante = $this->comprobantePDF($archivo, $id_archivo, $id_paquete_archivo);
							if($respuesta_comprobante != 200){
								$errors[] = "No pudimos leer el comprobante de domicilio.";
							}
						}

						$error_lectura[] = $archivo;
						$error_dato[]    = $id_archivo;
						
					}else{
						$errors[] = "Error al subir los archivos";
					}
				}
				
			}else{
				$errors[] = "Error al insertar paquete de archivos";
			}

		}

		if(count($errors) > 0){ //Si al final de todo tenemos algún error, borramos todo para cargar por paquete
			$this->borrarRegistros($error_lectura, $error_dato, $id_paquete_archivo);
		}else{

			$getNss     = $this->getNss($curp, $id_paquete_archivo);
			$return_nss = $getNss["return"];
			
			if($return_nss == 200){
	
				$nss = $getNss["nss"];
				// $this->getHistorialLaboral($curp, $nss);
				$this->getHistorialImss($curp, $nss);

			}

			$getRfc     = $this->getRFC($curp);
			$return_rfc = $getRfc["return"];
			
			if($return_rfc == 200){
				$this->getDatos($rfc, $id_paquete_archivo);
				// echo "xxxxx";
			}


		}


        // Responder con éxito o error
        if (empty($errors)) {
			$array = array("status" => "success", "message" => "Archivos subidos correctamente.");
            echo json_encode($array);
        } else {
			$array = array("status" => "error", "errors" => $errors);
            echo json_encode($array);
        }

    }


	public function borrarRegistros($error_lectura, $error_dato, $id_paquete_archivo){

		foreach ($error_lectura as $archivo) {
			if (file_exists($archivo)) {
				unlink($archivo);
				// echo "Archivo eliminado: $archivo\n";
			}
		}

		foreach ($error_dato as $id_archivo) {
			$this->model->deleteArchivo($id_archivo);
			$this->model->deleteDatosComprobante($id_archivo);
			$this->model->deleteDatosConstancia($id_archivo);
			$this->model->deleteDatosIne($id_archivo);
		}

		$this->model->deletePaqueteArchivo($id_paquete_archivo);

		// unlink($archivo_comprobante);
		// unlink($archivo_constancia);
		// unlink($archivo_ine);

	}//termina borrarRegistros


	public function comprobantePDF($url, $id_archivo, $id_paquete_archivo){
	// public function comprobantePDF(){
		// OCR COMPROBANTE DE DOMICILIO
		$curl = curl_init();

		  //   $url = 'static/uploads/COMPROBANTE_DOMICILIO.pdf';
		// $url = 'static/uploads/2-Comprobante.pdf';
		// $id_archivo = 2;
		  
		$data = file_get_contents($url);
		$string_b64 = base64_encode($data);


		$method = 'POST';
		$headers = [
			'Content-Type: application/json',
			'Authorization: Basic ZmFjdG9yeDp4X2kuRTRoMTg='
		];

		$datos = array(
			'comprobante' => $string_b64
		);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON

		$options = [
			CURLOPT_URL => "https://ocr.nubarium.com/ocr/v2/comprobante_domicilio",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_POSTFIELDS => $payload,
			CURLOPT_HTTPHEADER => $headers,
		];

		curl_setopt_array($curl, $options);

		$response = curl_exec($curl);

		curl_close($curl);

		$json   = json_decode($response, true);
		$return = 400;

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if(array_key_exists("adeudoAnterior", $json)){


			$qr = null;

			if(array_key_exists("QR", $json)){
				$qr = $json["QR"];
			}

			$adeudoAnterior   = $json["adeudoAnterior"];
			$calle            = $json["calle"];
			$ciudad           = $json["ciudad"];
			$colonia          = $json["colonia"];
			$cp               = $json["cp"];
			$fecha            = $json["fecha"];
			$fechaLimitePago  = $json["fechaLimitePago"];
			$nombre           = $json["nombre"];
			$referencia       = $json["referencia"];
			$periodoFacturado = $json["periodoFacturado"];
			$totalPagar       = $json["totalPagar"];
			
			if(array_key_exists("validaciones", $json)){

				$codigoNumerico = $json["validaciones"]["codigoNumerico"];
				$fecha          = $json["validaciones"]["fecha"];
				$numeroServicio = $json["validaciones"]["numeroServicio"];
				$rmu            = $json["validaciones"]["rmu"];
				$tarifa         = $json["validaciones"]["tarifa"];
				$totalPagar     = $json["validaciones"]["totalPagar"];

				$insert_c = array();
				
				$insert_c["qr"]                 = $qr;
				$insert_c["adeudoAnterior"]     = $adeudoAnterior;
				$insert_c["calle"]              = $calle;
				$insert_c["ciudad"]             = $ciudad;
				$insert_c["colonia"]            = $colonia;
				$insert_c["cp"]                 = $cp;
				$insert_c["fecha"]              = $fecha;
				$insert_c["fechaLimitePago"]    = $fechaLimitePago;
				$insert_c["nombre"]             = $nombre;
				$insert_c["referencia"]         = $referencia;
				$insert_c["periodoFacturado"]   = $periodoFacturado;
				$insert_c["totalPagar"]         = $totalPagar;
				$insert_c["codigoNumerico"]     = $codigoNumerico;
				$insert_c["fecha"]              = $fecha;
				$insert_c["numeroServicio"]     = $numeroServicio;
				$insert_c["rmu"]                = $rmu;
				$insert_c["tarifa"]             = $tarifa;
				$insert_c["totalPagar"]         = $totalPagar;
				$insert_c["id_archivo"]         = $id_archivo;
				$insert_c["id_paquete_archivo"] = $id_paquete_archivo;
										
				$comprobante = $this->model->insertDatosComprobante($insert_c);

				if(!is_null($comprobante)){
					$return = 200;
				}

			}
			
		}

		return $return;

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

	}//termina comprobantePDF

	public function constanciaPDF($url, $id_archivo, $id_paquete_archivo){
			
		$data       = file_get_contents($url);
		
	
		$string_b64 = base64_encode($data);
		
		$username   = "factorx";
		$password   = "x_i.E4h18";
		
		$ch         = curl_init();

		$datos = "";
		$datos = array(
			'documento' => $string_b64, //SE ENVIA FOTO EN FORMATO BASE64
			'tipo' => 'pdf'
		);

		curl_setopt($ch, CURLOPT_URL, 'https://api.nubarium.com/sat/v1/consultar_cif'); //URL ENDPOINT
		//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Cache-Control: no-cache';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS
	
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}
		
		$json = json_decode($result, true);

		$return = 400;
		$curp   = null;


	

		$rfc                        = NULL;
		$apellidoMaterno            = NULL;
		$apellidoPaterno            = NULL;
		$curp                       = NULL;
		$fechaInicioOperaciones     = NULL;
		$fechaNacimiento            = NULL;
		$fechaUltimoCambioSituacion = NULL;
		$nombres                    = NULL;
		$situacionContribuyente     = NULL;
		$colonia                    = NULL;
		$correoElectronico          = NULL;
		$cp                         = NULL;
		$entidadFederativa          = NULL;
		$municipioDelegacion        = NULL;
		$nombreVialidad             = NULL;
		$numeroExterior             = NULL;
		$numeroInterior             = NULL;

		$insert_constancia = NULL;

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if(array_key_exists("datosIdentificacion", $json)){

			$apellidoMaterno            = $json["datosIdentificacion"]["apellidoMaterno"];
			$apellidoPaterno            = $json["datosIdentificacion"]["apellidoPaterno"];
			$curp                       = $json["datosIdentificacion"]["curp"];
			$fechaInicioOperaciones     = $json["datosIdentificacion"]["fechaInicioOperaciones"];
			$fechaNacimiento            = $json["datosIdentificacion"]["fechaNacimiento"];
			$fechaUltimoCambioSituacion = $json["datosIdentificacion"]["fechaUltimoCambioSituacion"];
			$nombres                    = $json["datosIdentificacion"]["nombres"];
			$situacionContribuyente     = $json["datosIdentificacion"]["situacionContribuyente"];

			$return = 200;

		}else{
			$return = 400;
			$curp   = null;
		}

		if(array_key_exists("datosUbicacion", $json)){

			$colonia                    = $json["datosUbicacion"]["colonia"];
			$correoElectronico          = $json["datosUbicacion"]["correoElectronico"];
			$cp                         = $json["datosUbicacion"]["cp"];
			$entidadFederativa          = $json["datosUbicacion"]["entidadFederativa"];
			$municipioDelegacion        = $json["datosUbicacion"]["municipioDelegacion"];
			$nombreVialidad             = $json["datosUbicacion"]["nombreVialidad"];
			$numeroExterior             = $json["datosUbicacion"]["numeroExterior"];
			$numeroInterior             = $json["datosUbicacion"]["numeroInterior"];
			$return = 200;

		}else{
			$return = 400;
			$curp   = null;
		}


		if (array_key_exists("caracteristicasFiscales", $json)) {

			$datos = $json["caracteristicasFiscales"];
		
			// ✅ Validamos que sea array
			if (!is_array($datos)) {
				$datos = json_decode(json_encode($datos), true); // Convertir a array si es objeto
			}
		
			$getRegimen = $this->model->getRegimenFiscal($id_paquete_archivo);
		
			if (is_null($getRegimen)) { // Si es null entonces insertamos
		
				foreach ($datos as $item) {
					if (is_array($item)) { // ✅ Validamos que $item sea array
						$codigo       = $item['codigo'] ?? null;
						$descripcion  = $item['regimen'] ?? null;
						$fechaAlta    = $item['fechaAlta'] ?? null;
		
						$insert_r = array(
							"regimen"            => $descripcion,
							"codigo"             => $codigo,
							"fechaAlta"          => $fechaAlta,
							"id_paquete_archivo" => $id_paquete_archivo
						);
		
						$this->model->insertRegimenFiscal($insert_r);
					} else {
						log_message('error', 'Elemento inválido en caracteristicasFiscales: ' . print_r($item, true));
					}
				} // foreach
			} // termina is_null
		}
		

		if(array_key_exists("rfc", $json)){
			$rfc = $json["rfc"];
		}

		if($return == 200){

			$insert_c = array();

			$fechaUltimoCambioSituacion       = str_replace('/', '-', $fechaUltimoCambioSituacion);
			$fechaUltimoCambioSituacion_final = date('Y-m-d', strtotime($fechaUltimoCambioSituacion));
			
			
			$fechaNacimiento       = str_replace('/', '-', $fechaNacimiento);
			$fechaNacimiento_final = date('Y-m-d', strtotime($fechaNacimiento));
			
			$fechaInicioOperaciones       = str_replace('/', '-', $fechaInicioOperaciones);
			$fechaInicioOperaciones_final = date('Y-m-d', strtotime($fechaInicioOperaciones));

			$insert_c["apellidoMaterno"]            = $apellidoMaterno;
			$insert_c["apellidoPaterno"]            = $apellidoPaterno;
			$insert_c["curp"]                       = $curp;
			$insert_c["fechaInicioOperaciones"]     = $fechaInicioOperaciones_final;
			$insert_c["fechaNacimiento"]            = $fechaNacimiento_final;
			$insert_c["fechaUltimoCambioSituacion"] = $fechaUltimoCambioSituacion_final;
			$insert_c["nombres"]                    = $nombres;
			$insert_c["situacionContribuyente"]     = $situacionContribuyente;
			$insert_c["colonia"]                    = $colonia;
			$insert_c["correoElectronico"]          = $correoElectronico;
			$insert_c["cp"]                         = $cp;
			$insert_c["entidadFederativa"]          = $entidadFederativa;
			$insert_c["municipioDelegacion"]        = $municipioDelegacion;
			$insert_c["nombreVialidad"]             = $nombreVialidad;
			$insert_c["numeroExterior"]             = $numeroExterior;
			$insert_c["numeroInterior"]             = $numeroInterior;
			$insert_c["rfc"]                        = $rfc;
			$insert_c["id_archivo"]                 = $id_archivo;
			$insert_c["id_paquete_archivo"]         = $id_paquete_archivo;
			
			$insert_constancia =  $this->model->insertDatosConstancia($insert_c);
		}

		
		if(!is_null($insert_constancia)){
			$return = 200;
		}else{
			$return = 500;
		}

		return array("return" => $return, "rfc" => $rfc, "curp" => $curp);

	}//termina constanciaPDF



	public function escanearINE($archivo, $id_archivo, $id_paquete_archivo){
		// public function escanearINE(){

		// $archivo    = 'static/uploads/ine.jpeg';
		// $id_archivo = 1;
	
		$data       = file_get_contents($archivo);
	
		$string_b64 = base64_encode($data);
		
		$username   = "factorx";
		$password   = "x_i.E4h18";
		
		$ch         = curl_init();

		$datos = "";
		$datos = array(
			'id' => $string_b64 //SE ENVIA FOTO EN FORMATO BASE64
		);

		curl_setopt($ch, CURLOPT_URL, 'https://ine.nubarium.com/ocr/obtener_datos'); //URL ENDPOINT
		//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Cache-Control: no-cache';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS
	
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}
		
		$json = json_decode($result, true);

		curl_close($ch);

		$return         = 500;
		$id_colaborador = null;
		$curp_return    = null;
		$nombre_return  = null;

		$curp             = NULL;
		$nombres          = NULL;
		$primerApellido   = NULL;
		$segundoApellido  = NULL;
		$calle            = NULL;
		$colonia          = NULL;
		$ciudad           = NULL;
		$sexo_colaborador = NULL;
		$fecha_nacimiento = NULL;
		$clave_elector    = NULL;

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if (!array_key_exists("curp", $json)) {
			
			$return         = 500;
			$id_colaborador = null;
			$curp_return    = null;
			$curp           = null;

		}else{

			// header('Content-Type: application/json');
			// print_r($json);
			// die();
			$curp             = $json["curp"];
			$nombres          = $json["nombres"];
			$primerApellido   = $json["primerApellido"];
			$segundoApellido  = $json["segundoApellido"];
			$calle            = $json["calle"];
			$colonia          = $json["colonia"];
			$ciudad           = $json["ciudad"];
			$sexo_colaborador = $json["sexo"];
			$fecha_nacimiento = $json["fechaNacimiento"];
			$clave_elector    = $json["claveElector"];
			$date             = str_replace('/', '-', $fecha_nacimiento);
			$fecha_nacimiento = date('Y-m-d', strtotime($date));
			
			$insert_ine                       = array();
			$insert_ine["curp"]               = $curp;
			$insert_ine["nombres"]            = $nombres;
			$insert_ine["primerApellido"]     = $primerApellido;
			$insert_ine["segundoApellido"]    = $segundoApellido;
			$insert_ine["calle"]              = $calle;
			$insert_ine["colonia"]            = $colonia;
			$insert_ine["ciudad"]             = $ciudad;
			$insert_ine["sexo"]               = $sexo_colaborador;
			$insert_ine["fechaNacimiento"]    = $fecha_nacimiento;
			$insert_ine["claveElector"]       = $clave_elector;
			$insert_ine["id_archivo"]         = $id_archivo;
			$insert_ine["id_paquete_archivo"] = $id_paquete_archivo;
			
			$insert_i = $this->model->insertDatosIne($insert_ine);

			if(!is_null($insert_i)){
				$return = 200;
			}

		}//termina else isset

		// echo "código: ".$return." id_colaborador: ".$id_colaborador." curp: ".$curp_return;
		// echo "return: ".$return;
		return array("return" => $return, "curp" => $curp);


	}//termina escanearINE


	public function getNss($curp, $id_paquete_archivo){
		
		$curl = curl_init();

		// $curp = "LOID930710HQTPBN04";
		// $id_paquete_archivo = 1;

		$url = 'https://apimarket.mx/api/imss/grupo/localizar-nss';
		$method = 'POST';
		$queryParams = http_build_query(["curp" => $curp]);
		$headers = [
			'Authorization: Bearer badd8309-2da2-4810-b564-6c903326b5a1',
			'Accept: application/json'
		];
		
		$options = [
			CURLOPT_URL => "$url?$queryParams",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_HTTPHEADER => $headers,
		];
		
		curl_setopt_array($curl, $options);
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		
		$json   = json_decode($response, true);
		$return = 400;
		$nss    = null;

		if(array_key_exists("data", $json)){

			$data = $json["data"];

			if(array_key_exists("nss", $data)){

				$nss                            = $data["nss"];
				$return                         = 200;
				
				$update_p                       = array();
				$update_p["nss"] = $nss;
				$this->model->updatePaqueteArchivo($update_p, $id_paquete_archivo);

			}

		}//termina

		return array("return" => $return, "nss" => $nss);
		// header('Content-Type: application/json');
		// print_r($json);
		// die();
	}//termina getNss

	public function getHistorialImss($curp, $nss){

		// $curp = "LOID930710HQTPBN04";
		// $nss  = "14089343777";
		
		// $curp = "ROMJ930907HQTDRS08";
		// $nss  = "14129329760";

		$url_w = base_url()."index.php/GetDatosImss";
		// $url_w = "https://raasmex.com.mx/opinion.php";
		
		  // die("url_w: ".$url_w);
		

		$username   = "factorx";
		$password   = "x_i.E4h18";

		$curl = curl_init();

		// curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api.nubarium.com/mex/ss/v1/employment-info-imss',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_USERPWD => $username . ":" . $password,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS =>'{
		  "curp": "'.$curp.'",
		  "nss": "'.$nss.'",
		  "url": "'.$url_w.'"
		}',
		  CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		  ),
		));
		
		$response = curl_exec($curl);
		
		// echo "resp: ".$response;

		curl_close($curl);
		// echo $response;

		
	}//termina getHistorialImss

	public function getHistorialLaboral($curp, $nss){

		$curl = curl_init();

		// $curp = "LOID930710HQTPBN04";
		// $nss  = "14089343777";

		$url = 'https://apimarket.mx/api/imss/grupo/historial-laboral';
		$method = 'POST';
		$postFields = json_encode([
			"curp" => $curp,
			"nss" => $nss
		]);
		$headers = [
			'Authorization: Bearer badd8309-2da2-4810-b564-6c903326b5a1',
			'Accept: application/json',
			'Content-Type: application/json'
		];
		
		$options = [
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_POSTFIELDS => $postFields,
			CURLOPT_HTTPHEADER => $headers,
		];
		
		curl_setopt_array($curl, $options);
		
		$response = curl_exec($curl);
		
		curl_close($curl);

		$json   = json_decode($response, true);
		$return = 400;

		$json               = json_decode($response, true);
		$return             = 400;
		$id_paquete_archivo = 1;
		
		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if(array_key_exists("data", $json)){

			$data = $json['data'];

			if(array_key_exists("historialLaboral", $data)){

				$historialLaboral = $data['historialLaboral'];

				foreach ($historialLaboral as $registro) {

					$entidadFederativa     = $registro['entidadFederativa'];
					$salarioBaseCotizacion = $registro['salarioBaseCotizacion'];
					$registroPatronal      = $registro['registroPatronal'];
					$nombrePatron          = $registro['nombrePatron'];
					// $fechaAlta             = date('Y-m-d', strtotime($registro['fechaAlta']));
					$fechaBaja             = $registro['fechaBaja'];
					
					$fechaAlta = DateTime::createFromFormat('d/m/Y', $registro['fechaAlta']);
					$fechaAlta = $fechaAlta ? $fechaAlta->format('Y-m-d') : null;

					$insert_h                          = array();
					$insert_h["entidadFederativa"]     = $entidadFederativa;
					$insert_h["salarioBaseCotizacion"] = $salarioBaseCotizacion;
					$insert_h["registroPatronal"]      = $registroPatronal;
					$insert_h["nombrePatron"]          = $nombrePatron;
					$insert_h["fechaAlta"]             = $fechaAlta;
					$insert_h["fechaBaja"]             = $fechaBaja;
					$insert_h["id_paquete_archivo"]    = $id_paquete_archivo;
					$this->model->insertHistorialLaboral($insert_h);

					$return = 200;

				}//termina foreach

				if(array_key_exists("constancia", $data)) {
					
					$constancia     = $data['constancia'];
					$nombre_archivo = "constancia-laboral-".$id_paquete_archivo.'.pdf';
					$url            = $constancia;
					$file_path      = "static/uploads/constancia_laboral/".$nombre_archivo;					
					$this->fileDownload($url, $file_path);

					$update_p                       = array();
					$update_p["constancia_laboral"] = $file_path;
					$this->model->updatePaqueteArchivo($update_p, $id_paquete_archivo);

					$return = 200;
				}  //termina array_key_exist
				
			}

		}//termina array_key_exist "data", $json

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		return $return;
		// echo "return: ".$return;

	}//termina getHistorialLaboral

	public function getRFC($curp){

		// $curp = "LOID930710HQTPBN04";

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, "https://apimarket.mx/api/sat/grupo/obtener-rfc?curp=".$curp);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		
		$headers = array();
		$headers[] = 'Authorization: Bearer badd8309-2da2-4810-b564-6c903326b5a1';
		$headers[] = 'Accept: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		
		$response = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		
		$json   = json_decode($response, true);
		$return = 400;
		$rfc    = null;
		


		if(array_key_exists("status", $json)){

			$status = $json["status"];

			if($status == 200){
				$rfc    = $json["data"]["rfc"];
				$return = 200;
			}

		}

		return array("return" => $return, "rfc" => $rfc);

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

	}//termina getRFC


	public function getCorreo(){


		$rfc = "LOID9307107U8";
		$id_paquete_archivo = 1;

		$this->getDatos($rfc, $id_paquete_archivo);

	}//termina getCorreo

	public function getDatos($rfc, $id_paquete_archivo){
		// public function getDatos(){
		$curl = curl_init();

		// $rfc = "LOID9307107U8";
		// $id_paquete_archivo = 1;

		$url = 'https://satpi.mx/api/search/'.$rfc.'';
		$headers = [
			'x-api-key: d05eec13-9e8458bc'
		];
		
		$options = [
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => $headers,
			CURLOPT_SSL_VERIFYPEER => false
		];
		
		curl_setopt_array($curl, $options);
		
		$response = curl_exec($curl);
		
		curl_close($curl);

		$json   = json_decode($response, true);
		$return = 400;

		$cp      = NULL;
		$curp    = NULL;
		$nombres = NULL;
		$correo  = NULL;


		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if(array_key_exists("email", $json)){
			
			$cp      = $json["cp"];
			$curp    = $json["curp"];
			$nombres = $json["nombre"];
			$correo  = $json["email"];
			
			if(array_key_exists("regimen", $json)){

				$datos       = $json["regimen"];
				$clave       = null;
				$descripcion = null;
				
				$getRegimen = $this->model->getRegimenFiscal($id_paquete_archivo);

				if(is_null($getRegimen)){//Si es null entonces insertamos

					foreach ($datos as $item) {
					
						$codigo      = $item['clave'];
						$descripcion = $item['descripcion'];
						
						$insert_r                       = array();
						$insert_r["regimen"]            = $descripcion;
						$insert_r["codigo"]             = $codigo;
						$insert_r["id_paquete_archivo"] = $id_paquete_archivo;
						$this->model->insertRegimenFiscal($insert_r);
	
					}//foreach

				}//termina is_null

				$getConstancia = $this->model->getDatosConstancia($id_paquete_archivo);

				if(is_null($getConstancia)){//si es null insertamos

					$insert_c                      = array();
					$insert_c["nombres"]           = $nombres;
					$insert_c["curp"]              = $curp;
					$insert_c["cp"]                = $cp;
					$insert_c["correoElectronico"] = $correo;
					$this->model->insertDatosConstancia($insert_c);

				}else{//si no actualizamos el correo

					$update_c                      = array();
					$update_c["correoElectronico"] = $correo;
					$this->model->updateDatosConstancia($update_c, $id_paquete_archivo);

				}

			}
			
		}

	}//termina getDatos

	public function fileDownload($url, $destination){

		$fp = fopen ($destination, 'w+');
		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $url );
		curl_setopt( $ch, CURLOPT_BINARYTRANSFER, true );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, false );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
	   
		curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 10 );
		curl_setopt( $ch, CURLOPT_FILE, $fp );
		$result = curl_exec( $ch );
		curl_close( $ch );
		fclose( $fp );
	   
	   if ($result) {
		   return true;
	   }else{

		   return false;
	   }
		
  }//termina fileDownload


//   public function crearExcel(){


// 	$fecha      = $this->input->post("fecha");
// 	$supervisor = $this->input->post("supervisor");
// 	$puesto     = $this->input->post("puesto");
// 	$inicio     = $this->input->post("inicio");
// 	$fin        = $this->input->post("fin");

// 	$this->load->library('excel'); // o 'PHPExcel' si es el nombre del archivo en libraries
// 	$objPHPExcel = new PHPExcel();
// 	$sheet = $objPHPExcel->getActiveSheet();


	// $headers = [
	// 	'Global ID (GID)',
	// 	'Country',
	// 	'Name Title (Mr./Ms./Mrs.)',
	// 	'LEGAL First Name',
	// 	'Middle Name',
	// 	'LEGAL Last Name',
	// 	'Secondary Last Name',
	// 	'Local Script First Name',
	// 	'Local Script Middle Name',
	// 	'Local Script Last Name',
	// 	'Social Suffix',
	// 	'Full Name',
	// 	'Gender',
	// 	'Date of Birth',
	// 	'National ID Type / Name',
	// 	'National ID Number',
	// 	'National ID ISO Country Code',
	// 	'National ID - Issued Date',
	// 	'National ID - Expiration Date',
	// 	'National ID - Verification Date',
	// 	'National ID - Series',
	// 	'National ID - Issuing Agency',
	// 	'Home Address - Country',
	// 	'Home Address Line 1',
	// 	'Home Address Line 2',
	// 	'City',
	// 	'Submunicipality Data',
	// 	'Postal Code',
	// 	'Home Phone Area Code',
	// 	'Home Phone Number',
	// 	'Home Phone Device Type',
	// 	'Employee Home Email Address',
	// 	'Manager Global ID (GID)',
	// 	'Manager Name',
	// 	'Legacy Manager',
	// 	'Strong Team',
	// 	'Employee Type',
	// 	'Hire Date',
	// 	'Original Hire Date',
	// 	'Continuous Service Date',
	// 	'Time Off Service Date',
	// 	'Seniority Date',
	// 	'Retirement Eligibility Date',
	// 	'Probation Period Start Date',
	// 	'Probation Period End Date',
	// 	'Employment End Date',
	// 	'Legacy Position Title',
	// 	'Job Profile',
	// 	'Position Title',
	// 	'Business Title',
	// 	'Work Location',
	// 	'Field Employee',
	// 	'Time Type (Full or Part Time)',
	// 	'Work Shift',
	// 	'Default Hours',
	// 	'Scheduled Hours',
	// 	'Legacy Pay Rate Type',
	// 	'Pay Rate Type',
	// 	'Legacy Frequency',
	// 	'Frequency',
	// 	'Legacy Overtime Eligibility',
	// 	'Overtime Eligibility',
	// 	'Period Salary Plan',
	// 	'Legacy Amount',
	// 	'BD Amount',
	// 	'Currency',
	// 	'Compensation Package',
	// 	'Compensation Grade',
	// 	'Compensation Grade Profile',
	// 	'Compensation Step',
	// 	'Progression Start Date',
	// 	'Bonus Plan',
	// 	'Bonus Individual Target Percent',
	// 	'Merit Plan',
	// 	'Stock Plan',
	// 	'Stock Individual Target Amount',
	// 	'Stock ID',
	// 	'Company Code',
	// 	'Company Name',
	// 	'Legacy Cost Center',
	// 	'Cost Center',
	// 	'Line of Sight',
	// 	'Legacy Plan Flag',
	// 	'Labor Type',
	// 	'Pay Group',
	// 	'(eTime) Accrual Profile',
	// 	'(eTime) Pay Rule',
	// 	'(eTime) Person Type',
	// 	'Step or No Step',
	// 	'Salary Adjustment',
	// 	'Former BD associate',
	// 	'ID Type (RFC)',
	// 	'Supervisory Organization Number',
	// 	'Workplace Arrangement',
	// 	'Pay Plan',
	// 	'JG'
	// ];


// 	// Encabezados
// 	$col = 0;
// 	foreach ($headers as $header) {
// 		$sheet->setCellValueByColumnAndRow($col, 1, $header);
// 		$col++;
// 	}

// 	// Configurar nombre del archivo
// 	$filename = 'Plantilla_BD_' . date('Ymd_His') . '.xlsx';

// 	// Enviar al navegador
// 	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
// 	header("Content-Disposition: attachment;filename=\"$filename\"");
// 	header('Cache-Control: max-age=0');

// 	$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
// 	$writer->save('php://output');
// 	exit;



//   }//termina crearExcel


  	public function test(){

		$headers = [
			'NA',
			'Field Name',
			'Global ID (GID)',
			'Country',
			'Name Title (Mr./Ms./Mrs.)',
			'LEGAL First Name',
			'Middle Name',
			'LEGAL Last Name',
			'Secondary Last Name',
			'Local Script First Name',
			'Local Script Middle Name',
			'Local Script Last Name',
			'Social Suffix',
			'Full Name',
			'Gender',
			'Date of Birth',
			'National ID Type / Name',
			'National ID Number',
			'National ID ISO Country Code',
			'National ID - Issued Date',
			'National ID - Expiration Date',
			'National ID - Verification Date',
			'National ID - Series',
			'National ID - Issuing Agency',
			'Home Address - Country',
			'Home Address Line 1',
			'Home Address Line 2',
			'City',
			'Submunicipality Data',
			'Postal Code',
			'Home Phone Area Code',
			'Home Phone Number',
			'Home Phone Device Type',
			'Employee Home Email Address',
			'Manager Global ID (GID)',
			'Manager Name',
			'Legacy Manager',
			'Strong Team',
			'Employee Type',
			'Hire Date',
			'Original Hire Date',
			'Continuous Service Date',
			'Time Off Service Date',
			'Seniority Date',
			'Retirement Eligibility Date',
			'Probation Period Start Date',
			'Probation Period End Date',
			'Employment End Date',
			'Legacy Position Title',
			'Job Profile',
			'Position Title',
			'Business Title',
			'Work Location',
			'Field Employee',
			'Time Type (Full or Part Time)',
			'Work Shift',
			'Default Hours',
			'Scheduled Hours',
			'Legacy Pay Rate Type',
			'Pay Rate Type',
			'Legacy Frequency',
			'Frequency',
			'Legacy Overtime Eligibility',
			'Overtime Eligibility',
			'Period Salary Plan',
			'Legacy Amount',
			'BD Amount',
			'Currency',
			'Compensation Package',
			'Compensation Grade',
			'Compensation Grade Profile',
			'Compensation Step',
			'Progression Start Date',
			'Bonus Plan',
			'Bonus Individual Target Percent',
			'Merit Plan',
			'Stock Plan',
			'Stock Individual Target Amount',
			'Stock ID',
			'Company Code',
			'Company Name',
			'Legacy Cost Center',
			'Cost Center',
			'Line of Sight',
			'Legacy Plan Flag',
			'Labor Type',
			'Pay Group',
			'(eTime) Accrual Profile',
			'(eTime) Pay Rule',
			'(eTime) Person Type',
			'Step or No Step',
			'Salary Adjustment',
			'Salary Adjustment',
			'Former BD associate',
			'ID Type (RFC)',
			'Supervisory Organization Number',
			'Workplace Arrangement',
			'Pay Plan',
			'Workplace Arrangement',
			'JG'
		];


		$col = 0;
		foreach ($headers as $header) {
			echo "header: ".$header."<br>";
			$col++;
		}

	}


	public function crearExcel(){

		$inicio             = $this->input->post("inicio");
		$fin                = $this->input->post("fin");
		$fecha_contratacion = $this->input->post("fecha");
		$id_supervisor      = $this->input->post("supervisor");
		$id_puesto          = $this->input->post("puesto");
		
		$this->load->library('ExcelSpreadsheet');
		$spreadsheet = new ExcelSpreadsheet();
		$sheet = $spreadsheet->getActiveSheet();

		$headers = [
			'',
			'Field Name',
			'Global ID (GID)',
			'Country',
			'Name Title (Mr./Ms./Mrs.)',
			'LEGAL First Name',
			'Middle Name',
			'LEGAL Last Name',
			'Secondary Last Name',
			'Local Script First Name',
			'Local Script Middle Name',
			'Local Script Last Name',
			'Social Suffix',
			'Full Name',
			'Gender',
			'Date of Birth',
			'National ID Type / Name',
			'National ID Number',
			'National ID ISO Country Code',
			'National ID - Issued Date',
			'National ID - Expiration Date',
			'National ID - Verification Date',
			'National ID - Series',
			'National ID - Issuing Agency',
			'Home Address - Country',
			'Home Address Line 1',
			'Home Address Line 2',
			'City',
			'Submunicipality Data',
			'Postal Code',
			'Home Phone Area Code',
			'Home Phone Number',
			'Home Phone Device Type',
			'Employee Home Email Address',
			'Manager Global ID (GID)',
			'Manager Name',
			'Legacy Manager',
			'Strong Team',
			'Employee Type',
			'Hire Date',
			'Original Hire Date',
			'Continuous Service Date',
			'Time Off Service Date',
			'Seniority Date',
			'Retirement Eligibility Date',
			'Probation Period Start Date',
			'Probation Period End Date',
			'Employment End Date',
			'Legacy Position Title',
			'Job Profile',
			'Position Title',
			'Business Title',
			'Work Location',
			'Field Employee',
			'Time Type (Full or Part Time)',
			'Work Shift',
			'Default Hours',
			'Scheduled Hours',
			'Legacy Pay Rate Type',
			'Pay Rate Type',
			'Legacy Frequency',
			'Frequency',
			'Legacy Overtime Eligibility',
			'Overtime Eligibility',
			'Period Salary Plan',
			'Legacy Amount',
			'BD Amount',
			'Currency',
			'Compensation Package',
			'Compensation Grade',
			'Compensation Grade Profile',
			'Compensation Step',
			'Progression Start Date',
			'Bonus Plan',
			'Bonus Individual Target Percent',
			'Merit Plan',
			'Stock Plan',
			'Stock Individual Target Amount',
			'Stock ID',
			'Company Code',
			'Company Name',
			'Legacy Cost Center',
			'Cost Center',
			'Line of Sight',
			'Legacy Plan Flag',
			'Labor Type',
			'Pay Group',
			'(eTime) Accrual Profile',
			'(eTime) Pay Rule',
			'(eTime) Person Type',
			'Step or No Step',
			'Salary Adjustment',
			'Salary Adjustment',
			'Former BD associate',
			'ID Type (RFC)',
			'Supervisory Organization Number',
			'Workplace Arrangement',
			'Pay Plan',
			'Workplace Arrangement',
			'JG'
		];

		// echo "<pre>";
		// print_r($headers);
		// exit;

		$col = 1;
		foreach ($headers as $header) {
			$sheet->setCellValueByColumnAndRow($col, 1, $header);
			$col++;
		}

		// Estilo para encabezados
		$styleArray = [
			'font' => [
				'bold' => true,
				'color' => ['rgb' => '000000'],
			],
			'fill' => [
				'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
				'startColor' => ['rgb' => 'D9E1F2'] // Azul clarito (opcional)
			],
			'alignment' => [
				'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
				'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
				'wrapText' => true
			],
			'borders' => [
				'allBorders' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
				],
			],
		];

		// Aplicar estilo a la fila 1 (encabezados)
		$lastCol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex(count($headers));
		$sheet->getStyle("A1:{$lastCol}1")->applyFromArray($styleArray);

		$puesto         = "N/A";
		$job_profile    = "N/A";
		$position_title = "N/A";
		$legacy_amount  = "N/A";
		$jg             = "N/A";
		$getPuesto      = $this->model->getCatalogoPuestoById($id_puesto);

		if (!is_null($getPuesto)) {
			$puesto         = $getPuesto->puesto;
			$job_profile    = $getPuesto->job_profile;
			$position_title = $getPuesto->position_title;
			$legacy_amount  = $getPuesto->legacy_amount;
			$jg             = $getPuesto->jg;
		}

		$num_empleado      = "N/A";
		$nombre_supervisor = "N/A";
		$organizacion      = "N/A";
		$centro_costos     = "N/A";
		$getSupervisor     = $this->model->getCatalogoSupervisorById($id_supervisor);

		if (!is_null($getSupervisor)) {
			$num_empleado      = $getSupervisor->num_empleado;
			$nombre_supervisor = $getSupervisor->nombre_supervisor;
			$organizacion      = $getSupervisor->organizacion;
			$centro_costos     = $getSupervisor->centro_costos;
		}
		
		$filtro = $this->model->getFiltroPaquetesArchivos($inicio, $fin);

		if (!is_null($filtro)) {
			$row = 2;
			$contador = 1;

			foreach ($filtro as $f) {

				$calle       = $f->calle;
				$domicilio_c = '';
				if (!is_null($calle)) {
					$domicilio_c = $this->reordenarDomicilio($calle);
				}
				if (!is_null($f->colonia)) {

					
					$domicilio_c = $domicilio_c.", ".$f->colonia;

					$domicilio_c = $this->reordenarDomicilio($domicilio_c);
				}

				$sheet->setCellValueByColumnAndRow(1, $row, $contador);
				$sheet->setCellValueByColumnAndRow(2, $row, '');
				$sheet->setCellValueByColumnAndRow(3, $row, '');
				$sheet->setCellValueByColumnAndRow(4, $row, 'MEX');
				$sheet->setCellValueByColumnAndRow(5, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(6, $row, $f->nombres);
				$sheet->setCellValueByColumnAndRow(7, $row, 'N/A');
				$apellidos = trim($f->primerApellido . ' ' . $f->segundoApellido);
				$sheet->setCellValueByColumnAndRow(8, $row, $apellidos);
				$sheet->setCellValueByColumnAndRow(9, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(10, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(11, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(12, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(13, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(14, $row, 'N/A');

				$sexo = strtoupper(trim($f->sexo)) === 'H' ? 'MALE' : 'FEMALE';
				$sheet->setCellValueByColumnAndRow(15, $row, $sexo);

				$sheet->setCellValueByColumnAndRow(16, $row, $f->fechaNacimiento);
				$sheet->setCellValueByColumnAndRow(17, $row, $f->nss);
				$sheet->setCellValueByColumnAndRow(18, $row, $f->curp);

				$sheet->setCellValueByColumnAndRow(19, $row, 'MEX');  // Col S
				$sheet->setCellValueByColumnAndRow(20, $row, 'N/A');  // Col T
				$sheet->setCellValueByColumnAndRow(21, $row, 'N/A');  // Col U
				$sheet->setCellValueByColumnAndRow(22, $row, 'N/A');  // Col V
				$sheet->setCellValueByColumnAndRow(23, $row, 'N/A');  // Col W
				$sheet->setCellValueByColumnAndRow(24, $row, 'N/A');  // Col X
				$sheet->setCellValueByColumnAndRow(25, $row, 'MEX');  // Col Y
				$sheet->setCellValueByColumnAndRow(26, $row, $domicilio_c);
				$sheet->setCellValueByColumnAndRow(27, $row, 'N/A');
				$sheet->setCellValueByColumnAndRow(28, $row, 'TIJUANA');                                                      // AB
				$sheet->setCellValueByColumnAndRow(29, $row, 'BAJA CALIFORNIA');                                              // AC
				$sheet->setCellValueByColumnAndRow(30, $row, $f->cp);                                                         // AD
				
				$sheet->setCellValueExplicitByColumnAndRow(31, $row, $f->lada_pais, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);

				// $sheet->setCellValueByColumnAndRow(31, $row, $f->lada_pais);                                                  // AE
				$sheet->setCellValueByColumnAndRow(32, $row, $f->celular_persona);                                            // AF
				$sheet->setCellValueByColumnAndRow(33, $row, 'MOBILE');                                                       // AG
				$sheet->setCellValueByColumnAndRow(34, $row, $f->correoElectronico);                                          // AH
				$sheet->setCellValueByColumnAndRow(35, $row, $num_empleado);                                                  // AI
				$sheet->setCellValueByColumnAndRow(36, $row, $nombre_supervisor);                                             // AJ
				$sheet->setCellValueByColumnAndRow(37, $row, 'N/A');                                                          // AK
				$sheet->setCellValueByColumnAndRow(38, $row, 'Medication Delivery Solutions Manufacturing Sub-Strong Team');  // AL
				$sheet->setCellValueByColumnAndRow(39, $row, 'REGULAR');                                                      // AM
				$sheet->setCellValueByColumnAndRow(40, $row, $fecha_contratacion);                                            // AN

				$sheet->setCellValueByColumnAndRow(41, $row, $fecha_contratacion);                // AO
				$sheet->setCellValueByColumnAndRow(42, $row, $fecha_contratacion);                // AP
				$sheet->setCellValueByColumnAndRow(43, $row, $fecha_contratacion);                // AQ
				$sheet->setCellValueByColumnAndRow(44, $row, $fecha_contratacion);                // AR
				$sheet->setCellValueByColumnAndRow(45, $row, 'N/A');                              // AS
				$sheet->setCellValueByColumnAndRow(46, $row, 'N/A');                              // AT
				$sheet->setCellValueByColumnAndRow(47, $row, 'N/A');                              // AU
				$sheet->setCellValueByColumnAndRow(48, $row, 'N/A');                              // AV
				$sheet->setCellValueByColumnAndRow(49, $row, $puesto);                            // AW
				$sheet->setCellValueByColumnAndRow(50, $row, $job_profile);                       // AX
				$sheet->setCellValueByColumnAndRow(51, $row, $position_title);                    // AY
				$sheet->setCellValueByColumnAndRow(52, $row, $puesto);                            // AZ
				$sheet->setCellValueByColumnAndRow(53, $row, 'MEX Tijuana - Alaris El Florido');  // BA
				$sheet->setCellValueByColumnAndRow(54, $row, 'N/A');                              // BB
				$sheet->setCellValueByColumnAndRow(55, $row, 'Full Time');                        // BC
				$sheet->setCellValueByColumnAndRow(56, $row, 'N/A');                              // BD
				$sheet->setCellValueByColumnAndRow(57, $row, '48');                               // BE
				$sheet->setCellValueByColumnAndRow(58, $row, '48');                               // BF
				$sheet->setCellValueByColumnAndRow(59, $row, 'DAILY');                            // BG
				$sheet->setCellValueByColumnAndRow(60, $row, 'DAILY');                            // BH
				$sheet->setCellValueByColumnAndRow(61, $row, 'DAILY');                            // BI
				$sheet->setCellValueByColumnAndRow(62, $row, 'DAILY');                            // BJ
				$sheet->setCellValueByColumnAndRow(63, $row, 'YES');                              // BK
				$sheet->setCellValueByColumnAndRow(64, $row, 'YES');                              // BL
				$sheet->setCellValueByColumnAndRow(65, $row, '12 Month Plan');                    // BM
				
				$sheet->setCellValueByColumnAndRow(66, $row, "$".$legacy_amount);                             // BN
				$sheet->setCellValueByColumnAndRow(67, $row, "$".$legacy_amount);                             // BO
				$sheet->setCellValueByColumnAndRow(68, $row, 'MXN');                                      // BP
				$sheet->setCellValueByColumnAndRow(69, $row, 'GENERAL COMPENSATION PACKAGE');             // BQ
				$sheet->setCellValueByColumnAndRow(70, $row, 'O1');                                       // BR
				$sheet->setCellValueByColumnAndRow(71, $row, 'O1/Mexico/D/II/Daily');                     // BS
				$sheet->setCellValueByColumnAndRow(72, $row, 'N/A');                                      // BT
				$sheet->setCellValueByColumnAndRow(73, $row, 'N/A');                                      // BU
				$sheet->setCellValueByColumnAndRow(74, $row, 'N/A');                                      // BV
				$sheet->setCellValueByColumnAndRow(75, $row, 'N/A');                                      // BW
				$sheet->setCellValueByColumnAndRow(76, $row, 'N/A');                                      // BX
				$sheet->setCellValueByColumnAndRow(77, $row, 'N/A');                                      // BY
				$sheet->setCellValueByColumnAndRow(78, $row, 'N/A');                                      // BZ
				$sheet->setCellValueByColumnAndRow(79, $row, 'N/A');                                      // CA
				$sheet->setCellValueByColumnAndRow(80, $row, '0190');                                     // CB
				$sheet->setCellValueByColumnAndRow(81, $row, 'Sistemas Médicos ALARIS, S.A. de C.V.');    // CC
				$sheet->setCellValueByColumnAndRow(82, $row, 'N/A');                                      // CD
				$sheet->setCellValueByColumnAndRow(83, $row, $centro_costos);                             // CE
				$sheet->setCellValueByColumnAndRow(84, $row, 'GMIP - Tijuana CFN MDS');                   // CF
				$sheet->setCellValueByColumnAndRow(85, $row, 'CareFusion Legacy Plans');                  // CG
				$sheet->setCellValueByColumnAndRow(86, $row, 'None');                                     // CH
				$sheet->setCellValueByColumnAndRow(87, $row, 'MEX12 MEX-Mexico Tijuana, Weekly (0190)');  // CI
				$sheet->setCellValueByColumnAndRow(88, $row, 'N/A');                                      // CJ
				$sheet->setCellValueByColumnAndRow(89, $row, 'N/A');                                      // CK
				$sheet->setCellValueByColumnAndRow(90, $row, 'N/A');                                      // CL
				$sheet->setCellValueByColumnAndRow(91, $row, 'No Step');                                  // CM
				$sheet->setCellValueByColumnAndRow(92, $row, 'N/A');                                      // CN
				$sheet->setCellValueByColumnAndRow(93, $row, 'N/A');                                      // CO
				$sheet->setCellValueByColumnAndRow(94, $row, 'N/A');                                      // CP
				$sheet->setCellValueByColumnAndRow(95, $row, $f->rfc);                                    // CQ
				$sheet->setCellValueByColumnAndRow(96, $row, $organizacion);                              // CR
				$sheet->setCellValueByColumnAndRow(97, $row, 'Onsite>Manufacturing');                     // CS
				$sheet->setCellValueByColumnAndRow(98, $row, 'Hourly Plan');                              // CT
				$sheet->setCellValueByColumnAndRow(99, $row, 'On-site');                                  // CU
				$sheet->setCellValueByColumnAndRow(100, $row, $jg);                                       // CV
				

				$contador++;
				$row++;
			}
		}

		for ($i = 1; $i <= count($headers); $i++) {
			$colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($i);
			$sheet->getColumnDimension($colLetter)->setAutoSize(true);
		}

		// Guardar archivo
		$filename = 'Plantilla_BD_' . date('Ymd_His') . '.xlsx';
		$filepath = FCPATH . 'static/excel/' . $filename;

		// Writer
		$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
		$writer->save($filepath);

		echo json_encode([
			'respuesta' => 200,
			'url' => base_url().'static/excel/' . $filename
		]);

	}  //termina crearExcel
	
	// function reordenarDomicilio($direccion) {
	// 	$direccionSinCP = preg_replace('/\bCP\.?\d*/i', '', $direccion);
	// 	if (preg_match('/\b(\d+)\b/', $direccionSinCP, $coincidencias)) {
	// 		$numero = $coincidencias[1];
	// 		$resto = preg_replace('/\b' . preg_quote($numero, '/') . '\b/', '', $direccionSinCP, 1);
	// 		return trim($numero . ' ' . trim($resto));
	// 	}
	// 	return trim($direccionSinCP);
	// }

	public function testdomicilio(){
		$direccion = "17906 COLINA SAN ANTONIC, COLINAS DE LA PRESA, C.P 22125";
		$resultado = $this->reordenarDomicilio($direccion);
		echo "Dirección original: " . $direccion . "<br>";
		echo "Dirección reordenada: " . $resultado . "<br>";
	}

	public function reordenarDomicilio($direccion) {
		
		// 0) Quitar tags <br>, variantes y "br" como palabra
		$txt = preg_replace('/<\s*br\s*\/?>/i', ' ', $direccion);
		$txt = preg_replace('/\bbr\b/i', ' ', $txt);

		// 1) Quitar CP, CP. y CP.<números> (aunque venga pegado)
		$txt = preg_replace('/\.?CP\.?\s*\d*/i', ' ', $txt);

		// 2) Detectar el primer número
		if (preg_match('/\b(\d+)\b/u', $txt, $m)) {
			$numero = $m[1];

			// 3) Eliminar solo la primera aparición de ese número
			$resto = preg_replace('/\b' . preg_quote($numero, '/') . '\b/u', ' ', $txt, 1);

			// 4) Eliminar el resto de números
			$resto = preg_replace('/\d+/u', ' ', $resto);

			// 5) Eliminar puntuación/símbolos sobrantes
			$resto = preg_replace('/[^\p{L}\s]/u', ' ', $resto);

			// 6) Eliminar letras sueltas (p. ej., "B"), pero conservar palabras normales (de, la, etc. no se tocan por ser 2+ letras)
			$resto = preg_replace('/\b\p{L}\b/u', ' ', $resto);

			// 7) Normalizar espacios
			$resto = preg_replace('/\s{2,}/u', ' ', trim($resto));

			return trim($numero . ' ' . $resto);
		}

		// Si no hay número: limpiar igual
		$txt = preg_replace('/\d+/u', ' ', $txt);
		$txt = preg_replace('/[^\p{L}\s]/u', ' ', $txt);
		$txt = preg_replace('/\b\p{L}\b/u', ' ', $txt);
		$txt = preg_replace('/\s{2,}/u', ' ', trim($txt));
		return $txt;
	}

	public function getCiudadCp(){

		$cp  = "64000";
		$url = "https://api-sepomex.hckdrk.mx/query/info_cp/$cp?type=simplified";

		$response = file_get_contents($url);
		$data     = json_decode($response, true);

		if (isset($data['response']['municipio']) && isset($data['response']['estado'])) {
			$municipio = $data['response']['municipio'];
			$estado    = $data['response']['estado'];
			echo "Municipio: $municipio<br>Estado: $estado";
		} else {
			echo "No se pudo obtener información del código postal.";
		}

	}


}//termina class
