<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Personas extends CI_Controller {

	/*
	Creamos un constructor para validar que exista una sesion 
	y poder dar acceso a las siguientes vistas
	*/
	
	public function __construct(){
		
		parent::__construct();
		// $this->load->library('encrypt');
		
		header("Cache-Control: no-store,no-cache,must-revalidate;");
		header("Cache-Control: post-check=0,pre-check=0", FALSE);
		header("Pragma:no-chache");
	 	
		if($this->session->userdata("usuario") == false){
		
			$this->session->set_flashdata("error","Acceso Restringido");
	
			redirect("login/");
	
		}
		$this->load->model("personas_model", "model");		
	}

	public function index(){

		$data["_APP_TITTLE"] = "Personas";
		$data["_TAB"]        = "pers";
		$data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
		$data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
		$data["personas"]    = $this->model->getPersonas();
		$data["fragment"]    = $this->load->view('app/admin/fragments/personas_view', $data, TRUE);
		$this->load->view('app/admin/main_view', $data, FALSE);
	
	}//termina index

	public function filtrar(){
		
		$inicio    = $this->input->post("inicio");
		$fin       = $this->input->post("fin");

		$getFiltro = $this->model->getFiltro($inicio, $fin);

		$tabla     = "";
		$cont      = 1;
		$respuesta = 400;

		if (!is_null($getFiltro)) {
			$respuesta 	= 200;
			$cont       = 1;
			$estatus	= "";
			foreach ($getFiltro as $v) {
				
				$tabla .= "<tr><td>".$cont."</td>";
				$tabla .= "<td>".$v->nombre_persona."</td>";
				$tabla .= "<td>".$v->celular_persona."</td>";
				$tabla .= "<td>".$v->registro."</td>";
				$tabla .= "<td>".$v->fecha_registro."</td></tr>";

				$cont++;
			}//termina foreach
		}//termina isnull

		echo json_encode(array("tabla" => $tabla, "respuesta" => $respuesta));

	}//termina filtrar

}
