<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Rutas extends CI_Controller {

	/*
	Creamos un constructor para validar que exista una sesion 
	y poder dar acceso a las siguientes vistas
	*/
	
	public function __construct(){
		
		parent::__construct();
		// $this->load->library('encrypt');
		
		header("Cache-Control: no-store,no-cache,must-revalidate;");
		header("Cache-Control: post-check=0,pre-check=0", FALSE);
		header("Pragma:no-chache");
	 	
		if($this->session->userdata("usuario") == false){
		
			$this->session->set_flashdata("error","Acceso Restringido");
	
			redirect("login/");
	
		}
		$this->load->model("rutas_model", "model");		
	}

	public function index(){

		$data["_APP_TITTLE"] = "Rutas";
		$data["_TAB"]        = "ruta";
		$data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
		$data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
		$data["pdf"]    	 = $this->model->getPdf();
		$data["fragment"]    = $this->load->view('app/admin/fragments/rutas_view', $data, TRUE);
		$this->load->view('app/admin/main_view', $data, FALSE);
	
	}//termina index

	public function updateFile(){

		date_default_timezone_set('America/Mexico_City');
		$hoy      = date("Y-m-d");
		$hoy_hora = date("Y-m-d H:i:s");
		$hora     = date("H:i:s");
		
		$respuesta      = 500;
		$mensaje        = "";

		if (isset($_FILES["file"])) {
			$name = $_FILES["file"]['name'];
			$ext  = pathinfo($name, PATHINFO_EXTENSION);
			$ext  = strtolower($ext);

			// die("ext: ".$ext);

			if ($ext == "pdf" || $ext == "jpg" || $ext == "jpeg" || $ext == "png" || $ext == "xlsx" || $ext == "xls") {

				if ($ext == "pdf") {
					$type = "file";
				}else if($ext == "xlsx" || $ext == "xls"){
					$type = "xlsx";
				}else{
					$type = "image";
				}
				$nombre_archivo = "rutas.".$ext;
				if (move_uploaded_file($_FILES["file"]["tmp_name"], "static/principal/".$nombre_archivo)) {

					$url = base_url()."static/principal/".$nombre_archivo."";

					$update_r 				= array();
					$update_r["pdf_ruta"] 	= $url;
					$update_r["tipo"] 		= $type;

					if($this->model->updateRuta($update_r)){
						$respuesta = 200;
						$mensaje = "Archivo actualizado con éxito";
					}else {
						$respuesta = 200;
						$mensaje = "Error al actualizar archivo";
					}

				}else {
					$respuesta = 300;
					$mensaje = "No se pudo subir el archivo, vuelve a intentarlo";
				}
			}else{
				$respuesta = 300;
				$mensaje = "Por favor selecciona un archivo tipo PDF, PNG, JPEG o JPG";
			}
		}else{
			$respuesta = 300;
			$mensaje = "Por favor selecciona un archivo";
		}


		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina updateFile

}
