<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Usuarios extends CI_Controller {

	
	public function __construct(){
		
		parent::__construct();
		$this->load->model("usuarios_model", "model");
		$this->load->library('encryption');
		header("Cache-Control: no-store,no-cache,must-revalidate;");
		header("Cache-Control: post-check=0,pre-check=0", FALSE);
		header("Pragma:no-chache");
	 	
		if($this->session->userdata("usuario") == false){
		
			$this->session->set_flashdata("error","Acceso Restringido");
	
			redirect("login/");
	
		}else if($this->session->userdata("id_tipo_usuario") != 1){

			redirect("admin/dashboard/");

		}
	
	}//termina constructor


	public function index(){

		if ($this->session->userdata('id_tipo_usuario') == 1) {
			
			$data["_APP_TITTLE"]        = "Usuarios";
			$data["_TAB"]               = "user";
			$data["main_menu"]          = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
			$data["nav"]                = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
			$data["usuarios"]           = $this->model->getUsuarioTipo();
			$data["tipo"]               = $this->model->getTipo();
			$data["fragment"]           = $this->load->view('app/admin/fragments/usuarios_view', $data, TRUE);
			$this->load->view('app/admin/main_view', $data, FALSE);
		}else{
			die("Acceso restringido");
		}

	}

	public function insertar_usuario(){
		
		$usuario          = $this->input->post('usuario');
		$correo           = $this->input->post('correo');
		$password         = $this->input->post('contraseña');
		$tipo_usuario     = $this->input->post('tipo_usuario');
		$estatus          = $this->input->post('estatus');
		$regreso          = 500;
		$mensaje          = "Error, vuelve a intentarlo";

		$encrypted_string = $this->encryption->encrypt($password);
		
		$getUsuario       = $this->model->getUsuario($correo);

		if (is_null($getUsuario)) {

			$datosAddUsuario             = array();
			$datosAddUsuario['usuario']  = $usuario;
			$datosAddUsuario['correo']   = $correo;
			$datosAddUsuario['password'] = $encrypted_string;
			$datosAddUsuario['id_tipo']  = $tipo_usuario;
			$datosAddUsuario['estatus']  = $estatus;

			$idInsert = $this->model->insertUsuario($datosAddUsuario);

			if(!is_null($idInsert)){
				$regreso = 200;
				$mensaje = "Usuario agregado";
			}else{
				$regreso = 400;
				$mensaje = "Error al insertar usuario";
			}

		}else{
			$regreso = 300;
			$mensaje = "Este correo ya esta registrado";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));

	}

	public function getUsuario(){

		$id_usuario = $this->input->post("id_usuario");
		$datos      = $this->model->usuario($id_usuario);
		$regreso    = false;

		$usuario    = "";
		$pass       = "";
		$tipo       = "";
		$correo     = "";
		$estatus    = "";

		if (!is_null($datos)) {
			$usuario    = $datos->usuario;
			$tipo       = $datos->id_tipo;
			$correo     = $datos->correo;
			$estatus    = $datos->estatus;
			$regreso    = true;
		}

		echo json_encode(array("regreso" => $regreso, "usuario" => $usuario, "correo" => $correo, "tipo" => $tipo, "estatus" => $estatus));

	}//getUsuario


	public function updateUsuario(){
		
		$usuario      = $this->input->post('usuario');
		$correo       = $this->input->post('correo');
		$tipo_usuario = $this->input->post('tipo_usuario');
		$estatus      = $this->input->post('estatus');
		$regreso      = 500;
		$mensaje      = "Error, vuelve a intentarlo";
		$id_usuario   = $this->input->post("id_usuario");
		$getUsuario   = $this->model->getUsuarioRegistrado($correo, $id_usuario);

		if (is_null($getUsuario)) {

			$datos            = array();
			$datos['usuario'] = $usuario;
			$datos['correo']  = $correo;
			$datos['id_tipo'] = $tipo_usuario;
			$datos['estatus'] = $estatus;

			$respuestaUpdate = $this->model->actualizarUsuario($datos, $id_usuario);

			if ($respuestaUpdate) {
				$regreso = 200;
				$mensaje = "Usuario actualizado";
			}else{
				$regreso = 400;
				$mensaje = "No se pudo actualizar";
			}

		}else{
			$regreso = 300;
			$mensaje = "Este correo ya se encuentra registrado, intenta con otro";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));

	}//termina updateUsuario

	public function actualizarPass(){
		
		$id_usuario   = $this->input->post("id_usuario");
		// $contra_ant   = $this->input->post("contra_ant");
		$contra_nueva = $this->input->post("contra_nueva");
		$confirmar    = $this->input->post("confirmar");
		$pass         = "";
		$regreso      = false;
		$mensaje      = "";

		$datos = $this->model->usuario($id_usuario);

		if (!is_null($datos)) {

			// $key    = 'bd_fx_2022*';
			// $contra = $this->encrypt->encode($confirmar, $key);

			$contra = $this->encryption->encrypt($confirmar);
			
			$update             = array();
			$update["password"] = $contra;	
			$this->model->actualizarUsuario($update, $id_usuario);
			
			$regreso = true;
			$mensaje = "Contraseña actualizada correctamente";

		}else{
			$mensaje = "Error, vuelve a intentarlo";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));

	}//actualizarPass
	
	public function logout(){

		$arr_sesiones = array();
		
		$arr_sesiones["usuario"] = FALSE;
		$arr_sesiones["password"] = FALSE;
		
		$this->session->unset_userdata($arr_sesiones);
		
		redirect("login/");

	}



}
