<?php class Vacantes_model extends CI_Model{

	
	public function getVacantes(){
	
		$query = $this->db->query("SELECT * FROM vacantes v
									INNER JOIN usuarios u ON u.id_usuario = v.id_usuario
									WHERE v.estatus_vacante = 1
									ORDER BY v.nombre_vacante ASC;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getVacantes

	public function getPostulaciones($id_vacante){
	
		$query = $this->db->query("SELECT pv.*, p.celular_persona, p.nombre_persona, p.registro
									FROM persona_vacante pv
									INNER JOIN personas p ON p.id_persona = pv.id_persona
									WHERE pv.id_vacante = ".$id_vacante."
									GROUP BY p.id_persona ORDER BY pv.id_persona_vacante DESC;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getPostulaciones

	public function getVacante($nombre_vacante){
	
		$query = $this->db->query("SELECT * FROM vacantes v WHERE v.nombre_vacante = '".$nombre_vacante."' AND v.estatus_vacante = 1;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getVacante

	public function getTurnos($id_vacante){
	
		$query = $this->db->query("SELECT * FROM turnos_vacantes t 
									WHERE t.id_vacante = ".$id_vacante." AND t.estatus = 1
									ORDER BY t.desc_turno ASC;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getTurnos

	public function getTurno($id_vacante, $nombre_turno){
	
		$query = $this->db->query("SELECT * FROM turnos_vacantes t 
									WHERE t.id_vacante = ".$id_vacante." AND t.estatus = 1 AND t.desc_turno = '".$nombre_turno."';");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getTurno

	public function getVacanteUpdate($id_vacante, $nombre_vacante){
	
		$query = $this->db->query("SELECT * FROM vacantes v 
									WHERE v.id_vacante != ".$id_vacante."
									AND v.nombre_vacante = '".$nombre_vacante."' 
									AND v.estatus_vacante = 1;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getVacanteUpdate

	public function getTurnoUpdate($id_turno_vacante, $id_vacante, $nombre_turno){
	
		$query = $this->db->query("SELECT * FROM turnos_vacantes t 
									WHERE t.id_vacante = ".$id_vacante." 
									AND t.estatus = 1 
									AND t.desc_turno = '".$nombre_turno."'
									AND t.id_turno_vacante != ".$id_turno_vacante.";");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getTurnoUpdate

	public function getInfoTurno($id_turno_vacante){
	
		$query = $this->db->query("SELECT * FROM turnos_vacantes t 
									WHERE t.id_turno_vacante = ".$id_turno_vacante.";");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getInfoTurno

	public function getInfoVacante($id_vacante){
	
		$query = $this->db->query("SELECT * FROM vacantes v WHERE v.id_vacante = ".$id_vacante.";");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getInfoVacante

	public function getFiltroTodos(){
	
		$query = $this->db->query("SELECT * FROM vacantes v 
									INNER JOIN usuarios u ON u.id_usuario = v.id_usuario
									ORDER BY v.nombre_vacante ASC;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getFiltroTodos

	public function getFiltroEstatus($estatus){
	
		$query = $this->db->query("SELECT * FROM vacantes v 
									INNER JOIN usuarios u ON u.id_usuario = v.id_usuario
									WHERE v.estatus_vacante = ".$estatus."
									ORDER BY v.nombre_vacante ASC;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getFiltroEstatus
	

	public function insertVacante($datos){

		$this->db->insert('vacantes', $datos);
		return TRUE;
		
	}//insertVacante

	public function insertTurno($datos){

		$this->db->insert('turnos_vacantes', $datos);
		return TRUE;
		
	}//insertTurno

	public function updateTurno($id_turno_vacante, $datos){

		$this->db->where('id_turno_vacante', $id_turno_vacante);
		$this->db->update('turnos_vacantes', $datos);
        return TRUE;

	}//updateTurno

	public function updateVacante($id_vacante, $datos){

		$this->db->where('id_vacante', $id_vacante);
		$this->db->update('vacantes', $datos);
        return TRUE;

	}//updateVacante

}