<div class = "row">
<div class = "col-md-12">
<h1  class = "page-header"><i class = "fa fa-book"></i> Cargar archivos</h1>
    </div>
</div>

<div class="row">
    <!-- INE -->
    <div class="col-md-12 mb-4">
        <fieldset class="border p-4">
            <legend class="w-auto">INE (JPG, PNG, JPEG)</legend>
            <div class="drop-zone">
                <input type="file" class="drop-zone__input" id="ineFile" accept="image/jpeg, image/png">
                <span class="drop-zone__prompt">Arrastra aquí o haz clic para subir</span>
            </div>
        </fieldset>
    </div>

    <!-- Comprobante de domicilio -->
    <div class="col-md-12 mb-4">
        <fieldset class="border p-4">
            <legend class="w-auto">Comprobante de domicilio (PDF, JPG, PNG, JPEG)</legend>
            <div class="drop-zone">
                <input type="file" class="drop-zone__input" id="domicilioFile" accept="application/pdf, image/jpeg, image/png">
                <span class="drop-zone__prompt">Arrastra aquí o haz clic para subir</span>
            </div>
        </fieldset>
    </div>

    <!-- Constancia de situación fiscal -->
    <div class="col-md-12 mb-4">
        <fieldset class="border p-4">
            <legend class="w-auto">Constancia de situación fiscal (PDF)</legend>
            <div class="drop-zone">
                <input type="file" class="drop-zone__input" id="constanciaFile" accept="application/pdf">
                <span class="drop-zone__prompt">Arrastra aquí o haz clic para subir</span>
            </div>
        </fieldset>
    </div>

    <!-- Barra de Progreso -->
    <div class="col-md-12">
        <div class="progress" style="height: 30px;">
            <div id="progress-bar" class="progress-bar progress-bar-striped progress-bar-animated" 
                role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                0%
            </div>
        </div>
    </div>

    <div class="col-md-12 text-center mt-4">
        <button class="btn btn-success" id="btn_guardar">
            <i class="fa fa-check"></i> Guardar
        </button>
    </div>

    <!-- Mensaje de resultado -->
    <div class="col-md-12 text-center mt-3">
        <div id="uploadStatus"></div>
    </div>
</div>

<!-- Estilos para el drag & drop -->
<style>
    .drop-zone {
        border: 2px dashed #007bff;
        border-radius: 10px;
        padding: 25px;
        text-align: center;
        cursor: pointer;
        transition: background 0.3s ease-in-out;
        position: relative;
        color: #007bff;
        min-height: 100px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .drop-zone:hover {
        background: #f8f9fa;
    }

    .w-auto{
        margin-bottom: 20px !important;
    }

    .p-4{
        margin-bottom: 18px !important;
    }


    .drop-zone__input {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        cursor: pointer;
    }
    .drop-zone__prompt {
        font-size: 18px;
        font-weight: bold;
        pointer-events: none;
    }
    .drop-zone--over {
        background-color: #e0f7fa;
    }
    .progress {
        display: none;
        margin-top: 20px;
    }
    #uploadStatus {
        margin-top: 15px;
    }
</style>

<!-- Script para Drag & Drop y AJAX -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        // Manejo de arrastrar y soltar
        $(".drop-zone").each(function () {
            const dropZone = $(this);
            const input = dropZone.find(".drop-zone__input");

            input.on("change", function () {
                if (this.files.length) {
                    dropZone.find(".drop-zone__prompt").text(this.files[0].name);
                }
            });

            dropZone.on("dragover", function (event) {
                event.preventDefault();
                dropZone.addClass("drop-zone--over");
            });

            dropZone.on("dragleave", function () {
                dropZone.removeClass("drop-zone--over");
            });

            dropZone.on("drop", function (event) {
                event.preventDefault();
                dropZone.removeClass("drop-zone--over");

                if (event.originalEvent.dataTransfer.files.length) {
                    input[0].files = event.originalEvent.dataTransfer.files;
                    dropZone.find(".drop-zone__prompt").text(input[0].files[0].name);
                }
            });
        });


        $("#btn_guardar").click(function () {
            
            var formData = new FormData();
            formData.append("ineFile", $("#ineFile")[0].files[0]);
            formData.append("domicilioFile", $("#domicilioFile")[0].files[0]);
            formData.append("constanciaFile", $("#constanciaFile")[0].files[0]);

            $("#btn_guardar").prop("disabled", true);
            $(".progress").show();
            $("#progress-bar").css("width", "0%").text("0%");
            $("#uploadStatus").html("");

            // Simulación de carga gradual
            let simulatedProgress = 0;
            let interval = setInterval(function () {
                if (simulatedProgress < 95) { // Llegamos hasta el 95% para que el 100% sea al finalizar
                    simulatedProgress++;
                    $("#progress-bar").css("width", simulatedProgress + "%").text(simulatedProgress + "%");
                }
            }, 100); // Aumenta cada 100ms (ajusta a tu necesidad)

            $.ajax({
                url: "archivos/cargarArchivos", // URL de tu controlador en CodeIgniter
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    clearInterval(interval); // Detener simulación
                    $("#progress-bar").css("width", "100%").text("100%");

                    var result = JSON.parse(response);
                    if(result.status == "error") {
                        let errorHtml = '<div class="alert alert-danger"><ul>';
                        result.errors.forEach(error => {
                            errorHtml += `<li>${error}</li>`;
                        });
                        errorHtml += '</ul></div>';
                        $("#uploadStatus").html(errorHtml);
                    } else {
                        $('input[type="file"]').val('');
                        $('.drop-zone__prompt').text('Arrastra aquí o haz clic para subir');
                        $('.drop-zone').removeClass('drop-zone--over');
                        $("#uploadStatus").html('<div class="alert alert-success">Archivos subidos correctamente</div>');
                    }
                },
                error: function () {
                    clearInterval(interval);
                    $("#uploadStatus").html('<div class="alert alert-danger">Error al subir los archivos</div>');
                },
                complete: function () {
                    clearInterval(interval);
                    $("#btn_guardar").prop("disabled", false);
                    setTimeout(function () {
                        $(".progress").fadeOut();
                    }, 2000);
                }
            });
        });


        /*
          // Enviar archivos por AJAX con barra de progreso
        $("#btn_guardar").click(function () {
            var formData = new FormData();
            formData.append("ineFile", $("#ineFile")[0].files[0]);
            formData.append("domicilioFile", $("#domicilioFile")[0].files[0]);
            formData.append("constanciaFile", $("#constanciaFile")[0].files[0]);

            $("#btn_guardar").prop("disabled", true);
            $(".progress").show();
            $("#progress-bar").css("width", "0%").text("0%");
            $("#uploadStatus").html("");

            $.ajax({
                url: "archivos/cargarArchivos", // URL de tu controlador en CodeIgniter
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                xhr: function () {
                    var xhr = new window.XMLHttpRequest();
                    xhr.upload.addEventListener("progress", function (event) {
                        if (event.lengthComputable) {
                            var percentComplete = Math.round((event.loaded / event.total) * 100);
                            $("#progress-bar").css("width", percentComplete + "%").text(percentComplete + "%");
                        }
                    }, false);
                    return xhr;
                },
                success: function (response) {
                    
                    var result = JSON.parse(response);

                    if(result.status == "error") {
                        console.log("estoy en error:");
                        let errorHtml = '<div class="alert alert-danger"><ul>';
                        result.errors.forEach(error => {
                            errorHtml += `<li>${error}</li>`;  // Aquí accedes a cada error
                        });
                        errorHtml += '</ul></div>';
                        $("#uploadStatus").html(errorHtml);

                    }else{
                        $('input[type="file"]').val('');
                        $('.drop-zone__prompt').text('Arrastra aquí o haz clic para subir');
                        $('.drop-zone').removeClass('drop-zone--over');  // Limpiar cualquier clase adicional

                        $("#uploadStatus").html('<div class="alert alert-success">Archivos subidos correctamente</div>');
                    }
                    
                },
                error: function () {
                    $("#uploadStatus").html('<div class="alert alert-danger">Error al subir los archivos</div>');
                },
                complete: function () {
                    $("#btn_guardar").prop("disabled", false);
                    setTimeout(function () {
                        $(".progress").fadeOut();
                    }, 2000);
                }
            });
        });

        */

    });
</script>
