<div class="row">
    <div class="col-md-12">
        <h1 class="page-header"><i class="fa fa-briefcase"></i> Catálogo de Puestos</h1>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <button class="btn btn-success" data-toggle="modal" data-target="#addPuestoModal"><i class="fa fa-plus"></i> Agregar Puesto</button>
    </div>
</div>

<br>

<div class="row">
    <div class="col-md-12">
        <table class="table table-responsive table-striped" id="puestosTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Puesto</th>
                    <th>Job Profile</th>
                    <th>Position Title</th>
                    <th>Legacy Amount</th>
                    <th>JG</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($puestos)): ?>
                    <?php foreach($puestos as $puesto): ?>
                        <tr>
                            <td><?php echo $puesto->id_catalogo_puesto; ?></td>
                            <td><?php echo $puesto->puesto; ?></td>
                            <td><?php echo $puesto->job_profile; ?></td>
                            <td><?php echo $puesto->position_title; ?></td>
                            <td><?php echo $puesto->legacy_amount; ?></td>
                            <td><?php echo $puesto->jg; ?></td>
                            <td>
                                <button class="btn btn-primary edit-puesto"
                                        data-id="<?php echo $puesto->id_catalogo_puesto; ?>"
                                        data-puesto="<?php echo htmlspecialchars($puesto->puesto); ?>"
                                        data-job_profile="<?php echo htmlspecialchars($puesto->job_profile); ?>"
                                        data-position_title="<?php echo htmlspecialchars($puesto->position_title); ?>"
                                        data-legacy_amount="<?php echo htmlspecialchars($puesto->legacy_amount); ?>"
                                        data-jg="<?php echo htmlspecialchars($puesto->jg); ?>"
                                        data-toggle="modal" data-target="#editPuestoModal">
                                    <i class="fa fa-pencil"></i> Editar
                                </button>
                                <button class="btn btn-danger delete-puesto" data-id="<?php echo $puesto->id_catalogo_puesto; ?>">
                                    <i class="fa fa-trash"></i> Eliminar
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add Puesto Modal -->
<div class="modal fade" id="addPuestoModal" tabindex="-1" role="dialog" aria-labelledby="addPuestoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #004593; color: white;">
                <h4 class="modal-title text-center" id="addPuestoModalLabel" style="width: 100%;">Agregar Nuevo Puesto</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addPuestoForm">
                    <div class="form-group">
                        <label for="puesto">Puesto</label>
                        <input type="text" class="form-control" id="puesto" name="puesto" required>
                    </div>
                    <div class="form-group">
                        <label for="job_profile">Job Profile</label>
                        <input type="text" class="form-control" id="job_profile" name="job_profile">
                    </div>
                    <div class="form-group">
                        <label for="position_title">Position Title</label>
                        <input type="text" class="form-control" id="position_title" name="position_title">
                    </div>
                    <div class="form-group">
                        <label for="legacy_amount">Legacy Amount</label>
                        <input type="text" class="form-control" id="legacy_amount" name="legacy_amount">
                    </div>
                    <div class="form-group">
                        <label for="jg">JG</label>
                        <input type="text" class="form-control" id="jg" name="jg">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="savePuesto">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Puesto Modal -->
<div class="modal fade" id="editPuestoModal" tabindex="-1" role="dialog" aria-labelledby="editPuestoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #004593; color: white;">
                <h4 class="modal-title text-center" id="editPuestoModalLabel" style="width: 100%;">Editar Puesto</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editPuestoForm">
                    <input type="hidden" name="id_catalogo_puesto" id="edit_id_catalogo_puesto">
                    <div class="form-group">
                        <label for="edit_puesto">Puesto</label>
                        <input type="text" class="form-control" id="edit_puesto" name="puesto" required>
                    </div>
                    <div class="form-group">
                        <label for="edit_job_profile">Job Profile</label>
                        <input type="text" class="form-control" id="edit_job_profile" name="job_profile">
                    </div>
                    <div class="form-group">
                        <label for="edit_position_title">Position Title</label>
                        <input type="text" class="form-control" id="edit_position_title" name="position_title">
                    </div>
                    <div class="form-group">
                        <label for="edit_legacy_amount">Legacy Amount</label>
                        <input type="text" class="form-control" id="edit_legacy_amount" name="legacy_amount">
                    </div>
                    <div class="form-group">
                        <label for="edit_jg">JG</label>
                        <input type="text" class="form-control" id="edit_jg" name="jg">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="updatePuesto">Actualizar</button>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo base_url('static/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('static/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>

<script type="text/javascript">
$(document).ready(function() {
    var table = $('#puestosTable').DataTable();

    // Add Puesto
    $('#savePuesto').on('click', function() {
        var isValid = true;
        $('#addPuestoForm input').each(function() {
            if ($.trim($(this).val()) == '') {
                isValid = false;
                $(this).css({
                    "border": "1px solid red",
                    "background": "#FFCECE"
                });
            } else {
                $(this).css({
                    "border": "",
                    "background": ""
                });
            }
        });

        if (isValid == false) {
            Swal.fire({
                type: 'error',
                title: 'Error',
                text: 'Todos los campos son obligatorios.'
            });
            return false;
        }

        $.ajax({
            url: "<?php echo site_url('admin/Catalogo_puesto/ajax_add_puesto')?>",
            type: "POST",
            data: $('#addPuestoForm').serialize(),
            dataType: "JSON",
            success: function(data) {
                if(data.status) {
                    $('#addPuestoModal').modal('hide');
                    $('#addPuestoForm')[0].reset();
                    Swal.fire({
                        type: 'success',
                        title: '¡Éxito!',
                        text: 'Puesto agregado correctamente.'
                    }).then(function(){
                        location.reload();
                    });
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                 Swal.fire({
                    type: 'error',
                    title: 'Error',
                    text: 'No se pudo agregar el puesto.'
                });
            }
        });
    });

    // Edit Puesto
    $('#puestosTable tbody').on('click', '.edit-puesto', function () {
        $('#edit_id_catalogo_puesto').val($(this).data('id'));
        $('#edit_puesto').val($(this).data('puesto'));
        $('#edit_job_profile').val($(this).data('job_profile'));
        $('#edit_position_title').val($(this).data('position_title'));
        $('#edit_legacy_amount').val($(this).data('legacy_amount'));
        $('#edit_jg').val($(this).data('jg'));
    });

    // Update Puesto
    $('#updatePuesto').on('click', function() {
        $.ajax({
            url: "<?php echo site_url('admin/Catalogo_puesto/ajax_update_puesto')?>",
            type: "POST",
            data: $('#editPuestoForm').serialize(),
            dataType: "JSON",
            success: function(data) {
                if(data.status) {
                    $('#editPuestoModal').modal('hide');
                    Swal.fire({
                        type: 'success',
                        title: '¡Éxito!',
                        text: 'Puesto actualizado correctamente.'
                    }).then(function(){
                        location.reload();
                    });
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                 Swal.fire({
                    type: 'error',
                    title: 'Error',
                    text: 'No se pudo actualizar el puesto.'
                });
            }
        });
    });
    // Delete Puesto
    $('#puestosTable tbody').on('click', '.delete-puesto', function () {
        var idPuesto = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "Esta acción no se puede revertir.",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, eliminar!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo site_url('admin/Catalogo_puesto/ajax_delete_puesto')?>",
                    type: "POST",
                    data: {id_catalogo_puesto: idPuesto},
                    dataType: "JSON",
                    success: function(data) {
                        if(data.status) {
                            Swal.fire(
                                '¡Eliminado!',
                                'El puesto ha sido eliminado.',
                                'success'
                            ).then(function(){
                                location.reload();
                            });
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        Swal.fire(
                            'Error',
                            'No se pudo eliminar el puesto.',
                            'error'
                        );
                    }
                });
            }
        });
    });
});
</script>