<link rel="stylesheet" href="<?php echo base_url();?>static/principal/css/graphics.css">
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.1/css/all.css" integrity="sha384-vp86vTRFVJgpjF9jiIGPEEqYqlDwgyBgEF109VFjmqGmIY/Y4HV4d3Gp2irVfcrp" crossorigin="anonymous">

<div class="row">

        <div class="carga" id="carga" style="display: none;"></div>

        <div class="col-md-9">
            <h1 class="page-header"> <i class="fa fa-bar-chart"></i> Métricas</h1>
            <br><br>
        </div>
    </div>
        <div class="col-md-4"></div>
        <div class="col-md-8">
            <button class="imprimir btn btn-danger"><i class="fa fa-file-pdf-o"></i> Exportar</button>
            <!-- <a id="btnExcel" class="btn btn-success"><i class="fa fa-file-excel-o"></i> Excel</a> -->
        </div>

<div class="print-wrap page1">
    <div class="row">
        <div class="col-md-4" style="margin-top: -60px;">
            <div class="col-md-12">
                <div class="form-group">
                    <label>
                        Filtrar por fechas
                    </label>
                    <input type="text" name="dates" id="rango" class="form-control" />
                </div>
            </div>
        </div>
        <div class="col-md-12">

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Personas registradas | <label>Total: <span id="total_personas">0</span></label></div>
                    <div class="panel-body">
                        <div id="grafica_personas_registradas"></div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Postulaciones | <label>Total: <span id="total_postulaciones">0</span></label></div>
                    <div class="panel-body">
                        <div id="grafica_total_postulaciones"></div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Postulaciones por vacantes (top 5)</div>
                    <div class="panel-body">
                        <div id="grafica_postulaciones_vacantes"></div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Horario en que se utiliza más el chatbot WhatsApp</div>
                    <div class="panel-body">
                        <div id="grafica_horario_whatsapp"></div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<div class="print-wrap page2">
    <div class="row">
        <div class="col-md-12">

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Horario en que se utiliza más el chatbot Facebook</div>
                    <div class="panel-body">
                        <div id="grafica_horario_facebook"></div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Mensajes enviados | <label>Total: <span id="total_msjs">0</span></label></div>
                    <div class="panel-body">
                        <div id="grafica_satisfaccion">

                            <div class="grafica2">
                                <div class="align">
                                    <div class="yesno">
                                    
                                        <div class="avatar avatar-left">
                                            <div class="left"><h4 id="text_si">0<p class="resp">Usuarios</p></h4></div>
                                            <div id="respuestas_si" class="porcent-left" style="height:0%;"></div>
                                            <div class="cabeza"><i class="far fa-smile"></i></div>
                                            <div class="body"></div>
                                            <div class="pies"></div>
                                        </div>
                                        <p class="emotion" style=""><span id="msjs_usuarios">0</span> mensajes enviados</p>

                                        
                                    </div>
                                    <div class="medio">
                                        <img src="<?php echo base_url();?>static/principal/images/avatar-medio.svg" alt="">
                                    </div>
                                    <div class="yesno">
                                        <div class="avatar avatar-right">
                                            <div class="right"><h4 id="text_no">0<p class="resp">Bot</p></h4></div>
                                            <div id="respuestas_no" class="porcent-right" style="height:0%;"></div>
                                            <div class="cabeza"><i class="fa fa-robot" style="margin-left: -10px;"></i></div>
                                            <div class="body"></div>
                                            <div class="pies"></div>
                                        </div>
                                        <p class="emotion"><span id="msjs_bot">0</span> mensajes enviados</p>
                                        
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="panel panel-default alto">
                    <div class="panel-heading" style="text-align: center;" >Sesiones y usuarios</div>
                    <div class="panel-body">
                        <div id="grafica_sesiones_usuarios"></div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<style type="text/css">
    .alto{
        height: 480px;
    }

    .swal2-container {
        z-index: 12000 !important;
    }

    .carga {
        border: 24px solid #f3f3f3;
        border-radius: 50%;
        border-top: 24px solid #004593;
        width: 160px;
        height: 160px;
        -webkit-animation: spin 2s linear infinite;
        animation: spin 2s linear infinite;
        margin:auto;
        left:0;
        right:0;
        top:0;
        bottom:0;
        position:fixed;
        z-index: 11000 !important;
    }

    @-webkit-keyframes spin {
        0% { -webkit-transform: rotate(0deg); }
        100% { -webkit-transform: rotate(360deg); }
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

</style>

<script type="text/javascript" src="<?=base_url();?>static/js/jquery.js"></script>
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.5.3/jspdf.min.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
<script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<!-- <script src="https://code.highcharts.com/highcharts.js"></script> -->

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/highcharts-more.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<script src="https://code.highcharts.com/modules/pattern-fill.js"></script>

<!-- <script src="https://code.highcharts.com/modules/data.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script> -->
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <script type="text/javascript">
    jQuery(document).ready(function($){ 

        $(document).on('click', '.imprimir', function(){
            mostrarLoader();
            $(this).attr('disabled', true);
            setTimeout(function() { 
             generatePDF();
            }, 1000);
        });

var pdf,page_section,HTML_Width,HTML_Height,top_left_margin,PDF_Width,PDF_Height,canvas_image_width,canvas_image_height;
    
    
    
    function calculatePDF_height_width(selector,index){
        page_section        = $(selector).eq(index);
        HTML_Width          = page_section.width();
        HTML_Height         = page_section.height();
        top_left_margin     = 15;
        PDF_Width           = HTML_Width + (top_left_margin * 2);
        PDF_Height          = (PDF_Width * 1.2) + (top_left_margin * 2);
        canvas_image_width  = HTML_Width;
        canvas_image_height = HTML_Height;
    }

    //Generate PDF
    function generatePDF() {
        pdf = "";
        html2canvas($(".print-wrap:eq(0)")[0], { allowTaint: true }).then(function(canvas) {

            calculatePDF_height_width(".print-wrap",0);
            canvas.getContext('2d');
            var imgData = canvas.toDataURL("image/jpeg", 1.0);

            pdf = new jsPDF('p', 'pt', [PDF_Width, PDF_Height]);
            pdf.addImage(imgData, 'JPG', top_left_margin, top_left_margin, HTML_Width, HTML_Height);

        });

        html2canvas($(".print-wrap:eq(1)")[0], { allowTaint: true }).then(function(canvas) {

            calculatePDF_height_width(".print-wrap",1);
            canvas.getContext('2d');
            var imgData = canvas.toDataURL("image/jpeg", 1.0);

            pdf.addPage(PDF_Width, PDF_Height);
            pdf.addImage(imgData, 'JPG', top_left_margin, top_left_margin, HTML_Width, HTML_Height);

            setTimeout(function() {
                pdf.save("Métricas.pdf");
                setTimeout(ocultarLoader, 1000);
                $(".imprimir").attr('disabled', false);
            }, 0);

        });

    };


    $('input[name="dates"]').daterangepicker({
        "locale": {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aceptar",
        "cancelLabel": "Cancelar",
        "fromLabel": "From",
        "toLabel": "To",
        "customRangeLabel": "Custom",
        "daysOfWeek": [
            "Dom",
            "Lun",
            "Mar",
            "Mie",
            "Jue",
            "Vie",
            "Sab"
        ],
        "monthNames": [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre"
        ],
        "firstDay": 1
        }
    });

    $("#rango").on('apply.daterangepicker', function(ev, picker) {
      var inicio = picker.startDate.format('YYYY-MM-DD');
      var fin    = picker.endDate.format('YYYY-MM-DD');
      mostrarLoader();
      filtrar(inicio, fin);
      $("#btnExcel").attr('href', '<?php echo base_url() ?>index.php/admin/metricas/excel?inicio='+inicio+'&fin='+fin+'');
    });

});//termina jQuery

    function filtrar(inicio, fin) {
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/metricas/filtrar",
            type : "POST",
            dataType : "json",
            data :{"inicio" : inicio, "fin" : fin},
            success : function(datos){

                $("#total_personas").html(datos.contPers);
                $("#total_postulaciones").html(datos.contPost);

                $('#grafica_personas_registradas').highcharts({
                    chart: {
                        type: 'column'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        allowDecimals: false,
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b><br/>'
                    },

                    "series":
                    datos.personas_registradas
                    ,
                    
                })//termina grafica_personas_registradas;

                $('#grafica_horario_whatsapp').highcharts({
                    chart: {
                        type: 'column'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        allowDecimals: false,
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b><br/>'
                    },

                    "series":
                    datos.hora_utilizado_whatsapp
                    ,
                    
                })//termina grafica_horario_whatsapp;

                $('#grafica_horario_facebook').highcharts({
                    chart: {
                        type: 'column'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        allowDecimals: false,
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b><br/>'
                    },

                    "series":
                    datos.hora_utilizado_facebook
                    ,
                    
                })//termina grafica_horario_facebook;

                $('#grafica_total_postulaciones').highcharts({
                    chart: {
                        type: 'column'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        allowDecimals: false,
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b><br/>'
                    },

                    "series":
                    datos.total_postulaciones
                    ,
                    
                })//termina grafica_total_postulaciones;

                $('#grafica_postulaciones_vacantes').highcharts({
                    chart: {
                        type: 'column'
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        allowDecimals: false,
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b><br/>'
                    },

                    "series":
                    datos.postulaciones_vacantes
                    ,
                    
                })//termina grafica_postulaciones_vacantes;

                var tot_msjs             = parseInt(datos.msjs_usuarios) + parseInt(datos.msjs_bot);
                var por_msjs_usuarios    = 0;
                var por_msjs_bot         = 0;

                if (tot_msjs > 0) {

                    por_msjs_usuarios   = (parseInt(datos.msjs_usuarios)*100)/tot_msjs;
                    por_msjs_bot        = (parseInt(datos.msjs_bot)*100)/tot_msjs;

                }

                $("#msjs_usuarios").html(datos.msjs_usuarios);
                $("#msjs_bot").html(datos.msjs_bot);
                $("#total_msjs").html(tot_msjs);
                $("#respuestas_si").css("height", Math.round(por_msjs_usuarios)+"%");
                $("#respuestas_no").css("height", Math.round(por_msjs_bot)+"%");
                $("#text_si").html(Math.round(por_msjs_usuarios)+'% <p class="resp">Usuarios</p>');
                $("#text_no").html(Math.round(por_msjs_bot)+'% <p class="resp">Bot</p>');

                const iconos = {
                    Sesiones: 'fa-user-secret',
                    Usuarios: 'fa-user'
                };

                $('#grafica_sesiones_usuarios').highcharts({
                    colors: ['#5a98cf'],
                    chart: {
                        type: 'column',
                        inverted: true,
                        polar: true
                    },
                    credits: {
                        enabled: false
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    accessibility: {
                        keyboardNavigation: {
                            seriesNavigation: {
                                mode: 'serialize'
                            }
                        }
                    },
                    tooltip: {
                        outside: true
                    },
                    pane: {
                        size: '85%',
                        innerSize: '20%',
                        endAngle: 270
                    },
                    legend: {
                        enabled: false
                    },
                    exporting: {
                        enabled: false
                    },
                    xAxis: {
                        tickInterval: 1,
                        labels: {
                            align: 'right',
                            useHTML: true,
                            allowOverlap: true,
                            step: 1,
                            y: 3,
                            style: {
                                fontSize: '13px'
                            },
                            formatter: function () {
                                return `${
                                    this.value
                                } <span class='f16'><i class="fa ${iconos[this.value]}"></i> </span>`;
                            }
                        },
                        lineWidth: 0,
                        categories: ['Sesiones', 'Usuarios'],
                        accessibility: {
                            description: 'Countries'
                        }
                    },
                    yAxis: {
                        crosshair: {
                            enabled: true,
                            color: '#333'
                        },
                        lineWidth: 0,
                        tickInterval: 25,
                        reversedStacks: false,
                        endOnTick: true,
                        showLastLabel: true,
                        accessibility: {
                            description: 'Cantidad'
                        }
                    },
                    plotOptions: {
                        column: {
                            stacking: 'normal',
                            borderWidth: 1,
                            pointPadding: 0,
                            groupPadding: 0.15
                        }
                    },
                    series: [
                        {
                            name: 'Cantidad',
                            data: datos.sesiones_usuarios,
                            color: { patternIndex: 0 },
                            borderColor: '#668FF0'
                        }
                    ]
                });

                setTimeout(ocultarLoader, 1000);

            }//termina success

        });

    }//termina filtrar

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

    </script>