<div class="row">
    <div class="col-md-12">
        <h1 id="subir" class="page-header"><i class="fa fa-plus"></i><i class="fa fa-user"></i> Agregar usuario |<small class="text-muted"> Datos obligatorios <i class="text-danger fa fa-asterisk"></i></h4></small></h1>
    </div>
</div>

<br>

<div class="row">
    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Usuario:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <input type="text" class="form-control" placeholder="Ingresa el usuario" id="usuario" name="usuario" required="">
        </div>  
    </div>

    <div class="col-md-3">
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Correo:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <input type="email" class="form-control" placeholder="Ingresa el correo" id="correo" name="correo" required="">
            </div>  
    </div>

    <div id="div_contra" class="col-md-3">
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Contraseña:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <input type="password" class="form-control" placeholder="Ingresa la contraseña" id="contraseña" name="contraseña" required="">
            </div>  
    </div>

    <div class="col-md-3">
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Tipo usuario:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <select id="tipo_usuario" class="form-control" required>
                    <option value="0">--Seleccionar--</option>
                    <?php
                        if (!is_null($tipo)) {
                            foreach ($tipo as $v) {?>
                                <option value="<?php echo $v->id_tipo ?>"> <?php echo $v->nombre ?></option>
                        <?php }
                        }
                     ?>
                </select>
            </div>  
    </div>

    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Estatus:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <select class="form-control" id="estatus">
                <option value="1">Activo</option>
                <option value="2">Inactivo</option>
            </select>
        </div>  
    </div>

    <div class="col-md-12">
        <a class="guardar btn btn-success" id="save"><i class="fa fa-save"></i>  Guardar</a>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <h1 class="page-header"><strong><i class="fa fa-users"></i> Usuarios registrados</strong></h1>
        
        <table class="table table-responsive table-striped" id="tabla_usuarios">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Usuario</th>
                    <th>Correo</th>
                    <th>Tipo de usuario</th>
                    <th>Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!is_null($usuarios)) {

                    $cont = 1;
                    foreach ($usuarios as $v) {
                        $estatus = "";
                        if ($v->estatus == 1) {
                            $estatus = "<h4><span class='label label-success'>Activo<span></h4>";
                        }else{
                            $estatus = "<h4><span class='label label-danger'>Inactivo<span></h4>";
                        }
                        ?>

                        <tr>
                            <td><?php echo $cont; ?></td>
                            <td><?php echo $v->usuario; ?></td>
                            <td><?php echo $v->correo; ?></td>
                            <td><?php echo $v->nombre; ?></td>
                            <td><?php echo $estatus; ?></td>
                            <td>
                                <button class="update btn btn-primary" data-id="<?php echo $v->id_usuario; ?>"><i class="fa fa-refresh"></i> Actualizar</button><br>
                                <button class="actualizarContra btn btn-warning" data-id-usu="<?php echo $v->id_usuario;?>"><i class="fa fa-pencil-square-o"></i> Actualizar contraseña</button>
                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>
        <input type="hidden" id="usuario_id">

    </div>
    
</div>

<div class="modal fade" id="modalContraseña" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <center><h3 class="modal-title" id="exampleModalLabel"> Actualizar contraseña</h3></center>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>


      <div class="modal-body">
        
        
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Nueva contraseña:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <input type="password" class="form-control" id="contra_nueva" name="contra_nueva" required="">
            </div>  
        
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Confirmar nueva contraseña:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <input type="password" class="form-control" id="confirmar" name="confirmar" required="">
            </div>  
        
        <input type="hidden" id="id_contra" />
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="aceptar_contra">Actualizar</button>
      </div>
    </div>
  </div>
</div>


<script type="text/javascript" src="<?=base_url();?>static/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="<?php echo base_url('static/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('static/dataTables.bootstrap.js')?>"></script>
    <script type="text/javascript">
    jQuery(document).ready(function($){

        $("#tabla_usuarios").dataTable();

    $(document).on('click', '.guardar', function(){

        var usuario      = $("#usuario").val();
        var correo       = $("#correo").val();
        var contraseña   = $("#contraseña").val();
        var tipo_usuario = $("#tipo_usuario").val();
        var estatus      = $("#estatus").val();

        if (validar(usuario, contraseña, tipo_usuario)) {
            addUsuario(usuario, correo, contraseña, tipo_usuario, estatus);
        }
        
    });

    $(document).on('click', '.actualizar', function(){

        var usuario      = $("#usuario").val();
        var correo       = $("#correo").val();
        var tipo_usuario = $("#tipo_usuario").val();
        var estatus      = $("#estatus").val();

        if (validarUpdate(usuario, correo, tipo_usuario)) {
            updateUsuario(usuario, correo, tipo_usuario, estatus);
        }
        
    });

    $(document).on('click', '.delete', function(){

        var id_usuario = $(this).attr("data-id-usuario");

        eliminarUsuario(id_usuario);
        
    });

    $(document).on('click', '.update', function(){

        $("#usuario").css("border-color","#D5D4D4").focus();
        $("#correo").css("border-color","#D5D4D4").focus();
        $("#contraseña").css("border-color","#D5D4D4").focus();
        $("#tipo_usuario").css("border-color","#D5D4D4").focus();
        
        $("#usuario_id").val("");

        var id_usuario = $(this).attr('data-id');
        
        $("#usuario_id").val(id_usuario);
        
        var position = $("#subir").offset().top;
        $("#subir").offset().top; $("HTML, BODY").animate({ scrollTop: position }, 1000);
        $("#div_contra").hide();
        $("#contraseña").val("");
        getUsuario(id_usuario);

    })

    $(document).on('click', '.actualizarContra', function(){

        var id_usuario = $(this).attr("data-id-usu");
        $("#id_contra").val(id_usuario);
        $("#modalContraseña").modal("show");

    })

    $("#aceptar_contra").click(function () {

        if ($("#contra_nueva").val() == $("#confirmar").val()) {

            actualizarContraseña()
        }else{
            Swal.fire({
                type: 'error',
                title: "Las contraseñas no coinciden"
            })
        }


    })

});//termina jQuery

    function actualizarContraseña() {

        var id_usuario   = $("#id_contra").val();
        var contra_nueva = $("#contra_nueva").val();
        var confirmar    = $("#confirmar").val();

        $.ajax({
                url : "<?php echo base_url();?>index.php/admin/usuarios/actualizarPass",
                type : "POST",
                dataType : "json",
                data :{"contra_nueva" : contra_nueva, "confirmar" : confirmar, "id_usuario" : id_usuario},
                success : function(datos){

                        if(datos.regreso){
                            Swal.fire({
                              title: datos.mensaje,
                              type: 'success'
                            })
                            setTimeout(function(){
                                location. reload();
                            }, 2500);
                        }else{
                            Swal.fire({
                              type: 'error',
                              title: datos.mensaje
                            })
                        }
                    
                     }
        });

    }

    function eliminarUsuario(id_usuario) {
        
        $.ajax({
                url : "<?php echo base_url();?>index.php/admin/usuarios/eliminarUsuario",
                type : "POST",
                dataType : "json",
                data :{"id_usuario" : id_usuario},
                success : function(datos){

                        if(datos){
                            Swal.fire({
                              title: "Usuario eliminado",
                              type: 'success'
                            })
                            setTimeout(function(){
                                location. reload();
                            }, 2500);
                        }else{
                            Swal.fire({
                              type: 'error',
                              title: "Algo salio mal, vuelve a intentarlo"
                            })
                        }
                    
                     }
        });

    }//termina eliminarUsuario

    function getUsuario(id_usuario) {
        
        $.ajax({
                url : "<?php echo base_url();?>index.php/admin/usuarios/getUsuario",
                type : "POST",
                dataType : "json",
                data :{"id_usuario" : id_usuario},
                success : function(datos){

                    if(datos.regreso){
                        $("#usuario").val(datos.usuario);
                        $("#correo").val(datos.correo);
                        $("#tipo_usuario").val(datos.tipo);
                        $("#estatus").val(datos.estatus);
                        $("#save").removeClass("guardar");
                        $("#save").addClass('actualizar');
                    }else{
                         alert("no se encontraron datos")
                    }
                
                }

        });

    }//termina getUsuario

    function addUsuario(usuario, correo, contraseña, tipo_usuario, estatus) {
        
        $.ajax({
                url : "<?php echo base_url();?>index.php/admin/usuarios/insertar_usuario",
                type : "POST",
                dataType : "json",
                data :{"usuario": usuario, "correo": correo, "contraseña" : contraseña, "tipo_usuario" : tipo_usuario, "estatus" : estatus},
                success : function(datos){

                        if(datos.regreso == 200){
                            Swal.fire({
                              title: datos.mensaje,
                              type: 'success'
                            })
                            limpiar();
                            setTimeout(function(){
                                location. reload();
                            }, 2500);

                        }else if(datos.regreso == 300 || datos.regreso == 400) {
                             Swal.fire({
                              type: 'error',
                              title: datos.mensaje
                            })
                        }else{
                            Swal.fire({
                              type: 'error',
                              title: datos.mensaje
                            })
                        }
                    
                     }

        });

    }//termina addUsuario

    function updateUsuario(usuario, correo, tipo_usuario, estatus) {
        
        var id_usuario = $("#usuario_id").val();

        $.ajax({
                url : "<?php echo base_url();?>index.php/admin/usuarios/updateUsuario",
                type : "POST",
                dataType : "json",
                data :{"usuario": usuario, "correo": correo, "id_usuario" : id_usuario, "tipo_usuario" : tipo_usuario, "estatus" : estatus},
                success : function(datos){

                        if(datos.regreso == 200){
                            Swal.fire({
                              title: datos.mensaje,
                              type: 'success'
                            })
                            setTimeout(function(){
                                location. reload();
                            }, 2500);


                        }else if(datos.regreso == 300 || datos.regreso == 400){
                             Swal.fire({
                              type: 'error',
                              title: datos.mensaje
                            })
                        }else{
                             Swal.fire({
                              type: 'error',
                              title: datos.mensaje
                            })
                        }
                    
                     }

        });

    }//termina updateUsuario


    function limpiar() {

        $("#usuario").val("");
        $("#correo").val("");
        $("#tipo_usuario").val("");
        $("#contraseña").val("");
    
    }

    function validar(usuario, contraseña, tipo_usuario) {

        $("#usuario").css("border-color","#D5D4D4").focus();
        $("#correo").css("border-color","#D5D4D4").focus();
        $("#contraseña").css("border-color","#D5D4D4").focus();
        $("#tipo_usuario").css("border-color","#D5D4D4").focus();
        
        var regex               = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;
        var contador_usuario    = $("#usuario").val().length;
        var contador_contraseña = $("#contraseña").val().length;
        var regreso             = true;

        if (contador_usuario < 2) {
            regreso = false;
            $("#usuario").css("border-color","red").focus();
            alert("Ingresa el usuario");
        }else if (regex.test($('#correo').val().trim()) != true) {
            regreso = false;
            $("#correo").css("border-color","red").focus();
            alert("Este correo no es válido");
        }else if (contador_contraseña < 3) {
            regreso = false;
            $("#contraseña").css("border-color","red").focus();
            alert("Ingresa una contraseña mayor a 3 caracteres");
        }else if (tipo_usuario == 0) {
            regreso = false;
            $("#tipo_usuario").css("border-color","red").focus();
            alert("Por favor selecciona un tipo de usuario");
        }

        return regreso;
    }//termina validar

    function validarUpdate(usuario, correo, tipo_usuario) {

        $("#usuario").css("border-color","#D5D4D4").focus();
        $("#correo").css("border-color","#D5D4D4").focus();
        $("#tipo_usuario").css("border-color","#D5D4D4").focus();
        
        var regex               = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;
        var contador_usuario    = $("#usuario").val().length;
        var regreso             = true;

        if (contador_usuario < 2) {
            regreso = false;
            $("#usuario").css("border-color","red").focus();
            alert("Ingresa el usuario");
        }else if (regex.test($('#correo').val().trim()) != true) {
            regreso = false;
            $("#correo").css("border-color","red").focus();
            alert("Este correo no es válido");
        }else if (tipo_usuario == 0) {
            regreso = false;
            $("#tipo_usuario").css("border-color","red").focus();
            alert("Por favor selecciona un tipo de usuario");
        }

        return regreso;
    }//termina validar
    </script>