<?php
/**
 * @author Daniel Lopez Ibarra
 * @version 0.1
 * @copyright  2015. Todos los Derechos Reservados
*/
?>

<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 id="subir" class="page-header"><i class="fa fa-plus"></i><i class="fa fa-book"></i> Agregar Vacante</h1>
        <!-- <h1 id="subir" class="page-header"><i class="fa fa-refresh"></i> <i class="fa fa-book"></i> Editar Vacante</h1> -->
    </div>
</div>


<div class="row">

    <div class="col-md-5">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Nombre:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <input type="text" class="form-control" id="nombre_vacante" name="nombre_vacante" placeholder="Ingresa el nombre de la vacante"/>
            <input type="hidden" id="id_vacante" name="id_vacante"/>
        </div>  
    </div>

    <!-- <div class="col-md-7">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Dirección:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <input type="text" class="form-control" id="direccion_vacante" name="direccion_vacante" placeholder="Ingresa la dirección de la vacante"/>
        </div>  
    </div> -->

    <div class="col-md-12">
        <a class="agregar btn btn-success" id="save"><i class="fa fa-save"></i>  Guardar</a>
        <!-- <a class="btn btn-success" id="updateVacante" style="pointer-events: none;"><i class="fa fa-save"></i>  Guardar</a> -->
    </div>

</div>


<div class="row">

    <div class="col-md-12" style="margin-top: 2em;">
        <h1 class="page-header"><i class="fa fa-book"></i> Vacantes registradas</h1>
    </div>

    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Estatus:
            </label>
            <select id="select_estatus" class="form-control" required style="cursor: pointer;">
                <option value="#">Todas</option>
                <option value="1">Activa</option>
                <option value="0">Desactivada</option>
            </select>
        </div>  
    </div>

    <div class="col-md-3">
        <button class="btn btn-info" style="margin-top: 24px;" id="filtrar_vacantes"><i class="fa fa-search"></i> Buscar</button>
    </div>

    <div class="col-md-12" style="margin-top: 1em;">
        <table class="table table-responsive table-striped" id="tabla_vacantes">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nombre Vacante</th>
                    <!-- <th>Dirección</th> -->
                    <th>Creada por</th>
                    <th>Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="tbody_vacantes">
                <?php
                if (!is_null($vacantes)) {

                    $cont           = 1;
                    $switch         = "";
                    $btn_estatus    = "";
                    $label_estatus  = "";
                    foreach ($vacantes as $v) {

                        if ($v->estatus_vacante == 1) {
                            $btn_estatus    = '<button class="updateEstatusVacante btn btn-danger" data-id="'.$v->id_vacante.'" data-estatus="0" style="width: 130px;"><i class="fa fa-arrow-down"></i> Desactivar</button><br>';
                            $label_estatus  = "<h4><span class='label label-success'>Activa<span></h4>";
                        }else {
                            $btn_estatus    = '<button class="updateEstatusVacante btn btn-success" data-id="'.$v->id_vacante.'" data-estatus="1" style="width: 130px;"><i class="fa fa-arrow-up"></i> Activar</button><br>';
                            $label_estatus  = "<h4><span class='label label-danger'>Desactivada<span></h4>";
                        }

                        ?>

                        <tr>
                            <td><?php echo $cont;?></td>
                            <td><?php echo $v->nombre_vacante;?></td>
                            <!-- <td><?php echo $v->direccion;?></td> -->
                            <td><?php echo $v->usuario;?></td>
                            <td><?php echo $label_estatus;?></td>
                            <td>
                                <a href='<?php echo base_url(); ?>index.php/admin/vacantes/viewInteresados?id=<?php echo $v->id_vacante; ?>' class='btn btn-primary' style='width: 130px;'><i class='fa fa-book'></i> Interesados</a><br>
                                <button class="getInfoVacante btn btn-warning" data-id="<?php echo $v->id_vacante; ?>" style="width: 130px;"><i class="fa fa-refresh"></i> Actualizar</button><br>
                                <button class="verTurnos btn btn-info" data-id="<?php echo $v->id_vacante; ?>" style="width: 130px;"><i class="fa fa-eye"></i> Turnos</button><br>
                                <?php echo $btn_estatus; ?>
                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>

    </div>
    
</div>

<div class="modal fade"  tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="modal_turnos" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" id="div-modal-header-agendar" style="background: #31b0d5;">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Turnos</b></h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                
                    <div class="col-md-12" style="margin-top: -2em;">
                        <h1 id="subir_modal" class="page-header"><i class="fa fa-plus"></i> <i class="fa fa-briefcase"></i> Agregar Turno</h1>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Descripción:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="text" class="form-control" id="nombre_turno" name="nombre_turno" placeholder="Ingresa la descripción del turno"/>
                            <input type="hidden" id="id_vacante_modal" name="id_vacante_modal"/>
                            <input type="hidden" id="id_turno_vacante" name="id_turno_vacante"/>
                        </div>  
                    </div>

                    <div class="col-md-12">
                        <a class="agregarTurno btn btn-success" id="success_modal"><i class="fa fa-save"></i>  Guardar</a>
                    </div>

                    <div class="col-md-12" style="margin-top: 1em;">
                        <h1 class="page-header"><i class="fa fa-briefcase"></i> Turnos registrados</h1>
                    </div>

                    <div class="col-md-12">

                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Descripción</th>
                                <th>Estatus</th>
                                <th>Acciones</th>
                            </tr>
                            </thead>
                            <tbody id="tbody_turnos">



                            </tbody>
                        </table>

                    </div>

                </div>


            </div>
            <input type="hidden" id="fecha_delte"/>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" id="cerrar_modal" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<style type="text/css">

    .swal2-container {
        z-index: 12000 !important;
    }

    .carga {
        border: 24px solid #f3f3f3;
        border-radius: 50%;
        border-top: 24px solid #004593;
        width: 160px;
        height: 160px;
        -webkit-animation: spin 2s linear infinite;
        animation: spin 2s linear infinite;
        margin:auto;
        left:0;
        right:0;
        top:0;
        bottom:0;
        position:fixed;
        z-index: 11000 !important;
    }

    @-webkit-keyframes spin {
        0% { -webkit-transform: rotate(0deg); }
        100% { -webkit-transform: rotate(360deg); }
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

</style>


<script type="text/javascript" src="<?=base_url();?>static/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="<?php echo base_url('static/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('static/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">

    <script type="text/javascript">
    jQuery(document).ready(function($){

        ocultarLoader();
        $("#select_estatus").val("1");

        var tabla = $('#tabla_vacantes').dataTable( {
            dom: "'down'<'col-md-1'B><'col-md-6'l><'col-md-5'f>"+ "<br/>" +
            "<'top'<'col-md-12'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            buttons: [
                {
                    text: '<i class="fa fa-file-excel-o"></i> Excel',
                    extend: 'excelHtml5',
                    className : 'btn btn-success',
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                }
            ]
        });

        $(document).on('click', '#filtrar_vacantes', function(event) {

        var estatus     = $("#select_estatus").val();

        mostrarLoader();
        filtrar(estatus);

        });

        $(document).on('click', '.getInfoVacante', function(event) {

            var id_vacante = $(this).attr('data-id');

            var position = $("#subir").offset().top;
            $("#subir").offset().top; $("HTML, BODY").animate({ scrollTop: position }, 1000);
            mostrarLoader();

            $("#save").removeClass("agregar");
            $("#save").addClass('updateInfoVacante');
            // $("#updateVacante").css("pointer-events", "auto");
            getInfoVacante(id_vacante);

        });

        // $(document).on('click', '#updateVacante', function(event) {

        //     $("#nombre_vacante").css("border-color","#D5D4D4").focus();

        //     var id_vacante      = $("#id_vacante").val();
        //     var nombre_vacante  = $("#nombre_vacante").val();

        //     if (nombre_vacante.length < 4) {
                
        //         alert("Ingresa un nombre más largo");
        //         $("#nombre_vacante").css("border-color","red").focus();

        //     }else {

        //         mostrarLoader();
        //         updateVacante(id_vacante, nombre_vacante);

        //     }

        // });

        $(document).on('click', '.updateInfoVacante', function(event) {

            $("#nombre_vacante").css("border-color","#D5D4D4").focus();
            // $("#direccion_vacante").css("border-color","#D5D4D4").focus();

            var id_vacante      = $("#id_vacante").val();
            var nombre_vacante  = $("#nombre_vacante").val();
            // var direccion       = $("#direccion_vacante").val();

            if (nombre_vacante.length < 4) {
                
                alert("Ingresa un nombre más largo");
                $("#nombre_vacante").css("border-color","red").focus();

            // }else if (direccion.length < 4) {
                
            //     alert("Ingresa una dirección más larga");
            //     $("#direccion_vacante").css("border-color","red").focus();

            // }
            
            }else {

                mostrarLoader();
                updateVacante(id_vacante, nombre_vacante);

            }

        });

        $(document).on('click', '.updateEstatusVacante', function(event) {

            var id_vacante  = $(this).attr('data-id');
            var estatus     = $(this).attr('data-estatus');
            mostrarLoader();

            if (estatus == 0) {
                desactivarVacante(id_vacante, estatus);
            }else {
                activarVacante(id_vacante, estatus);
            }

        });

        $(document).on('click', '.updateTurno', function(event) {

            $("#nombre_turno").css("border-color","#D5D4D4").focus();

            var id_turno_vacante   = $("#id_turno_vacante").val();
            var nombre_turno       = $("#nombre_turno").val();
            var id_vacante         = $("#id_vacante_modal").val();

            if (nombre_turno.length < 4) {

                alert("Ingresa una descripción más larga");
                $("#nombre_turno").css("border-color","red").focus();

            }else {

                mostrarLoader();
                updateTurno(id_turno_vacante, nombre_turno, id_vacante);

            }

        });

        $(document).on('click', '.getInfoTurno', function(event) {

            var id_turno_vacante = $(this).attr('data-id');
            var id_vacante       = $(this).attr('data-id-vacante');

            $("#id_vacante_modal").val(id_vacante);

            // var position = $("#subir_modal").offset().top;
            // $("#subir_modal").offset().top; $("HTML, BODY").animate({ scrollTop: position }, 1000);

            $("#success_modal").removeClass("agregarTurno");
            $("#success_modal").addClass('updateTurno');
            mostrarLoader();
            getInfoTurno(id_turno_vacante);

        });

        $(document).on('click', '.agregar', function(event) {

            $("#nombre_vacante").css("border-color","#D5D4D4").focus();
            // $("#direccion_vacante").css("border-color","#D5D4D4").focus();
            
            var nombre_vacante  = $("#nombre_vacante").val();
            // var direccion       = $("#direccion_vacante").val();

            if (nombre_vacante.length < 4) {
                
                alert("Ingresa un nombre más largo");
                $("#nombre_vacante").css("border-color","red").focus();

            // }else if (direccion.length < 4) {
                
            //     alert("Ingresa una dirección más larga");
            //     $("#direccion_vacante").css("border-color","red").focus();

            // }
            }else {

                mostrarLoader();
                addVacante(nombre_vacante);

            }

        });

        $(document).on('click', '.agregarTurno', function(event) {

            $("#nombre_turno").css("border-color","#D5D4D4").focus();

            var id_vacante   = $("#id_vacante_modal").val();
            var nombre_turno = $("#nombre_turno").val();

            if (nombre_turno.length < 4) {
                
                alert("Ingresa una descripción más larga");
                $("#nombre_turno").css("border-color","red").focus();

            }else {

                mostrarLoader();
                addTurno(id_vacante, nombre_turno);

            }

        });

        $(document).on('click', '.verTurnos', function(event) {

            var id_vacante = $(this).attr('data-id');
            $("#nombre_turno").val("");
            getTurnos(id_vacante);
            $("#id_vacante_modal").val(id_vacante);

        });

        $(document).on('click', '.deleteTurno', function(event) {

            var id_turno_vacante = $(this).attr('data-id');
            var id_vacante       = $(this).attr('data-id-vacante');

            Swal.fire({
            title: '¡Cuidado!',
            text: "¿Estás segur@ de eliminar este registro?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: 'green',
            cancelButtonColor: '#d33',
            cancelButtonText: 'Cancelar',
            confirmButtonText: 'Confirmar',
            reverseButtons: true
        }).then((result) => {
            if (result.value == true) {
                mostrarLoader();
                deleteTurno(id_turno_vacante, id_vacante);
            }
        })

        });


    });//termina jQuery

    function activarVacante(id_vacante, estatus){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/activarVacante",
            type : "POST",
            dataType : "json",
            data :{"id_vacante" : id_vacante, "estatus" : estatus},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    })

                    setTimeout(function(){
                        location. reload();
                        ocultarLoader();
                    }, 2000);

                }else if (result.respuesta == 400){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'info'
                    });
                    setTimeout(ocultarLoader, 1000);
                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    });
                    setTimeout(ocultarLoader, 1000);
                }

            }
        });

    }

    function desactivarVacante(id_vacante, estatus){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/desactivarVacante",
            type : "POST",
            dataType : "json",
            data :{"id_vacante" : id_vacante, "estatus" : estatus},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    });

                    setTimeout(function(){
                        location. reload();
                        ocultarLoader();
                    }, 2000);

                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    });
                    setTimeout(ocultarLoader, 1000);
                }

            }
        });

    }

    function getInfoVacante(id_vacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/getInfoVacante",
            type : "POST",
            dataType : "json",
            data :{"id_vacante" : id_vacante},
            success : function(result){

                $("#id_vacante").val(result.id_vacante);
                $("#nombre_vacante").val(result.nombre_vacante);
                // $("#direccion_vacante").val(result.direccion);
                setTimeout(ocultarLoader, 1000);

                $("#subir").html('<i class="fa fa-refresh"></i><i class="fa fa-book"></i> Editar Vacante');
            
            }
        });

    }

    function getInfoTurno(id_turno_vacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/getInfoTurno",
            type : "POST",
            dataType : "json",
            data :{"id_turno_vacante" : id_turno_vacante},
            success : function(result){

                $("#id_turno_vacante").val(result.id_turno_vacante);
                $("#nombre_turno").val(result.desc_turno);
                setTimeout(ocultarLoader, 1000);
            
            }
        });

    }

    function deleteTurno(id_turno_vacante, id_vacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/deleteTurno",
            type : "POST",
            dataType : "json",
            data :{"id_turno_vacante" : id_turno_vacante},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    })

                    // Volver a llenar tabla
                    getTurnos(id_vacante);
                    $("#success_modal").removeClass("updateTurno");
                    $("#success_modal").addClass('agregarTurno');

                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    })
                }
            
                setTimeout(ocultarLoader, 1000);

            }
        });

    }

    function getTurnos(id_vacante){

        $("#success_modal").removeClass("updateTurno");
        $("#success_modal").addClass('agregarTurno');
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/getTurnos",
            type : "POST",
            dataType : "json",
            data :{"id_vacante" : id_vacante},
            success : function(result){

                if (result.respuesta == 200) {

                    $("#tbody_turnos").html(result.tabla);
                    $("#modal_turnos").modal("show");

                }else {

                    $("#tbody_turnos").html("");
                    $("#modal_turnos").modal("show");

                }
            
            }
        });

    }

    function updateVacante(id_vacante, nombre_vacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/updateVacante",
            type : "POST",
            dataType : "json",
            data :{"id_vacante" : id_vacante, "nombre_vacante" : nombre_vacante},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    });

                    setTimeout(function(){
                        location. reload();
                        ocultarLoader();
                    }, 2000);

                    $("#save").removeClass("updateInfoVacante");
                    $("#save").addClass('agregar');

                    $("#subir").html('<i class="fa fa-plus"></i><i class="fa fa-book"></i> Agregar Vacante');

                }else if(result.respuesta == 400){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'info'
                    });
                    setTimeout(ocultarLoader, 1000);
                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    });
                    setTimeout(ocultarLoader, 1000);
                }

            }
        });

    }

    function updateTurno(id_turno_vacante, nombre_turno, id_vacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/updateTurno",
            type : "POST",
            dataType : "json",
            data :{"id_turno_vacante" : id_turno_vacante, "id_vacante" : id_vacante, "nombre_turno" : nombre_turno},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    });

                    $("#success_modal").removeClass("updateTurno");
                    $("#success_modal").addClass('agregarTurno');

                    // Volver a llenar tabla
                    getTurnos(id_vacante);
                    $("#id_turno_vacante").val("");
                    $("#nombre_turno").val("");

                }else if(result.respuesta == 400){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'info'
                    })
                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    })
                }
            
                setTimeout(ocultarLoader, 1000);

            }
        });

    }

    function addTurno(id_vacante, nombre_turno){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/addTurno",
            type : "POST",
            dataType : "json",
            data :{"id_vacante" : id_vacante, "nombre_turno" : nombre_turno},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    })

                    // Volver a llenar tabla
                    getTurnos(id_vacante);
                    $("#nombre_turno").val("");

                }else if(result.respuesta == 400){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'info'
                    })
                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    })
                }
            
                setTimeout(ocultarLoader, 1000);

            }

        });

    }

    function addVacante(nombre_vacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/admin/vacantes/addVacante",
            type : "POST",
            dataType : "json",
            data :{"nombre_vacante" : nombre_vacante},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'success'
                    })
                    setTimeout(function(){
                        location. reload();
                        ocultarLoader();
                    }, 2000);
                }else if(result.respuesta == 400){
                    Swal.fire({
                        title: result.mensaje,
                        type: 'info'
                    });
                    setTimeout(ocultarLoader, 1000);
                }else{
                    Swal.fire({
                        title: result.mensaje,
                        type: 'error'
                    });
                    setTimeout(ocultarLoader, 1000);
                }
            
            }
        });

    }

    function filtrar(estatus){
      
      $("#tabla_vacantes").dataTable().fnDestroy();
      
      $("#save").removeClass("updateInfoVacante");
      $("#save").addClass('agregar');

      $("#subir").html('<i class="fa fa-plus"></i><i class="fa fa-book"></i> Agregar Vacante');

      $.ajax({
        url : "<?=base_url()?>index.php/admin/vacantes/filtrar",
        type : "POST",
        dataType : "json",
        data :{"estatus" : estatus},
            success : function(result){

                if(result.respuesta == 200){

                    $("#tbody_vacantes").html(result.tabla);
                    var tabla = $('#tabla_vacantes').dataTable( {
                        dom: "'down'<'col-md-1'B><'col-md-6'l><'col-md-5'f>"+ "<br/>" +
                        "<'top'<'col-md-12 scroll-x'tr>>" +
                        "<'top'<'col-md-4'i><'col-md-7'p>>",
                        buttons: [
                            {
                                text: '<i class="fa fa-file-excel-o"></i> Excel',
                                extend: 'excelHtml5',
                                className : 'btn btn-success',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            }
                        ]
                    });
                }
                else{
                    Swal.fire({
                        type: 'error',
                        title: "No se encontraron datos"
                    });
                    $("#tbody_vacantes").html("");

                }

                setTimeout(ocultarLoader, 1000);
            }//termina success
        
        });

    }//termina filtrar

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

   
    </script>