/**
 * @author UTEQ, Raul Zavaleta Zea
 * @version 0.1
 * @copyright Universidad Tecnológica de Querétaro, 2015. Todos los Derechos Reservados
*/
jQuery(document).ready(function($) {

	$("#go_Auth").submit(function(event) {
		/* Act on the event */

		/*Evitamos que el formulario
		ejecute el action*/
		event.preventDefault();

		/*Convertimos a md5 el usuario de acceso*/
		var tkn_user = md5($.trim($("#lzdu").val()));
		/*Tomamos el password del usuario*/
		var tkn_pass = $.trim($("#lzdp").val());

		/*Tomamos el html defecto del boton submit*/
		var default_btn_submit_html = $("#go-btn-ws-lgn-lzd").html();

		//No permitimos la escritura en los campos
		$("#lzdu, #lzdp").attr('readonly', 'readonly');

		//Deshabilitamos el boton de login
		$("#go-btn-ws-lgn-lzd").attr('disabled', 'disabled');
		//Mostramos un icono mientras intentamos acceder al WS
		$("#go-btn-ws-lgn-lzd").html("<i class='fa fa-cog fa-spin'></i>");

		//Consultamos en segundo plano (ajax)
		//El intento de inicio de sesión
		$.ajax({
			url : "http://dtaivirtual.uteq.edu.mx/web_service/api/auth_didet/",
			type : "POST",
			dataType : "json",
			data : {
				lzdu : tkn_user,
				lzdp : tkn_pass
			},
			success : function (json) {

				/*Si la respuesta ajax es 401 significa 
				que el usuario no tiene permisos
				o no existe*/
				if (json.response_code == "401") {
					/*Mostramos el mensaje de error en la vista*/
					var validation_message  = '<div class="alert text-center alert-danger alert-dismissable">';
							validation_message += '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>';
							validation_message += '<strong>Usuario / Contraseña incorrectos</strong>';
						validation_message += '</div>';

					//Limpiamos los campos
					$("#lzdu, #lzdp").val("");
					//Pasamos el cursor al campo
					$("#lzdu").focus();

					$("#validation-message").html(validation_message);
					
					//Permitimos la escritura de los campos
					$("#lzdu, #lzdp").removeAttr('readonly', 'readonly');

					//Habilitamos el boton de login
					$("#go-btn-ws-lgn-lzd").removeAttr('disabled', 'disabled');

					//Mostramos el texto original del boton
					$("#go-btn-ws-lgn-lzd").html(default_btn_submit_html);
					
				} 

				/*Si los datos de acceso son correctos entonces creamos las sesiones
				correspondients*/
				if (json.response_code == "200") {
					/*Creamos otra peticion ajax para enviar los datos 
					que nos regreso el Lizard*/
					$.ajax({
						url : base_url()+"sys/auth/",
						type : "POST",
						dataType : "json",
						data : json.dataUser,
						success : function (json) {
							if (json.response_code == "200") {
								window.location.href= base_url() + "admin/dashboard/";
							}
							else {
								noty_error();
								//Permitimos la escritura de los campos
								$("#lzdu, #lzdp").removeAttr('readonly', 'readonly');

								//Habilitamos el boton de login
								$("#go-btn-ws-lgn-lzd").removeAttr('disabled', 'disabled');

								//Mostramos el texto original del boton
								$("#go-btn-ws-lgn-lzd").html(default_btn_submit_html);

							}
						},
						error : function () {
							noty_error();
							//Permitimos la escritura de los campos
							$("#lzdu, #lzdp").removeAttr('readonly', 'readonly');

							//Habilitamos el boton de login
							$("#go-btn-ws-lgn-lzd").removeAttr('disabled', 'disabled');

							//Mostramos el texto original del boton
							$("#go-btn-ws-lgn-lzd").html(default_btn_submit_html);
						}
					});
				}
			},
			error : function () {
				noty_error();
			}
			
		});

	});

	$("#goto_recover").click(function(event) {
		event.preventDefault();
		$("#get-pass-modal").modal("show");
	});
	
});

function noty_error () {
	
	$.notify({
		// options
		icon: 'fa fa-times',
		title: ' <strong>Ocurrió un error</strong><br />',
		message: 'Oops!, algo salió mal, por favor vuelve a intentarlo'
	},{
		// settings
		element: 'body',
		position: null,
		type: "danger",
		allow_dismiss: true,
		newest_on_top: false,
		showProgressbar: false,
		placement: {
			from: "bottom",
			align: "right"
		},
		offset: 20,
		spacing: 10,
		z_index: 1031,
		delay: 3000,
		timer: 100,
		url_target: '_blank',
		mouse_over: null,
		animate: {
			enter: 'animated fadeInDown',
			exit: 'animated fadeOutUp'
		},
		onShow: null,
		onShown: null,
		onClose: null,
		onClosed: null,
		icon_type: 'class'
	});
	
}