<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\TicketsModel; 

class Tickets extends BaseController{

    private $TicketsModel; //Nombre de la variable para el modelo 
    protected $session;

    public function __construct(){
        
        $this->TicketsModel = new TicketsModel(); //modelo que vayan a usar
        $this->session      = session();

    }//termina __construct

    
    public function index(){

		$session         = session();
		$idUsuario       = $session->get('id_usuario');
		$nombre          = $session->get('usuario');
		$id_tipo_usuario = $session->get('id_tipo_usuario');
		$usuarios        = NULL;

		$idsVacantes     = [];

		if ($id_tipo_usuario == 1) {
			$usuarios = $this->TicketsModel->getUsuarioTicket($idUsuario);
		}else{//reclutador
			$usuarios = $this->TicketsModel->getTipoUsuarioTicket($idUsuario, $id_tipo_usuario);

			$vacantesReclutador = $this->TicketsModel->getVacantesByReclutador($idUsuario);

			if (!is_null($vacantesReclutador)) {
				foreach ($vacantesReclutador as $v) {
					$idsVacantes[] = intval($v->id_vacante);
				}
			}else {
				$idsVacantes[] = 50000;
			}
			
		}
        
		$data                    = array();
		$data["nombre"]          = strtoupper($nombre);
		$data["_APP_TITTLE"]     = "Conversaciones";
		$data["_TAB"]            = "tickets";
		$data["idUsuario"]       = $idUsuario;
		$data["id_tipo_usuario"] = $id_tipo_usuario;
		$data["usuarios"]        = $usuarios;
		$data["idsVacantes"]     = $idsVacantes;
		$data["fragment"]        = view("admin/fragments/conversaciones_view", $data);
		$data["main_menu"]       = view("admin/nav/main_menu_nav", $data);
		$data["nav"]             = view("admin/nav/main_nav", $data);
        
        return view("admin/main_view", $data);

    }  //termina index

    public function atendidas(){

		$session         = session();
		$id_usuario      = $session->get('id_usuario');
		$id_tipo_usuario = $session->get('id_tipo_usuario');
		$consulta        = NULL;

		if ($id_tipo_usuario == 1) {
			$consulta = $this->TicketsModel->getTicketsAtendidosAll();
		}else{
			$consulta = $this->TicketsModel->getTicketsAtendidosByUsuario($id_usuario);
		}
        
        $data                   = array();
        $data["_APP_TITTLE"]    = "Conversaciones atendidas";
        $data["_TAB"]           = "conv_aten";
        $data["conversaciones"] = $consulta;
        $data["fragment"]       = view("admin/fragments/conversaciones_atendidas_view", $data);
        $data["main_menu"]      = view("admin/nav/main_menu_nav", $data);
        $data["nav"]            = view("admin/nav/main_nav", $data);
        
        return view("admin/main_view", $data);

    }  //termina atendidas

	public function sendPlantilla(){

		$session = session();
		$nombre  = $session->get('usuario');

		$request = service('request');
		$celular = $request->getPost("celular");

		$respuesta = 500;
		$mensaje   = "Ocurrió un error, vuelve a intentarlo";

		// URL de la API
		$url = "https://api.gupshup.io/wa/api/v1/template/msg";

		// Datos a enviar
		$postData = http_build_query([
			'template' => json_encode([
				'id' => '2150acfe-f295-4d7e-a6d1-985455fd93d3',
				'params' => [''.$nombre.'']
			]),
			'source' => '5215598160206',
			'src.name' => 'testraasmex',
			'destination' => ''.$celular.'',
			'channel' => 'whatsapp'
		]);

		// Inicializar cURL
		$ch = curl_init($url);

		// Configurar opciones de cURL
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'accept: application/json',
			'apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6',
			'content-type: application/x-www-form-urlencoded'
		]);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

		// Ejecutar la petición
		$response = curl_exec($ch);

		// Cerrar cURL
		curl_close($ch);

		$json     = json_decode($response, true);
		$id_envio = NULL;

		if (isset($json["messageId"])) {
			$id_envio = $json["messageId"];
		}

		if(!is_null($id_envio)){
			
			$respuesta 	= 200;
			$mensaje	= "Plantilla enviada con éxito";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}// termina sendPlantilla

    public function tomarTicket(){

		date_default_timezone_set('America/Mexico_City');
		$fecha_hoy      		    = date ('Y-m-d H:i:s');

        $session 	                = session();
		$id_usuario 		        = $session->get('id_usuario');
		$nombre_usuario	            = $session->get('usuario');

		$respuesta 				    = 500;
		$mensaje 				    = "Ocurrió un error, vuelve a intentarlo";

        $request 		            = service('request');

		$idTicket      			    = $request->getPost("id_firestore");
		$celular      			    = $request->getPost("celular");

		$message 				    = "¡Bienvenido! Mi nombre es *".$nombre_usuario."* y estoy aquí para ayudarte a terminar tu postulación.";

        $update_t                   = array();
        $update_t["fecha_inicio"]   = $fecha_hoy;
        $update_t["estatus"]        = 1;
        $update_t["id_usuario"]     = $id_usuario;

        if($this->TicketsModel->updateTicket($update_t, $idTicket)){

            $respuesta 					= 200;
            $mensaje 					= "¡Conversación tomada con éxito!";

        }

        $this->mensaje_bot($message, $celular, $idTicket);
		
		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina tomarTicket

    public function sendMessageWeb(){

		date_default_timezone_set('America/Mexico_City');
		$fecha_hoy = date("Y-m-d H:i:s");

        $request = service('request');

		$id_ticket = $request->getPost("id_ticket");
		$celular   = $request->getPost("celular");
		$message   = $request->getPost("message");
		
		$this->mensaje_bot($message, $celular, $id_ticket);

		echo json_encode(200);

	}//termina sendMessageWeb

	public function subirArchivo(){

		date_default_timezone_set('America/Mexico_City');
		$fecha_hoy    	= date("Y-m-d H:i:s");
		$hora_hoy    	= date("H:i:s");

		$request 		= service('request');

		$id_firestore  	= $request->getPost("id_firestore");
		$id_firestore  	= (int)$id_firestore;
		$cel   			= $request->getPost("cel");
		
		$respuesta 		= 500;
		$mensaje 		= "Ocurrió un error, vuelve a intentarlo";

		if (isset($_FILES["file"])) {
			$name = $_FILES["file"]['name'];
			$ext  = pathinfo($name, PATHINFO_EXTENSION);
			$ext  = strtolower($ext);
			if ($ext == "jpg" || $ext == "jpeg" || $ext == "png" || $ext == "pdf" || $ext == "doc" || $ext == "docx" || $ext == "xls" || $ext == "xlsx") {
				$nombre_archivo = $cel."_".$hora_hoy.".".$ext;


				if (move_uploaded_file($_FILES["file"]["tmp_name"], "public/imagenesConversacion/".$nombre_archivo)) {
					$url = base_url()."public/imagenesConversacion/".$nombre_archivo."";
					sleep(1);
					$type 		= "";
					$type_file 	= "";
					if ($ext == "pdf" || $ext == "doc" || $ext == "docx" || $ext == "xls" || $ext == "xlsx") {

						$type 		= 2;
						$type_file 	= "file";

						$this->mensaje_file($cel, $url, "Archivo", $id_firestore);

					}else{

						$type 		= 1;
						$type_file 	= "image";

						$this->mensaje_image($cel, $url, "", $id_firestore);

					}

					$respuesta 	= 200;
					$mensaje 	= "Mensaje enviado con éxito";

				}//termina if move
			}else{
				$respuesta 	= 300;
				$mensaje 	= "Por favor selecciona un archivo válido";
			}
		}else{
			$respuesta 	= 300;
			$mensaje 	= "Por favor selecciona un archivo";
		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina subirArchivo

    public function cerrarTicket(){

		date_default_timezone_set('America/Mexico_City');

		$session         = session();
		$id_usuario      = $session->get('id_usuario');
		$nombre_usuario  = $session->get('usuario');
		$id_tipo_usuario = $session->get('id_tipo_usuario');

		$fecha_hoy      			= date ('Y-m-d H:i:s');

		$respuesta 					= 500;
		$mensaje 					= "Ocurrió un error, vuelve a intentarlo";

        $request 		            = service('request');
		$idTicket      			    = $request->getPost("id_firestore");
		$celular      				= $request->getPost("celular");

		$mensaje_bot 				= "Fue un placer apoyarte, te atendió *".$nombre_usuario."*.";

		$update_t					= array();
		$update_t["fecha_cerrado"] 	= $fecha_hoy;
		$update_t["estatus"] 	    = 2;

        $update_p 					= array();
		$update_p["conversacion"] 	= 1;
		$update_p["id_ticket"] 	    = 0;

        if($this->TicketsModel->updateTicket($update_t, $idTicket) && $this->TicketsModel->updatePregunta($update_p, $celular)){

			$respuesta = 200;
			$mensaje   = "¡Conversación cerrada con éxito!";

        }

		$this->mensaje_bot($mensaje_bot, $celular, $idTicket);
		
		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}  //termina cerrarTicket

		public function cerrarTicketInactividad(){

		date_default_timezone_set('America/Mexico_City');

		$session         = session();
		$id_usuario      = $session->get('id_usuario');
		$nombre_usuario  = $session->get('usuario');
		$id_tipo_usuario = $session->get('id_tipo_usuario');

		$fecha_hoy      = date ('Y-m-d H:i:s');
		$fecha_inicio_t = date ('Y-m-d H:i:s');

		$respuesta = 500;
		$mensaje   = "Ocurrió un error, vuelve a intentarlo";

		$request  = service('request');
		$idTicket = $request->getPost("id_firestore");
		$celular  = $request->getPost("celular");

		$ticket = $this->TicketsModel->getTicket($idTicket);

		if(!is_null($ticket)){
			if(!is_null($ticket->fecha_inicio) && $ticket->fecha_inicio != ""){
				$fecha_inicio_t = $ticket->fecha_inicio;
			}
		}

		$update_t                  = array();
		$update_t["fecha_inicio"]  = $fecha_inicio_t;
		$update_t["fecha_cerrado"] = $fecha_hoy;
		$update_t["estatus"]       = 3;
		$update_t["id_usuario"]    = $id_usuario;

		$update_p                 = array();
		$update_p["conversacion"] = 1;
		$update_p["id_ticket"]    = 0;

        if($this->TicketsModel->updateTicket($update_t, $idTicket) && $this->TicketsModel->updatePregunta($update_p, $celular)){

			$respuesta = 200;
			$mensaje   = "¡Conversación cerrada con éxito!";

        }
		
		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina cerrarTicketInactividad
	
	public function reasignarTicketSql(){

		date_default_timezone_set('America/Mexico_City');
		$session        = session();
		$id_usuario     = $session->get('id_usuario');
		$respuesta      = 500;
		$mensaje        = "Ocurrió un error, vuelve a intentarlo";
		$request        = service('request');
		$idTicket       = $request->getPost("id_firestore");
		$celular        = $request->getPost("celular");
		$id_usuario_new = $request->getPost("id_usuario_new");
		$mensaje_bot    = "Tu caso ha sido reasignado a otro asesor, por favor espera un momento mientras te atienden.";

		$update_t               = array();
		$update_t["id_usuario"] = $id_usuario_new;

		$insert_b                      = array();
		$insert_b["id_ticket"]         = $idTicket;
		$insert_b["id_usuario_actual"] = $id_usuario;
		$insert_b["id_usuario_new"]    = $id_usuario_new;

		if ($this->TicketsModel->updateTicket($update_t, $idTicket) && $this->TicketsModel->insertBitacoraTicket($insert_b)) {

			$this->correoReasignar($idTicket, $id_usuario, $id_usuario_new);

			$respuesta = 200;
			$mensaje   = "¡Conversación reasignada con éxito!";
		}

		$this->mensaje_bot($mensaje_bot, $celular, $idTicket);

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina reasignarTicketSql

    public function updateContador(){

		$respuesta 							= 500;
		$mensaje 							= "Ocurrió un error, vuelve a intentarlo";

        $request 		                    = service('request');

		$celular      			            = $request->getPost("celular");

		$getPreguntaByCel					= $this->TicketsModel->getPreguntaByCel($celular);

		if (!is_null($getPreguntaByCel)) {

			$update_p["cont_msj"] 			= 0;
			$this->TicketsModel->updatePregunta($update_p, $celular);
			
			$respuesta 						= 200;
			$mensaje 						= "OK";

		}
		
		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina updateContador

	public function updateEstatusTicket(){
    
		$session          = session();
		$idUsuario        = $session->get('id_usuario');
		$id_ticket        = $this->request->getPost('id_ticket');
		$id_estado_update = $this->request->getPost('id_estado_update');
		
		$estadoAnteriorTicket = $this->TicketsModel->getEstadoTicket($id_ticket);
	
		if (!$estadoAnteriorTicket) {
			return $this->response->setJSON([
				'status' => 'error',
				'message' => 'Ticket no encontrado.'
			]);
		}
	
		$estadoAnterior = $estadoAnteriorTicket->estatus_conversacion;
		
		if ($id_ticket && $id_estado_update !== '') {
			
			$this->TicketsModel->updateEstadoTicket($id_ticket, $id_estado_update);
	
			if ($estadoAnterior !== $id_estado_update) {
				
				$datosHistorial = [
					'estado_anterior' => $estadoAnterior,
					'estado_nuevo' => $id_estado_update,
					'id_ticket' => $id_ticket,
					'id_usuario' => $idUsuario
				];
	
				$this->TicketsModel->insertHistorialCambioEstado($datosHistorial);
			}
	
			return $this->response->setJSON([
				'status' => 'success',
				'message' => 'Estado del ticket actualizado correctamente.',
				'id_ticket' => $id_ticket,
				'id_estado_update' => $id_estado_update
			]);
		} else {
			return $this->response->setJSON([
				'status' => 'error',
				'message' => 'Por favor seleccione una opción de la lista'
			]);
		}
	}// termina updateEstatusTicket

    public function mensaje_bot($message,$numero, $idTicket){
	
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
			'channel' => 'whatsapp',
			'source' => '5215598160206',
			'destination' => ''.$numero.'',
			'src.name' => 'testraasmex',
			'message' => json_encode(array('type' => 'text', 'text' => $message))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		$message = nl2br($message);

		$this->insertConversacionFirestore(0, NULL, $numero, $message, 2, 0, $idTicket);

	}  //termina mensaje_bot
	
	public function mensaje_boton($numero, $cabecera, $mensaje, $pie, $options, $idTicket){

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5215598160206',
		    'destination' => ''.$numero.'',
		    'src.name' => 'testraasmex',
		    'disablePreview' => 'false',
		    'encode' => 'false',
		    'message' => json_encode(array('content' => array('type' => 'text', 'header' => ''.$cabecera.'', 'text' => ''.$mensaje.'', 'caption' => ''.$pie.''), 'type' => 'quick_reply', 'msgid' => 'qr1', 'options' => $options))
		];

		$limpio = array();
	    for ($i = 0; $i < count($options); $i++) {
     		foreach ($options[$i] as $key => $op){
	            if ($key == "title") {
	                $new = array("options" => $op);
	           		array_push($limpio, $new);
	            }
	         }
	    }

		$mensaje 		= nl2br($mensaje);

		$array_insert 	= array("header" => $cabecera, "body" => $mensaje, "foot" => $pie, "options" => $limpio);
		$json_insert  	= json_encode($array_insert);
		$json_insert  	= str_replace('"', "'", $json_insert);

		$this->insertConversacionFirestore(0, NULL, $numero, $json_insert, 2, 4, $idTicket);

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		curl_close($ch);

	}//termina mensaje_boton

	public function mensaje_image($numero, $url, $caption, $idTicket){

		// $numero		= "5214427791115";
		// // $url		= FCPATH."static/images/1.jpg";
		// $url		= "https://Abacom.com.mx/powerbell/static/imagen_pdf/prueba (1).jpg";
		// $caption	= "Prueba";

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5215598160206',
		    'destination' => ''.$numero.'',
		    'src.name' => 'testraasmex',
		    'message' => json_encode(array('type' => 'image', "originalUrl" => $url, "previewUrl" => $url, "caption" => $caption))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		$json = json_decode($result);

		$status = $json->status;

		curl_close($ch);

		// var_dump($json);

		$this->insertConversacionFirestore(0, $url, $numero, NULL, 2, 1, $idTicket);

		if($status == "submitted"){
			return 200;
		}else{
			return 400;
		}

	}//termina mensaje_image

	public function mensaje_file($numero, $url, $filename, $idTicket){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5215598160206',
		    'destination' => ''.$numero.'',
		    'src.name' => 'testraasmex',
		    'message' => json_encode(array('type' => 'file', "url" => $url, "filename" => $filename))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		$json = json_decode($result);

		$status = $json->status;

		curl_close($ch);

		// var_dump($json);

		$this->insertConversacionFirestore(0, $url, $numero, NULL, 2, 2, $idTicket);

		if($status == "submitted"){
			return 200;
		}else{
			return 400;
		}

    }//termina mensaje_file
    
	public function insertConversacionFirestore($estatus, $url, $cel, $mensaje, $tipo, $type_file, $idTicket){

		date_default_timezone_set('America/Mexico_City');
		$fecha_hoy  = date("Y-m-d H:i:s");

		$curl 		= curl_init();

		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://firestore.googleapis.com/v1/projects/bux-puntual-3fea9/databases/(default)/documents/conversacion?key=AIzaSyDdGBOH9zbjHkrttDvI0R-yy7bt7lwcSNI',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS =>'{"fields":
			{ 
			"estatus": {"integerValue" : '.$estatus.'},
			"fecha": {"stringValue" :"'.$fecha_hoy.'"},
			"fecha_msj": {"stringValue" :"'.$fecha_hoy.'"},
			"file_img": {"stringValue" :"'.$url.'"},
			"cel": {"stringValue" :"'.$cel.'"},
			"mensaje": {"stringValue" :"'.$mensaje.'"},
			"tipo": {"integerValue" : '.$tipo.'},
			"type_file": {"integerValue" : '.$type_file.'},
			"id_ticket": {"integerValue" : '.$idTicket.'}
			}
		}

		',
		CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		),
		));

		$response = curl_exec($curl);

		curl_close($curl);

	}//termina insertConversacionFirestore

	public function getFiltroAtendidas(){

		$session         = session();
		$id_usuario      = $session->get('id_usuario');
		$id_tipo_usuario = $session->get('id_tipo_usuario');

		$request      = service('request');
		$fecha_inicio = $request->getPost("fecha_inicio");
		$fecha_fin    = $request->getPost("fecha_fin");
		$filtro       = NULL;

		if ($id_tipo_usuario == 1) {
			$filtro = $this->TicketsModel->getFiltroTicketsAtendidosAll($fecha_inicio, $fecha_fin);
		}else{
			$filtro = $this->TicketsModel->getFiltroTicketsAtendidosByUsuario($fecha_inicio, $fecha_fin, $id_usuario);
		}

		$tabla = "";
		$cont  = 1;

		if(!is_null($filtro)){

			foreach ($filtro as $v) {

				$tabla .= "<tr><td>".$cont."</td>";
				$tabla .= "<td>".$v->nombre."</td>";
				$tabla .= "<td>".$v->celular."</td>";
				$tabla .= "<td>".$v->nombre_vacante."</td>";
				$tabla .= "<td>".$v->fecha_inicio."</td>";
				$tabla .= "<td>".$v->fecha_cerrado."</td>";
				$tabla .= "<td>".$v->tiempo_tomado."</td>";
				$tabla .= "<td>".$v->t_usuario."</td>";
				$tabla .= "<td>".$v->nombre_usuario."</td>";
				$tabla .= '<td style="text-align: center;"><button class="showConversation btn btn-primary" data-id="'.$v->id_ticket.'" data-celular="'.$v->celular.'"><i class="fa fa-comments"></i> Conversación</button></td>';
				$tabla .= '</tr>';
				
				$cont++;

			}//foreach

		}//is_null

		echo json_encode($tabla);

	}  //termina getFiltroAtendidas
	
	public function correoReasignar($id_ticket, $id_usuario, $id_usuario_new){
	// public function correoReasignar(){

	// 	$id_ticket      = 9;
	// 	$id_usuario     = 13;
	// 	$id_usuario_new = 11;
		$nombre         = "";
		$celular        = "";
		$getDatosTicket = $this->TicketsModel->getTicket($id_ticket);
		$usuarioActual  = $this->TicketsModel->getUsuario($id_usuario);
		$usuarioNuevo   = $this->TicketsModel->getUsuario($id_usuario_new);
		$nombre_u       = "";
		$nombre_u_nuevo = "";
		$correo_u_nuevo = "";
		
		if (!is_null($usuarioActual)) {
			$nombre_u = $usuarioActual->usuario;
		}
		
		if (!is_null($usuarioNuevo)) {
			$nombre_u_nuevo = $usuarioNuevo->usuario;
			$correo_u_nuevo = $usuarioNuevo->correo;
		}

		if(!is_null($getDatosTicket)){

			$nombre  = $getDatosTicket->nombre_persona;
			$celular = $getDatosTicket->celular_persona;
		
		}  //datosPostulacion
		
		$correos = $correo_u_nuevo;

		$body = "Hola ".$nombre_u_nuevo.", tienes un nuevo <strong>TICKET</strong> reasignado de ".$nombre_u.", te comparto su nombre y celular de la persona. <br><br>";
		$body .= "<section>
				<h3>Datos</h3>
				<ul>
				<li type='disc'>Nombre: <strong>".$nombre."</strong></li>
				<li type='disc'>WhatsApp: <strong>".$celular."</strong></li>
				</ul>";
		$body .= "<p>Ingresa a la plataforma para atenderla <a href='".base_url()."index.php/conversaciones'>Da clic aquí</a></p>";

		$this->enviarCorreoNotificacion($correos, $body);

	}//termina correoReasignar

	public function enviarCorreoNotificacion($correos, $body){

		$data = array (
			'From' 			=> '[ABACOM] notificaciones@factorx.com.mx',
			'To' 			=> ''.$correos.'',
			'Subject' 		=> 'ABACOM - NUEVO TICKET REASIGNADO',
			'HtmlBody' 		=> ''.$body.'',
			'MessageStream' => 'outbound'
		);

		$json_body = json_encode($data);

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://api.postmarkapp.com/email',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => $json_body,
			CURLOPT_HTTPHEADER => array(
				'Accept: application/json',
				'Content-Type: application/json',
				'X-Postmark-Server-Token: e3a6446f-195f-4652-b861-c1deb3303701'
			),
		));

		$response = curl_exec($curl);

		// echo var_dump($response);

		curl_close($curl);

		$json 		= json_decode($response);
		$errorCode 	= $json->ErrorCode;

		if($errorCode == 0) {
			return true;
		}else {
			return false;
		}

	}  //termina enviarCorreoNotificacion

}//termina Class 
