<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\VacantesModel;
use App\Libraries\Ciqrcode;
use App\Libraries\Excel;

class Vacantes extends BaseController {
	
	private $VacantesModel; //Nombre de la variable para el modelo 
    protected $session;
	private $encrypter;

    public function __construct(){
        
        $this->VacantesModel = new VacantesModel(); // modelo a usar
        $this->session = session();

    }//termina __construct

	public function index(){

		$session   = session();
		$tipo      = $session->get('id_tipo_usuario');
		$idUsuario = $session->get('id_usuario');
		
		$vacantes = null;

		if($tipo == 1){
			$vacantes = $this->VacantesModel->getVacantes();
		}else if($tipo == 2){
			$vacantes = $this->VacantesModel->getVacantesReclutador($idUsuario);
		}

		$data                = array();
		$data["_APP_TITTLE"] = "Vacantes";
		$data["_TAB"]        = "vacantes";
		$data["vacantes"]    = $vacantes;
		$data["fragment"]    = view('admin/fragments/vacantes_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function vacantesReclutador(){

		$session 		= session();
		$idUsuario		= $session->get('id_usuario');

		$data                = array();
		$data["_APP_TITTLE"] = "Vacantes";
		$data["_TAB"]        = "vacantes";
		$data["reclutador"]  = $this->VacantesModel->reclutadorIdUsuario($idUsuario);
		$data["vacantes"]	 = $this->VacantesModel->getVacantesReclutador($idUsuario);
		$data["fragment"]    = view('admin/fragments/vacantes_reclutador_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina vacantesReclutador

	public function agregar(){

		$data                 = array();
		$data["_APP_TITTLE"]  = "Agregar vacante";
		$data["_TAB"]         = "agregarV";
		$data["categorias"]   = $this->VacantesModel->getCategorias();
		$data["reclutadores"] = $this->VacantesModel->getReclutadores();
		$data["sucursales"]   = $this->VacantesModel->getSucursales();
		$data["fragment"]     = view('admin/fragments/agregar_vacante_view', $data);
		$data["main_menu"]    = view('admin/nav/main_menu_nav', $data);
		$data["nav"]          = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina agregar

	public function agregarVacante(){

		$session    = session();
		$id_usuario = $session->get('id_usuario');

		$request      = service('request');
		$nombre       = $request->getPost("nombre");
		$id_categoria = $request->getPost("id_categoria");
		$descripcion  = $request->getPost('descripcion');
		$id_sucursal  = $request->getPost('id_sucursal');
		$reclutadores = $request->getPost('reclu');
		$mensajeP     = $request->getPost("mensaje");

		$regreso = 500;
		$mensaje = "Error, vuelve a intentarlo";
		
		$vacante                 	= array();
		$vacante['nombre']       	= $nombre;
		$vacante['descripcion']  	= $descripcion;
		$vacante['id_categoria'] 	= $id_categoria;
		$vacante['id_sucursal']     = $id_sucursal;
		$vacante['mensaje_viable'] 	= $mensajeP;

		$idVacante = $this->VacantesModel->insertarVacante($vacante);

		$nombre = preg_replace('/\s+/', '', $nombre);
		$nombre = $this->eliminar_acentos($nombre);
		$rest   = substr($nombre, 0, 3);
		$codigo = mb_strtoupper($rest."MEDC-".$idVacante);
		
		$updateVacante                    = array();
		$updateVacante["codigo_vacante"] = $codigo;
		$this->VacantesModel->actualizarVacante($idVacante,$updateVacante);
	
		if (!is_null($idVacante)) {

			$regreso = 200;
			$mensaje = "Vacante insertada con éxito";

			$field_name = $request->getPost("field_name");
			$arrayDel   = $request->getPost("arrayDel");
			$arrayDatos = $request->getPost("arrayDatos");

			$arrayDatos      = json_decode($arrayDatos);
			$arrayDel        = json_decode($arrayDel);
			$total_preguntas = count($arrayDel);
			$datosTabla      = array();
			$pregunta        = "";
			$insertPregunta  = array();
			$insertOpcion    = array();

			for ($num=0; $num < $total_preguntas; $num++){
				
				$posicion = $arrayDel[$num];
				$pregunta = $field_name[$num];
				$tipo_r   = $request->getPost("tipo_r_".$posicion);

				if ($tipo_r == "texto_".$posicion) {
					$tipo = 1;
				}else{
					$tipo = 2;
				}

				$insertPregunta["pregunta"]       = $pregunta;
				$insertPregunta["id_vacante"]     = $idVacante;
				$insertPregunta["tipo_respuesta"] = $tipo;

				$id_pregunta_vacante = $this->VacantesModel->insertarPreguntaVacante($insertPregunta);

				if(isset($_FILES["file-".$posicion])){

					$name = $_FILES["file-".$posicion]['name'];
					$ext  = pathinfo($name, PATHINFO_EXTENSION);
					$ext  = strtolower($ext);

					if ($ext == "jpg" || $ext == "jpeg" || $ext == "png"){
						$image = getimagesize($_FILES["file-".$posicion]['tmp_name']);
						$width = $image[0];

						if($width <= 1500){

							if (move_uploaded_file($_FILES["file-".$posicion]["tmp_name"], "public/archivos_preguntas/".$id_pregunta_vacante.".".$ext)) {
								$url = base_url()."public/archivos_preguntas/".$id_pregunta_vacante.".".$ext;
	
								$actualizarPregunta = array();
								$actualizarPregunta["pdf_pregunta"] = $url;
	
								$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante);
							}else {
								$regreso = 300;
								$mensaje = "No se pudo subir el archivo, vuelve a intentarlo";
							}

						}else{
							$regreso 	= 300;
							$mensaje 	= "La imagen ".$name." excede el ancho permitido";
						}

					}else{
						if (move_uploaded_file($_FILES["file-".$posicion]["tmp_name"], "public/archivos_preguntas/".$id_pregunta_vacante.".".$ext)) {
							$url = base_url()."public/archivos_preguntas/".$id_pregunta_vacante.".".$ext;

							$actualizarPregunta = array();
							$actualizarPregunta["pdf_pregunta"] = $url;

							$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante);
						}else {
							$regreso = 300;
							$mensaje = "No se pudo subir el archivo, vuelve a intentarlo";
						}
					}


				}else{
					$actualizarPregunta = array();
					$actualizarPregunta["pdf_pregunta"] = NULL;

					$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante);
				}


				if ($tipo == 2) {
					if(isset($arrayDatos[$posicion])){

						$datosPosicion = $arrayDatos[$posicion];
	
						if(!is_null($datosPosicion)){
							$datosTabla = $arrayDatos[$posicion]->tabla;

							for ($contDatos=0; $contDatos < count($datosTabla); $contDatos++){
		
								$valorTabla = $datosTabla[$contDatos]->valor;

								if($datosTabla[$contDatos]->esCorrecta == true){
									$esDescarte = 0;
								}else{
									$esDescarte = 1;
								}
		
								$insertOpcion["id_pregunta_vacante"] = $id_pregunta_vacante;
								$insertOpcion["opcion"]              = $valorTabla;
								$insertOpcion["descarte"]		     = $esDescarte;

								$this->VacantesModel->insertarOpcionPregunta($insertOpcion);
		
							}//segundo for
						}
	
					}//Aqui termina todo lo de las tablas
				}//termina if tipo
			}//termina for

			$reclutadores = json_decode($reclutadores);

			if($reclutadores != ""){
				for ($i=0; $i < count($reclutadores); $i++) { 

					$reclutador = $this->VacantesModel->getReclutador($reclutadores[$i]);
					// $this->generarCodigoQrReclutador($reclutador->codigo_reclutador, $codigo, $nombre);
					
					$vacanteReclutador = array();
					$vacanteReclutador["id_vacante"] 	= $idVacante;
					$vacanteReclutador["id_reclutador"] = $reclutadores[$i];
					// $vacanteReclutador["url_qr"]		= "https://raasmex.com.mx/medina_consultores/public/vacante_reclutador_qr/".$reclutador->codigo_reclutador.$codigo.".png";

					$this->VacantesModel->insertarVacanteReclutador($vacanteReclutador);

				}
			}
			

		}else{
			$regreso   = 500;
			$mensaje   = "Error al agregar vacante, vuelve a intentarlo";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));


	}//termina agregarVacante

	public function actualizarVacante(){

		$request   = service('request');
		$idVacante = base64_decode($request->getGet("v"));
		$vacante   = $this->VacantesModel->getDatosVacantes($idVacante);

		$session   = session();
		$tipo      = $session->get('id_tipo_usuario');
		$idUsuario = $session->get('id_usuario');

		if(!is_null($vacante)){

			$data["_APP_TITTLE"]  = "Actualizar vacante";
			$data["_TAB"]         = "vacantes";
			$data["vacante"]      = $vacante;
			$data["preguntas"]    = $this->VacantesModel->getPreguntasVacante($idVacante);
			$data["categorias"]   = $this->VacantesModel->getCategorias();
			$data["reclutadores"] = $this->VacantesModel->getReclutadores();
			$data["sucursales"]   = $this->VacantesModel->getSucursales();
			$data["reVacante"]    = $this->VacantesModel->getReclutadoresVacante($idVacante);
			$data["idVacante"]    = $idVacante;
			$data["fragment"]     = view('admin/fragments/actualizar_vacante_view', $data);
			$data["main_menu"]    = view('admin/nav/main_menu_nav', $data);
			$data["nav"]          = view('admin/nav/main_nav', $data);

			return view("admin/main_view", $data);

		}else {

			return redirect()->to('/vacantes');

		}

	}//termina actualizarVacante

	public function getOpciones(){

		$request 	 = service('request');
		$id_pregunta = $request->getPost("id_pregunta");
		$posicion    = $request->getPost("posicion");

		//die(var_dump($posicion));

		$tabla = "";
		$datos = null;

		if($id_pregunta != ""){
			$datos = $this->VacantesModel->opcionesMultiples($id_pregunta);
		}

		//$datos = $this->model->getPreguntaOpciones($id_pregunta);
		$cont           = 1;
		$array_posicion = array();

		if (!is_null($datos)) {
			
			$button      = "";
			$btnEliminar = "";
			
			foreach ($datos as $v) {

				$i = $cont-1;

				if($v->descarte == 0){
					$descarte = "<input type='radio' name='viable_".$i."' class='viable' data-val='0' data-index='".$i."' data-posicion='".$posicion."' data-del='".$v->id_opcion_multiple."' checked/> Sí <input type='radio' name='viable_".$i."' class='viable' data-val='1' data-index='".$i."' data-posicion='".$posicion."' data-del='".$v->id_opcion_multiple."'/> No";
				}else{
					$descarte = "<input type='radio' name='viable_".$i."' class='viable' data-val='0' data-index='".$i."' data-posicion='".$posicion."' data-del='".$v->id_opcion_multiple."'/> Sí <input type='radio' name='viable_".$i."' class='viable' data-val='1' data-index='".$i."' data-posicion='".$posicion."' data-del='".$v->id_opcion_multiple."' checked/> No";
				}
				
				$array_opcion = array();
				
				$btnEliminar = '<a style="display: inline-block;" class="eliminarOpcion btn btn-danger btn-sm" data-del="'.$v->id_opcion_multiple.'" title="Eliminar opción"><i class="fa fa-trash"></i></a>';

				$button = '<a style="display: inline-block; background-color: #1d70b6; color: white;" id="ver_2" href="javascript:void(0);" data-op = "'.$v->opcion.'"
				data-id-op="'.$v->id_opcion_multiple.'" data-es="'.$v->descarte.'"
				class="actualizarOpcion btn btn-sm" title="Ver opciones"><i class="fa fa-pencil"></i> Actualizar</a>'; 


				$tabla .= "<tr><td>".$cont."</td>";
				$tabla .= "<td id='op_".$v->id_opcion_multiple."'>".$v->opcion."</td>";
				$tabla .= "<td>".$descarte."</td>";

				$array_opcion["valor"]    = $v->opcion;
				$array_opcion["descarte"] = ($v->descarte == 0) ? true : false;
				$array_opcion["posicion"] = $posicion;

				$tabla .= "<td>".$button."  ".$btnEliminar."</td></tr>";
				$cont++;

				array_push($array_posicion, $array_opcion);
			}

		}

		echo json_encode(array("tabla" => $tabla, "p" => $cont, "array_posicion" => $array_posicion));

	}//termina getOpciones

	public function guardarPregunta(){

		$request 	 = service('request');

		$pregunta    = $request->getPost("pregunta");
		$tipo        = $request->getPost("tipo");
		$arrayNew    = json_decode($request->getPost("arrayNew"));
		$idVacante   = $request->getPost("idVacante");
		
		$insert_p              		= array();
		$insert_p["pregunta"]  		= $pregunta;
		$insert_p["tipo_respuesta"] = $tipo;
		$insert_p["id_vacante"]     = $idVacante;

		$id_pregunta_vacante = $this->VacantesModel->insertarPreguntaVacante($insert_p);

		$respuesta = 200;
		$mensaje = "Pregunta guardada correctamente";

		if(isset($_FILES["file"])){

			$name = $_FILES["file"]['name'];
			$ext  = pathinfo($name, PATHINFO_EXTENSION);
			$ext  = strtolower($ext);

			if ($ext == "jpg" || $ext == "jpeg" || $ext == "png"){
				$image = getimagesize($_FILES["file"]['tmp_name']);

				$width = $image[0];

				if($width <= 1500){

					if (move_uploaded_file($_FILES["file"]["tmp_name"], "public/archivos_preguntas/".$id_pregunta_vacante.".".$ext)) {
						$url = base_url()."public/archivos_preguntas/".$id_pregunta_vacante.".".$ext;
	
						$actualizarPregunta = array();
						$actualizarPregunta["pdf_pregunta"] = $url;
	
						$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante);
					}else {
						$respuesta = 300;
						$mensaje = "No se pudo subir el archivo, vuelve a intentarlo";
					}

				}else{
					$respuesta 	= 300;
					$mensaje 	= "La imagen ".$name." excede el ancho permitido";
				}

			}else{
				if (move_uploaded_file($_FILES["file"]["tmp_name"], "public/archivos_preguntas/".$id_pregunta_vacante.".".$ext)) {
					$url = base_url()."public/archivos_preguntas/".$id_pregunta_vacante.".".$ext;

					$actualizarPregunta = array();
					$actualizarPregunta["pdf_pregunta"] = $url;

					$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante);
				}else {
					$respuesta = 300;
					$mensaje = "No se pudo subir el archivo, vuelve a intentarlo";
				}
			}

			

		}else{
			$actualizarPregunta = array();
			$actualizarPregunta["pdf_pregunta"] = NULL;

			$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante);
		}


		if ($tipo == 2) {
			for ($i=0; $i < count($arrayNew); $i++) {

				//var_dump($arrayNew[$i]["esCorrecta"]);
				if($arrayNew[$i]->esCorrecta == true){
					$descarte = 0;
				}else{
					$descarte = 1;
				}
				//var_dump($descarte);

				$opcion                           = $arrayNew[$i]->valor;
				$insert_o                         = array();
				$insert_o["opcion"]               = $opcion;
				$insert_o["descarte"]			  = $descarte;
				$insert_o["id_pregunta_vacante"] = $id_pregunta_vacante;
				$this->VacantesModel->insertarOpcionPregunta($insert_o);
			}
		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina guardarPregunta

	public function addOpcion(){

		$request 	 		  = service('request');
		$opcion               = $request->getPost("opcion");
		$esCorrecta           = $request->getPost("esCorrecta");
		$id_pregunta_vacante  = $request->getPost("id_pregunta_vacante");
		$regreso = 500;

		$insert                        = array();
		$insert["id_pregunta_vacante"] = $id_pregunta_vacante;
		$insert["opcion"]              = $opcion;
		$insert["descarte"]		       = ($esCorrecta == "true") ? 0 : 1;

		if(!is_null($this->VacantesModel->insertarOpcionPregunta($insert))){
			$regreso = 200;
		}

		echo json_encode($regreso);

	}//termina addOpcion

	public function updateOpcion(){

		$request	= service('request');

		$id_opcion        = $request->getPost("id_opcion");
		$opcion           = $request->getPost("opcion");
		$regreso          = 500;
		
		$update           	= array();
		$update["opcion"] 	= $opcion;
		

		if($this->VacantesModel->updateOpcion($update, $id_opcion)){
			$regreso = 200;
		}

		echo json_encode($regreso);

	}//termina updateOpcion

	public function updateDescarte(){

		$request	= service('request');

		$id_opcion        = $request->getPost("id_opcion");
		$valor            = $request->getPost("valor");
		$regreso          = 500;
		
		$update           	= array();
		$update["descarte"] = $valor;
		

		if($this->VacantesModel->updateOpcion($update, $id_opcion)){
			$regreso = 200;
		}

		echo json_encode($regreso);

	}//termina updateDescarte

	public function bajaOpcion(){

		$request	= service('request');

		$id_opcion   = $request->getPost('id_opcion');
		$id_pregunta = $request->getPost('id_pregunta');
		$regreso     = 500;
		$mensaje     = "Ocurrio un error, por favor vuelve a intentarlo";

		$opActivas   = $this->VacantesModel->opcionesMultiples($id_pregunta);

		if ($opActivas > 1) {
			if ($this->VacantesModel->eliminarOpcion($id_opcion)){
				$regreso = 200;
				$mensaje = "Opción eliminada correctamente";
			}
		}else{
			$regreso = 300;
			$mensaje = "No puedes eliminar todas las opciones";
		}
		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));

	}//termina bajaOpcion

	public function bajaPregunta(){

		$request	= service('request');

		$id_pregunta = $request->getPost('id_pregunta');
		$regreso     = false;

		$update            = array();
		$update["estatus"] = 0;

		if ($this->VacantesModel->actualizarPreguntaVacante($update, $id_pregunta)){
			$regreso = true;
		}

		echo json_encode($regreso);

	}//termina bajaPregunta

	public function bajaArchivo(){

		$request	= service('request');

		$id_pregunta = $request->getPost('id_pregunta');
		$regreso     = false;

		$update            		= array();
		$update["pdf_pregunta"] = NULL;

		if ($this->VacantesModel->actualizarPreguntaVacante($update, $id_pregunta)){
			$regreso = true;
		}

		echo json_encode($regreso);

	}//termina bajaArchivo

	public function guardarArchivo(){

		$request	= service('request');
		$idPregunta = $request->getPost('idPregunta');
		$respuesta  = 500;
		$mensaje 	= "Error, vuelve a intentarlo";


		if(isset($_FILES["file"])){

			$name = $_FILES["file"]['name'];
			$ext  = pathinfo($name, PATHINFO_EXTENSION);
			$ext  = strtolower($ext);

			if ($ext == "jpg" || $ext == "jpeg" || $ext == "png"){
				$image = getimagesize($_FILES["file"]['tmp_name']);

				$width = $image[0];

				if($width <= 1500){

					if (move_uploaded_file($_FILES["file"]["tmp_name"], "public/archivos_preguntas/".$idPregunta.".".$ext)) {
						$url = base_url()."public/archivos_preguntas/".$idPregunta.".".$ext;
	
						$actualizarPregunta = array();
						$actualizarPregunta["pdf_pregunta"] = $url;
	
						$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $idPregunta);
	
						$respuesta  = 200;
						$mensaje	= "Archivo guardado correctamente";
	
					}else {
						$respuesta = 300;
						$mensaje 	= "No se pudo subir el archivo, vuelve a intentarlo";
					}

				}else{
					$respuesta 	= 300;
					$mensaje 	= "La imagen ".$name." excede el ancho permitido";
				}

			}else{
				if (move_uploaded_file($_FILES["file"]["tmp_name"], "public/archivos_preguntas/".$idPregunta.".".$ext)) {
					$url = base_url()."public/archivos_preguntas/".$idPregunta.".".$ext;

					$actualizarPregunta = array();
					$actualizarPregunta["pdf_pregunta"] = $url;

					$this->VacantesModel->actualizarPreguntaVacante($actualizarPregunta, $idPregunta);

					$respuesta  = 200;
					$mensaje	= "Archivo guardado correctamente";

				}else {
					$respuesta = 300;
					$mensaje 	= "No se pudo subir el archivo, vuelve a intentarlo";
				}
			}

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina guardarArchivo

	public function updateVacante(){
		
		$request         = service('request');
		$session         = session();
		$tipo            = $session->get('id_tipo_usuario');
		$idUsuarioSesion = $session->get('id_usuario');

		$nombre       = $request->getPost("nombre");
		$categoria    = $request->getPost("id_categoria");
		$descripcion  = $request->getPost('descripcion');
		$id_sucursal  = $request->getPost('id_sucursal');
		$reclutadores = $request->getPost('reclu');
		$mensajeP     = $request->getPost('mensaje');

		$idVacante = $request->getPost('idVacante');

		$respuesta = 500;
		$mensaje   = "Error, vuelve a intentarlo";
	
		$vacante                   = array();
		$vacante['nombre']         = $nombre;
		$vacante['descripcion']    = $descripcion;
		$vacante['id_categoria']   = $categoria;
		$vacante['id_sucursal']    = $id_sucursal;
		$vacante['mensaje_viable'] = $mensajeP;


		if($this->VacantesModel->actualizarVacante($idVacante,$vacante)){
			$respuesta = 200;
			$mensaje   = "Vacante actualizada con éxito";
		}
		
		$field_name = $request->getPost("field_name");
		$cont       = 1;
		
		for ($i=0; $i < count($field_name); $i++) {

			$pregunta_id = $request->getPost("id_pregunta_".$cont);
			$pregunta    = $field_name[$i];

			$update_pv              = array();
			$update_pv["pregunta"]  = trim($pregunta);

			$this->VacantesModel->actualizarPreguntaVacante($update_pv, $pregunta_id);

			$cont++;

		}//termina for

		$this->VacantesModel->eliminarReclutadores($idVacante);
		$reclutadores = json_decode($reclutadores);
		// $datosVacante = $this->VacantesModel->getDatosVacantes($idVacante);

			if($reclutadores != ""){
				for ($i=0; $i < count($reclutadores); $i++) {

					$reclutador = $this->VacantesModel->getReclutador($reclutadores[$i]);
					// $this->generarCodigoQrReclutador($reclutador->codigo_reclutador, $datosVacante->codigo_vacante, $nombre);
					
					$vacanteReclutador                  = array();
					$vacanteReclutador["id_vacante"]    = $idVacante;
					$vacanteReclutador["id_reclutador"] = $reclutadores[$i];
					// $vacanteReclutador["url_qr"]        = "https://raasmex.com.mx/medina_consultores/public/vacante_reclutador_qr/".$datosVacante->codigo_vacante.$reclutador->codigo_reclutador.".png";

					$this->VacantesModel->insertarVacanteReclutador($vacanteReclutador);

				}
			}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina updateVacante

	public function preguntasVacante(){

		$request 		= service('request');
		$idVacante 		= $request->getPost("idVacante");
		$preguntas		= "";

		$data = $this->VacantesModel->getPreguntasVacante($idVacante);

		if (!is_null($data)) {

			$preguntas .= "<div class='panel-group' id='accordion' role='tablist' aria-multiselectable='true'>";
			
			foreach ($data as $da) {
				
				$preguntas .= "<div class='panel panel-default'>";
				$preguntas .= "<div class='panel-heading' role='tab' id='heading$da->id_pregunta_vacante'>";
				$preguntas .= "<h4 class='panel-title'>";
				$preguntas .= "<a class='collapsed' role='button' data-toggle='collapse' data-parent='#accordion' href='#collapse$da->id_pregunta_vacante' aria-expanded='false' aria-controls='collapse$da->id_pregunta_vacante'>";
				$preguntas .= $da->pregunta;
				$preguntas .= "</a></h4></div>";
				$preguntas .= "<div id='collapse$da->id_pregunta_vacante' class='panel-collapse collapse' role='tabpanel' aria-labelledby='heading$da->id_pregunta_vacante'>";
				$preguntas .= "<div class='panel-body'>";
				$preguntas .= "<p>";

					if($da->tipo_respuesta == 2){

						$respuestas = $this->VacantesModel->opcionesMultiples($da->id_pregunta_vacante);

						$preguntas .= "<strong>Opciones:</strong><br>";

						$cont = 1;

						foreach ($respuestas as $respuesta) {

							$preguntas .= "<span style='margin-left: 2rem;'>".$cont.".- ".$respuesta->opcion."</span><br>";
							$cont++;
						}


					}else{
						$preguntas .= "Pregunta con tipo de respuesta libre";
					}

					if(!is_null($da->pdf_pregunta)){

						$preguntas .= "<strong>Archivo:</strong><br>";

						$preguntas .= '<a class="btn" style="width: 80px; background-color: #1d70b6; color: white; margin-top: 0.5rem;"
                                href="'.$da->pdf_pregunta.'" target="_blank"><i class="fa-solid fa-file-pdf"></i> Ver</a>';
					}

				$preguntas .= "</p>";
				$preguntas .= "</div>";
				$preguntas .= "</div></div>";

			}

			$preguntas .= "</div>";
		}

		echo json_encode(array("preguntas" => $preguntas));


	}//termina preguntasVacante

	public function noPostularon(){

		$session         = session();
		$noPostulaciones = NULL;
		$tipo            = $session->get('id_tipo_usuario');
		$idUsuario       = $session->get('id_usuario');

		if($tipo == 1){
			$noPostulaciones = $this->VacantesModel->getNoPostulaciones();
		}else if($tipo == 2){
			$noPostulaciones = $this->VacantesModel->noPostulacionesReclutador($idUsuario);
		}

		$data                = array();
		$data["_APP_TITTLE"] = "Postulaciones sin concretar";
		$data["_TAB"]        = "no-postularon";
		$data["noPostulacion"] = $noPostulaciones;
		$data["fragment"]    = view('admin/fragments/nopostularon_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina noPostularon

	public function postuladosVacante(){

		$request   = service('request');
		$idVacante = base64_decode($request->getGet("v"));

		$data                  = array();
		$data["_APP_TITTLE"]   = "Postulaciones";
		$data["_TAB"]          = "vacantes";
		$data["vacante"]       = $this->VacantesModel->getDatosVacantes($idVacante);
		$data["postulaciones"] = $this->VacantesModel->getPostuladosVacante($idVacante);
		$data["idVacante"]     = $idVacante;
		$data["fragment"]      = view('admin/fragments/vacante_postulaciones_view', $data);
		$data["main_menu"]     = view('admin/nav/main_menu_nav', $data);
		$data["nav"]           = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina postuladosVacante

	public function postuladosVacanteReclutador(){

		$request   = service('request');
		$idVacante = base64_decode($request->getGet("v"));
		$session   = session();
		$idUsuario = $session->get('id_usuario');

		$data                  = array();
		$data["_APP_TITTLE"]   = "Postulaciones";
		$data["_TAB"]          = "vacantes";
		$data["vacante"]       = $this->VacantesModel->getDatosVacantes($idVacante);
		$data["postulaciones"] = $this->VacantesModel->getPostuladosVacante($idVacante);
		$data["idVacante"]     = $idVacante;
		$data["fragment"]      = view('admin/fragments/vacante_postulaciones_view', $data);
		$data["main_menu"]     = view('admin/nav/main_menu_nav', $data);
		$data["nav"]           = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina postuladosVacanteReclutador

	public function noPostularonFiltrar(){

		$request 		= service('request');
		$inicio 		= $request->getPost("inicio");
		$fin 			= $request->getPost("fin");

		$data 			= NULL;
		$session 		= session();
		$tipo 			= $session->get('id_tipo_usuario');
		$idUsuario		= $session->get('id_usuario');

		if($tipo == 1){
			$data = $this->VacantesModel->getNoPostulacionesFiltrar($inicio, $fin);
		}else if($tipo == 2){
			$data = $this->VacantesModel->noPostulacionesReclutadorFiltrar($inicio, $fin,$idUsuario);
		}

		$tabla = "";

		if (!is_null($data)) {

			$cont = 1;

			foreach ($data as $da) {

				if (is_null($da->motivo) || $da->motivo == "") {
					$desc = "N/A";
				}else {
					$descripcion = $da->motivo;

					$descripcion = str_replace('"', '', $descripcion);
					$descripcion = str_replace('“', '', $descripcion);
					$descripcion = str_replace("'", '', $descripcion);

					$cont_desc = strlen($descripcion);
					if($cont_desc > 40){
						$desc = substr($descripcion,0, 40).'... <a href class="showMensaje"  data-mensaje="'.nl2br($descripcion).'">Ver más</a>'; 
					}else{
						$desc = $descripcion;
					}
				}


				$tabla .= "<tr>";
				$tabla .= "<td>".$cont."</td>";
				$tabla .= "<td>".$da->nombre_candidato."</td>";
				$tabla .= "<td>(+".substr($da->celular_candidato, 0, -10).") ".substr($da->celular_candidato, -10)."</td>";
				$tabla .= "<td><a class='btn' style='background-color: #03E676; color: white; border-radius: 15px;'
				href='https://api.whatsapp.com/send?phone=".$da->celular_candidato."&amp;text=Hola ".$da->nombre_candidato."' target='_blank' title='Comienza a Chatear'><i class='fa-brands fa-whatsapp'></i> Chatear</a></td>";
				$tabla .= "<td>".$desc."</td>";
				$tabla .= "<td style='display: none;'>".$da->motivo."</td>";
				$tabla .= "<td>".$da->nombre."</td>";
				$tabla .= "<td>".$da->nombre_sucursal."</td>";
				$tabla .= "<td>".$da->fecha_registro."</td>";				
				$tabla .= "</tr>";

				$cont ++;
			}

		}


		echo json_encode(array("tabla" => $tabla));

	}//termina noPostularonFiltrar

	public function generarCodigoQrReclutador(){

		$request      = service('request');
		$idVacante    = $request->getPost("idVacante");
		$idReclutador = $request->getPost("idReclutador");
		$nombre       = $request->getPost("nombre");

		$datosVacante    = $this->VacantesModel->getDatosVacantes($idVacante);
		$datosReclutador = $this->VacantesModel->getReclutador($idReclutador);

		$codigoVacante = $datosVacante->codigo_vacante;
		$vacante       = $nombre;

		$codigoReclutador = $datosReclutador->codigo_reclutador;

		$url_qr      = base_url()."public/vacante_reclutador_qr/".$codigoVacante.$codigoReclutador.".png";
		$nombreQr    = $codigoVacante.$codigoReclutador.".png";
		$urlCopia    = "";
		$codigoCopia = $codigoVacante.$codigoReclutador;

		if (!file_exists($url_qr)) {

			$cadena = rawurlencode("Da enter para saber de la vacante ".$vacante." ".$codigoVacante.";".$codigoReclutador);

			$urlCopia = 'https://api.whatsapp.com/send?phone=5215598160206&text='.$cadena;
	
			$this->ciqrcode 	= new Ciqrcode();
			$params['data']     = $urlCopia;
			$params['level']    = 'H';
			$params['size']     = 10;
			$params['savename'] = FCPATH.'public/vacante_reclutador_qr/'.$codigoVacante.$codigoReclutador.'.png';
			$this->ciqrcode->generate($params);

		}

		$update_vr 			 = array();
		$update_vr["url_qr"] = $url_qr;

		$this->VacantesModel->updateVacanteReclutador($idVacante, $idReclutador, $update_vr);

		echo json_encode(array("url_qr" => $url_qr, "nombreQr" => $codigoCopia, "urlCopia" => $urlCopia));
		
	}//termina generarCodigoQrReclutador

	public function desactivarVacante(){

		$request    = service('request');
		$id_vacante = $request->getPost("id_vacante");
		$estatus    = $request->getPost("estatus");

		$respuesta = 500;
		$mensaje   = "Ocurrió un error, por favor vuelve a intentarlo.";

		$update_v            = array();
		$update_v["estatus"] = $estatus;

		if($this->VacantesModel->actualizarVacante($id_vacante, $update_v)){
			$respuesta = 200;
			$mensaje   = "Vacante desactivada con éxito.";
		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));
		
	}//termina desactivarVacante

	public function activarVacante(){

		$request    = service('request');
		$id_vacante = $request->getPost("id_vacante");
		$estatus    = $request->getPost("estatus");
		$nombre     = $request->getPost("nombre");

		$respuesta = 500;
		$mensaje   = "Ocurrió un error, por favor vuelve a intentarlo.";

		$update_v            = array();
		$update_v["estatus"] = $estatus;

		if($this->VacantesModel->actualizarVacante($id_vacante, $update_v)){
			$respuesta = 200;
			$mensaje   = "Vacante activada con éxito.";
		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));
		
	}//termina activarVacante

	public function generarCodigoQr(){

		$request   = service('request');
		$idVacante = $request->getPost("idVacante");
		$nombre    = $request->getPost("nombre");

		$datosVacante = $this->VacantesModel->getDatosVacantes($idVacante);

		$codigoVacante = $datosVacante->codigo_vacante;
		$vacante       = $nombre;

		$url_qr   = base_url()."public/vacantes_qr/".$codigoVacante.".png";
		$nombreQr = $vacante.".png";
		$urlCopia = "";

		if (!file_exists($url_qr)) {

			$cadena = rawurlencode("Da enter para saber de la vacante ".$vacante." ".$codigoVacante);

			$urlCopia = 'https://api.whatsapp.com/send?phone=5215598160206&text='.$cadena;
	
			$this->ciqrcode     = new Ciqrcode();
			$params['data']     = $urlCopia;
			$params['level']    = 'H';
			$params['size']     = 10;
			$params['savename'] = FCPATH.'public/vacantes_qr/'.$codigoVacante.'.png';
			$this->ciqrcode->generate($params);

		}

		$vacanteUpdate 			 = array();
		$vacanteUpdate["url_qr"] = $url_qr;

		$this->VacantesModel->actualizarVacante($idVacante, $vacanteUpdate);

		echo json_encode(array("url_qr" => $url_qr, "nombreQr" => $codigoVacante, "urlCopia" => $urlCopia));
		
	}//termina generarCodigoQr

	public function eliminar_acentos($cadena){
		
		//Reemplazamos la A y a
		$cadena = str_replace(
		array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
		array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
		$cadena
		);

		//Reemplazamos la E y e
		$cadena = str_replace(
		array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
		array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
		$cadena );

		//Reemplazamos la I y i
		$cadena = str_replace(
		array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
		array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
		$cadena );

		//Reemplazamos la O y o
		$cadena = str_replace(
		array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
		array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
		$cadena );

		//Reemplazamos la U y u
		$cadena = str_replace(
		array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
		array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
		$cadena );

		//Reemplazamos la N, n, C y c
		$cadena = str_replace(
		array('Ñ', 'ñ', 'Ç', 'ç'),
		array('N', 'n', 'C', 'c'),
		$cadena
		);
		
		return $cadena;
	}//termina eliminar_acentos

	public function acortarUrl(){

		$request 	  = service('request');
		$copyText	  = $request->getPost("copyText");

		$url = $this->shortLink($copyText);

		$urlNueva = $url->data->tiny_url;

		echo json_encode(array("url" => $urlNueva));

	}//termina acortarUrl

	public function shortLink($url){

		// Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
		$ch = curl_init();

		//$url = "http://localhost:8080/validate?token-ieUcc1D3n0Ee6iKONP_&id-2084";

		$arreglo = array("url" => $url, "domain" => "tinyurl.com", "description" => "string");
		$json    = json_encode($arreglo);


		curl_setopt($ch, CURLOPT_URL, 'https://api.tinyurl.com/create?api_token=l7HtMsSrQhFmt6burf3YcUUHQIFju9I1xmwFY5aR4YxUjvpTNRB5BDAr0Tcp');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

		$headers = array();
		$headers[] = 'Accept: application/json';
		$headers[] = 'Content-Type: application/json';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);

		$decode = json_decode($result);

		//die(var_dump($decode));

		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		return $decode;
	}

	public function generarExcelPostulaciones() {

		$request     = service('request');
		$idV_encoded = $request->getGet("idV");

		if (!$idV_encoded) {
			return redirect()->to('/vacantes');
		}

		$idVacante = base64_decode($idV_encoded, true);  // true evita errores silenciosos

		  // Verifica si el resultado es válido y numérico
		if ($idVacante === false || !ctype_digit($idVacante)) {
			return redirect()->to('/vacantes');
		}

		  // Ya puedes usar $idVacante como entero seguro
		$idVacante = intval($idVacante);

		$vacante       = $this->VacantesModel->getDatosVacantes($idVacante);
		$postulaciones = $this->VacantesModel->getPostuladosVacante($idVacante);

		if(!is_null($vacante)){

			// Cargar tu librería personalizada
			$excel    = new Excel();
			$contador = 1;

			$excel->getActiveSheet()->setTitle('Postulaciones');

			$styleTitulos	= array(
				'font' => array(
					'bold'  => true,
					'color' => array('rgb' => 'FFFFFF'),
					'size'  => 11,
				),
				'borders' => array(
					'allborders' => array(
							'style' => \PHPExcel_Style_Border::BORDER_THIN
					)
				),
				'alignment' => array(
					'vertical'   => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				),
				'fill' => array(
					'type'  => \PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '0C1138')
				)
			);

			$styleTitulosSecundarios	= array(
				'font' => array(
					'bold'  => true,
					'color' => array('rgb' => 'FFFFFF'),
					'size'  => 11,
				),
				'borders' => array(
					'allborders' => array(
							'style' => \PHPExcel_Style_Border::BORDER_THIN
					)
				),
				'alignment' => array(
					'vertical'   => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				),
				'fill' => array(
					'type'  => \PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => '96a3ae')
				)
			);

			$styleContenido	= array(
				'font' => array(
					'size' => 11,
				),
				'borders' => array(
					'allborders' => array(
							'style' => \PHPExcel_Style_Border::BORDER_THIN
					)
				),
				'alignment' => array(
					'vertical'   => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				)
			);

			$styleContenidoNoViable	= array(
				'font' => array(
					'color' => array('rgb' => 'FFFFFF'),
					'size'  => 11,
				),
				'borders' => array(
					'allborders' => array(
							'style' => \PHPExcel_Style_Border::BORDER_THIN
					)
				),
				'alignment' => array(
					'vertical'   => \PHPExcel_Style_Alignment::VERTICAL_CENTER,
					'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				),
				'fill' => array(
					'type'  => \PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => 'db343b')
				)
			);

			// TITULO
			$excel->getActiveSheet()->mergeCells("A{$contador}:E{$contador}");
			$excel->getActiveSheet()->setCellValue("A{$contador}", "POSTULACIONES - ".strtoupper($vacante->nombre));
			$excel->getActiveSheet()->getStyle("A{$contador}:E{$contador}")->applyFromArray($styleTitulos);

			$contador++;

			// TITULOS
			$excel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
	        $excel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
	        $excel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
	        $excel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
	        $excel->getActiveSheet()->getColumnDimension('E')->setWidth(30);

			$excel->getActiveSheet()->getStyle("A{$contador}")->getFont()->setBold(true);
	        $excel->getActiveSheet()->getStyle("B{$contador}")->getFont()->setBold(true);
	        $excel->getActiveSheet()->getStyle("C{$contador}")->getFont()->setBold(true);
	        $excel->getActiveSheet()->getStyle("D{$contador}")->getFont()->setBold(true);
	        $excel->getActiveSheet()->getStyle("E{$contador}")->getFont()->setBold(true);

	        $excel->getActiveSheet()->setCellValue("A{$contador}", '#');
	        $excel->getActiveSheet()->setCellValue("B{$contador}", 'Candidato');
	        $excel->getActiveSheet()->setCellValue("C{$contador}", 'Celular');
	        $excel->getActiveSheet()->setCellValue("D{$contador}", 'Fecha de postulación');
	        $excel->getActiveSheet()->setCellValue("E{$contador}", '¿Es viable?');

			$excel->getActiveSheet()->getStyle("A{$contador}:E{$contador}")->applyFromArray($styleTitulosSecundarios);

			$contador++;

			$contador_postulaciones = 1;

			foreach ($postulaciones as $v) {
				
				$id_candidato      = $v->id_candidato;
				$nombre_candidato  = $v->nombre_candidato;
				$celular_candidato = $v->celular_candidato;
				$fecha_postulacion = $v->fecha_postulacion;

				if ($v->es_viable == 1) {
					$viable = "Viable";
				}else{
					$viable = "No viable";
				}

				$excel->getActiveSheet()->setCellValue("A{$contador}", ''.$contador_postulaciones.'');
				$excel->getActiveSheet()->setCellValue("B{$contador}", ''.$nombre_candidato.'');
				$excel->getActiveSheet()->setCellValueExplicit("C{$contador}", $celular_candidato, \PHPExcel_Cell_DataType::TYPE_STRING);
				$excel->getActiveSheet()->setCellValue("D{$contador}", ''.$fecha_postulacion.'');

				$excel->getActiveSheet()->getStyle("A{$contador}:D{$contador}")->applyFromArray($styleContenido);

				if($v->es_viable == 1){
					$excel->getActiveSheet()->setCellValue("E{$contador}", ''.$viable.'');
					$excel->getActiveSheet()->getStyle("E{$contador}")->applyFromArray($styleContenido);
				}else {
					$excel->getActiveSheet()->setCellValue("E{$contador}", ''.$viable.'');
					$excel->getActiveSheet()->getStyle("E{$contador}")->applyFromArray($styleContenidoNoViable);
				}

				$letraInicialPreguntas = "F";
				$preguntas_respuestas  = $this->VacantesModel->getPreguntasRespuestasCandidato($idVacante, $id_candidato);

				if(!is_null($preguntas_respuestas)){

					$total = count($preguntas_respuestas);
					$index = 0;

					foreach ($preguntas_respuestas as $p) {

						$index++;
						
						$excel->getActiveSheet()->setCellValue("".$letraInicialPreguntas."".$contador."", $p->pregunta);
						$excel->getActiveSheet()->getStyle("".$letraInicialPreguntas."".$contador."")->applyFromArray($styleContenido);

						$contador++;

						if($p->descarte == "SI"){

							$excel->getActiveSheet()->setCellValue("".$letraInicialPreguntas."".$contador."", $p->respuesta);
							$excel->getActiveSheet()->getStyle("".$letraInicialPreguntas."".$contador."")->applyFromArray($styleContenidoNoViable);

						}else {

							$excel->getActiveSheet()->setCellValue("".$letraInicialPreguntas."".$contador."", $p->respuesta);
							$excel->getActiveSheet()->getStyle("".$letraInicialPreguntas."".$contador."")->applyFromArray($styleContenido);

						}

						$contador--;

						$letraInicialPreguntas++;

						if ($index === $total) {//última vuelta al ciclo, reseteamos variable para pegar nuevos registros
							$letraInicialPreguntas = "F";
						}

					}

				}

				$contador = $contador + 2;
				$contador_postulaciones++;

				// echo $nombre_candidato." - ".$celular_candidato." - ".$fecha_postulacion." - ".$viable."<br>";

			}

			// Asume que $excel es una instancia de PHPExcel correctamente construida
			$nombre_archivo = "Postulaciones.xlsx";

			// Limpia salida previa (muy importante)
			if (ob_get_length()) ob_end_clean();

			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment; filename="' . $nombre_archivo . '"');
			header('Cache-Control: max-age=0');

			// Crear el writer y forzar descarga
			$writer = \PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
			$writer->save('php://output');
			exit;

		}else {

			return redirect()->to('/vacantes');

		}

	}//termina generarExcelPostulaciones

}
