<?php

namespace App\Controllers;

use App\Models\CronPostulacionModel;

class Cron_postulacion_incompleta extends BaseController
{

    private $CronPostulacionModel;

    public function __construct(){
        
        $this->CronPostulacionModel = new CronPostulacionModel();

    }//termina __construct

    public function index(){

        $datos = $this->CronPostulacionModel->getPostulacionIncompletas();

        if(!is_null($datos)){

            foreach ($datos as $v) {
                
                $celular = $v->celular;

                $message = "¿Continuamos con tu postulación? ¡Solo quedan algunas preguntas!";
                $this->mensaje_bot($message,$celular);

                $update_pre                 		= array();
                $update_pre["postulacion_completa"]	= 1;
                $update_pre["cron_postulacion"]		= 1;
                $this->CronPostulacionModel->updatePregunta($celular, $update_pre);

            }//foreach

        }//datos

    }  //termina index

    public function mensaje_bot($message,$numero){
	
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
			'channel' => 'whatsapp',
			'source' => '5216866810985',
			'destination' => ''.$numero.'',
			'src.name' => 'alarmexreclutamiento',
			'message' => json_encode(array('type' => 'text', 'text' => $message))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		$message = nl2br($message);

		$this->insertConversacionFirestore(0, NULL, $numero, $message, 2, 0);

	}//termina mensaje_bot

    public function insertConversacionFirestore($estatus, $url, $cel, $mensaje, $tipo, $type_file){

		date_default_timezone_set('America/Mexico_City');
		$fecha_hoy  = date("Y-m-d H:i:s");

		$curl 		= curl_init();

		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://firestore.googleapis.com/v1/projects/alarmex-reclutamiento/databases/(default)/documents/conversacion?key=AIzaSyDwVCQ1MAw4rbcVeWElHMnT4ykOWuDXGGI',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS =>'{"fields":
			{ 
			"estatus": {"integerValue" : '.$estatus.'},
			"fecha": {"stringValue" :"'.$fecha_hoy.'"},
			"fecha_msj": {"stringValue" :"'.$fecha_hoy.'"},
			"file_img": {"stringValue" :"'.$url.'"},
			"cel": {"stringValue" :"'.$cel.'"},
			"mensaje": {"stringValue" :"'.$mensaje.'"},
			"tipo": {"integerValue" : '.$tipo.'},
			"type_file": {"integerValue" : '.$type_file.'},
			"id_ticket": {"integerValue" : 0}
			}
		}

		',
		CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		),
		));

		$response = curl_exec($curl);

		curl_close($curl);

	}//termina insertConversacionFirestore

}
