<?php

namespace App\Models;
use CodeIgniter\Model;

class CandidatosModel extends Model{

    protected $table = 'candidatos';

  public function getCandidatos(){

    $query = $this->query("SELECT vc.*, r.nombre_reclutador, v.nombre, c.nombre_candidato,c.celular_candidato,
    c.fecha_nacimiento,c.escolaridad, c.cv_candidato,cl.nombre_cliente FROM vacante_candidato_reclutador vc
    INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
    INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
    LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
    LEFT JOIN clientes cl ON v.id_cliente=cl.id_cliente
    GROUP BY c.id_candidato
    ORDER BY vc.fecha_postulacion DESC LIMIT 500;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

	}//termina getCandidatos

  public function getFiltroCandidatos($inicio, $fin){

    $query = $this->query("SELECT vc.*, r.nombre_reclutador, v.nombre, c.nombre_candidato,c.celular_candidato,
    c.fecha_nacimiento,c.escolaridad, c.cv_candidato,cl.nombre_cliente FROM vacante_candidato_reclutador vc
    INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
    INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
    LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
    LEFT JOIN clientes cl ON v.id_cliente=cl.id_cliente
    WHERE DATE(vc.fecha_postulacion) BETWEEN '$inicio' AND '$fin'
    GROUP BY c.id_candidato
    ORDER BY vc.fecha_postulacion DESC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina getFiltroCandidatos

  public function getCandidatosSinResponder(){

    $query = $this->query("SELECT * FROM candidatos c WHERE c.id_candidato NOT IN (SELECT vc.id_candidato FROM vacante_candidato_reclutador vc)
    ORDER BY c.id_candidato DESC LIMIT 500;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina getCandidatosSinResponder

  public function getFiltroCandidatosSinResponder($inicio, $fin){

    $query = $this->query("SELECT * FROM candidatos c WHERE c.id_candidato NOT IN (SELECT vc.id_candidato FROM vacante_candidato_reclutador vc)
    AND DATE(c.fecha_registro) BETWEEN '$inicio' AND '$fin'
    ORDER BY c.id_candidato DESC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina getFiltroCandidatosSinResponder

  public function getCandidatosReclutador($idUsuario){

    $query = $this->query("SELECT vc.*, r.nombre_reclutador, v.nombre, c.nombre_candidato,c.celular_candidato,
    c.fecha_nacimiento,c.escolaridad, c.cv_candidato,cl.nombre_cliente FROM vacante_candidato_reclutador vc
    INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
    INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
    LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
    LEFT JOIN clientes cl ON v.id_cliente=cl.id_cliente
    WHERE vc.id_vacante IN (
      SELECT id_vacante 
      FROM vacante_reclutador vr
      INNER JOIN reclutadores r ON vr.id_reclutador = r.id_reclutador
      INNER JOIN usuarios u ON r.id_usuario = u.id_usuario AND vr.id_vacante = v.id_vacante
      WHERE u.id_usuario = ?
    )
    ORDER BY vc.fecha_postulacion DESC LIMIT 500", array($idUsuario));

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina getCandidatosReclutador

  public function getFiltroCandidatosReclutador($inicio, $fin, $idUsuario){

    $query = $this->query("SELECT vc.*, r.nombre_reclutador, v.nombre, c.nombre_candidato,c.celular_candidato,
    c.fecha_nacimiento,c.escolaridad, c.cv_candidato,cl.nombre_cliente FROM vacante_candidato_reclutador vc
    INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
    INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
    LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
    LEFT JOIN clientes cl ON v.id_cliente=cl.id_cliente
    WHERE vc.id_vacante IN (
      SELECT id_vacante 
      FROM vacante_reclutador vr
      INNER JOIN reclutadores r ON vr.id_reclutador = r.id_reclutador
      INNER JOIN usuarios u ON r.id_usuario = u.id_usuario AND vr.id_vacante = v.id_vacante
      WHERE u.id_usuario = '$idUsuario'
    )
    AND DATE(vc.fecha_postulacion) BETWEEN '$inicio' AND '$fin'
    ORDER BY vc.fecha_postulacion DESC LIMIT 500;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina getFiltroCandidatosReclutador

  public function postulacionesCandidato($idCandidato){

    $query = $this->query("SELECT * FROM vacante_candidato_reclutador vc INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
        LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
        WHERE vc.id_candidato='$idCandidato' ORDER BY vc.id_vacante_candidato_reclutador ASC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina postulacionesCandidato

  public function postulacionesCandidatoReclutador($idCandidato, $idUsuario){

    $query = $this->query("SELECT * FROM vacante_candidato_reclutador vc INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
        LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
        WHERE vc.id_candidato='$idCandidato' AND (vc.id_reclutador=(SELECT id_reclutador FROM reclutadores 
        WHERE id_usuario='$idUsuario') OR vc.id_reclutador IS NULL)
        ORDER BY vc.id_vacante_candidato_reclutador ASC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina postulacionesCandidatoReclutador

  public function datosCandidato($idCandidato){

    $query = $this->query("SELECT * FROM candidatos WHERE id_candidato='$idCandidato';");

		return($query->getNumRows() <= 0) ? null: $query->getRow();

  }//termina datosCandidato

  public function getPreguntasVacante($idVacante){

    $query = $this->query("SELECT * FROM pregunta_vacante pv WHERE pv.id_vacante='$idVacante' AND pv.estatus=1 ORDER BY pv.id_pregunta_vacante ASC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina getPreguntasVacante

  public function opcionesMultiples($idPreguntaVacante){

    $query = $this->query("SELECT * FROM opciones_multiples op WHERE op.id_pregunta_vacante='$idPreguntaVacante' ORDER BY op.id_opcion_multiple ASC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

  }//termina opcionesMultiples

  public function respuestaCandidato($idPreguntaVacante, $idCandidato){

    $query = $this->query("SELECT * FROM respuesta_vacante WHERE id_pregunta_vacante='$idPreguntaVacante' AND id_candidato='$idCandidato';");

		return($query->getNumRows() <= 0) ? null: $query->getRow();

  }//termina respuestaCandidato

}