<?php

namespace App\Models;
use CodeIgniter\Model;

class ChatbotModel extends Model{

	protected $table = 'pregunta';
    
    public function getPregunta($cel){

		if (!empty($cel)) {

			$sql   = "SELECT * FROM pregunta WHERE celular = '".$cel."';";
			$query = $this->query($sql);

          	// return($query->getNumRows() <= 0) ? null: $query->getResult();
        	return($query->getNumRows() <= 0) ? null: $query->getRow();
		}

    }//termina getPregunta

	public function getOpcionesMenu($id_menu){

		$sql  = "SELECT * FROM menu m 
		INNER JOIN opcion_menu o ON o.id_menu = m.id_menu 
		WHERE m.id_menu = ".$id_menu."
		AND o.estatus = 1
		ORDER BY o.orden ASC;";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getOpcionesMenu

	public function getCandidatoByCel($cel){

		$sql  = "SELECT * FROM candidatos c WHERE c.celular_candidato = '".$cel."';";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getCandidatoByCel

	public function getCiudades(){

		$sql  = "SELECT * FROM ciudades c WHERE c.estatus = 1;";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getCiudades

	public function getCategorias(){

		$sql  = "SELECT * FROM categorias c WHERE c.estatus = 1;";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getCategorias

	public function getSucursales(){

		$sql  = "SELECT * FROM sucursales s 
		WHERE s.estatus_sucursal = 1
		ORDER BY s.nombre_sucursal ASC;";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getSucursales

	public function getVacantesByCiudadCategoria($id_ciudad, $id_categoria){

		$sql  = "SELECT * FROM vacantes v WHERE v.id_ciudad = ".$id_ciudad." AND v.id_categoria = ".$id_categoria." AND v.estatus = 1";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getVacantesByCiudadCategoria


	public function getVacantesByCategoria($id_categoria){

		$sql  = "SELECT * FROM vacantes v WHERE v.id_categoria = ".$id_categoria." AND v.estatus = 1";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getVacantesByCategoria

	public function getVacantesBySucursal($id_sucursal){

		$sql  = "SELECT * FROM vacantes v WHERE v.id_sucursal = ".$id_sucursal." AND v.estatus = 1";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getVacantesBySucursal

	public function getVacantesBySucursalCategoria($id_sucursal, $id_categoria){

		$sql  = "SELECT * FROM vacantes v 
		WHERE v.id_sucursal = ?
		AND v.id_categoria = ?
		AND v.estatus = 1";
		$query = $this->query($sql, [$id_sucursal, $id_categoria]);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getVacantesBySucursalCategoria

	public function getCountPreguntas($id_vacante){

		$sql  = "SELECT COUNT(pv.id_pregunta_vacante) AS tot
		FROM pregunta_vacante pv
		WHERE pv.id_vacante = ".$id_vacante." AND pv.estatus = 1;";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getCountPreguntas

	public function getPreguntaVacanteLimit($id_vacante, $limit){

		$sql  = "SELECT * FROM pregunta_vacante pv
		WHERE pv.id_vacante = ".$id_vacante." AND pv.estatus = 1
		ORDER BY pv.id_pregunta_vacante ASC LIMIT ".$limit.",1;";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getPreguntaVacanteLimit

	public function getOpcionesMultiple($id_pregunta){

		$sql  = "SELECT * FROM opciones_multiples om
		WHERE om.id_pregunta_vacante = ".$id_pregunta."
		ORDER BY om.id_opcion_multiple ASC;";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getOpcionesMultiple

	public function getRespuestaCandidato($id_pregunta_vacante, $id_candidato){

		$sql  = "SELECT * FROM respuesta_vacante rv
		WHERE rv.id_candidato = ".$id_candidato."
		AND rv.id_pregunta_vacante = ".$id_pregunta_vacante.";";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getRespuestaCandidato

	public function getVacanteById($id_vacante){

		$sql  = "SELECT * FROM vacantes v
		WHERE v.id_vacante = ".$id_vacante.";";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getVacanteById

	public function getVacanteReclutadorByCodigos($codigo_vacante, $codigo_reclutador){

		$sql  = "SELECT v.id_vacante, v.id_categoria, r.id_reclutador, v.nombre, v.descripcion, r.estatus_reclutador
		FROM vacante_reclutador vr
		INNER JOIN vacantes v ON v.id_vacante = vr.id_vacante
		INNER JOIN reclutadores r ON r.id_reclutador = vr.id_reclutador
		WHERE v.codigo_vacante = '".$codigo_vacante."'
		AND r.codigo_reclutador = '".$codigo_reclutador."'
		AND v.estatus = 1;";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getVacanteReclutadorByCodigos

	public function validarPostulacionById($id_vacante, $id_candidato){

		$sql  = "SELECT * FROM vacante_candidato_reclutador vcr
		WHERE vcr.id_vacante = ".$id_vacante." AND vcr.id_candidato = ".$id_candidato.";";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina validarPostulacionById

	public function validarPostulacionByCodigo($codigo, $id_candidato){

		$sql  = "SELECT v.*
		FROM vacantes v
		WHERE v.estatus = 1 AND v.codigo_vacante = '".$codigo."' AND v.id_vacante NOT IN 
		(
			SELECT vcr.id_vacante FROM vacante_candidato_reclutador vcr
			WHERE vcr.id_vacante = v.id_vacante 
			AND vcr.id_candidato = ".$id_candidato."
		);";
		
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina validarPostulacionByCodigo

	public function getDatosCandidatoVacante($id_candidato, $id_vacante){

		$sql  = "SELECT v.nombre, c.nombre_candidato, c.fecha_nacimiento, c.escolaridad,
		vcr.fecha_postulacion, IF(vcr.es_viable = 2, 'NO', 'SI') AS es_viable,
		u.correo, c.celular_candidato, r.nombre_reclutador
		FROM vacante_candidato_reclutador vcr
		INNER JOIN vacantes v ON v.id_vacante = vcr.id_vacante
		INNER JOIN candidatos c ON c.id_candidato = vcr.id_candidato
		LEFT JOIN reclutadores r ON r.id_reclutador = vcr.id_reclutador
		LEFT JOIN usuarios u ON u.id_usuario = r.id_usuario
		WHERE vcr.id_vacante = ".$id_vacante." AND vcr.id_candidato = ".$id_candidato.";";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getDatosCandidatoVacante

	public function getPreguntasRespuestasPostulacion($id_candidato, $id_vacante){

		$sql  = "SELECT pv.pregunta, rv.respuesta
		FROM respuesta_vacante rv
		INNER JOIN pregunta_vacante pv ON pv.id_pregunta_vacante = rv.id_pregunta_vacante
		WHERE pv.id_vacante = ".$id_vacante." AND rv.id_candidato = ".$id_candidato."
		ORDER BY pv.id_pregunta_vacante ASC;";
		$query = $this->query($sql);

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getPreguntasRespuestasPostulacion

	public function getVacanteByCodigo($codigo_vacante){

		$query = $this->query("SELECT v.*, s.nombre_sucursal, c.categoria
		FROM vacantes v
		INNER JOIN sucursales s ON s.id_sucursal = v.id_sucursal
		INNER JOIN categorias c ON c.id_categoria = v.id_categoria
		WHERE v.codigo_vacante = ? AND v.estatus = 1", array($codigo_vacante));

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getVacanteByCodigo

	public function getUsuarioByReclutador($id_reclutador){

		$query = $this->query("SELECT * FROM reclutadores r WHERE r.id_reclutador = ".$id_reclutador.";");

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getUsuarioByReclutador

	public function getReclutadoresVacante($id_vacante){

		$query = $this->query("SELECT u.usuario, u.correo
		FROM vacante_reclutador vr
		INNER JOIN reclutadores r ON r.id_reclutador = vr.id_reclutador
		INNER JOIN usuarios u ON u.id_usuario = r.id_usuario
		WHERE vr.id_vacante = ? AND u.estatus = 1 AND r.estatus_reclutador = 1", array($id_vacante));

		return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getReclutadoresVacante

	public function existeTicket($celular){

		$query = $this->query("SELECT * FROM ticket t WHERE t.celular = ? AND t.estatus <> 2", array($celular));

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina existeTicket

	public function existePostulacion($id_candidato, $id_vacante){

		$query = $this->query("SELECT * FROM vacante_candidato_reclutador vcr 
		WHERE vcr.id_vacante = ? AND vcr.id_candidato = ?", array($id_vacante, $id_candidato));

		return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina existePostulacion
	
    // ========== UPDATES ==========

	public function updatePregunta($cel,$datos){

		$quert = $this->db->table('pregunta');
        $quert->where('celular', $cel);
        $quert->update($datos);
        return true;

	}//updatePregunta

	public function updateCandidato($id_candidato, $datos){

		$quert = $this->db->table('candidatos');
        $quert->where('id_candidato', $id_candidato);
        $quert->update($datos);
        return true;

	}//updateCandidato

	public function updateRespuestaVacante($id_pregunta_vacante, $id_candidato, $datos){

		$quert = $this->db->table('respuesta_vacante');
        $quert->where('id_pregunta_vacante', $id_pregunta_vacante);
        $quert->where('id_candidato', $id_candidato);
        $quert->update($datos);
        return true;

	}//updateRespuestaVacante

	public function updateVacante($id_vacante,$datos){

		$quert = $this->db->table('vacantes');
        $quert->where('id_vacante', $id_vacante);
        $quert->update($datos);
        return true;

	}//updateVacante


	// ========== INSERTS ==========

	public function insertPregunta($datos){

		$quert = $this->db->table('pregunta');
        $quert->insert($datos);
        return $this->db->insertID();
		
	}  //insertPregunta

	public function insertCandidato($datos){

		$quert = $this->db->table('candidatos');
        $quert->insert($datos);
        return $this->db->insertID();
		
	}  //insertCandidato

	public function insertNoContinuoProceso($datos){

		$quert = $this->db->table('no_continuo_proceso');
        $quert->insert($datos);
        return $this->db->insertID();
		
	}  //insertNoContinuoProceso

	public function insertRespuestaVacante($datos){

		$quert = $this->db->table('respuesta_vacante');
        $quert->insert($datos);
        return $this->db->insertID();
		
	}//insertRespuestaVacante

	public function insertVacanteCandidatoReclutador($datos){

		$quert = $this->db->table('vacante_candidato_reclutador');
        $quert->insert($datos);
        return $this->db->insertID();
		
	}//insertVacanteCandidatoReclutador

	public function insertTicket($datos){

		$quert = $this->db->table('ticket');
        $quert->insert($datos);
        return $this->db->insertID();
		
	}//insertTicket

}//termina clase