<?php 

    $session 	= session();
    $tipo 		= $session->get('id_tipo_usuario');
    $idUsuario	= $session->get('id_usuario');

?>

<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-9">
        <h1 class="page-header"><i class="fa-solid fa-chart-simple fa-xl"></i> Métricas</h1>
    </div>

    <div class="print-wrap page1">
        <div class="row">

            <div class="col-md-4">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>
                            Filtrar por fechas:
                        </label>
                        <input type="text" name="dates" id="rango" class="form-control" />
                    </div>
                </div>
            </div>

            <div class="col-md-8" style="margin-top: 2em;">
                <button class="imprimir btn" style="background-color: #1d70b6; color: white;"><i class="fa-solid fa-file-export"></i> Exportar</button>
            </div>

            <div class="col-md-12" style="margin-top: 2em;">

                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" >Candidatos | <label>Total: <span id="total_candidatos">0</span></label></div>
                        <div class="panel-body">
                            <div id="grafica_candidatos"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" ><strong>Top 5:</strong> Vacantes con más postulaciones</div>
                        <div class="panel-body">
                            <div id="grafica_top5"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" >Postulaciones | <label>Total: <span id="total_postulaciones">0</span></label></div>
                        <div class="panel-body">
                            <div id="grafica_postulaciones"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" >Candidatos que decidieron no continuar | <label>Total: <span id="total_candidatos_no">0</span></label></div>
                        <div class="panel-body">
                            <div id="grafica_candidatos_no"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="print-wrap page2">
        <div class="row">
            <div class="col-md-12">

            
                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" >Candidatos - <label>Viables | No viables </label></div>
                        <div class="panel-body">
                            <div id="grafica_candidatos_vnv"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" >Tickets - <label>Creados | Tomados | Cerrados </label></div>
                        <div class="panel-body">
                            <div id="grafica_tickets"></div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="panel panel-default alto">
                        <div class="panel-heading" style="text-align: center;" >Tickets atendidos por usuario</div>
                        <div class="panel-body">
                            <div id="grafica_atendidos"></div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</div>

<style type="text/css">
    .alto{
        height: 465px;
    }

    .highcharts-subtitle{
        font-size: 1.3em !important;
    }

</style>

<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.5.3/jspdf.min.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
<script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/drilldown.js"></script>


    <script type="text/javascript">
    jQuery(document).ready(function($){ 

		$(document).on('click', '.imprimir', function(){
            $("#carga").show();
            $(this).attr('disabled', true);
            setTimeout(function() { 
			 generatePDF();
            }, 1000);
		});

    var pdf,page_section,HTML_Width,HTML_Height,top_left_margin,PDF_Width,PDF_Height,canvas_image_width,canvas_image_height;
    
    
    
    function calculatePDF_height_width(selector,index){
        page_section        = $(selector).eq(index);
        HTML_Width          = page_section.width();
        HTML_Height         = page_section.height();
        top_left_margin     = 15;
        PDF_Width           = HTML_Width + (top_left_margin * 2);
        PDF_Height          = (PDF_Width * 1) + (top_left_margin * 2);
        canvas_image_width  = HTML_Width;
        canvas_image_height = HTML_Height;
    }

    //Generate PDF
    function generatePDF() {

        pdf = "";
        html2canvas($(".print-wrap:eq(0)")[0], { allowTaint: true }).then(function(canvas) {

            calculatePDF_height_width(".print-wrap",0);
            canvas.getContext('2d');
            var imgData = canvas.toDataURL("image/jpeg", 1.0);

            pdf = new jsPDF('p', 'pt', [PDF_Width, PDF_Height]);
            pdf.addImage(imgData, 'JPG', top_left_margin, top_left_margin, HTML_Width, HTML_Height);

        });

        html2canvas($(".print-wrap:eq(1)")[0], { allowTaint: true }).then(function(canvas) {

            calculatePDF_height_width(".print-wrap",1);
            canvas.getContext('2d');
            var imgData = canvas.toDataURL("image/jpeg", 1.0);

            pdf.addPage(PDF_Width, PDF_Height);
            pdf.addImage(imgData, 'JPG', top_left_margin, top_left_margin, HTML_Width, HTML_Height);

            setTimeout(function() {
                pdf.save("Métricas.pdf");
                setTimeout(ocultarLoader, 1000);
                $(".imprimir").attr('disabled', false);
            }, 0);

        });

    };

    $('input[name="dates"]').daterangepicker({
        "locale": {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aceptar",
        "cancelLabel": "Cancelar",
        "fromLabel": "From",
        "toLabel": "To",
        "customRangeLabel": "Custom",
        "daysOfWeek": [
            "Dom",
            "Lun",
            "Mar",
            "Mie",
            "Jue",
            "Vie",
            "Sab"
        ],
        "monthNames": [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre"
        ],
        "firstDay": 1
        }
    });

    $("#rango").on('apply.daterangepicker', function(ev, picker) {
      var inicio = picker.startDate.format('YYYY-MM-DD');
      var fin    = picker.endDate.format('YYYY-MM-DD');
      mostrarLoader();
      filtrar(inicio, fin);

    });

});//termina jQuery

    function filtrar(inicio, fin) {
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/filtrarMetricas",
            type : "POST",
            dataType : "json",
            data :{"inicio" : inicio, "fin" : fin},
            success : function(response){

                $("#total_candidatos").html(response.contCandidatos);

				$('#grafica_candidatos').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b> del total<br/>'
                    },

                    "series": response.candidatos
                    
                });//termina grafica_candidatos

                $('#grafica_top5').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        // text: 'Da click sobre la barra para más detalles'
                        text: ''
                    },
                    accessibility: {
                        announceNewData: {
                            enabled: true
                        }
                    },
                    xAxis: {
                        type: 'category'
                    },
                    yAxis: {
                        title: {
                            text: 'Total'
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                format: '{point.y:,.0f}'
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:,.0f}</b> total<br/>'
                    },

                    series: [
                        {
                            name: "Postulaciones",
                            colorByPoint: true,
                            data: 
                            response.top5
                            
                        }
                    ],
                    drilldown: {

                        drillUpButton: {
                            
                            relativeTo: 'spacingBox',
                            position: {
                                y: 0,
                                x: 0
                            },
                        },


                        series: response.reclutadores
                    }
                });

                $("#total_postulaciones").html(response.contPostulaciones);

                $('#grafica_postulaciones').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b> del total<br/>'
                    },

                    "series": response.postulaciones
                    
                });//termina grafica_postulaciones

                $("#total_candidatos_no").html(response.contCandidatosNo);

                $('#grafica_candidatos_no').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b> del total<br/>'
                    },

                    "series": response.noCandidatos
                    
                });//termina grafica_candidatos_no

                $('#grafica_candidatos_vnv').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b> del total<br/>'
                    },

                    "series": response.candidatosViablesNoViables
                    
                });//termina grafica_candidatos_vnv

                $('#grafica_tickets').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b> del total<br/>'
                    },

                    "series": response.tickets
                    
                });//termina grafica_tickets

                $('#grafica_atendidos').highcharts({
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    subtitle: {
                        text: ''
                    },
                    xAxis: {
                        type: 'category',
                        labels: {
                            rotation: 0,
                            style: {
                                fontSize: '11px',
                                fontFamily: 'Verdana, sans-serif'
                            }
                        }
                    },
                    yAxis: {
                        title: {
                            text: ''
                        }

                    },
                    legend: {
                        enabled: false
                    },
                    plotOptions: {
                        series: {
                            borderWidth: 0,
                            dataLabels: {
                                enabled: true,
                                
                            }
                        }
                    },

                    tooltip: {
                        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
                        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.0f}</b> del total<br/>'
                    },

                    "series": response.ticketsUsuarios
                    
                });//termina grafica_atendidos

                setTimeout(ocultarLoader, 1000);

            }//termina success
        });

    }//termina filtrar

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

    </script>