<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12" style="display: grid; grid-template-columns: 1fr 1fr; margin-top: -1rem;">
        <h1 class="page-header"><i class="fa-solid fa-users"></i> <strong> Usuarios</strong></h1>
        <button type="button" class="btn agregar" style="margin-top: 3.2rem; align-self: center; justify-self: end; background-color: #1d70b6; color: white;">
        <i class="fa-solid fa-user-plus"></i> Agregar nuevo</button>
    </div>

    <div class="col-md-12">
        <br><br>
        <table class="table table-responsive table-striped" id="tabla_usuarios">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Usuario</th>
                    <th>Correo</th>
                    <th>Fecha registro</th>
                    <th>Estatus</th>
                    <th>Tipo</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!is_null($usuarios)) {

                    $cont = 1;
                    foreach ($usuarios as $usuario) {
                        if ($usuario->estatus == 1) {
                            $estatus = "<h4><span class='label label-success'>Activo</span></h4>";
                        }else{
                            $estatus = "<h4><span class='label label-danger'>Inactivo</span></h4>";
                        }

                        ?>

                        <tr>
                            <td><?=$cont; ?></td>
                            <td><?=$usuario->usuario; ?></td>
                            <td><?=$usuario->correo; ?></td>
                            <td><?=$usuario->fecha_registro?></td>
                            <td><?=$estatus; ?></td>
                            <td><?=$usuario->tipo_usuario; ?></td>
                            <td>
                                <button class="update btn" data-id="<?=$usuario->id_usuario; ?>" style="width: 170px; background-color: #db343b; 
                                color: white; margin-bottom: 0.5rem;">
                                    <i class="fa-solid fa-pen-to-square"></i> Actualizar</button><br>
                                <button class="actualizarContra btn" data-id-usu="<?=$usuario->id_usuario;?>" style="width: 170px; background-color: #1d70b6; color: white;">
                                    <i class="fa-solid fa-lock"></i> Actualizar contraseña</button><br>
                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>
        <input type="hidden" id="usuario_id">
    </div>
</div>

<!-- The Modal agregar usuario-->
<div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="modal_agregar" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Agregar usuario</b></h3>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Tipo usuario:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <select id="tipo_usuario" class="form-control" style="cursor: pointer;">
                                <option value="0">--Seleccionar--</option>
                                <?php
                                    if (!is_null($tipo)) {
                                        foreach ($tipo as $t) {?>
                                            <option value="<?=$t->id_tipo_usuario;?>"><?=$t->tipo_usuario;?></option>
                                        <?php
                                        }
                                    }?>
                            </select>
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Usuario:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="text" class="form-control" placeholder="Ingresa el usuario" id="usuario" name="usuario" required="">
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Correo:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="email" class="form-control" placeholder="Ingresa el correo" id="correo" name="correo" required="">
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Contraseña:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                        <input type="text" class="form-control" placeholder="Ingresa la contraseña" id="contrasena" name="contrasena" required="">
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Estatus:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <select class="form-control" id="estatus" style="cursor: pointer;">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>  
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="modal-footer">
                <button class="btn guardar" style="background-color: #db343b; color: white;">
                    <i class="fa-solid fa-floppy-disk"></i>  Guardar</button>
                    <button id="cerrarModal" type="button" class="btn" data-dismiss="modal" style="background-color: #1d70b6; color: white;">
                    <i class="fa-solid fa-xmark"></i> Cerrar</button>
            </div>
        </div>
    </div>
</div>
<!--Termina modal Agregar -->

<!-- The Modal actualizar-->
<div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="modal_editar" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Actualizar usuario</b></h3>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <div id="div_tipo" class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Tipo usuario:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <select id="tipo_usuario_update" class="form-control" required>
                                <option value="0">--Seleccionar--</option>
                                <?php
                                    if (!is_null($tipo)) {
                                        foreach ($tipo as $t) {?>
                                            <option value="<?=$t->id_tipo_usuario?>"> <?=$t->tipo_usuario ?></option>
                                        <?php
                                        }
                                    }?>
                            </select>
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Usuario:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="text" class="form-control" placeholder="Ingresa el usuario" id="usuario_update" name="usuario_update" required="">
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Correo:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="email" class="form-control" placeholder="Ingresa el correo" id="correo_update" name="correo_update" required="">
                        </div>  
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Estatus:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <select class="form-control" id="estatus_update">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>  
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="modal-footer">
                <button type="button" class="btn" data-dismiss="modal" style="background-color: #1d70b6; color: white;">    
                    <i class="fa-solid fa-xmark"></i> Cerrar</button>
                <button class="btn actualizar" style="background-color: #db343b; color: white;">
                    <i class="fa-solid fa-floppy-disk"></i>  Guardar</button>
            </div>
        </div>
    </div>
</div>
<!--Termina modal Editar -->

<div class="modal fade" id="modalContraseña" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Actualizar contraseña</b></h3>
      </div>
      <div class="modal-body">
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Nueva contraseña:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <input type="text" class="form-control" id="contra_nueva" name="contra_nueva" required="">
            </div>       
            <div class="form-group">
                <label for="cveprodep" class="control-label">
                    Confirmar nueva contraseña:
                    <i class="text-danger fa fa-asterisk"> </i> 
                </label>
                <input type="text" class="form-control" id="confirmar" name="confirmar" required="">
            </div>  
        <input type="hidden" id="id_contra" />
      </div>

      <div class="modal-footer">
        <button type="button" class="btn" data-dismiss="modal" style="background-color: #1d70b6; color: white;">    
            <i class="fa-solid fa-xmark"></i> Cerrar</button>
        <button type="button" class="btn" id="aceptar_contra" style="background-color: #db343b; color: white;">
            <i class="fa-solid fa-floppy-disk"></i> Guardar</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script> -->
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> -->
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript">
    jQuery(document).ready(function($){

        ocultarLoader();

        var tabla = $('#tabla_usuarios').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: { 
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    extend: 'excelHtml5', 
                    className : 'btn btn-primary',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                }
            ]
        });

        $("#tabla_usuarios").css("margin-top", "1em");
        $("#tabla_usuarios_info").css("margin-top", "2em");
        $("#tabla_usuarios_paginate").css("margin-top", "2em");
        $("#tabla_usuarios_previous").find( "a" ).html("Anterior");
        $("#tabla_usuarios_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_usuarios_previous").find( "a" ).html("Anterior");
            $("#tabla_usuarios_next").find( "a" ).html("Siguiente");

        });

        $('#cerrarModal').click(function() {

            $("#usuario").val("");
            $("#correo").val("");
            $("#contrasena").val("");
            $("#tipo_usuario").val("0");
        });

        $(document).on('click', '.agregar', function(event) {
            $("#modal_agregar").modal("show");
        });

        $(document).on('click', '.guardar', function(){

            var usuario      = $("#usuario").val().trim();
            var correo       = $("#correo").val().trim();
            var contrasena   = $("#contrasena").val().trim();
            var tipo_usuario = $("#tipo_usuario").val();
            var estatus      = $("#estatus").val();

            if (validar(usuario, correo, contrasena, tipo_usuario)) {
                mostrarLoader();
                addUsuario(usuario, correo, contrasena, estatus, tipo_usuario);            
            }
        });

        $(document).on('click', '.actualizar', function(){

            var usuario      = $("#usuario_update").val().trim();
            var correo       = $("#correo_update").val().trim();
            var tipo_usuario = $("#tipo_usuario_update").val();
            var estatus      = $("#estatus_update").val();

            if (validarUpdate(usuario, correo, tipo_usuario)) {
                mostrarLoader();
                updateUsuario(usuario, correo, tipo_usuario, estatus);
            }
        });

        $(document).on('click', '.update', function(){
        
            $("#usuario_id").val("");

            var id_usuario = $(this).attr('data-id');
        
            $("#usuario_id").val(id_usuario);

            getUsuario(id_usuario);

            $("#modal_editar").modal("show");
        })

        $(document).on('click', '.actualizarContra', function(){

            var id_usuario = $(this).attr("data-id-usu");
            $("#id_contra").val(id_usuario);
            $("#modalContraseña").modal("show");
        });

        $("#aceptar_contra").click(function () {
            if($("#contra_nueva").val() != ""){
                if ($("#contra_nueva").val() == $("#confirmar").val()) {
                    actualizarContraseña();
                }else{
                    swal({
                        icon: 'warning',
                        title: "Las contraseñas no coinciden"
                    });
                }
            }else{
                swal({
                    icon: 'warning',
                    title: "Por favor ingresa la nueva contraseña"
                });
            }
        });

    });//termina jQuery

    function getUsuario(id_usuario) {

        $.ajax({
            url : "<?php echo base_url();?>index.php/getUsuario",
            type : "POST",
            dataType : "json",
            data :{"id_usuario" : id_usuario},
            success : function(result){

                if(result.respuesta == 200){

                    $("#usuario_update").val(result.datos.usuario);
                    $("#correo_update").val(result.datos.correo);
                    $("#tipo_usuario_update").val(result.datos.id_tipo_usuario);
                    $("#estatus_update").val(result.datos.estatus);

                }else{
                    swal({
                        icon: 'info',
                        title: "No se encontraron datos"
                    });
                }
            }
        });
    }//termina getUsuario

    function actualizarContraseña() {

        var id_usuario   = $("#id_contra").val();
        var contra_nueva = $("#contra_nueva").val();
        var confirmar    = $("#confirmar").val();

        $.ajax({
            url : "<?php echo base_url();?>index.php/actualizarPass",
            type : "POST",
            dataType : "json",
            data :{"contra_nueva" : contra_nueva, "confirmar" : confirmar, "id_usuario" : id_usuario},
            success : function(datos){

                if(datos.regreso){
                    swal({
                        title: datos.mensaje,
                        icon: 'success'
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);
                }else{
                    swal({
                        icon: 'error',
                        title: datos.mensaje
                    });
                }
            }
        });
    }//termina actualizar contraseña

    function addUsuario(usuario, correo, contrasena, estatus, tipo_usuario) {
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/agregarUsuario",
            type : "POST",
            dataType : "json",
            data :{"usuario": usuario, "correo": correo, "contrasena" : contrasena, "estatus" : estatus, "tipo_usuario" : tipo_usuario},
            success : function(datos){

                if(datos.regreso == 200){
                    swal({
                        title: datos.mensaje,
                        icon: 'success'
                    });
                    limpiar();
                    setTimeout(function(){
                        location. reload();
                    }, 2500);
                }else if(datos.regreso == 300 || datos.regreso == 400) {

                    swal({
                        icon: 'info',
                        title: datos.mensaje
                    });
                }else{
                    swal({
                        icon: 'error',
                        title: datos.mensaje
                    });
                }

                setTimeout(ocultarLoader, 1000);
            }
        });
    }//termina addUsuario

    function updateUsuario(usuario, correo, tipo_usuario, estatus) {
        
        var id_usuario = $("#usuario_id").val();

        $.ajax({
            url : "<?php echo base_url();?>index.php/actualizarUsuario",
            type : "POST",
            dataType : "json",
            data :{"usuario": usuario, "correo": correo, "id_usuario" : id_usuario, "estatus" : estatus, "tipo_usuario" : tipo_usuario},
            success : function(datos){

                if(datos.regreso == 200){
                    swal({
                        title: datos.mensaje,
                        icon: 'success'
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);
                }else if(datos.regreso == 300 || datos.regreso == 400){

                    swal({
                        icon: 'info',
                        title: datos.mensaje
                    });
                }else{
                    swal({
                        icon: 'error',
                        title: datos.mensaje
                    });
                }
                
                setTimeout(ocultarLoader, 1000);
                
            }
        });

    }//termina updateUsuario

    function limpiar() {

        $("#usuario").val("");
        $("#correo").val("");
        $("#tipo_usuario").val("");
        $("#contrasena").val("");
    }//termina limpiar

    function validar(usuario, correo, contrasena, tipo_usuario) {
        
        var regex               = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;
        var contador_contrasena = $("#contrasena").val().length;
        var regreso             = true;

        if (tipo_usuario == 0 || tipo_usuario == "0") {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor selecciona un tipo de usuario"
            });
        }else if (usuario.length < 2) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa el usuario"
            });
        }else if (regex.test(correo) != true) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa un correo válido"
            });
        }else if (contrasena.length < 3) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa una contraseña mayor a 3 caracteres"
            });
        }

        return regreso;
    }//termina validar

    function validarUpdate(usuario, correo, tipo_usuario) {
        
        var regex               = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;
        var regreso             = true;

        if (tipo_usuario == 0 || tipo_usuario == "0") {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor selecciona un tipo de usuario"
            });
        }else if (usuario.length < 2) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa el usuario"
            });
        }else if (regex.test(correo) != true) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa un correo válido"
            });
        }

        return regreso;
    }//termina validarUpdate

    function soloNumeros(e){   
        var numero = (e.which) ? e.which : e.keyCode;
        var valor  = e.key;

        if (valor=="+" || valor == "-") {
        return false;
        }
        //PUNTO
        else if(numero==46) { 
        return true;
        //CERO
        }else if(numero==8) { 
        return true;
        //DEL 1 AL 9
        } else if(numero>=48 && numero<=57) {
        return true;
        } else{ 
        return false;
        }
    }

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

</script>