<div class="row">

    <?php 

        $session 	= session();
        $tipo 		= $session->get('id_tipo_usuario');
        $idUsuario	= $session->get('id_usuario');
    
    ?>

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 class="page-header"><i class="fa-solid fa-briefcase"></i><strong> Vacantes</strong></h1>
    </div>

    <div class="col-md-12">
        <br>
        <a id="downloadLink" style="display: none;"></a>
        <table class="table table-responsive table-striped" id="tabla_vacantes">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nombre</th>
                    <th>Descripción</th>
                    <th style="display: none;">Descripción</th>
                    <th>Categoría</th>
                    <th>Sucursal</th>
                    <th>Postulados</th>
                    <th style="text-align: center;">Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!is_null($vacantes)) {

                    $cont = 1;
                    foreach ($vacantes as $vacante) {

                        if ($vacante->estatus == 1) {
                            $estatus     = "<h4><span class='label label-success'>Activa</span></h4>";
                            $btn_estatus = '<button class="updateEstatus btn" style="width: 120px; background-color: #db343b; color: white; margin-bottom: 0.5rem;" data-id="'.$vacante->id_vacante.'" data-estatus="0" data-nombre="'.$vacante->nombre.'"><i class="fa fa-arrow-down"></i> Desactivar</button><br>';
                        }else{
                            $estatus     = "<h4><span class='label label-danger'>Inactiva</span></h4>";
                            $btn_estatus = '<button class="updateEstatus btn btn-success" style="width: 120px; margin-bottom: 0.5rem;" data-id="'.$vacante->id_vacante.'" data-estatus="1" data-nombre="'.$vacante->nombre.'"><i class="fa fa-arrow-up"></i> Activar</button><br>';
                        }

                        if (is_null($vacante->descripcion) || $vacante->descripcion == "") {
                            $desc = "N/A";
                        }else {
                            $descripcion = $vacante->descripcion;

                            $descripcion = str_replace('"', '', $descripcion);
                            $descripcion = str_replace('“', '', $descripcion);
                            $descripcion = str_replace("'", '', $descripcion);
    
                            $cont_desc = strlen($descripcion);
                            if($cont_desc > 30){
                                $desc = substr($descripcion,0, 30).'... <a href class="showMensaje"  data-mensaje="'.nl2br($descripcion).'">Ver más</a>'; 
                            }else{
                                $desc = $descripcion;
                            }
                        }

                        $idVacante = base64_encode($vacante->id_vacante);

                        ?>

                        <tr>
                            <td><?=$cont; ?></td>
                            <td><?=$vacante->nombre; ?></td>
                            <td><?=$desc ?></td>
                            <td style="display: none;"><?=$vacante->descripcion; ?></td>
                            <td><?=$vacante->categoria;?></td>
                            <td><?=$vacante->nombre_sucursal?></td>
                            <td style="text-align: center;">
                                <h4><span class="label" style="background-color: #1d70b6; color: white;"><?=$vacante->postulaciones;?></span></h4>
                            </td>
                            <td style="text-align: center;"><?=$estatus; ?></td>
                            <td>
                                <a class="btn" style="width: 120px; background-color: #1d70b6; color: white; margin-bottom: 0.5rem;"
                                href="<?php echo base_url();?>index.php/actualizarVacante?v=<?=$idVacante?>">
                                    <i class="fa-solid fa-pen-to-square"></i> Actualizar</a><br>

                                <button class="verPreguntas btn" data-id="<?=$vacante->id_vacante;?>" style="width: 120px; background-color: #db343b; 
                                color: white; margin-bottom: 0.5rem;">
                                    <i class="fa-solid fa-circle-question"></i> Preguntas</button><br>

                                <a class="btn" style="width: 120px; background-color: #1d70b6; color: white; margin-bottom: 0.5rem;"
                                href="<?php echo base_url();?>index.php/postuladosVacante?v=<?=$idVacante?>">
                                    <i class="fa-solid fa-user-check"></i> Postulados</a><br>

                                <button class="verQR btn" data-id="<?=$vacante->id_vacante; ?>"
                                data-vacante="<?=$vacante->nombre; ?>" style="width: 120px; margin-bottom: 0.5rem; background-color:#809bc4; color:white;">
                                <i class="fa fa-eye"></i> QR</button><br>

                                <?=$btn_estatus?>

                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }
                 } 
                 ?>
                
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade"  tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="mensaje_modal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Descripción:</b></h3>
            </div>
            <div class="modal-body" id="mensaje_body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal preguntas -->
<div class="modal fade" id="preguntasModal" tabindex="-1" role="dialog" aria-labelledby="preguntasModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="preguntasModalLabel" style="color: white; font-weight: bold;">Preguntas</h3>
      </div>
      <div class="modal-body">
        <div class="row">
            <div class="contenedor col-md-12">
              
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn" data-dismiss="modal" style="background-color: #3f5364; color: white;">
        <i class="fa-solid fa-rectangle-xmark"></i> Cerrar
        </button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal_qr" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 style="text-align: center; color: white;" class="modal-title" id="txt_modal_qr">QR</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal-salidas">
                <div class="row">
                    <div class="col-md-12" style="text-align: center">
                        <img id="imgQR" src="" class="img-rounded" alt="IMG1" width="330" height="330" title="IMG1" />
                    </div>
                    <br><br>
                    <div class="col-md-12" style="text-align: center">
                        <label>URL:</label>
                        <br>
                        <a href="https://example.com" id="url" target="_blank"></a>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-success" id="btnCopiar" data-url=""><i class="fa fa-copy"></i> Copiar</button>
                <a href="" download="" id="descargar" class="btn btn-primary"><i class="fa fa-download"></i> Descargar</a>
            </div>
        </div>
    </div>
</div>

<style type="text/css">
    
    .swal-footer {
        text-align: center !important;
    }

    a:hover,a:focus{
    text-decoration: none;
    outline: none;
    }

    #accordion .panel{
        border: none;
        box-shadow: none;
        border-radius: 30px;
        margin-bottom: 15px;
    }
    #accordion .panel-heading{
        padding: 0;
        border-radius: 30px;
    }
    #accordion .panel-title a{
        display: block;
        padding: 12px 20px 12px 50px;
        background: #3f536430;
        font-size: 14px;
        font-weight: 600;
        color: #1d70b6;
        border: none;
        border-radius: 30px;
        position: relative;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed{ color: #3f5364; }
    #accordion .panel-title a:after,
    #accordion .panel-title a.collapsed:after{
        content: "\f107";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        width: 45px;
        height: 45px;
        line-height: 50px;
        border-radius: 50%;
        background: #1d70b6;
        font-size: 25px;
        color: #fff;
        text-align: center;
        position: absolute;
        top: -0.3rem;
        left: 0;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed:after{ content: "\f105"; }
    #accordion .panel-body{
        padding: 20px 0 0 0;
        font-size: 14px;
        color: #3f5364;
        line-height: 25px;
        border-top: none;
        position: relative;
    }
    #accordion .panel-body p{
        padding: 10px 20px 10px;
        margin: 0;
        background: #3f536430;
        border-radius: 15px;
    }


    @media(max-width:1300px){
        .postuladosV {
            margin-top: 0.5rem;
        }
    }

    @media(max-width:750px){
        #divFiltro {
            display: grid;
            grid-template-columns: 1fr 1fr;
        }
    }


</style>

<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script> -->
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> -->
<!-- <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script> -->
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript">
    jQuery(document).ready(function($){

        ocultarLoader();

        var tabla = $('#tabla_vacantes').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: { 
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    extend: 'excelHtml5', 
                    className : 'btn btn-primary',
                    exportOptions: {
                        columns: [0, 1, 3, 4, 5, 6, 7]
                    }
                }
            ]
        });

        $("#tabla_vacantes").css("margin-top", "1em");
        $("#tabla_vacantes_info").css("margin-top", "2em");
        $("#tabla_vacantes_paginate").css("margin-top", "2em");
        $("#tabla_vacantes_previous").find( "a" ).html("Anterior");
        $("#tabla_vacantes_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_vacantes_previous").find( "a" ).html("Anterior");
            $("#tabla_vacantes_next").find( "a" ).html("Siguiente");

        });

        $(document).on('click', '.showMensaje', function(){

            event.preventDefault()
            var mensaje = $(this).attr("data-mensaje");

            // mensaje     = mensajeConvertido(mensaje); 

            $("#mensaje_body").html(mensaje);
            $("#mensaje_modal").modal("show");

        });

        $('#btnCopiar').on('click', function () {
            var textoACopiar = $(this).data('url');

            navigator.clipboard.writeText(textoACopiar).then(function () {
                Swal.fire({
                    title: 'URL copiada con éxito',
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 2000,
                    timerProgressBar: true
                });
            }, function (err) {
                alert("Error al copiar: " + err);
            });

        });

        $(document).on('click', '.updateEstatus', function(event) {

            var id_vacante   = $(this).attr('data-id');
            var estatus      = $(this).attr('data-estatus');
            var nombre       = $(this).attr('data-nombre');
            var texto_alerta = "activar";

            if(estatus == 0 || estatus == "0"){
                texto_alerta = "desactivar";
            }

            Swal.fire({
                title: 'Confirmación',
                text: "¿Estás segur@ de "+texto_alerta+" esta vacante?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'green',
                cancelButtonColor: '#d33',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Confirmar',
                reverseButtons: true
            }).then((result) => {
                if (result.value == true) {
                    mostrarLoader();
                    if (estatus == 0) {
                        desactivarVacante(id_vacante, estatus);
                    }else {
                        activarVacante(id_vacante, estatus, nombre);
                    }
                    
                }
            });

        });

        $(document).on('click', '.verPreguntas', function(event) {
            
            var idVacante = $(this).attr("data-id");

            getPreguntasVacante(idVacante);

        });

        $(document).on('click', '.verQR', function(event) {

            var idVacante    = $(this).attr("data-id");
            var nombre       = $(this).attr("data-vacante");

            generarCodigoQr(idVacante, nombre);

        });

    });//termina jQuery

    function activarVacante(id_vacante, estatus, nombre){

        mostrarLoader();

        $.ajax({
            url : "<?php echo base_url();?>index.php/activarVacante",
            type : "POST",
            dataType : "json",
            data :{"id_vacante": id_vacante, "estatus": estatus, "nombre": nombre},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        icon: 'success'
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);

                }else{
                    Swal.fire({
                        title: result.mensaje,
                        icon: 'info'
                    });
                }

                setTimeout(ocultarLoader, 1000);

            }
        });

    }//termina activarVacante

    function desactivarVacante(id_vacante, estatus){

        mostrarLoader();

        $.ajax({
            url : "<?php echo base_url();?>index.php/desactivarVacante",
            type : "POST",
            dataType : "json",
            data :{"id_vacante": id_vacante, "estatus": estatus},
            success : function(result){

                if(result.respuesta == 200){
                    Swal.fire({
                        title: result.mensaje,
                        icon: 'success'
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);

                }else{
                    Swal.fire({
                        title: result.mensaje,
                        icon: 'info'
                    });
                }

                setTimeout(ocultarLoader, 1000);

            }
        });

    }//termina desactivarVacante

    function generarCodigoQr(idVacante, nombre){

        $.ajax({
            url : "<?php echo base_url();?>index.php/generarCodigoQr",
            type : "POST",
            dataType : "json",
            data :{"idVacante": idVacante, "nombre" : nombre},
            success : function(response){

                /*var imageUrl = response.url_qr;

                // Crear un enlace oculto y asignarle el URL de la imagen
                var link = $('#downloadLink');
                link.attr('href', imageUrl);
                link.attr('download', response.nombreQr);

                // Simular un clic en el enlace
                link[0].click();*/

                $("#btnCopiar").attr("data-url", response.urlCopia);
                
                $("#txt_modal_qr").html("QR - " + response.nombreQr);
                $("#url").attr("href", response.url_qr);
                $("#url").text(response.url_qr);

                $("#imgQR").attr("src", response.url_qr);

                $("#descargar").attr("href", response.url_qr);
                $("#descargar").attr("download", "QR-" + response.nombreQr);

                $("#modal_qr").modal("show");

            }
        });

    }//termina generarCodigoQr

    function mensajeConvertido(mensaje){

        var asteriscos      = mensaje.split("*").length - 1;
        var guiones_bajos   = mensaje.split("_").length - 1;
        var tachados        = mensaje.split("~").length - 1;

        if(asteriscos > 0){

            for (let i = 1; i <= asteriscos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("*", "</strong>");
                }else{
                    mensaje = mensaje.replace("*", "<strong>");
                }
                
            }

        }

        if(guiones_bajos > 0){

            for (let i = 1; i <= guiones_bajos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("_", "</i>");
                }else{
                    mensaje = mensaje.replace("_", "<i>");
                }
                
            }

        }

        if(tachados > 0){

            for (let i = 1; i <= tachados; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("~", "</span>");
                }else{
                    mensaje = mensaje.replace("~", "<span style='font-size: 14px; text-decoration-line: line-through;'>");
                }
                
            }

        }

        return mensaje;

    }//termina mensajeConvertido

    function getPreguntasVacante(idVacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/preguntasVacante",
            type : "POST",
            dataType : "json",
            data :{"idVacante": idVacante},
            success : function(response){

                $(".contenedor").html(response.preguntas);
                $("#preguntasModal").modal("show");

            }
        });
    }//termina getPreguntasVacante

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

</script>