<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clientes extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('auth_check');
        $this->auth_check->verificar();
        $this->load->model('cliente_model');
        $this->load->helper('url');
        $this->load->library('session');
    }

    public function index() {
        $data['clientes'] = $this->cliente_model->get_all();
        $this->load->view('clientes/lista', $data);
    }

    public function crear() {
        $this->load->view('clientes/crear');
    }

    public function guardar() {
        $data = array(
            'nombre' => $this->input->post('nombre'),
            'empresa' => $this->input->post('empresa'),
            'email' => $this->input->post('email'),
            'telefono' => $this->input->post('telefono'),
            'direccion' => $this->input->post('direccion'),
            'rfc' => $this->input->post('rfc'),
            'cargo' => $this->input->post('cargo')
        );
        
        $this->cliente_model->insert($data);
        $this->session->set_flashdata('success', 'Cliente creado exitosamente');
        redirect('clientes');
    }

    public function editar($id) {
        $data['cliente'] = $this->cliente_model->get_by_id($id);
        $this->load->view('clientes/editar', $data);
    }

    public function actualizar($id) {
        $data = array(
            'nombre' => $this->input->post('nombre'),
            'empresa' => $this->input->post('empresa'),
            'email' => $this->input->post('email'),
            'telefono' => $this->input->post('telefono'),
            'direccion' => $this->input->post('direccion'),
            'rfc' => $this->input->post('rfc'),
            'cargo' => $this->input->post('cargo')
        );
        
        $this->cliente_model->update($id, $data);
        $this->session->set_flashdata('success', 'Cliente actualizado exitosamente');
        redirect('clientes');
    }

    public function eliminar($id) {
        $this->cliente_model->delete($id);
        $this->session->set_flashdata('success', 'Cliente eliminado exitosamente');
        redirect('clientes');
    }
}
