<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Middleware de autenticación
 * Agregar este código al inicio de cada controlador que requiera autenticación
 */

class Auth_check {
    
    protected $CI;

    public function __construct() {
        $this->CI =& get_instance();
        $this->CI->load->library('session');
        $this->CI->load->model('auth_model');
        $this->CI->load->helper('url');
    }

    /**
     * Verificar si el usuario está autenticado
     */
    public function verificar() {
        // Verificar si existe sesión
        if (!$this->CI->session->userdata('logged_in')) {
            $this->CI->session->set_flashdata('error', 'Debe iniciar sesión para acceder');
            redirect('auth');
            return false;
        }

        // Verificar validez de la sesión en BD
        $usuario_id = $this->CI->session->userdata('user_id');
        $sesion_valida = $this->CI->auth_model->validar_sesion($usuario_id);

        if (!$sesion_valida) {
            $this->CI->session->sess_destroy();
            $this->CI->session->set_flashdata('error', 'Su sesión ha expirado. Por favor inicie sesión nuevamente');
            redirect('auth');
            return false;
        }

        return true;
    }

    /**
     * Obtener datos del usuario actual
     */
    public function usuario_actual() {
        if (!$this->CI->session->userdata('logged_in')) {
            return null;
        }

        $usuario_id = $this->CI->session->userdata('user_id');
        return $this->CI->auth_model->get_usuario($usuario_id);
    }
}

/**
 * INSTRUCCIONES DE USO:
 * 
 * Agregar al inicio de cada controlador que requiera autenticación:
 * 
 * public function __construct() {
 *     parent::__construct();
 *     $this->load->library('auth_check');
 *     $this->auth_check->verificar();
 * }
 * 
 * Para obtener datos del usuario actual:
 * $usuario = $this->auth_check->usuario_actual();
 */