<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
// $routes->setAutoRoute(true); // si habilitamos esta línea se puede hacer como en codeigniter 3 pero es menos seguro
// ========== RUTAS DE LOGIN ==========
$routes->get('/', 'Home::index');
$routes->get('/addUser', 'Home::addUser');
$routes->post('/verificarLogin', 'Home::verificarLogin');//Para agregar usuarios 

// ========== RUTAS DASHBOARD ==========
$routes->get('/Admin/dashboard', 'Admin\Dashboard::index');
$routes->get('/Admin/logOut', 'Admin\Dashboard::logOut');
$routes->get('/Admin/prueba', 'Admin\Dashboard::prueba');
$routes->post('/cambiarVariableSesion', 'Admin\Dashboard::cambiarVariableSesion'); //AJAX
$routes->post('/variableSesion', 'Admin\Dashboard::variableSesion'); //AJAX
$routes->post('/getVacantesReclutador', 'Admin\Dashboard::getVacantesReclutador'); //AJAX
$routes->post('/codigoQR', 'Admin\Dashboard::codigoQR'); //AJAX

// ========== RUTAS USUARIOS ==========
$routes->get('/usuarios', 'Admin\Usuarios::index');
$routes->post('/agregarUsuario', 'Admin\Usuarios::agregarUsuario'); //AJAX
$routes->post('/actualizarUsuario', 'Admin\Usuarios::actualizarUsuario'); //AJAX
$routes->post('/getUsuario', 'Admin\Usuarios::getUsuario'); //AJAX
$routes->post('/actualizarPass', 'Admin\Usuarios::actualizarPass'); //AJAX
$routes->get('/getUsuarios', 'Admin\Usuarios::getUsuarios');

// ========== RUTAS RECLUTADORES ==========
$routes->get('/reclutadores', 'Admin\Reclutadores::index');
$routes->post('/agregarReclutador', 'Admin\Reclutadores::agregarReclutador'); //AJAX
$routes->post('/getReclutador', 'Admin\Reclutadores::getReclutador'); //AJAX
$routes->post('/actualizarReclutador', 'Admin\Reclutadores::actualizarReclutador'); //AJAX
$routes->post('/actualizarPassReclutador', 'Admin\Reclutadores::actualizarPassReclutador'); //AJAX

// ========== RUTAS LIDERES ==========
$routes->get('/lideres', 'Admin\Lideres::index');
$routes->post('/agregarLider', 'Admin\Lideres::agregarLider'); //AJAX
$routes->post('/getLider', 'Admin\Lideres::getLider'); //AJAX
$routes->post('/actualizarLider', 'Admin\Lideres::actualizarLider'); //AJAX
$routes->post('/actualizarPassLider', 'Admin\Lideres::actualizarPass'); //AJAX
$routes->get('/liderClientes', 'Admin\Lideres::liderClientes/$1');

// ========== RUTAS CLIENTES ==========
$routes->get('/clientes', 'Admin\Clientes::index');
$routes->post('/agregarCliente', 'Admin\Clientes::agregarCliente'); //AJAX
$routes->post('/getCliente', 'Admin\Clientes::getCliente'); //AJAX
$routes->post('/actualizarCliente', 'Admin\Clientes::actualizarCliente'); //AJAX
$routes->get('/clienteLideres', 'Admin\Clientes::clienteLideres/$1');

// ========== RUTAS VACANTES ==========
$routes->get('/vacantes', 'Admin\Vacantes::index');
$routes->get('/nuevaVacante', 'Admin\Vacantes::agregar');
$routes->get('/generarExcelPostulaciones', 'Admin\Vacantes::generarExcelPostulaciones');
$routes->post('/agregarVacante', 'Admin\Vacantes::agregarVacante'); //AJAX
$routes->get('/actualizarVacante', 'Admin\Vacantes::actualizarVacante/$1');
$routes->post('/preguntasVacante', 'Admin\Vacantes::preguntasVacante'); //AJAX
$routes->get('/noPostularon', 'Admin\Vacantes::noPostularon');
$routes->post('/filtrarNoPostulaciones', 'Admin\Vacantes::noPostularonFiltrar'); //AJAX
$routes->get('/abandonaronProceso', 'Admin\Vacantes::abandonaronProceso');
$routes->post('/filtrarAbandonaronProceso', 'Admin\Vacantes::filtrarAbandonaronProceso'); //AJAX
$routes->post('/getOpciones', 'Admin\Vacantes::getOpciones'); //AJAX
$routes->post('/guardarPregunta', 'Admin\Vacantes::guardarPregunta'); //AJAX
$routes->post('/addOpcion', 'Admin\Vacantes::addOpcion'); //AJAX
$routes->post('/updateOpcion', 'Admin\Vacantes::updateOpcion'); //AJAX
$routes->post('/bajaOpcion', 'Admin\Vacantes::bajaOpcion'); //AJAX
$routes->post('/bajaPregunta', 'Admin\Vacantes::bajaPregunta'); //AJAX
$routes->post('/guardarArchivo', 'Admin\Vacantes::guardarArchivo'); //AJAX
$routes->post('/bajaArchivo', 'Admin\Vacantes::bajaArchivo'); //AJAX
$routes->post('/updateVacante', 'Admin\Vacantes::updateVacante'); //AJAX
$routes->get('/postuladosVacante', 'Admin\Vacantes::postuladosVacante/$1');
$routes->get('/vacantesReclutador', 'Admin\Vacantes::vacantesReclutador');
$routes->get('/postuladosVacanteReclutador', 'Admin\Vacantes::postuladosVacanteReclutador/$1');
$routes->post('/generarCodigoQr', 'Admin\Vacantes::generarCodigoQr'); //AJAX
$routes->post('/generarCodigoQrReclutador', 'Admin\Vacantes::generarCodigoQrReclutador'); //AJAX
$routes->post('/updateDescarte', 'Admin\Vacantes::updateDescarte'); //AJAX
$routes->post('/acortarUrl', 'Admin\Vacantes::acortarUrl'); //AJAX
$routes->post('/getReclutadoresClientesLider', 'Admin\Vacantes::getReclutadoresClientesLider'); //AJAX


// ========== RUTAS CANDIDATOS ==========
$routes->get('/candidatos', 'Admin\Candidatos::index');
$routes->get('/postulaciones', 'Admin\Candidatos::getPostulaciones/$1');
$routes->post('/respuestasCandidato', 'Admin\Candidatos::respuestasCandidato'); //AJAX
$routes->get('/candidatosSinResponder', 'Admin\Candidatos::candidatosSinResponder');
$routes->post('/filtrarCandidatosSinPostular', 'Admin\Candidatos::filtrarCandidatosSinPostular'); //AJAX
$routes->post('/filtrarCandidatos', 'Admin\Candidatos::filtrarCandidatos'); //AJAX

//========== RUTAS TICKETS ==========
$routes->get('/conversaciones', 'Admin\Tickets::index');
$routes->get('/conversaciones_responsive', 'Admin\Tickets::responsive');
$routes->get('/atendidas', 'Admin\Tickets::atendidas');
$routes->get('/correoReasignar', 'Admin\Tickets::correoReasignar');
$routes->post('/updateContador', 'Admin\Tickets::updateContador'); //AJAX
$routes->post('/tomarTicket', 'Admin\Tickets::tomarTicket'); //AJAX
$routes->post('/sendMessageWeb', 'Admin\Tickets::sendMessageWeb'); //AJAX
$routes->post('/subirArchivo', 'Admin\Tickets::subirArchivo'); //AJAX
$routes->post('/cerrarTicket', 'Admin\Tickets::cerrarTicket'); //AJAX
$routes->post('/reasignarTicketSql', 'Admin\Tickets::reasignarTicketSql'); //AJAX
$routes->post('/getFiltroAtendidas', 'Admin\Tickets::getFiltroAtendidas'); //AJAX
$routes->post('/updateEstadoTicket', 'Admin\Tickets::updateEstatusTicket'); // AJAX
$routes->post('/sendPlantilla', 'Admin\Tickets::sendPlantilla'); // AJAX

// ========== RUTAS METRICAS ==========
$routes->get('/metricas', 'Admin\Metricas::index');
$routes->post('/filtrarMetricas', 'Admin\Metricas::filtrar'); //AJAX


// ===== CHATBOT =====
$routes->post('/Chatbot_medina', 'Chatbot_medina::index');
$routes->get('/pruebaChatbot', 'Chatbot_medina::pruebaChatbot');

// ===== CRONS, =====
$routes->get('/Cron_postulacion_incompleta', 'Cron_postulacion_incompleta::index');

// ===== APP LOGIN =====

$routes->post('/Adminapp/loginApp', 'Adminapp\Login::loginApp');//Api para loguear




// ===== SCRIPTS =====
$routes->post('/Scripts', 'Scripts::index'); //GENERAR QR DE VACANTE

$routes->group('admin', static function ($routes){ // esto se hace para agrupar por rutas para cada tipo de usuario o rol

    $routes->view('productos', 'Admin/Productos::index');

});

// ========== Ejemplos rutas ===========
// $routes->get('/home', '');
// $routes->get('/', 'Home::index');
// $routes->get('/otraruta/(:num)', 'Home::prueba/$1');
//$routes->get('/postulaciones', 'Admin\Candidatos::getPostulaciones/$1');
// $routes->get('/Admin/prueba/(:alpha)', 'Admin\Dashboard::prueba/$1');
// $routes->view('ejemplo/(:alpha)', 'ejemplo_ruta');
// $routes->view('iconoView', 'welcome_message'); --> también se pueden mandar llamar vistas desde las rutas