<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\ClientesModel;

class Clientes extends BaseController {
	
	private $ClientesModel; //Nombre de la variable para el modelo 
    protected $session;
	private $encrypter;

    public function __construct(){
        
        $this->ClientesModel = new ClientesModel(); // modelo a usar
        $this->session = session();

    }//termina __construct

	public function index(){

		$data                = array();
		$data["_APP_TITTLE"] = "Clientes";
		$data["_TAB"]        = "clientes";
		$data["clientes"]    = $this->ClientesModel->getClientes();
		$data["fragment"]    = view('admin/fragments/clientes_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function agregarCliente(){

		$request 		= service('request');
		$cliente 		= $request->getPost("cliente");
		$estatus        = $request->getPost('estatus');
		
		$regreso          = 500;
		$mensaje          = "Error, vuelve a intentarlo";
				
		$nuevoCliente             		 = array();
		$nuevoCliente['nombre_cliente']  = $cliente;
		$nuevoCliente['estatus_cliente'] = $estatus;

		if($this->ClientesModel->insertarCliente($nuevoCliente)){
			$regreso = 200;
			$mensaje = "Cliente agregado";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));

	}//termina agregarCliente

	public function getCliente(){

		$request 	= service('request');
		$idCliente 	= $request->getPost("idCliente");

		$datos      = $this->ClientesModel->getCliente($idCliente);

		echo json_encode(array("datos" => $datos));

	}//termina getCliente

	public function actualizarCliente(){

		$request 	= service('request');
		$idCliente 	= $request->getPost("idCliente");
		$cliente    = $request->getPost("cliente");
		$estatus    = $request->getPost('estatus');		

		$respuesta      = 500;
		$mensaje      = "Error, vuelve a intentarlo";

		$datos            			= array();
		$datos['nombre_cliente']    = $cliente;
		$datos['estatus_cliente'] 	= intval($estatus);

		if ($this->ClientesModel->actualizarCliente($datos, $idCliente)) {
			$respuesta = 200;
			$mensaje = "Cliente actualizado";
		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina actualizarCliente

	public function clienteLideres(){

		$request 	= service('request');
		$idCliente 	= base64_decode($request->getGet("c"));

		$cliente = $this->ClientesModel->getCliente($idCliente);

		$data                = array();
		$data["_APP_TITTLE"] = "Lideres - ".$cliente->nombre_cliente;
		$data["_TAB"]        = "clientes";
		$data["cliente"]     = $cliente;
		$data["lideres"]     = $this->ClientesModel->getLideresCliente($idCliente);
		$data["fragment"]    = view('admin/fragments/lideres_cliente_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina clienteLideres


}
