<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\ReclutadoresModel;

class Reclutadores extends BaseController {
	
	private $ReclutadoresModel; //Nombre de la variable para el modelo 
    protected $session;
	private $encrypter;

    public function __construct(){
        
        $this->ReclutadoresModel = new ReclutadoresModel(); // modelo a usar
        $this->session = session();
		$this->encrypter = \Config\Services::encrypter();

    }//termina __construct

	public function index(){

		$session   = session();
		$tipo      = $session->get('id_tipo_usuario');
		$idUsuario = $session->get('id_usuario');

		$data                 = array();
		$data["_APP_TITTLE"]  = "Reclutadores";
		$data["_TAB"]         = "reclutadores";
		$data["reclutadores"] = $this->ReclutadoresModel->getReclutadores();
		$data["fragment"]     = view('admin/fragments/reclutadores_view', $data);
		$data["main_menu"]    = view('admin/nav/main_menu_nav', $data);
		$data["nav"]          = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function agregarReclutador(){

		$session   = session();
		$tipo      = $session->get('id_tipo_usuario');
		$idUsuario = $session->get('id_usuario');

		$request    = service('request');
		$nombre     = $request->getPost("nombre");
		$correo     = $request->getPost("correo");
		$lada       = $request->getPost('lada');
		$celular    = $request->getPost('celular');
		$contrasena = $request->getPost('contrasena');
		$estatus    = $request->getPost('estatus');
		
		$regreso = 500;
		$mensaje = "Error, vuelve a intentarlo";
		
		$encrypted_string = base64_encode($this->encrypter->encrypt($contrasena));
		$getUsuario       = $this->ReclutadoresModel->getUsuarioRegistradoAlta($correo);

		if (is_null($getUsuario)) {
				
			$usuario             		= array();
			$usuario['usuario']  		= $nombre;
			$usuario['correo']   		= $correo;
			$usuario['password'] 		= $encrypted_string;
			$usuario['estatus']  		= $estatus;
			$usuario['id_tipo_usuario'] = 2;

			$idUsuario = $this->ReclutadoresModel->insertUsuario($usuario);

			if(!is_null($idUsuario)){

				$reclutador 						= array();
				$reclutador["nombre_reclutador"] 	= $nombre;
				$reclutador["celular_reclutador"] 	= $lada.$celular;
				$reclutador["id_usuario"]			= $idUsuario;
				$reclutador["estatus_reclutador"]	= $estatus;

				$idReclutador = $this->ReclutadoresModel->insertarReclutador($reclutador);

				$actualizar = array();
				$actualizar["codigo_reclutador"] = mb_strtoupper("RECL-".$idReclutador);

				$this->ReclutadoresModel->actualizarReclutador($actualizar, $idUsuario);

				$regreso = 200;
				$mensaje = "Agregado con éxito";
				
			}

		}else{
			$regreso = 300;
			$mensaje = "Este correo ya está registrado";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));


	}//termina agregarUsuario

	public function getReclutador(){

		$request 		= service('request');
		$id_usuario 	= $request->getPost("id_usuario");

		$datos      	= $this->ReclutadoresModel->usuarioReclutador($id_usuario);

		$respuesta 	= 500;

		if (!is_null($datos)) {
			$respuesta = 200;
		}

		echo json_encode(array("respuesta" => $respuesta, "datos" => $datos));

	}//termina getReclutador

	public function actualizarReclutador(){

		$session         = session();
		$tipo            = $session->get('id_tipo_usuario');
		$idUsuarioSesion = $session->get('id_usuario');

		$request   = service('request');
		$idUsuario = $request->getPost("idUsuario");
		$nombre    = $request->getPost("nombre");
		$correo    = $request->getPost('correo');
		$lada      = $request->getPost('lada');
		$celular   = $request->getPost('celular');
		$estatus   = $request->getPost('estatus');

		$respuesta = 500;
		$mensaje   = "Error, vuelve a intentarlo";

		$getUsuario = $this->ReclutadoresModel->getUsuarioRegistrado($correo, $idUsuario);

		if (is_null($getUsuario)) {

			$datos            			= array();
			$datos['usuario'] 			= $nombre;
			$datos['correo']  			= $correo;
			$datos['estatus'] 			= intval($estatus);

			if ($this->ReclutadoresModel->actualizarUsuario($datos, $idUsuario)) {

				$reclutador 						= array();
				$reclutador["nombre_reclutador"] 	= $nombre;
				$reclutador["celular_reclutador"] 	= $lada.$celular;
				$reclutador["estatus_reclutador"]	= $estatus;

				$this->ReclutadoresModel->actualizarReclutador($reclutador, $idUsuario);

				$respuesta = 200;
				$mensaje = "Actualizado con éxito";

			}

		}else{
			$respuesta = 300;
			$mensaje = "Este correo ya se encuentra registrado, intenta con otro";
		}

		echo json_encode(array("regreso" => $respuesta, "mensaje" => $mensaje));

	}//termina actualizarReclutador

	public function actualizarPassReclutador(){
		
		$request 		= service('request');
		$id_usuario   	= $request->getPost("id_usuario");
		$contra_nueva 	= $request->getPost("contra_nueva");
		$confirmar    	= $request->getPost("confirmar");
		$regreso      = false;
		$mensaje      = "";

		$datos = $this->ReclutadoresModel->usuarioReclutador($id_usuario);

		if (!is_null($datos)) {
				
				$contra = base64_encode($this->encrypter->encrypt($confirmar));

				$update = array();
				$update["password"] = $contra;

				$this->ReclutadoresModel->actualizarUsuario($update, $id_usuario);
				$regreso = true;
				$mensaje = "Contraseña actualizada correctamente";

		}else{
			$mensaje = "Error, vuelve a intentarlo";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));


	}//termina actualizarPassReclutador

}
