<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\UsuariosModel;

class Usuarios extends BaseController {
	
	private $UsuariosModel; //Nombre de la variable para el modelo 
    protected $session;
	private $encrypter;

    public function __construct(){
        
        $this->UsuariosModel = new UsuariosModel(); // modelo a usar
        $this->session = session();
		$this->encrypter = \Config\Services::encrypter();


    }//termina __construct

	public function index(){

		$data                = array();
		$data["_APP_TITTLE"] = "Usuarios";
		$data["_TAB"]        = "user";
		$data["usuarios"]    = $this->UsuariosModel->getUsuarioTipo();
		$data["tipo"]		 = $this->UsuariosModel->getTipo();
		$data["fragment"]    = view('admin/fragments/usuarios_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function agregarUsuario(){

		$request 		= service('request');
		$usuario 		= $request->getPost("usuario");
		$correo 		= $request->getPost("correo");
		$contrasena     = $request->getPost('contrasena');
		$estatus        = $request->getPost('estatus');
		$tipo_usuario   = $request->getPost('tipo_usuario');

		date_default_timezone_set('America/Mexico_City');
		$tiempo           = date("Y-m-d H:i:s");
		
		
		$regreso          = 500;
		$mensaje          = "Error, vuelve a intentarlo";
		
		$encrypted_string = base64_encode($this->encrypter->encrypt($contrasena));
		$getUsuario       = $this->UsuariosModel->getUsuarioRegistradoAlta($correo);

		if (is_null($getUsuario)) {
				
			$datosAddUsuario             		= array();
			$datosAddUsuario['usuario']  		= $usuario;
			$datosAddUsuario['correo']   		= $correo;
			$datosAddUsuario['password'] 		= $encrypted_string;
			$datosAddUsuario['estatus']  		= $estatus;
			$datosAddUsuario['fecha_registro']  = $tiempo;
			$datosAddUsuario['id_tipo_usuario'] = $tipo_usuario;

			if(!is_null($this->UsuariosModel->insertUsuario($datosAddUsuario))){
				$regreso = 200;
				$mensaje = "Usuario agregado";
			}else{
				$regreso = 400;
				$mensaje = "Error al insertar usuario";
			}

		}else{
			$regreso = 300;
			$mensaje = "Este correo ya está registrado";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));


	}//termina agregarUsuario

	public function getUsuario(){

		$request 		= service('request');
		$id_usuario 	= $request->getPost("id_usuario");
		$datos      	= $this->UsuariosModel->usuario($id_usuario);

		$respuesta 	= 500;

		if (!is_null($datos)) {
			$respuesta = 200;
		}

		echo json_encode(array("respuesta" => $respuesta, "datos" => $datos));

	}//termina getUsuario

	public function actualizarUsuario(){

		$request 		= service('request');
		$id_usuario 	= $request->getPost("id_usuario");
		$usuario  		= $request->getPost("usuario");
		$correo       	= $request->getPost('correo');
		$tipo_usuario 	= $request->getPost('tipo_usuario');
		$estatus      	= $request->getPost('estatus');		

		$respuesta      = 500;
		$mensaje      = "Error, vuelve a intentarlo";

		$getUsuario   = $this->UsuariosModel->getUsuarioRegistrado($correo, $id_usuario);

		if (is_null($getUsuario)) {

			$datos            			= array();
			$datos['usuario'] 			= $usuario;
			$datos['correo']  			= $correo;
			$datos['id_tipo_usuario'] 	= $tipo_usuario;
			$datos['estatus'] 			= intval($estatus);

			if ($this->UsuariosModel->actualizarUsuario($datos, $id_usuario)) {
				$respuesta = 200;
				$mensaje = "Usuario actualizado";
			}else{
				$respuesta = 400;
				$mensaje = "No se pudo actualizar";
			}

		}else{
			$respuesta = 300;
			$mensaje = "Este correo ya se encuentra registrado, intenta con otro";
		}

		echo json_encode(array("regreso" => $respuesta, "mensaje" => $mensaje));

	}//termina actualizarUsuario

	public function actualizarPass(){
		
		$request 		= service('request');
		$id_usuario   	= $request->getPost("id_usuario");
		$contra_nueva 	= $request->getPost("contra_nueva");
		$confirmar    	= $request->getPost("confirmar");
		$regreso      = false;
		$mensaje      = "";

		$datos = $this->UsuariosModel->usuario($id_usuario);

		if (!is_null($datos)) {
				
				$contra = base64_encode($this->encrypter->encrypt($confirmar));

				$update = array();
				$update["password"] = $contra;

				$this->UsuariosModel->actualizarUsuario($update, $id_usuario);
				$regreso = true;
				$mensaje = "Contraseña actualizada correctamente";

		}else{
			$mensaje = "Error, vuelve a intentarlo";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));


	}//termina actualizarPass

	public function getUsuarios(){

		$usuarios = $this->UsuariosModel->getUsuariosTodos();

		if(!is_null($usuarios)){

			foreach ($usuarios as $usuario) {

				$pass = $this->encrypter->decrypt(base64_decode($usuario->password));
				
				echo "Usuario: ".$usuario->usuario." , Correo: ".$usuario->correo." , Contraseña: ".$pass."<br>";
			}

		}

		//die();


	}//termina getUsuarios

}
