<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\ChatbotModel;

class Chatbot_medina extends BaseController{

	private $ChatbotModel;

	public function __construct(){
        $this->ChatbotModel = new ChatbotModel();
    }  //termina __construct
	public function index(){

		$json    = file_get_contents('php://input');
		$decoded = json_decode($json,true);
		http_response_code(200);

		// ob_start();
		// var_dump($decoded);
		// $input   = ob_get_contents();
		// // //$input = $decoded["message"];
		// ob_end_clean();
		// file_put_contents('nuevoChatbot.log',$input.PHP_EOL,FILE_APPEND);
		// // die("En bot");
		// die("prueba");

		$mensaje_whats 		= "";
		$cel           		= NULL;

		$file               = NULL;
		$video              = NULL;
		$image              = NULL;
		$title_button       = NULL;
		$audio              = NULL;
		$type               = NULL;
		$context            = NULL;
		$contact            = NULL;
		$count_contact      = 0;
		$valor_list         = NULL;
		$content_type       = NULL;
		$timestamp_bot      = NULL;
		$latitude           = "";
		$longitude          = "";
		$nombre_whats       = NULL;
		$sticker            = NULL;

        if(!is_null($decoded)){
			
			$payload       = $decoded["payload"];
			$timestamp_bot = $decoded["timestamp"];

			if (isset($decoded["type"])) {
				$type_event = $decoded["type"];
				if ($type_event == "message-event") {
					$payEvento     = $decoded["payload"];
					$evento        = $payEvento["type"];
				}
			}

			if(!is_null($payload)){

				if (isset($payload["source"])) {
					$cel = $payload["source"];
				}

				if(array_key_exists('payload', $payload)){

					$pay           = $payload["payload"];
					$type           = $payload["type"];
				
					if (array_key_exists('text', $pay)) {
						$mensaje_whats = $pay["text"];
					}else if ($type == "file") {
						$file          = $pay["url"];
						$mensaje_whats = NULL;
						$content_type  = $pay["contentType"];
					}else if ($type == "button_reply") {
						$title_button = $pay["title"];
					}else if ($type == "image") {
						$image         = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = NULL;
					}else if ($type == "video") {
						$video         = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = NULL;
					}
					else if ($type == "sticker") {
						$sticker       = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = NULL;
					}
					else if ($type == "audio") {
						$audio         = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = NULL;
					}
					else if ($type == "contact") {
						$count_contact = count($pay["contacts"]);
						$contact       = $pay["contacts"][0]["phones"][0]["phone"];
						$mensaje_whats = NULL;
					}else if($type == "list_reply"){
						$mensaje_whats = $pay["title"];
						$valor_list    = $pay["postbackText"];
					}

					if (array_key_exists('latitude', $pay) && array_key_exists('longitude', $pay)) {
						$latitude = $pay["latitude"];
						$longitude = $pay["longitude"];
					}


				}else{
					$mensaje_whats = "NA";
				}

				$type          = $payload["type"];

				if($type == "order"){

					$context = $payload["context"];

				}


			}//termina is null payload

		}//termina isnull decoded

        // ob_start();
        // var_dump($context);
        // $input = ob_get_contents();
        // //$input = $decoded["message"];
        // ob_end_clean();
        // file_put_contents('prueba.log',$input.PHP_EOL,FILE_APPEND);

		// if (!is_null($cel) && ($cel == "5214423238854" || $cel == "5214423275640")) {

			date_default_timezone_set('America/Mexico_City');
			$tiempo = date("Y-m-d H:i:s");

			$p0            = "";
			$p1            = "";
			$p2            = "";
			$p3            = "";
			$p4            = "";
			$p5            = "";
			$p6            = "";
			$p7            = "";
			$p8            = "";
			$p9            = "";
			$p10           = "";
			$p11           = "";
			$p12           = "";
			$p13           = "";
			$nombre_c      = "";
			$tot_p         = 0;
			$viable        = 1;
			$id_candidato  = 0;
			$id_categoria  = 0;
			$id_ciudad     = 0;
			$id_vacante    = 0;
			$id_reclutador = 0;
			$cont_msj      = 0;
			$id_ticket     = 0;
			$conversacion  = 1;

			$v = $this->ChatbotModel->getPregunta($cel);

			if (!is_null($v)) {
				
				$p0            = $v->pregunta_0;
				$p1            = $v->pregunta_1;
				$p2            = $v->pregunta_2;
				$p3            = $v->pregunta_3;
				$p4            = $v->pregunta_4;
				$p5            = $v->pregunta_5;
				$p6            = $v->pregunta_6;
				$p7            = $v->pregunta_7;
				$p8            = $v->pregunta_8;
				$p9            = $v->pregunta_9;
				$p10           = $v->pregunta_10;
				$p11           = $v->pregunta_11;
				$p12           = $v->pregunta_12;
				$p13           = $v->pregunta_13;
				$nombre_c      = $v->nombre;
				$tot_p         = $v->tot_preguntas;
				$viable        = $v->viable;
				$id_candidato  = $v->id_candidato;
				$id_categoria  = $v->id_categoria;
				$id_ciudad     = $v->id_ciudad;
				$id_vacante    = $v->id_vacante;
				$id_reclutador = $v->id_reclutador;
				$cont_msj      = $v->cont_msj;
				$id_ticket     = $v->id_ticket;
				$conversacion  = $v->conversacion;
				
			} //termina if !is_null

			$type_file = 1;
			$msj_fire  = NULL;

			if ($type == "button_reply") {
				$msj_fire = $title_button;
			}else if ($type == "list_reply") {
				$msj_fire = $mensaje_whats;
			}else{
				$msj_fire = nl2br($mensaje_whats);
			}

			$url_file_fire = NULL;

			if ($type == "text" || $type == "button_reply" || $type == "list_reply") {
				$type_file = 0;
			}else if ($type == "image") {
				$type_file = 1;
				$url_file_fire = $image;
			}else if ($type == "file"){
				$type_file = 2; //0 = texto, 1= imagen, 2 = document, 3 = lista y 4 = boton, 5 = video
				$url_file_fire = $file;
			}else if ($type == "video"){
				$type_file     = 5; //0 = texto, 1= imagen, 2 = document, 3 = lista y 4 = boton
				$url_file_fire = $video;
			}else if($type == "sticker"){
				$type_file     = 6; //0 = texto, 1= imagen, 2 = document, 3 = lista y 4 = boton 6 = sticker
				$url_file_fire = $sticker;
			}else{
				$type_file     = 7; //0 = texto, 1= imagen, 2 = document, 3 = lista y 4 = boton 6 = sticker, 7 = audio
				$url_file_fire = $audio;
			}

			if(!is_null($cel)){

				$this->insertConversacionFirestore(0, $url_file_fire, $cel, $msj_fire, 1, $type_file, $id_ticket);

				if($conversacion == 1){

					$qr_v = $this->vacanteQr($mensaje_whats, $cel, $nombre_c, $id_candidato);
					$resp = $qr_v["respuesta"];

					// ============== QR VACANTE ==============
		
					if($resp == 200){// TODO OK Y PUEDE POSTULARSE
		
						$id_vacante 			= $qr_v["id_vacante"];
						$id_categoria 			= $qr_v["id_categoria"];
						$id_reclutador 			= $qr_v["id_reclutador"];
						$nombre_vacante 		= $qr_v["nombre_vacante"];
						$desc_vacante 			= $qr_v["desc_vacante"];
		
						if(!is_null($v)){//ACTUALIZAR CAMPOS PARA DESPUÉS POSICIONAR EN CHATBOT
		
							$update_pre                         = array();
							$update_pre["pregunta_4"]           = "SIGUIENTE";
							$update_pre["pregunta_5"]           = $id_categoria;
							$update_pre["pregunta_6"]           = $id_vacante;
							$update_pre["pregunta_7"]           = NULL;
							$update_pre["pregunta_8"]           = NULL;
							$update_pre["pregunta_9"]           = NULL;
							$update_pre["pregunta_10"]          = NULL;
							$update_pre["pregunta_11"]          = NULL;
							$update_pre["pregunta_12"]          = NULL;
							$update_pre["pregunta_13"]          = NULL;
							$update_pre["fecha_ultima"]         = $tiempo;
							$update_pre["tot_preguntas"]        = 0;
							$update_pre["viable"]               = 1;
							$update_pre["id_categoria"]         = $id_categoria;
							$update_pre["id_vacante"]           = $id_vacante;
							$update_pre["id_reclutador"]        = $id_reclutador;
							$update_pre["postulacion_completa"] = 0;
							$update_pre["cron_postulacion"]     = 0;
							$this->ChatbotModel->updatePregunta($cel, $update_pre);
		
						}
		
						if($p0 == ""){
							$this->pregunta0($mensaje_whats, $cel, $nombre_c, $tiempo, $id_vacante, $id_categoria, $id_reclutador, 1);
						}
						else if($p1 == ""){
							$this->pregunta1($mensaje_whats, $cel, $nombre_c, $tiempo, 1);
						}
						else if($p2 == ""){
							$this->pregunta2($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, 1);
						}
						else if($p3 == ""){
							$this->pregunta3($mensaje_whats, $valor_list, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante, $id_categoria, $id_reclutador, 1);
						}else {

							$message = "¡Muchas gracias, ".$nombre_c."! Has seleccionado la vacante *".$nombre_vacante."*, a continuación te muestro la descripción:

".$desc_vacante."";
							$this->mensaje_bot($message,$cel);

							sleep(1);

							$cabecera 	= "";
							$mensaje  	= "¿Te gustaría continuar con el proceso?";
							$pie      	= "Oprime el botón de tu preferencia";

							$options[] 	= array('type' => 'text', 'title' => 'No', "encodeText" => true);
							$options[] 	= array('type' => 'text', 'title' => 'Sí', "encodeText" => true);
							$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

						}
		
					}else if($resp == 300){// YA SE POSTULO A ESTA VACANTE
		
						$message = "✅ Ya tenemos tus datos registrados en esta vacante";
						$this->mensaje_bot($message,$cel);
		
					}

					else if($p0 == ""){
						$this->pregunta0($mensaje_whats, $cel, $nombre_c, $tiempo, $id_vacante, $id_categoria, $id_reclutador, 0);
					}
					else if($p1 == ""){
						$this->pregunta1($mensaje_whats, $cel, $nombre_c, $tiempo, 0);
					}
					else if($p2 == ""){
						$this->pregunta2($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, 0);
					}
					else if($p3 == ""){
						$this->pregunta3($mensaje_whats, $valor_list, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante, $id_categoria, $id_reclutador, 0);
					}
					else if(trim($this->quitar_tildes(strtolower($mensaje_whats))) == "medina"){
						$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $tiempo);
					}
					else if($p4 == ""){
						$this->pregunta4($mensaje_whats, $cel, $nombre_c, $tiempo);
					}
					else if($p5 == ""){
						$this->pregunta5($mensaje_whats, $cel, $nombre_c, $tiempo, $id_ciudad);
					}
					else if($p6 == ""){
						$this->pregunta6($mensaje_whats, $cel, $nombre_c, $tiempo, $id_ciudad, $id_categoria, $id_candidato);
					}
					else if($p6 == "NO_ENCONTRE_VACANTE"){
						$this->pregunta6_no_encontre_vacante($mensaje_whats, $file, $title_button, $cel, $nombre_c, $tiempo, $id_candidato, $id_ciudad, $id_categoria);
					}
					else if($p7 == ""){
						$this->pregunta7($mensaje_whats, $title_button, $cel, $nombre_c, $tiempo, $id_vacante);
					}

					// ========================= PREGUNTAS VACANTE =========================
					else if ($p7 == "PREGUNTAS") {
		
						$getCountPreguntas      = $this->ChatbotModel->getCountPreguntas($id_vacante);
						$count        			= $getCountPreguntas->tot;
						$total_p      			= $tot_p + 1;
		
						$getpreguntas      		= $this->ChatbotModel->getPreguntaVacanteLimit($id_vacante, $tot_p);
						$tipo_respuesta_id 		= 0;
						if(!is_null($getpreguntas)){
							$tipo_respuesta_id 	= $getpreguntas->tipo_respuesta;
							$anterior_p        	= $getpreguntas->pregunta;
						}
		
						if($tipo_respuesta_id == 1 && is_null($mensaje_whats)){
		
							$message = "❌ Por favor responda la pregunta con un texto:
		
".$anterior_p." *(".$total_p."/".$count.")*";
							$this->mensaje_bot($message,$cel);
		
						}else{
		
							if($total_p <= $count){
								$this->preguntas_vacante($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante, $id_reclutador, $total_p, $count, $viable);
							}
		
						}
		
					}

					// ================= NO CONTINUARON PROCESO DE VACANTE =================
					else if($p7 == "NO_CONTINUA_PROCESO" && $p8 == ""){
						$this->pregunta7_no_encontre_vacante($mensaje_whats, $valor_list, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante);
					}
					else if($p7 == "NO_CONTINUA_PROCESO" && $p8 == "MOTIVO"){
						$this->pregunta8_no_encontre_vacante($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante);
					}

					// ============================== REINICIO ==============================
					else if($p13 == "FIN"){
						$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $tiempo);
					}

				}else{

					$cont_msj 					= $cont_msj + 1;

					$update_p                 	= array();
					$update_p["fecha_ultima"] 	= $tiempo;
					$update_p["cont_msj"]     	= $cont_msj;
					$this->ChatbotModel->updatePregunta($cel,$update_p);

					$this->updateTicketFirestore($id_ticket, $tiempo, $cont_msj);


				}

			}

		// } //Termina if
        
    }//termina index

	public function vacanteQr($mensaje_whats, $cel, $nombre_c, $id_candidato){

		$respuesta      = 400;
		$id_vacante     = 0;
		$id_categoria   = 0;
		$id_reclutador  = 0;
		$nombre_vacante = "";
		$desc_vacante   = "";

		$ultima_posicion_espacio = strrpos($mensaje_whats, ' ');

		if ($ultima_posicion_espacio !== false) {
			$ultimo_texto = substr($mensaje_whats, $ultima_posicion_espacio + 1);

			// Si contiene punto y coma, asumimos que vienen los dos códigos
			if (strpos($ultimo_texto, ';') !== false) {
				$explode_espacio = explode(";", $ultimo_texto);

				if (count($explode_espacio) > 1) {

					$codigo_vacante    = $explode_espacio[0];
					$codigo_reclutador = $explode_espacio[1];

					$vacanteReclutador = $this->ChatbotModel->getVacanteReclutadorByCodigos($codigo_vacante, $codigo_reclutador);

					if (!is_null($vacanteReclutador)) {
						$validarPostulacion = $this->ChatbotModel->validarPostulacionByCodigo($codigo_vacante, $id_candidato);

						if (!is_null($validarPostulacion)) {
							$id_vacante     = $vacanteReclutador->id_vacante;
							$id_categoria   = $vacanteReclutador->id_categoria;
							$id_reclutador  = $vacanteReclutador->estatus_reclutador == 1 ? $vacanteReclutador->id_reclutador : 0;
							$nombre_vacante = $vacanteReclutador->nombre;
							$desc_vacante   = $vacanteReclutador->descripcion;
							$respuesta      = 200;
						} else {
							$respuesta = 300; // Ya se postuló
						}
					}
				}
			} else {
				// Solo viene el código de la vacante
				$codigo_vacante = $ultimo_texto;

				$vacante = $this->ChatbotModel->getVacanteByCodigo($codigo_vacante); // <-- necesitas crear este método si no existe

				if (!is_null($vacante)) {
					$validarPostulacion = $this->ChatbotModel->validarPostulacionByCodigo($codigo_vacante, $id_candidato);

					if (!is_null($validarPostulacion)) {
						$id_vacante     = $vacante->id_vacante;
						$id_categoria   = $vacante->id_categoria;
						$nombre_vacante = $vacante->nombre;
						$desc_vacante   = $vacante->descripcion;
						$respuesta      = 200;
					} else {
						$respuesta = 300;
					}
				}
			}
		}

		return array(
			"respuesta"      => $respuesta,
			"id_vacante"     => $id_vacante,
			"id_categoria"   => $id_categoria,
			"id_reclutador"  => $id_reclutador,
			"nombre_vacante" => $nombre_vacante,
			"desc_vacante"   => $desc_vacante
		);
	}//termina vacanteQr

	// public function vacanteQr($mensaje_whats, $cel, $nombre_c, $id_candidato){

	// 	$respuesta      = 400;
	// 	$id_vacante     = 0;
	// 	$id_categoria   = 0;
	// 	$id_reclutador  = 0;
	// 	$nombre_vacante = "";
	// 	$desc_vacante   = "";

	// 	$ultima_posicion_espacio 	= strrpos($mensaje_whats, ' ');

	// 	if ($ultima_posicion_espacio !== false) {
	// 		// Obtener el texto que sigue al último espacio
	// 		$ultimo_texto 		= substr($mensaje_whats, $ultima_posicion_espacio + 1);
	// 		$explode_espacio   	= explode(";", $ultimo_texto);

	// 		if(count($explode_espacio) > 1){

	// 			$codigo_vacante 	=  $explode_espacio[0];
	// 			$codigo_reclutador 	=  $explode_espacio[1];

	// 			$vacanteReclutador	= $this->ChatbotModel->getVacanteReclutadorByCodigos($codigo_vacante, $codigo_reclutador);

	// 			if(!is_null($vacanteReclutador)){

	// 				$validarPostulacion     	= $this->ChatbotModel->validarPostulacionByCodigo($codigo_vacante, $id_candidato);
	
	// 				if(!is_null($validarPostulacion)){// TODO OK
		
	// 					$id_vacante   = $vacanteReclutador->id_vacante;
	// 					$id_categoria = $vacanteReclutador->id_categoria;

	// 					if($vacanteReclutador->estatus_reclutador == 1){
	// 						$id_reclutador = $vacanteReclutador->id_reclutador;
	// 					}

	// 					$nombre_vacante = $vacanteReclutador->nombre;
	// 					$desc_vacante   = $vacanteReclutador->descripcion;
		
	// 					$respuesta = 200;
			
	// 				}else {// YA SE POSTULÓ A ESTA VACANTE
		
	// 					$respuesta 		= 300;
		
	// 				}
	
	// 			}//termina getVacanteReclutadorByCodigos

	// 		}//termina count($explode) > 1
			
	// 	}//termina validar última posición de espacio

	// 	return (array("respuesta" => $respuesta, "id_vacante" => $id_vacante, "id_categoria" => $id_categoria, "id_reclutador" => $id_reclutador, "nombre_vacante" => $nombre_vacante, "desc_vacante" => $desc_vacante));
	
	// }//termina vacanteQr

	public function preguntas_vacante($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante, $id_reclutador, $total_p, $count, $viable){

		sleep(1);

		$limit        					= $total_p;
		$pregunta     					= $this->ChatbotModel->getPreguntaVacanteLimit($id_vacante, $limit);

		$num          					= $limit + 1;
		$pregunta_dos 					= "";
		$id_pp        					= 0;

		$limit_ant    					= $limit - 1;
		$p_anterior   					= $this->ChatbotModel->getPreguntaVacanteLimit($id_vacante, $limit_ant);

		$id_pregunta_siguiente    		= NULL;
		$pregunta_siguiente       		= NULL;
		$pdf_pregunta_siguiente       	= NULL;
		$tipo_respuesta_siguiente 		= NULL;

		if(!is_null($pregunta)){
			$id_pregunta_siguiente    	= $pregunta->id_pregunta_vacante;
			$pregunta_siguiente       	= $pregunta->pregunta;
			$pdf_pregunta_siguiente     = $pregunta->pdf_pregunta;
			$tipo_respuesta_siguiente 	= $pregunta->tipo_respuesta;
		}


		if(!is_null($p_anterior)){
			$id_pp             = $p_anterior->id_pregunta_vacante;
			$pregunta_anterior = $p_anterior->pregunta;
			$id_tipo_respuesta = $p_anterior->tipo_respuesta;
		}

		$respuesta_c = $this->ChatbotModel->getRespuestaCandidato($id_pp, $id_candidato);

		if($id_tipo_respuesta == 1){//si el tipo de respuesta es igual a 1  (tipo texto)

			if(is_null($respuesta_c)){// si es null insertamos la respuesta

				$insert_v                        	= array();
				$insert_v["respuesta"]           	= $mensaje_whats;
				$insert_v["id_pregunta_vacante"] 	= $id_pp;
				$insert_v["id_candidato"]        	= $id_candidato;
				$insert_v["fecha"]               	= $tiempo;
				$this->ChatbotModel->insertRespuestaVacante($insert_v);

			}else{

				$update_rc 							= array();
				$update_rc["respuesta"] 			= $mensaje_whats;
				$update_rc["fecha"]     			= $tiempo;
				$this->ChatbotModel->updateRespuestaVacante($id_pp, $id_candidato, $update_rc);

			}

			if($count == $limit){

				if(is_null($this->ChatbotModel->existePostulacion($id_candidato, $id_vacante))){

					if($viable == 1){//SI ES VIABLE

						$message = "¡Tenemos tus datos completos! 😁";
						$this->mensaje_bot($message,$cel);
						sleep(0.5);

						$vacante = $this->ChatbotModel->getVacanteById($id_vacante);

						if(!is_null($vacante)){//SE MANDA MENSAJE PERSONALIZADO DE VACANTE
							if(!is_null($vacante->mensaje_viable) && $vacante->mensaje_viable != ""){
								$message = $vacante->mensaje_viable;
								$this->mensaje_bot($message,$cel);
							}
						}

						if($id_reclutador > 0){//se envia imagen y mensaje extra en caso de llegar por qr reclutador
							// $url_imagen_reclutador = "https://raasmex.com.mx/medina_consultores/public/images/reclutador_rocio_contreras.png";
							// $caption               = "";
							// sleep(0.5);
							// $this->mensaje_image($cel, $url_imagen_reclutador, $caption);
						}

						$message = "Comparte nuestro contacto para llegar a más candidatos.";
						sleep(1);
						$this->mensaje_bot($message,$cel);

						if(is_null($this->ChatbotModel->existeTicket($cel))){

							$correos_notificacion = "sales@raasmex.com";
							if($id_reclutador == 0){// si no trae reclutador ejecutamos sp para mover carrusel y asignarle uno
								$usuario_carrusel = $this->ChatbotModel->getCarruselVacante($id_vacante);
								if(!is_null($usuario_carrusel)){
									$id_reclutador         = $usuario_carrusel->id_reclutador;
									$correos_notificacion .= ",".$usuario_carrusel->correo;
								}
							}else {
								$tiene_permiso = $this->ChatbotModel->getUsuarioAsignadoVacante($id_reclutador, $id_vacante);
								if(!is_null($tiene_permiso)){// reclutador que viene de qr y si tiene permisos para ver la vacante en el backend
									$correos_notificacion .= ",".$tiene_permiso->correo;
								}else {// reclutador no tiene permiso para ver la vacante, ejecutamos sp y recorremos carrusel
									$usuario_carrusel = $this->ChatbotModel->getCarruselVacante($id_vacante);
									if(!is_null($usuario_carrusel)){
										$id_reclutador         = $usuario_carrusel->id_reclutador;
										$correos_notificacion .= ",".$usuario_carrusel->correo;
									}
								}
							}

							$insert_t               = array();
							$insert_t["celular"]    = $cel;
							$insert_t["id_vacante"] = $id_vacante;
							$id_ticket              = $this->ChatbotModel->insertTicket($insert_t);

							$update_pre                 = array();
							$update_pre["conversacion"] = 2;
							$update_pre["id_ticket"]    = $id_ticket;
							$this->ChatbotModel->updatePregunta($cel, $update_pre);

							$this->insertTicketFirestore($cel, $nombre_c, $tiempo, $id_ticket, $id_reclutador, $id_vacante);

						}

					}else {//NO ES VIABLE

						$message = "Muchas gracias, revisaremos tu información y en caso de ser un candidato viable nos comunicaremos contigo.";
						$this->mensaje_bot($message,$cel);

					}


					$insert_vc               				= array();
					$insert_vc["id_vacante"]       			= $id_vacante;	
					$insert_vc["id_candidato"]       		= $id_candidato;
					$insert_vc["id_reclutador"]       		= $id_reclutador;
					$insert_vc["es_viable"]       			= $viable;
					$this->ChatbotModel->insertVacanteCandidatoReclutador($insert_vc);

					$update_pre								= array();
					$update_pre["pregunta_7"]    			= "FIN";
					$update_pre["pregunta_8"]    			= "FIN";
					$update_pre["pregunta_9"]    			= "FIN";
					$update_pre["pregunta_10"]    			= "FIN";
					$update_pre["pregunta_11"]    			= "FIN";
					$update_pre["pregunta_12"]    			= "FIN";
					$update_pre["pregunta_13"]    			= "FIN";
					$update_pre["fecha_ultima"] 			= $tiempo;
					$update_pre["postulacion_completa"]		= 1;
					$update_pre["cron_postulacion"]			= 1;
					$this->ChatbotModel->updatePregunta($cel, $update_pre);

					$vacante								= $this->ChatbotModel->getVacanteById($id_vacante);

					if(!is_null($vacante)){// ACTUALIZAR POSTULACIONES EN VACANTE

						$postulados 						= $vacante->postulados;
						$postulados 						= $postulados + 1;

						$update_v							= array();
						$update_v["postulados"]    			= $postulados;
						$this->ChatbotModel->updateVacante($id_vacante, $update_v);
						
					}

					if($viable == 1){//SI ES VIABLE
						// AQUÍ SE ENVÍA CORREO POSTULACIÓN
						$this->correoPostulacion($id_candidato, $id_vacante, $correos_notificacion);
					}

				}

			}else{

				if(!is_null($pdf_pregunta_siguiente) && $pdf_pregunta_siguiente != ""){//Si pregunta tiene pdf se manda
					$extension = $this->obtenerExtensionURL($pdf_pregunta_siguiente);
					if($extension == "pdf"){
						$filename 	= "ARCHIVO";
						$this->mensaje_file($cel, $pdf_pregunta_siguiente, $filename);
						sleep(1);
					}else {
						$caption = "";
						$this->mensaje_image($cel, $pdf_pregunta_siguiente, $caption);
						sleep(1);
					}
				}
			
				$opcion_multiple = $this->ChatbotModel->getOpcionesMultiple($id_pregunta_siguiente);

				$multiple = "";
				$cont_m   = 1;
				if(!is_null($opcion_multiple)){
					foreach ($opcion_multiple as $k) {
						$multiple.= "*" . $cont_m . ".*" . " " . $k->opcion . "\n";
						$cont_m++;
					}
				}

				$message = "".$pregunta_siguiente." *(".$num."/".$count.")*

".$multiple."";

				$update_pre							= array();
				$update_pre["tot_preguntas"] 		= $limit;
				$update_pre["fecha_ultima"] 		= $tiempo;
				$update_pre["postulacion_completa"]	= 0;
				$update_pre["cron_postulacion"]		= 0;
				$this->ChatbotModel->updatePregunta($cel, $update_pre);

				$this->mensaje_bot($message,$cel);

			}

		}else if($id_tipo_respuesta == 2){ // SI es opciones multiple

			$this->respuestaOpcionMultiple($mensaje_whats, $nombre_c, $id_pp, $id_candidato, $tiempo, $id_pregunta_siguiente, $count, $limit, $cel,
			 $pregunta_siguiente, $pdf_pregunta_siguiente, $tipo_respuesta_siguiente, $id_vacante, $id_reclutador, $pregunta_anterior, $total_p, $viable);

		}

	}//termina preguntas_vacante

	public function respuestaOpcionMultiple($mensaje_whats, $nombre_c, $id_pp, $id_candidato, $tiempo, $id_pregunta_siguiente, $count, $limit, $cel, 
	$pregunta_siguiente, $pdf_pregunta_siguiente, $tipo_respuesta_siguiente, $id_vacante, $id_reclutador, $pregunta_anterior, $total_p, $viable){

		sleep(1);

		$respuesta_c        = $this->ChatbotModel->getRespuestaCandidato($id_pp, $id_candidato);
		$opcionesM          = $this->ChatbotModel->getOpcionesMultiple($id_pp);
		$i_cont             = 1;
		$respuesta          = 500;
		$id_opcion_multiple = 0;
		$opcion             = "";
		
		$num                = $limit + 1;

		$multi              = "";

		$mensaje_w          = strtoupper($mensaje_whats);
		$mensaje_w          = $this->quitar_tildes($mensaje_w);

		if (!is_null($opcionesM)) {
			foreach($opcionesM as $v) {

				$multi .= "*" . $i_cont . ".*" . " " . $v->opcion . "\n";

				$arreglo = array(''.strtolower(ltrim($this->quitar_tildes($v->opcion))).'',$i_cont);
				list($return, $palabra) = $this->palabra_clave($arreglo, $mensaje_w);

				if($return){
					$respuesta          = 200;
					$opcion             = $v->opcion;
					$id_opcion_multiple = $v->id_opcion_multiple;

				if ($v->descarte == 1 && $viable == 1) {
					$viable				 = 2;
					$update_pv           = array();
					$update_pv["viable"] = 2;
					$this->ChatbotModel->updatePregunta($cel,$update_pv);
				}

				break;
				}
								
				$i_cont++;
			} //termina foreach

		} //termina if null

		if($respuesta == 200){

			if(is_null($respuesta_c)){// si es null insertamos la respuesta

				$insert_v                        	= array();
				$insert_v["respuesta"]           	= $opcion;
				$insert_v["id_pregunta_vacante"] 	= $id_pp;
				$insert_v["id_candidato"]        	= $id_candidato;
				$insert_v["fecha"]               	= $tiempo;
				$this->ChatbotModel->insertRespuestaVacante($insert_v);

			}else{

				$update_rc 							= array();
				$update_rc["respuesta"] 			= $opcion;
				$update_rc["fecha"]     			= $tiempo;
				$this->ChatbotModel->updateRespuestaVacante($id_pp, $id_candidato, $update_rc);

			}

			if($count == $limit){

				if(is_null($this->ChatbotModel->existePostulacion($id_candidato, $id_vacante))){

					if($viable == 1){//SI ES VIABLE

						$message = "¡Tenemos tus datos completos! 😁";
						$this->mensaje_bot($message,$cel);
						sleep(0.5);
						
						$vacante = $this->ChatbotModel->getVacanteById($id_vacante);

						if(!is_null($vacante)){//SE MANDA MENSAJE PERSONALIZADO DE VACANTE
							if(!is_null($vacante->mensaje_viable) && $vacante->mensaje_viable != ""){
								$message = $vacante->mensaje_viable;
								$this->mensaje_bot($message,$cel);
							}
						}

						if($id_reclutador > 0){//se envia imagen y mensaje extra en caso de llegar por qr reclutador
							// $url_imagen_reclutador = "https://raasmex.com.mx/medina_consultores/public/images/reclutador_rocio_contreras.png";
							// $caption               = "";
							// sleep(0.5);
							// $this->mensaje_image($cel, $url_imagen_reclutador, $caption);
						}

						$message = "Comparte nuestro contacto para llegar a más candidatos.";
						sleep(1);
						$this->mensaje_bot($message,$cel);

						if(is_null($this->ChatbotModel->existeTicket($cel))){

							$correos_notificacion = "sales@raasmex.com";
							if($id_reclutador == 0){// si no trae reclutador ejecutamos sp para mover carrusel y asignarle uno
								$usuario_carrusel = $this->ChatbotModel->getCarruselVacante($id_vacante);
								if(!is_null($usuario_carrusel)){
									$id_reclutador         = $usuario_carrusel->id_reclutador;
									$correos_notificacion .= ",".$usuario_carrusel->correo;
								}
							}else {
								$tiene_permiso = $this->ChatbotModel->getUsuarioAsignadoVacante($id_reclutador, $id_vacante);
								if(!is_null($tiene_permiso)){// reclutador que viene de qr y si tiene permisos para ver la vacante en el backend
									$correos_notificacion .= ",".$tiene_permiso->correo;
								}else {// reclutador no tiene permiso para ver la vacante, ejecutamos sp y recorremos carrusel
									$usuario_carrusel = $this->ChatbotModel->getCarruselVacante($id_vacante);
									if(!is_null($usuario_carrusel)){
										$id_reclutador         = $usuario_carrusel->id_reclutador;
										$correos_notificacion .= ",".$usuario_carrusel->correo;
									}
								}
							}

							$insert_t               = array();
							$insert_t["celular"]    = $cel;
							$insert_t["id_vacante"] = $id_vacante;
							$id_ticket              = $this->ChatbotModel->insertTicket($insert_t);

							$update_pre                 = array();
							$update_pre["conversacion"] = 2;
							$update_pre["id_ticket"]    = $id_ticket;
							$this->ChatbotModel->updatePregunta($cel, $update_pre);

							$this->insertTicketFirestore($cel, $nombre_c, $tiempo, $id_ticket, $id_reclutador, $id_vacante);

						}

					}else {//NO ES VIABLE

						$message = "Muchas gracias, revisaremos tu información y en caso de ser un candidato viable nos comunicaremos contigo.";
						$this->mensaje_bot($message,$cel);

					}

					$insert_vc               				= array();
					$insert_vc["id_vacante"]       			= $id_vacante;	
					$insert_vc["id_candidato"]       		= $id_candidato;
					$insert_vc["id_reclutador"]       		= $id_reclutador;
					$insert_vc["es_viable"]       			= $viable;
					$this->ChatbotModel->insertVacanteCandidatoReclutador($insert_vc);

					$update_pre								= array();
					$update_pre["pregunta_7"]    			= "FIN";
					$update_pre["pregunta_8"]    			= "FIN";
					$update_pre["pregunta_9"]    			= "FIN";
					$update_pre["pregunta_10"]    			= "FIN";
					$update_pre["pregunta_11"]    			= "FIN";
					$update_pre["pregunta_12"]    			= "FIN";
					$update_pre["pregunta_13"]    			= "FIN";
					$update_pre["fecha_ultima"] 			= $tiempo;
					$update_pre["postulacion_completa"]		= 1;
					$update_pre["cron_postulacion"]			= 1;
					$this->ChatbotModel->updatePregunta($cel, $update_pre);

					$vacante								= $this->ChatbotModel->getVacanteById($id_vacante);

					if(!is_null($vacante)){// ACTUALIZAR POSTULACIONES EN VACANTE

						$postulados 						= $vacante->postulados;
						$postulados 						= $postulados + 1;

						$update_v							= array();
						$update_v["postulados"]    			= $postulados;
						$this->ChatbotModel->updateVacante($id_vacante, $update_v);
						
					}

					if($viable == 1){//SI ES VIABLE
						// AQUÍ SE ENVÍA CORREO POSTULACIÓN
						$this->correoPostulacion($id_candidato, $id_vacante, $correos_notificacion);
					}

				}

			}else{

				if(!is_null($pdf_pregunta_siguiente) && $pdf_pregunta_siguiente != ""){//Si pregunta tiene pdf se manda
					$extension = $this->obtenerExtensionURL($pdf_pregunta_siguiente);
					if($extension == "pdf"){
						$filename 	= "ARCHIVO";
						$this->mensaje_file($cel, $pdf_pregunta_siguiente, $filename);
						sleep(1);
					}else {
						$caption = "";
						$this->mensaje_image($cel, $pdf_pregunta_siguiente, $caption);
						sleep(1);
					}
				}

				$opcion_multiple = $this->ChatbotModel->getOpcionesMultiple($id_pregunta_siguiente);

				$multiple = "";
				$cont_m   = 1;
				if(!is_null($opcion_multiple)){
					foreach ($opcion_multiple as $k) {
						$multiple.= "*" . $cont_m . ".*" . " " . $k->opcion . "\n";
						$cont_m++;
					}

				}

				$message = "".$pregunta_siguiente." *(".$num."/".$count.")*

".$multiple."";

				$update_pre							= array();
				$update_pre["tot_preguntas"] 		= $limit;
				$update_pre["fecha_ultima"] 		= $tiempo;
				$update_pre["postulacion_completa"]	= 0;
				$update_pre["cron_postulacion"]		= 0;
				$this->ChatbotModel->updatePregunta($cel, $update_pre);

				$this->mensaje_bot($message,$cel);

			}

		}else{

			$message   = "❌ Lo siento, esta es una respuesta incorrecta. Por favor escribe el número de tu opción preferida:

".$pregunta_anterior." *(".$limit."/".$count.")*

".$multi."";

			$this->mensaje_bot($message,$cel);

		}

	}//termina respuestaOpcionMultiple

	public function pregunta8_no_encontre_vacante($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante){

		if(strlen($mensaje_whats) > 5){

			$message = "Lamentamos el no puedas acudir, si requieres ver más vacantes no dudes en escribirme.";
			$this->mensaje_bot($message,$cel);
	
			$update_pre                 		= array();
			$update_pre["pregunta_7"]   		= "FIN";
			$update_pre["pregunta_8"]   		= "FIN";
			$update_pre["pregunta_9"]   		= "FIN";
			$update_pre["pregunta_10"]   		= "FIN";
			$update_pre["pregunta_11"]   		= "FIN";
			$update_pre["pregunta_12"]   		= "FIN";
			$update_pre["pregunta_13"]   		= "FIN";
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 1;
			$update_pre["cron_postulacion"]		= 1;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);
	
			$insert_ncp						= array();
			$insert_ncp["motivo"]			= $mensaje_whats;
			$insert_ncp["id_candidato"]		= $id_candidato;
			$insert_ncp["id_vacante"]		= $id_vacante;
			$this->ChatbotModel->insertNoContinuoProceso($insert_ncp);

		}else {

			$message = "❌ Lo siento, este texto es demasiado corto. Por favor escribe un motivo más largo.";
			$this->mensaje_bot($message,$cel);

		}

	}//termina pregunta8_no_encontre_vacante

	public function pregunta7_no_encontre_vacante($mensaje_whats, $valor_list, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante){

		if(!is_null($valor_list)){

			$mensaje_w                	= $this->quitar_tildes(strtoupper($valor_list));

			$arreglo_1                	= array('opcion_1');
			list($return_1, $palabra) 	= $this->palabra_clave($arreglo_1, $mensaje_w);

			$arreglo_2                	= array('opcion_2');
			list($return_2, $palabra) 	= $this->palabra_clave($arreglo_2, $mensaje_w);

			$arreglo_3                	= array('opcion_3');
			list($return_3, $palabra) 	= $this->palabra_clave($arreglo_3, $mensaje_w);

			$arreglo_4                	= array('opcion_4');
			list($return_4, $palabra) 	= $this->palabra_clave($arreglo_4, $mensaje_w);

			$arreglo_5                	= array('opcion_5');
			list($return_5, $palabra) 	= $this->palabra_clave($arreglo_5, $mensaje_w);

			$motivo = "";

			if ($return_1) {
				$motivo = "Sueldo";
			}else if ($return_2) {
				$motivo = "Prestaciones";
			}else if ($return_3) {
				$motivo = "Turnos";
			}else if ($return_4) {
				$motivo = "Transporte";
			}else if ($return_5) {
				$motivo = "Otro";
			}

			if ($motivo != "") {

				if($motivo == "Otro"){

					$message = "Puedes específicar el motivo por favor:";
					$this->mensaje_bot($message,$cel);

					$update_pre                 		= array();
					$update_pre["pregunta_8"]   		= "MOTIVO";
					$update_pre["fecha_ultima"] 		= $tiempo;
					$update_pre["postulacion_completa"]	= 0;
					$update_pre["cron_postulacion"]		= 0;
					$this->ChatbotModel->updatePregunta($cel, $update_pre);

				}else {

					$message = "Lamentamos el no puedas acudir, si requieres ver más vacantes no dudes en escribirme.";
					$this->mensaje_bot($message,$cel);

					$update_pre                 		= array();
					$update_pre["pregunta_7"]   		= "FIN";
					$update_pre["pregunta_8"]   		= "FIN";
					$update_pre["pregunta_9"]   		= "FIN";
					$update_pre["pregunta_10"]   		= "FIN";
					$update_pre["pregunta_11"]   		= "FIN";
					$update_pre["pregunta_12"]   		= "FIN";
					$update_pre["pregunta_13"]   		= "FIN";
					$update_pre["fecha_ultima"] 		= $tiempo;
					$update_pre["postulacion_completa"]	= 1;
					$update_pre["cron_postulacion"]		= 1;
					$this->ChatbotModel->updatePregunta($cel, $update_pre);

					$insert_ncp						= array();
					$insert_ncp["motivo"]			= $motivo;
					$insert_ncp["id_candidato"]		= $id_candidato;
					$insert_ncp["id_vacante"]		= $id_vacante;
					$this->ChatbotModel->insertNoContinuoProceso($insert_ncp);

				}

			}else{

				$message = "❌ Lo siento, no entendí tu respuesta. Por favor selecciona una opción de la siguiente lista 👇";
				$this->mensaje_bot($message,$cel);

				sleep(1);

				$this->generarLista(2, $cel);
				
			}

		}else {

			$message = "❌ Lo siento, no entendí tu respuesta. Por favor selecciona una opción de la siguiente lista 👇";
			$this->mensaje_bot($message,$cel);

			sleep(1);

			$this->generarLista(2, $cel);

		}


	}//termina pregunta7_no_encontre_vacante

	public function pregunta7($mensaje_whats, $title_button, $cel, $nombre_c, $tiempo, $id_vacante){
		
		$mensaje_w                = $this->quitar_tildes(strtoupper($title_button));

		$arreglo_1                = array('si, claro','si','1','(1)','one','uno');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);

		$arreglo_2                = array('no, no quiero', 'no','2','(2)','two','dos');
		list($return_2, $palabra) = $this->palabra_clave($arreglo_2, $mensaje_w);

		if ($return_1) {

			$getCountPreguntas  = $this->ChatbotModel->getCountPreguntas($id_vacante);
			$count				= $getCountPreguntas->tot;
			$limit        		= 0;
			$pregunta     		= $this->ChatbotModel->getPreguntaVacanteLimit($id_vacante, $limit);
			$nom_pregunta 		= "NA";
			$pdf_pregunta 		= "";

			$message 			= "";

			if(!is_null($pregunta)){

				$id_pregunta_vacante = $pregunta->id_pregunta_vacante;
				$nom_pregunta        = $pregunta->pregunta;
				$pdf_pregunta        = $pregunta->pdf_pregunta;

				$opcion_multiple = $this->ChatbotModel->getOpcionesMultiple($id_pregunta_vacante);

				$multiple = "";
				$cont_m   = 1;
				if(!is_null($opcion_multiple)){
					foreach ($opcion_multiple as $k) {
						$multiple.= "*" . $cont_m . ".*" . " " . $k->opcion . "\n";
						$cont_m++;
					}//foreach
				}//is_null opcion_multiple

				if(!is_null($pdf_pregunta) && $pdf_pregunta != ""){//Si pregunta tiene pdf se manda
					$extension = $this->obtenerExtensionURL($pdf_pregunta);
					if($extension == "pdf"){
						$filename 	= "ARCHIVO";
						$this->mensaje_file($cel, $pdf_pregunta, $filename);
						sleep(1);
					}else {
						$caption = "";
						$this->mensaje_image($cel, $pdf_pregunta, $caption);
						sleep(1);
					}
				}

				$message = "¡Gracias por tu interés en esta vacante! 🙌

A continuación, te haré algunas preguntas para conocer mejor tu perfil y saber si esta oportunidad es ideal para ti.

Por favor, responde con el número de la opción que mejor se adapte a tu experiencia. 😊

".$nom_pregunta." *(1/".$count.")*

".$multiple."";

			}//termina is_null

			$this->mensaje_bot($message,$cel);

			$update_pre                 		= array();
			$update_pre["pregunta_7"]   		= "PREGUNTAS";
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel,$update_pre);

		}else if ($return_2) {

			$this->generarLista(2, $cel);

			$update_pre                 		= array();
			$update_pre["pregunta_7"]   		= "NO_CONTINUA_PROCESO";
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);

		}else{

			$message = '❌ Lo siento, no entendí tu respuesta.';
			$this->mensaje_bot($message,$cel);

			sleep(1);

			$cabecera = "";
			$mensaje  = "¿Te gustaría continuar con el proceso?";
			$pie      = "Oprime el botón de tu preferencia";

			$options[] = array('type' => 'text', 'title' => 'No', "encodeText" => true);
			$options[] = array('type' => 'text', 'title' => 'Sí', "encodeText" => true);
			$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

		}

	}//termina pregunta7

	public function pregunta6_no_encontre_vacante($mensaje_whats, $file, $title_button, $cel, $nombre_c, $tiempo, $id_candidato, $id_ciudad, $id_categoria){

		$mensaje_w = $this->quitar_tildes(strtoupper($title_button));

		$arreglo_regresar                     = array("regresar");
		list($return_atras, $palabra_vacante) = $this->palabra_clave($arreglo_regresar, $mensaje_w);

		if ($return_atras) {

			$vacantes 	= $this->ChatbotModel->getVacantesByCategoria($id_categoria);
			$mnsj_v     = "";
			$cont       = 1;

			if(!is_null($vacantes)){
		
				foreach ($vacantes as $v) {
					
					$vacante 	= $v->nombre;
					$mnsj_v   	.= "*(".$cont.")* ".$vacante." \n";
					$cont++;

				}//foreach

				$mnsj_v   .= "
*(".$cont.")* Regresar al menú anterior \n";

				$cont++;

				$mnsj_v   .= "
*(".$cont.")* 👷‍♂️ ¿No encontraste una vacante que se adecua a tu perfil? \n";

				$message = "Perfecto!, estas son las *vacantes* disponibles que tenemos a y a las que puedes aplicar, escribe la opción de tu preferencia:

".$mnsj_v."
_Responde solo con el número de la opción de tu preferencia._";

				$this->mensaje_bot($message,$cel);

			}

			$update_pre                 		= array();
			$update_pre["pregunta_6"]   		= NULL;
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);
			
		}else{

			if(!is_null($file)){

				$extension = $this->obtenerExtension($file);

				if($extension == "pdf"){

					$nombre_archivo = $cel.'.'.$extension;
					$url = $file;
	
					$file_path = "public/cv/".$nombre_archivo;
	
					if($this->fileDownload($url, $file_path)){
	
						$message = "¡Muchas gracias! En cuanto tengamos alguna vacante adecuada para ti nos pondremos en contacto.";
						$this->mensaje_bot($message,$cel);
	
						$update_c						= array();
						$update_c["cv_candidato"]		= base_url()."public/cv/".$cel.".".$extension;	
						$this->ChatbotModel->updateCandidato($id_candidato, $update_c);
	
						$update_pre							= array();
						$update_pre["pregunta_6"]    		= "FIN";
						$update_pre["pregunta_7"]    		= "FIN";
						$update_pre["pregunta_8"]    		= "FIN";
						$update_pre["pregunta_9"]    		= "FIN";
						$update_pre["pregunta_10"]    		= "FIN";
						$update_pre["pregunta_11"]    		= "FIN";
						$update_pre["pregunta_12"]    		= "FIN";
						$update_pre["pregunta_13"]    		= "FIN";
						$update_pre["postulacion_completa"]	= 1;
						$update_pre["cron_postulacion"]		= 1;
						$update_pre["fecha_ultima"] 		= $tiempo;
						$this->ChatbotModel->updatePregunta($cel, $update_pre);
	
					}else{
	
						$message 	= "❌ Lo siento, este formato es incorrecto.";
						$this->mensaje_bot($message,$cel);
		
						sleep(1);
		
						$cabecera 	= "";
						$mensaje  	= "Por favor envíame tu *CV* en formato *PDF*";
						$pie      	= "Oprime el botón para seleccionar otra vacante";
			
						$options[] 	= array('type' => 'text', 'title' => 'Regresar', "encodeText" => true);
						$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);
	
					}

				}else {

					$message 	= "❌ Lo siento, este formato es incorrecto.";
					$this->mensaje_bot($message,$cel);
	
					sleep(1);
	
					$cabecera 	= "";
					$mensaje  	= "Por favor envíame tu *CV* en formato *PDF*";
					$pie      	= "Oprime el botón para seleccionar otra vacante";
		
					$options[] 	= array('type' => 'text', 'title' => 'Regresar', "encodeText" => true);
					$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

				}

			}else{

				$message 	= "❌ Lo siento, este formato es incorrecto.";
				$this->mensaje_bot($message,$cel);

				sleep(1);

				$cabecera 	= "";
				$mensaje  	= "Por favor envíame tu *CV* en formato *PDF*";
				$pie      	= "Oprime el botón para seleccionar otra vacante";
	
				$options[] 	= array('type' => 'text', 'title' => 'Regresar', "encodeText" => true);
				$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

			}
		
		} //termina else regresar


	}//termina pregunta6_no_encontre_vacante

	public function pregunta6($mensaje_whats, $cel, $nombre_c, $tiempo, $id_ciudad, $id_categoria, $id_candidato){

		$mensaje_w  			= strtolower($this->quitar_tildes($mensaje_whats));
		$vacantes 				= $this->ChatbotModel->getVacantesByCategoria($id_categoria);
		$mnsj       			= "";
		$vacante_msj			= "";
		$nombre_vacante			= "";
		$descripcion_vacante	= "";
		$cont       			= 1;
		$respuesta  			= 400;
		$id_vacante     		= 0;

		if(!is_null($vacantes)){

			foreach ($vacantes as $v) {

				$nombre_vacante  = strtolower($this->quitar_tildes($v->nombre));
				$vacante_msj     = $v->nombre;
				$mnsj           .= "*(".$cont.")* ".$vacante_msj." \n";

				$arreglo                = array($cont, $nombre_vacante);
				list($return, $palabra) = $this->palabra_clave($arreglo, $mensaje_w);

				if($return){
					$id_vacante 			= $v->id_vacante;
					$nombre_vacante 		= $v->nombre;
					$descripcion_vacante 	= $v->descripcion;
					$respuesta 				= 200;
				}//if return

				$cont++;

			}//foreach

			$mnsj   .= "\n*(".$cont.")* Regresar al menú anterior \n";

			$cont++;

			$mnsj   .= "\n*(".$cont.")* 👷‍♂️ ¿No encontraste una vacante que se adecua a tu perfil? \n";

		}//termina categorias

		$arreglo_regresar                	= array('('.($cont - 1).')',''.($cont - 1).'','('.($cont - 1).'',''.($cont - 1).')','regresar al menu anterior','regresar','menu anterior');
		list($return_regresar, $palabra) 	= $this->palabra_clave($arreglo_regresar, $mensaje_w);

		$arreglo_no_encontre                = array('('.$cont.')',''.$cont.'','('.$cont.'',''.$cont.')','no encontre','no hay','no');
		list($return_no_encontre, $palabra) = $this->palabra_clave($arreglo_no_encontre, $mensaje_w);

		if($respuesta == 200){

			$validarPostulacion = $this->ChatbotModel->validarPostulacionById($id_vacante, $id_candidato);

			if(is_null($validarPostulacion)){//AÚN NO SE POSTULA A ESTA VACANTE

				$message = "¡Muchas gracias, ".$nombre_c."! Has seleccionado la vacante *".$nombre_vacante."*, a continuación te muestro la descripción:
			
".$descripcion_vacante."";
				$this->mensaje_bot($message,$cel);

				sleep(1);

				$cabecera 	= "";
				$mensaje  	= "¿Te gustaría continuar con el proceso?";
				$pie      	= "Oprime el botón de tu preferencia";

				$options[] 	= array('type' => 'text', 'title' => 'No', "encodeText" => true);
				$options[] 	= array('type' => 'text', 'title' => 'Sí', "encodeText" => true);
				$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

				$update_pre                 		= array();
				$update_pre["pregunta_6"]   		= $id_vacante;
				$update_pre["id_vacante"]   		= $id_vacante;
				$update_pre["fecha_ultima"] 		= $tiempo;
				$update_pre["postulacion_completa"]	= 0;
				$update_pre["cron_postulacion"]		= 0;
				$this->ChatbotModel->updatePregunta($cel, $update_pre);

			}else {

				$message = "✅ Ya tenemos tus datos registrados en esta vacante. Por favor selecciona otra opción:

".$mnsj."";
				$this->mensaje_bot($message,$cel);

			}
			
		}else if($return_regresar){

			$categorias = $this->ChatbotModel->getCategorias();
			$mnsj       = "";
			$cont       = 1;

			if(!is_null($categorias)){
		
				foreach ($categorias as $v) {
					
					$categoria 	= $v->categoria;
					$mnsj   	.= "*(".$cont.")* ".$categoria." \n";
					$cont++;

				}//foreach

				$mnsj   .= "
*(".$cont.")*  Regresar al menú anterior \n";

			}//termina categorias

			$message = "Por favor selecciona la *categoría* de tu interés:

".$mnsj."
_Responde solo con el número de la opción de tu preferencia._";

			$this->mensaje_bot($message,$cel);

			$update_pre                 		= array();
			$update_pre["pregunta_5"]   		= NULL;
			$update_pre["id_categoria"]   		= 0;
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);
	
		}else if($return_no_encontre){

			$cabecera 	= "";
			$mensaje  	= "Por favor envíame tu *CV* en formato *PDF*";
			$pie      	= "Oprime el botón para seleccionar otra vacante";

			$options[] 	= array('type' => 'text', 'title' => 'Regresar', "encodeText" => true);
			$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

			$update_pre                 		= array();
			$update_pre["pregunta_6"]   		= "NO_ENCONTRE_VACANTE";
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);

		}else{

			$message = "❌ Lo siento no entendí tu respuesta 😞, por favor responde solo con el número de la opción de tu preferencia:

".$mnsj."";
			$this->mensaje_bot($message,$cel);

		}


	}//termina pregunta6

	public function pregunta5($mensaje_whats, $cel, $nombre_c, $tiempo, $id_ciudad){

		$mensaje_w  		= strtolower($this->quitar_tildes($mensaje_whats));
		$categorias 		= $this->ChatbotModel->getCategorias();
		$mnsj       		= "";
		$categoria_msj		= "";
		$nombre_categoria	= "";
		$nombre_categoria_f	= "";
		$cont       		= 1;
		$respuesta  		= 400;
		$id_categoria     	= 0;

		if(!is_null($categorias)){

			foreach ($categorias as $v) {

				$nombre_categoria 	= strtolower($this->quitar_tildes($v->categoria));
				$categoria_msj 		= $v->categoria;
				$mnsj   			.= "*(".$cont.")* ".$categoria_msj." \n";

				$arreglo                = array($cont, $nombre_categoria);
				list($return, $palabra) = $this->palabra_clave($arreglo, $mensaje_w);

				if($return){
					$id_categoria 		= $v->id_categoria;
					$nombre_categoria_f = $v->categoria;
					$respuesta 			= 200;
				}//if return

				$cont++;

			}//foreach

			$mnsj   .= "\n*(".$cont.")* Regresar al menú anterior \n";

		}//termina categorias

		$arreglo_regresar                = array('('.$cont.')',''.$cont.'','('.$cont.'',''.$cont.')','regresar al menu anterior','regresar','menu anterior');
		list($return_regresar, $palabra) = $this->palabra_clave($arreglo_regresar, $mensaje_w);

		if($respuesta == 200){

			$vacantes 	= $this->ChatbotModel->getVacantesByCategoria($id_categoria);
			$mnsj_v     = "";
			$cont       = 1;

			if(!is_null($vacantes)){
		
				foreach ($vacantes as $v) {
					
					$vacante 	= $v->nombre;
					$mnsj_v   	.= "*(".$cont.")* ".$vacante." \n";
					$cont++;

				}//foreach

				$mnsj_v   .= "
*(".$cont.")* Regresar al menú anterior \n";

				$cont++;

				$mnsj_v   .= "
*(".$cont.")* 👷‍♂️ ¿No encontraste una vacante que se adecua a tu perfil? \n";

				$message = "Perfecto!, estas son las *vacantes* disponibles que tenemos a *".$nombre_categoria_f."* y a las que puedes aplicar, escribe la opción de tu preferencia:

".$mnsj_v."
_Responde solo con el número de la opción de tu preferencia._";

				$this->mensaje_bot($message,$cel);

				$update_pre                 		= array();
				$update_pre["pregunta_5"]   		= $id_categoria;
				$update_pre["id_categoria"]   		= $id_categoria;
				$update_pre["fecha_ultima"] 		= $tiempo;
				$update_pre["postulacion_completa"]	= 0;
				$update_pre["cron_postulacion"]		= 0;
				$this->ChatbotModel->updatePregunta($cel, $update_pre);

			}else {

				$message = "❌ Lo siento, por el momento no tenemos vacantes para esta categoría 😞.
				
Por favor prueba con otra categoría/ciudad o vuelve a intentarlo más tarde:

".$mnsj."
_Responde solo con el número de la opción de tu preferencia._";
			$this->mensaje_bot($message,$cel);

			}
			
		}else if($return_regresar){
		
			$this->generarLista(1, $cel);

			$update_pre                 		= array();
			$update_pre["pregunta_3"]   		= NULL;
			$update_pre["pregunta_4"]   		= NULL;
			$update_pre["id_ciudad"]   			= 0;
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);
	
		}else{

			$message = "❌ Lo siento no entendí tu respuesta 😞, por favor responde solo con el número de la opción de tu preferencia:

".$mnsj."";
			$this->mensaje_bot($message,$cel);

		}


	}//termina pregunta5

	public function pregunta4($mensaje_whats, $cel, $nombre_c, $tiempo){

		$mensaje_w  		= strtolower($this->quitar_tildes($mensaje_whats));
		$ciudades 			= $this->ChatbotModel->getCiudades();
		$mnsj       		= "";
		$ciudad_msj			= "";
		$nombre_ciudad		= "";
		$cont       		= 1;
		$respuesta  		= 400;
		$id_ciudad     		= 0;

		if(!is_null($ciudades)){

			foreach ($ciudades as $v) {

				$nombre_ciudad 	= strtolower($v->ciudad);
				$ciudad_msj 	= $v->ciudad;
				$mnsj   		.= "*(".$cont.")* ".$ciudad_msj." \n";

				$arreglo                = array($cont, $nombre_ciudad);
				list($return, $palabra) = $this->palabra_clave($arreglo, $mensaje_w);

				if($return){
					$id_ciudad 	= $v->id_ciudad;
					$respuesta 	= 200;
					break;
				}//if return

				$cont++;

			}//foreach

			$mnsj   .= "\n*(".$cont.")* Regresar al menú anterior \n";

		}//termina ciudades

		$arreglo_regresar                = array('('.$cont.')',''.$cont.'','('.$cont.'',''.$cont.')','regresar al menu anterior','regresar','menu anterior');
		list($return_regresar, $palabra) = $this->palabra_clave($arreglo_regresar, $mensaje_w);

		if($respuesta == 200){

			$categorias = $this->ChatbotModel->getCategorias();
			$mnsj       = "";
			$cont       = 1;

			if(!is_null($categorias)){
		
				foreach ($categorias as $v) {
					
					$categoria 	= $v->categoria;
					$mnsj   	.= "*(".$cont.")* ".$categoria." \n";
					$cont++;

				}//foreach

				$mnsj   .= "
*(".$cont.")*  Regresar al menú anterior \n";

			}//termina categorias

			$message = "Por favor selecciona la *categoría* de tu interés:

".$mnsj."
_Responde solo con el número de la opción de tu preferencia._";

			$this->mensaje_bot($message,$cel);

			$update_pre                 		= array();
			$update_pre["pregunta_4"]   		= $id_ciudad;
			$update_pre["id_ciudad"]   			= $id_ciudad;
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);
			
		}else if($return_regresar){

			$this->generarLista(1, $cel);

			$update_pre                 		= array();
			$update_pre["pregunta_3"]   		= NULL;
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);
	
		}else{

			$message = "❌ Lo siento no entendí tu respuesta 😞, por favor responde solo con el número de la opción de tu preferencia:

".$mnsj."";
			$this->mensaje_bot($message,$cel);

		}


	}//termina pregunta4

	public function pregunta3($mensaje_whats, $valor_list, $cel, $nombre_c, $tiempo, $id_candidato, $id_vacante, $id_categoria, $id_reclutador, $viene_de_qr){

		if(!is_null($valor_list)){

			$mensaje_w                	= $this->quitar_tildes(strtoupper($valor_list));

			$arreglo_1                	= array('opcion_1');
			list($return_1, $palabra) 	= $this->palabra_clave($arreglo_1, $mensaje_w);

			$arreglo_2                	= array('opcion_2');
			list($return_2, $palabra) 	= $this->palabra_clave($arreglo_2, $mensaje_w);

			$arreglo_3                	= array('opcion_3');
			list($return_3, $palabra) 	= $this->palabra_clave($arreglo_3, $mensaje_w);

			$arreglo_4                	= array('opcion_4');
			list($return_4, $palabra) 	= $this->palabra_clave($arreglo_4, $mensaje_w);

			$escolaridad = "";

			if ($return_1) {
				$escolaridad = "Primaria";
			}else if ($return_2) {
				$escolaridad = "Secundaria";
			}else if ($return_3) {
				$escolaridad = "Preparatoria";
			}else if ($return_4) {
				$escolaridad = "Licenciatura";
			}

			if ($escolaridad != "") {

				if($id_vacante > 0){//SI YA SELECCIONO VACANTE POR QR LO POSICIONAMOS

					$vacante = $this->ChatbotModel->getVacanteById($id_vacante);

					if(!is_null($vacante)){

						$nombre_vacante = $vacante->nombre;
						$desc_vacante 	= $vacante->descripcion;

						$message = "¡Muchas gracias, ".$nombre_c."! Has seleccionado la vacante *".$nombre_vacante."*, a continuación te muestro la descripción:
			
".$desc_vacante."";
						$this->mensaje_bot($message,$cel);

						sleep(1);

						$cabecera 	= "";
						$mensaje  	= "¿Te gustaría continuar con el proceso?";
						$pie      	= "Oprime el botón de tu preferencia";

						$options[] 	= array('type' => 'text', 'title' => 'No', "encodeText" => true);
						$options[] 	= array('type' => 'text', 'title' => 'Sí', "encodeText" => true);
						$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

						$update_c							= array();
						$update_c["escolaridad"]			= $escolaridad;
						$this->ChatbotModel->updateCandidato($id_candidato, $update_c);

						$update_pre                         = array();
						$update_pre["pregunta_3"]           = $escolaridad;
						$update_pre["pregunta_4"]           = "SIGUIENTE";
						$update_pre["pregunta_5"]           = $id_categoria;
						$update_pre["pregunta_6"]           = $id_vacante;
						$update_pre["pregunta_7"]           = NULL;
						$update_pre["pregunta_8"]           = NULL;
						$update_pre["pregunta_9"]           = NULL;
						$update_pre["pregunta_10"]          = NULL;
						$update_pre["pregunta_11"]          = NULL;
						$update_pre["pregunta_12"]          = NULL;
						$update_pre["pregunta_13"]          = NULL;
						$update_pre["fecha_ultima"]         = $tiempo;
						$update_pre["tot_preguntas"]        = 0;
						$update_pre["viable"]               = 1;
						$update_pre["postulacion_completa"] = 0;
						$update_pre["cron_postulacion"]     = 0;
						$update_pre["id_categoria"]         = $id_categoria;
						$update_pre["id_vacante"]           = $id_vacante;
						$update_pre["id_reclutador"]        = $id_reclutador;
						$this->ChatbotModel->updatePregunta($cel, $update_pre);

					}

				}else {//SINO QUE SIGA CON FLUJO NORMAL

					$categorias = $this->ChatbotModel->getCategorias();
					$mnsj       = "";
					$cont       = 1;

					if(!is_null($categorias)){
				
						foreach ($categorias as $v) {
							
							$categoria 	= $v->categoria;
							$mnsj   	.= "*(".$cont.")* ".$categoria." \n";
							$cont++;

						}//foreach

						$mnsj   .= "
*(".$cont.")*  Regresar al menú anterior \n";

					}//termina categorias

					$message = "Por favor selecciona la *categoría* de tu interés:

".$mnsj."
_Responde solo con el número de la opción de tu preferencia._";

					$this->mensaje_bot($message,$cel);

	
					$update_c							= array();
					$update_c["escolaridad"]			= $escolaridad;
					$this->ChatbotModel->updateCandidato($id_candidato, $update_c);
					
					$update_pre                 		= array();
					$update_pre["pregunta_3"]   		= $escolaridad;
					$update_pre["pregunta_4"]   		= "SIGUIENTE";
					$update_pre["id_ciudad"]   			= 0;
					$update_pre["fecha_ultima"] 		= $tiempo;
					$update_pre["postulacion_completa"]	= 0;
					$update_pre["cron_postulacion"]		= 0;
					$this->ChatbotModel->updatePregunta($cel, $update_pre);

				}

			}else{

				if($viene_de_qr == 1){

					$message = "Perfecto, para continuar por favor selecciona una opción de la siguiente lista 👇";	
					$this->mensaje_bot($message,$cel);

				}else {

					$message = "❌ Lo siento, no entendí tu respuesta. Por favor selecciona una opción de la siguiente lista 👇";	
					$this->mensaje_bot($message,$cel);

				}

				sleep(1);

				$this->generarLista(1, $cel);
				
			}

		}else {

			if($viene_de_qr == 1){

				$message = "Perfecto, para continuar por favor selecciona una opción de la siguiente lista 👇";	
				$this->mensaje_bot($message,$cel);

			}else {

				$message = "❌ Lo siento, no entendí tu respuesta. Por favor selecciona una opción de la siguiente lista 👇";	
				$this->mensaje_bot($message,$cel);

			}

			sleep(1);

			$this->generarLista(1, $cel);

		}


	}//termina pregunta3

	public function pregunta2($mensaje_whats, $cel, $nombre_c, $tiempo, $id_candidato, $viene_de_qr){

		// Expresiones regulares para encontrar una fecha en el formato 'Y-m-d'
		// $pattern = '/\d{4}-\d{2}-\d{2}/';
		$pattern = '/\b(\d{4}-\d{2}-\d{2}|\d{2}-\d{2}-\d{4}|\d{2}\/\d{2}\/\d{4}|\d{4}\/\d{2}\/\d{2})\b/';

		// Buscar la fecha en el mensaje
		if (preg_match($pattern, $mensaje_whats, $matches)) {

			$resp_fecha = $this->validar_fecha($mensaje_whats);
		
			if ($resp_fecha["respuesta"] == 200) {

				$this->generarLista(1, $cel);

				$mensaje_whats 					= $resp_fecha["fecha"];
	
				$update_c						= array();
				$update_c["fecha_nacimiento"]	= $mensaje_whats;
				$this->ChatbotModel->updateCandidato($id_candidato, $update_c);
				
				$update_pre                 		= array();
				$update_pre["pregunta_2"]   		= $mensaje_whats;
				$update_pre["fecha_ultima"] 		= $tiempo;
				$update_pre["postulacion_completa"]	= 0;
				$update_pre["cron_postulacion"]		= 0;
				$this->ChatbotModel->updatePregunta($cel, $update_pre);
	
			}else {

				if($viene_de_qr == 1){

					$message = "Perfecto, para continuar por favor escribe tu fecha de nacimiento:
	
_Ejemplo: 24-01-1993_";	
					$this->mensaje_bot($message,$cel);

				}else {

					$message = "❌ Lo siento, esta es una fecha incorrecta. Por favor escribe tu fecha de nacimiento:
	
_Ejemplo: 24-01-1993_";	
					$this->mensaje_bot($message,$cel);

				}
	
			}

		}else {

			if($viene_de_qr == 1){

				$message = "Perfecto, para continuar por favor escribe tu fecha de nacimiento:

_Ejemplo: 24-01-1993_";	
				$this->mensaje_bot($message,$cel);

			}else {

				$message = "❌ Lo siento, esta es una fecha incorrecta. Por favor escribe tu fecha de nacimiento:

_Ejemplo: 24-01-1993_";	
				$this->mensaje_bot($message,$cel);

			}

		}

	}//termina pregunta2

	public function pregunta1($mensaje_whats, $cel, $nombre_c, $tiempo, $viene_de_qr){
	// public function pregunta1(){
	// 	$mensaje_whats = 'Daniel López';
	// 	$cel           = '5214423275640';
	// 	$nombre_c      = '';
	// 	$tiempo        = '';
	// 	$viene_de_qr   = 0;

		$nombreFormateado = $this->validarNombre($mensaje_whats);

		if ($nombreFormateado) {

			$candidato	= $this->ChatbotModel->getCandidatoByCel($cel);

			if(is_null($candidato)){
				$insert_p						= array();
				$insert_p["nombre_candidato"]	= $nombreFormateado;
				$insert_p["celular_candidato"]	= $cel;
				$id_candidato 					= $this->ChatbotModel->insertCandidato($insert_p);
			}else {
				$id_candidato					= $candidato->id_candidato;
			}

			$update_pre                 		= array();
			$update_pre["pregunta_1"]   		= "nombre";
			$update_pre["nombre"]       		= $nombreFormateado;
			$update_pre["fecha_ultima"] 		= $tiempo;
			$update_pre["id_candidato"] 		= $id_candidato;
			$update_pre["postulacion_completa"]	= 0;
			$update_pre["cron_postulacion"]		= 0;
			$this->ChatbotModel->updatePregunta($cel, $update_pre);

			$message = "Muchas gracias, ¿cuál es tu fecha de nacimiento?
			
_Ejemplo: 24-01-1993_";
			$this->mensaje_bot($message,$cel);

		}else{

			if($viene_de_qr == 1){

				$message = "👉 Perfecto, para continuar por favor dime tu *nombre completo (nombre y apellidos):*";
				$this->mensaje_bot($message,$cel);

			}else {

				$message = "❌ Lo siento, este es un nombre incorrecto. Por favor escribe tu *nombre con apellidos:*";
				$this->mensaje_bot($message,$cel);

			}

		}


	}//termina pregunta1

	public function pregunta0($mensaje_whats, $cel, $nombre_c, $tiempo, $id_vacante, $id_categoria, $id_reclutador, $viene_de_qr){

		if(is_null($this->ChatbotModel->getPregunta($cel))){

			$insert_pre = array();

			if($id_vacante > 0){
				$insert_pre["pregunta_0"]    = "Bienvenida";
				$insert_pre["celular"]       = $cel;
				$insert_pre["fecha_ultima"]  = $tiempo;
				$insert_pre["fecha_inicio"]  = $tiempo;
				$insert_pre["pregunta_5"]    = $id_categoria;
				$insert_pre["pregunta_6"]    = $id_vacante;
				$insert_pre["id_vacante"]    = $id_vacante;
				$insert_pre["id_categoria"]  = $id_categoria;
				$insert_pre["id_reclutador"] = $id_reclutador;
			}else{ 
				$insert_pre                  = array();
				$insert_pre["pregunta_0"]    = "Bienvenida";
				$insert_pre["celular"]       = $cel;
				$insert_pre["fecha_ultima"]  = $tiempo;
				$insert_pre["fecha_inicio"]  = $tiempo;
			}

			$this->ChatbotModel->insertPregunta($insert_pre);
			
		}

		if($viene_de_qr == 1){

			$message = "¡Hola! 👋 Gracias por escanear nuestro código QR.

Soy *MediBot* 🤖, el asistente virtual de *MEDINA CONSULTORES*, y te voy a ayudar en el proceso para encontrar la mejor vacante para ti.

Antes de empezar, necesito algunos datos básicos para continuar con tu postulación.

🔒 Puedes consultar nuestro Aviso de Privacidad aquí: https://medinaconsultores.mx/aviso-de-privacidad/

👉 Por favor, dime tu *nombre completo (nombre y apellidos):*";

		}else {

			$message = "¡Hola! 👋 Bienvenido a *MEDINA CONSULTORES*.

Soy *MediBot* 🤖, tu asistente virtual, y estoy aquí para ayudarte a encontrar una vacante que se adapte a ti.

Antes de comenzar, necesito algunos datos básicos para tu registro.

🔒 Puedes consultar nuestro Aviso de Privacidad aquí: https://medinaconsultores.mx/aviso-de-privacidad/

👉 Por favor, dime tu *nombre completo (nombre y apellidos):*";

		}

		$this->mensaje_bot($message,$cel);

	}//termina pregunta0

	public function pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $tiempo){

		$categorias = $this->ChatbotModel->getCategorias();
		$mnsj       = "";
		$cont       = 1;

		if(!is_null($categorias)){
	
			foreach ($categorias as $v) {
				
				$categoria 	= $v->categoria;
				$mnsj   	.= "*(".$cont.")* ".$categoria." \n";
				$cont++;

			}//foreach

			$mnsj   .= "
*(".$cont.")*  Regresar al menú anterior \n";

		}//termina categorias

		if($this->quitar_tildes(strtolower($mensaje_whats)) == "medina"){

			$message = "¡Excelente! Por favor selecciona la *categoría* de tu interés:

".$mnsj."
_Responde solo con el número de la opción de tu preferencia._";

		}else {

			$message = "Estamos de regreso, por favor selecciona la *categoría* de tu interés:

".$mnsj."
_Responde solo con el número de la opción de tu preferencia._";

		}

		$this->mensaje_bot($message,$cel);

		$update_pre                         = array();
		$update_pre["pregunta_4"]           = "SIGUIENTE";
		$update_pre["pregunta_5"]           = NULL;
		$update_pre["pregunta_6"]           = NULL;
		$update_pre["pregunta_7"]           = NULL;
		$update_pre["pregunta_8"]           = NULL;
		$update_pre["pregunta_9"]           = NULL;
		$update_pre["pregunta_10"]          = NULL;
		$update_pre["pregunta_11"]          = NULL;
		$update_pre["pregunta_12"]          = NULL;
		$update_pre["pregunta_13"]          = NULL;
		$update_pre["fecha_ultima"]         = $tiempo;
		$update_pre["tot_preguntas"]        = 0;
		$update_pre["viable"]               = 1;
		$update_pre["id_categoria"]         = 0;
		$update_pre["id_ciudad"]            = 0;
		$update_pre["id_vacante"]           = 0;
		$update_pre["id_reclutador"]        = 0;
		$update_pre["postulacion_completa"] = 0;
		$update_pre["cron_postulacion"]     = 0;
		$this->ChatbotModel->updatePregunta($cel, $update_pre);

	}//termina pregunta_reinicio

	public function generarLista($id_menu, $cel){

		$msgid   = "list_".$id_menu;
		$datos   = $this->ChatbotModel->getOpcionesMenu($id_menu);

		if(!is_null($datos)){

			$descripcion_menu = null;
			$body_menu        = null;
			$arreglo_opciones = array();
			$arreglo_final    = array();
			
			foreach ($datos as $v) {

				$descripcion_menu = $v->descripcion_menu;
				$body_menu        = $v->body_menu;

				$type             = $v->type;
				$title            = $v->title;
				$description      = $v->description;
				$postbackText     = $v->postbackText;


				$arreglo_opciones = array(
					"type" => $type,
					"title" => $title,
					"description" => $description,
					"postbackText" => $postbackText,
					"encodeText" => true
				);

				array_push($arreglo_final, $arreglo_opciones);
				
			}//foreach

			$this->lista_mensaje($descripcion_menu, $body_menu, $arreglo_final, $cel, $msgid);

		}//is_null datos

	}//termina generarLista

	public function mensaje_location($longitude,$latitude,$name,$address,$numero){
	
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
			'channel' => 'whatsapp',
			'source' => '5214426445348',
			'destination' => ''.$numero.'',
			'src.name' => 'medinaconsultores',
			'message' => json_encode(
				array(
					'type' 		=> 'location',
					'longitude'	=> $longitude,
					'latitude' 	=> $latitude,
					'name' 		=> $name,
					'address' 	=> $address
				)
			)
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		var_dump($result);

		$array_insert 	= array("longitude" => $longitude, "latitude" => $latitude, "name" => $name, "address" => $address);
		$json_insert  	= json_encode($array_insert);
		$json_insert  	= str_replace('"', "'", $json_insert);

		$this->insertConversacionFirestore(0, NULL, $numero, $json_insert, 2, 8, 0);

	}//termina mensaje_location

	public function mensaje_bot($message,$numero){
	
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
			'channel' => 'whatsapp',
			'source' => '5214426445348',
			'destination' => ''.$numero.'',
			'src.name' => 'medinaconsultores',
			'message' => json_encode(array('type' => 'text', 'text' => $message))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		$message = nl2br($message);

		$this->insertConversacionFirestore(0, NULL, $numero, $message, 2, 0, 0);

	}//termina mensaje_bot

	public function mensaje_image($numero, $url, $caption){

		// $numero		= "5214427791115";
		// // $url		= FCPATH."static/images/1.jpg";
		// $url		= "https://medinaconsultores.com.mx/powerbell/static/imagen_pdf/prueba (1).jpg";
		// $caption	= "Prueba";

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5214426445348',
		    'destination' => ''.$numero.'',
		    'src.name' => 'medinaconsultores',
		    'message' => json_encode(array('type' => 'image', "originalUrl" => $url, "previewUrl" => $url, "caption" => $caption))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		$json = json_decode($result);

		$status = $json->status;

		curl_close($ch);

		// var_dump($json);

		$this->insertConversacionFirestore(0, $url, $numero, NULL, 2, 1, 0);

		if($status == "submitted"){
			return 200;
		}else{
			return 400;
		}

	}//termina mensaje_image

	public function mensaje_file($numero, $url, $filename){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5214426445348',
		    'destination' => ''.$numero.'',
		    'src.name' => 'medinaconsultores',
		    'message' => json_encode(array('type' => 'file', "url" => $url, "filename" => $filename))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		$json = json_decode($result);

		$status = $json->status;

		curl_close($ch);

		// var_dump($json);

		$this->insertConversacionFirestore(0, $url, $numero, NULL, 2, 2, 0);

		if($status == "submitted"){
			return 200;
		}else{
			return 400;
		}

	}//termina mensaje_file

	public function mensaje_boton($numero, $cabecera, $mensaje, $pie, $options){

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5214426445348',
		    'destination' => ''.$numero.'',
		    'src.name' => 'medinaconsultores',
		    'disablePreview' => 'false',
		    'encode' => 'false',
		    'message' => json_encode(array('content' => array('type' => 'text', 'header' => ''.$cabecera.'', 'text' => ''.$mensaje.'', 'caption' => ''.$pie.''), 'type' => 'quick_reply', 'msgid' => 'qr1', 'options' => $options))
		];

		$limpio = array();
	    for ($i = 0; $i < count($options); $i++) {
     		foreach ($options[$i] as $key => $op){
	            if ($key == "title") {
	                $new = array("options" => $op);
	           		array_push($limpio, $new);
	            }
	         }
	    }

		$mensaje 		= nl2br($mensaje);

		$array_insert 	= array("header" => $cabecera, "body" => $mensaje, "foot" => $pie, "options" => $limpio);
		$json_insert  	= json_encode($array_insert);
		$json_insert  	= str_replace('"', "'", $json_insert);

		$this->insertConversacionFirestore(0, NULL, $numero, $json_insert, 2, 4, 0);

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		// var_dump($result);
		curl_close($ch);

	}//termina mensaje_boton

	public function lista_mensaje($title, $body, $opciones, $numero, $msgid){

		// Sólo se pueden 10 arreglos de opciones
		// Sólo se pueden agregar 10
		// $title = 24 caracteres
		// $description = 72 caracteres

		$curl = curl_init();
		$globalButtons[] = array('type' => 'text', 'title' =>  'Opciones');
		$items[] = array('title' => $title, 'subtitle' => '', 'options' => $opciones);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5214426445348',
		    'destination' => ''.$numero.'',
		    'src.name' => 'medinaconsultores',
		    'message' => json_encode(array('type' => 'list', 'title' => $title, 'body' => $body, 'msgid' => $msgid,
		    						'globalButtons' => $globalButtons, 'items' => $items))
		 ];

		 $limpio = array();
		 for ($i = 0; $i < count($opciones); $i++) {
			 foreach ($opciones[$i] as $key => $o) {
				 if($key == "title"){
					 $new = array("option" => $o);
					 array_push($limpio, $new);
				 }
			 }
		 }
 
		 $options_insert = array("options" => $limpio);
		 $array_insert   = array("title" => $title, "options" => $options_insert);
		 $json_insert    = json_encode($array_insert);
		 $json_insert    = str_replace('"', "'", $json_insert);

		 $this->insertConversacionFirestore(0, NULL, $numero, $json_insert, 2, 3, 0);

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api.gupshup.io/wa/api/v1/msg',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS => http_build_query($payload),
		  CURLOPT_HTTPHEADER => array(
		    'Content-Type: application/x-www-form-urlencoded',
		    'apikey: ju1lhtzkkdzibqkolf6jcr6ztyvgoqe6'
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		// var_dump($response);

	}//termina lista_mensaje

	function validarFecha($fecha) {

		$fecha 	= str_replace("/", "-", $fecha);
		// Expresión regular para validar el formato DD-MM-AAAA
		$patron = "/^([0-9]{2})-([0-9]{2})-([0-9]{4})$/";
		
		// Verificar si la fecha coincide con el patrón
		if (preg_match($patron, $fecha, $matches)) {
			// Verificar si la fecha es válida usando checkdate()
			$dia = $matches[1];
			$mes = $matches[2];
			$ano = $matches[3];
			if (checkdate($mes, $dia, $ano)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}//termina validarFecha

	public function validarNombre($nombreCompleto){

		$nombreCompleto = trim($nombreCompleto);

		// Verificar que el texto contenga al menos dos palabras
		if (str_word_count($nombreCompleto) < 3) {
			return false;
		}

		// Verificar que solo contenga letras y espacios
		if (!preg_match("/^[a-zA-ZáéíóúÁÉÍÓÚñÑ\s]+$/", $nombreCompleto)) {
			return false;
		}

		// Convertir a mayúscula la primera letra de cada palabra
		$nombreFormateado = ucwords(strtolower($nombreCompleto));

		return $nombreFormateado;

	}//termina validarNombre

	public function getNombre($mensaje_whats){

		$url = 'https://api.openai.com/v1/completions';

		$headers = array(
			'Content-Type: application/json',
			'Authorization: Bearer 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'
		);

		// $nombre = 'mi nombre es jesus rodriguez morales y estoy interesado en un chatbot';
		// $mensaje_whats = "Me llamo daniel lopez y soy de queretaro";

		$prompt = 'Extrae el nombre de la persona de la siguiente frase: '.$mensaje_whats.', si no es un nombre real regresame NULL\n\n';
		
		$data = array(
			'model' => 'gpt-3.5-turbo-instruct',
			'prompt' => $prompt,
			'temperature' => 0.5,
			'max_tokens' => 256,
			'top_p' => 1,
			'frequency_penalty' => 0,
			'presence_penalty' => 0
		);
		
		$ch = curl_init($url);
		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
		
		$result = curl_exec($ch);

		
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}


		// die(var_dump($result));

		// Manejar el resultado
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		} else {
			// Decodificar el resultado JSON
			$json_decode = json_decode($result);
		
			// Obtener el nombre desde el resultado
			$choices = $json_decode->choices;
			$datos = $choices[0];
			$text = $datos->text;
			// Extraer el nombre
			$nombre = trim($text);		
			// Devolver el nombre
			return $nombre;
		}
		
		// Cerrar la conexión cURL
		curl_close($ch);

	}// termina getNombre

	public function palabra_clave($arreglo, $mensaje_whats){
		$offset = 0;
		$chr = array();
		$palabra = "";
		$return  = false;
		if (array_search(strtolower($mensaje_whats) , $arreglo, false) !== false) {
			$return = true;
		}

		return array(
			$return,
			$palabra
		);

	} //termina funcion palabra_clave

	public function quitar_tildes($cadena){

		$originales  = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ';
		$modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
		$cadena      = utf8_decode($cadena);
		$cadena      = strtr($cadena, utf8_decode($originales) , $modificadas);
		$cadena      = strtolower($cadena);

		return utf8_encode($cadena);

	} //termina quitar_tildes

	public function insertTicketFirestore($cel, $nombre, $fecha, $id_ticket, $id_reclutador, $id_vacante){

		$id_usuario = 0;
		$usuario	= $this->ChatbotModel->getUsuarioByReclutador($id_reclutador);

		if(!is_null($usuario)){
			$id_usuario = $usuario->id_usuario;
		}

		$nombre_vacante = "";
		$vacante        = $this->ChatbotModel->getVacanteById($id_vacante);

		if(!is_null($vacante)){
			$nombre_vacante = $vacante->nombre;
		}

		$update_t               = array();
		$update_t["id_usuario"] = $id_usuario;
		$this->ChatbotModel->updateTicket($id_ticket, $update_t);

		$curl = curl_init();

		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://firestore.googleapis.com/v1/projects/medina-consultores/databases/(default)/documents/ticket?documentId='.$id_ticket.'&key=AIzaSyBuNiBTW2QipNlAzizdANaZqfY6iyRJ7sM',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS =>'{"fields":
			{
			"cel": {"stringValue" : "'.$cel.'"},
			"fecha_registro": {"stringValue" :"'.$fecha.'"},
			"fecha_ultima": {"stringValue" :"'.$fecha.'"},
			"nombre": {"stringValue" :"'.$nombre.'"},
			"cont_msj": {"integerValue" : 0},
			"id_usuario": {"integerValue" : '.$id_usuario.'},
			"conversacion": {"integerValue" : 1},
			"cron_sesion": {"integerValue" : 1},
			"estatus": {"integerValue" : 0},
			"id_vacante": {"integerValue" : '.$id_vacante.'},
			"nombre_vacante": {"stringValue" : "'.$nombre_vacante.'"}
			}
		}

		',
		CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		
		//var_dump($response);

	}//termina insertTicketFirestore

	public function updateTicketFirestore($cel, $fecha, $cont){
		
		$url = 'https://firestore.googleapis.com/v1/projects/medina-consultores/databases/(default)/documents/ticket/'.$cel.'?updateMask.fieldPaths=fecha_ultima';
		$data = array(
			"fields" => array(
				"fecha_ultima" => array("stringValue" => $fecha)
			)
		);


		if($cont != ""){//validar si viene contador de msj

			$url = 'https://firestore.googleapis.com/v1/projects/medina-consultores/databases/(default)/documents/ticket/'.$cel.'?updateMask.fieldPaths=fecha_ultima&updateMask.fieldPaths=cont_msj';

			$data = array(
				"fields" => array(
					"fecha_ultima" => array("stringValue" => $fecha),
					"cont_msj" => array("integerValue" => $cont)
				)
			);

		}

		$jsonData = json_encode($data);

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL 				=> $url,
		  CURLOPT_RETURNTRANSFER 	=> true,
		  CURLOPT_ENCODING 			=> '',
		  CURLOPT_MAXREDIRS 		=> 10,
		  CURLOPT_TIMEOUT 			=> 0,
		  CURLOPT_FOLLOWLOCATION 	=> true,
		  CURLOPT_HTTP_VERSION 		=> CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST 	=> 'PATCH',
		  CURLOPT_POSTFIELDS 		=> $jsonData,
		  CURLOPT_HTTPHEADER 		=> array(
			'Content-Type: application/json'
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		// var_dump($response);

	}//termina updateTicketFirestore

	public function insertConversacionFirestore($estatus, $url, $cel, $mensaje, $tipo, $type_file, $id_ticket){

		date_default_timezone_set('America/Mexico_City');
		$fecha_hoy  = date("Y-m-d H:i:s");

		$curl 		= curl_init();

		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://firestore.googleapis.com/v1/projects/medina-consultores/databases/(default)/documents/conversacion?key=AIzaSyBuNiBTW2QipNlAzizdANaZqfY6iyRJ7sM',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS =>'{"fields":
			{ 
			"estatus": {"integerValue" : '.$estatus.'},
			"fecha": {"stringValue" :"'.$fecha_hoy.'"},
			"fecha_msj": {"stringValue" :"'.$fecha_hoy.'"},
			"file_img": {"stringValue" :"'.$url.'"},
			"cel": {"stringValue" :"'.$cel.'"},
			"mensaje": {"stringValue" :"'.$mensaje.'"},
			"tipo": {"integerValue" : '.$tipo.'},
			"type_file": {"integerValue" : '.$type_file.'},
			"id_ticket": {"integerValue" : '.$id_ticket.'}
			}
		}

		',
		CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		),
		));

		$response = curl_exec($curl);

		curl_close($curl);

	}//termina insertConversacionFirestore

	public function validar_fecha($fecha){

		$fecha 		= str_replace("/", "-", $fecha);
		$valores 	= explode('-', $fecha);

		$fecha_f 	= "";
		$respuesta 	= 500;

		if(count($valores) == 3 && (checkdate($valores[1], $valores[0], $valores[2]) || checkdate($valores[1], $valores[2], $valores[0]))){

			if(strlen($valores[2]) == 4 || strlen($valores[0]) == 4){

				if(checkdate($valores[1], $valores[0], $valores[2])){
					$fecha_f 	= $valores[2]."-".$valores[1]."-".$valores[0];
					$respuesta 	= 200;
				}else {
					$fecha_f 	= $valores[0]."-".$valores[1]."-".$valores[2];
					$respuesta 	= 200;
				}
			}

		}

		return array("fecha" => $fecha_f, "respuesta" => $respuesta);
		
	}//termina validar_fecha

	public function correoPostulacion($id_candidato, $id_vacante, $correos){

		$preguntas_respuestas 	= $this->ChatbotModel->getPreguntasRespuestasPostulacion($id_candidato, $id_vacante);

		$tabla 	= '<table border=2>
					<thead>
					<tr align="center">
					<th>#</th>
					<th>PREGUNTA</th>
					<th>RESPUESTA</th>
				</tr></thead>';

		$tabla .= '<tbody>';

		$cont   			= 1;

		if(!is_null($preguntas_respuestas)){// TRAER PREGUNTAS Y RESPUESTAS DE POSTULACIÓN
			foreach ($preguntas_respuestas as $v) {

				$tabla 		.= '<tr>';
				$tabla 		.= '<td>'.$cont.'</td>';
				$tabla 		.= '<td>'.$v->pregunta.'</td>';
				$tabla 		.= '<td>'.$v->respuesta.'</td>';
				$tabla 		.= '</tr>';
				$cont++;

			}

		}//preguntas_respuestas

		$tabla .= '</table>';

		$datosPostulacion 	= $this->ChatbotModel->getDatosCandidatoVacante($id_candidato, $id_vacante);
		$nombre_candidato 	= "";
		$fecha_nacimiento 	= "";
		$celular_candidato 	= "";
		$escolaridad		= "";
		$nombre_vacante 	= "";
		$fecha_postulacion 	= "";
		$es_viable 			= "";
		$correo_reclutador 	= "";
		$nombre_reclutador 	= "";

		if(!is_null($datosPostulacion)){

			$nombre_candidato 	= $datosPostulacion->nombre_candidato;
			$fecha_nacimiento 	= $datosPostulacion->fecha_nacimiento;
			$celular_candidato 	= $datosPostulacion->celular_candidato;
			$escolaridad 		= $datosPostulacion->escolaridad;
			$nombre_vacante 	= $datosPostulacion->nombre;
			$fecha_postulacion 	= $datosPostulacion->fecha_postulacion;
			$es_viable 			= $datosPostulacion->es_viable;
			$correo_reclutador 	= $datosPostulacion->correo;
			$nombre_reclutador 	= $datosPostulacion->nombre_reclutador;
			
		}//datosPostulacion

		// $correos = "sales@raasmex.com";

		// $reclutadoresVacante = $this->ChatbotModel->getReclutadoresVacante($id_vacante);

		// if(!is_null($reclutadoresVacante)){
		// 	foreach ($reclutadoresVacante as $v) {

		// 		if(!is_null($v->correo) && $v->correo != ""){
		// 			$correos .= ", ".$v->correo;
		// 		}

		// 	}//foreach
		// }

		$mnsj = "Hola, <strong>RECLUTADOR</strong>.<br><br>Un nuevo candidato se ha postulado a la vacante de <strong>".$nombre_vacante."</strong>, aquí te muestro sus datos. 
		<br><br>";
		$mnsj .= '<section>
				<h3>Datos</h3>
				<ul>
				<li type="disc">Nombre Candidato: <strong>'.$nombre_candidato.'</strong></li>
				<li type="disc">WhatsApp: <strong>'.$celular_candidato.'</strong></li>
				<li type="disc">Fecha Nacimiento: <strong>'.$fecha_nacimiento.'</strong></li>
				<li type="disc">Escolaridad: <strong>'.$escolaridad.'</strong></li>
				<li type="disc">Vacante: <strong>'.$nombre_vacante.'</strong></li>
				<li type="disc">Fecha Postulación: <strong>'.$fecha_postulacion.'</strong></li>
				<li type="disc">¿Es viable?: <strong>'.$es_viable.'</strong></li>
				<li type="disc">Preguntas/Respuestas:</li>
				</ul>
				</section><br><br>'.$tabla.'';

		$subject = "MÉDINA CONSULTORES - NUEVA POSTULACIÓN";

		$this->sendCorreo($correos, $mnsj, $subject);

	}//termina correoPostulacion

	public function sendCorreo($correos, $body, $subject){

		$data = array (
			'From' 			=> '[MÉDINA] notificaciones@raasmex.com.mx',
			'To' 			=> ''.$correos.'',
			'Subject' 		=> ''.$subject.'',
			'HtmlBody' 		=> ''.$body.'',
			'MessageStream' => 'outbound'
		);

		$json_body = json_encode($data);

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://api.postmarkapp.com/email',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => $json_body,
			CURLOPT_HTTPHEADER => array(
				'Accept: application/json',
				'Content-Type: application/json',
				'X-Postmark-Server-Token: 4170a46f-510b-4331-849c-52d7787013d7'
			),
		));

		$response = curl_exec($curl);

		// echo var_dump($response);

		curl_close($curl);

		$json 		= json_decode($response);
		$errorCode 	= $json->ErrorCode;

		if($errorCode == 0) {
			return true;
		}else {
			return false;
		}

	}//termina sendCorreo

	public function obtenerExtensionURL($url){

		$path_info = pathinfo($url);
		$extension = $path_info['extension'];
		return $extension;

	}//termina obtenerExtensionURL

	public function obtenerExtension($url) {

		// $url = 'https://filemanager.gupshup.io/wa/00cff84f-92c0-422a-a22e-fbdd9a0bfdfe/wa/media/1429712067656517?download=false&fileName=Temas+Sensibles.pdf';

		$query = parse_url($url, PHP_URL_QUERY);
		
		parse_str($query, $params);
		$filename  = $params['fileName'];
		$parts     = explode('.', $filename);
		$extension = end($parts);
		
		return $extension;

	}

	public function fileDownload($url, $destination){

		$fp = fopen ($destination, 'w+');
		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $url );
		curl_setopt( $ch, CURLOPT_BINARYTRANSFER, true );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, false );
		curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
	   
		curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 10 );
		curl_setopt( $ch, CURLOPT_FILE, $fp );
		$result = curl_exec( $ch );
		curl_close( $ch );
		fclose( $fp );
	   
	   if ($result) {
		   return true;
	   }else{

		   return false;
	   }
		
  }//termina fileDownload

  public function pruebaChatbot(){

	die("Sin servicio");

	$usuario_carrusel = $this->ChatbotModel->getCarruselVacante(6);

	echo $usuario_carrusel->correo;

	$datos = $this->ChatbotModel->getReclutadoresVacante(6);

	die(var_dump($datos));

  }//termina pruebaChatbot

}