<?php

namespace App\Models;
use CodeIgniter\Model;

class VacantesModel extends Model{

    protected $table = 'vacantes';

    public function getVacantes(){

      $query = $this->query("SELECT v.*,ca.categoria,cl.nombre_cliente,
      (SELECT COUNT(vcr.id_vacante_candidato_reclutador)
      FROM vacante_candidato_reclutador vcr
      WHERE vcr.id_vacante=v.id_vacante) AS postulaciones
      FROM vacantes v
      INNER JOIN categorias ca ON v.id_categoria=ca.id_categoria
      INNER JOIN clientes cl ON v.id_cliente=cl.id_cliente 
      ORDER BY v.id_vacante DESC");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

	  }//termina getVacantes

    public function getVacantesReclutador($idUsuario){

      $query = $this->query("SELECT vr.*, v.*,ca.categoria, (SELECT COUNT(vcr.id_vacante_candidato_reclutador)
      FROM vacante_candidato_reclutador vcr
      WHERE vcr.id_vacante=vr.id_vacante) AS postulaciones
      FROM vacante_reclutador vr
      INNER JOIN vacantes v ON vr.id_vacante=v.id_vacante
      INNER JOIN categorias ca ON v.id_categoria=ca.id_categoria
      WHERE vr.id_reclutador=(SELECT id_reclutador FROM reclutadores WHERE id_usuario='$idUsuario')
      ORDER BY vr.id_vacante DESC;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getVacantesReclutador

    public function getDatosVacantes($idVacante){

      $query = $this->query("SELECT * FROM vacantes v WHERE v.id_vacante='$idVacante';");

      return($query->getNumRows() <= 0) ? null: $query->getRow();

    }//termina getDatosVacantes

    public function getCategorias(){

      $query = $this->query("SELECT * FROM categorias ca WHERE ca.estatus = 1 ORDER BY ca.id_categoria ASC;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getCategorias

    public function getClientes(){

      $query = $this->query("SELECT * FROM clientes c WHERE c.estatus_cliente = 1;");

      return ($query->getNumRows() <= 0) ? null : $query->getResult();

    }//termina getClientes

    public function getReclutadores(){

      $query = $this->query("SELECT * FROM reclutadores r WHERE r.estatus_reclutador=1 ORDER BY r.id_reclutador ASC");

      return ($query->getNumRows() <= 0) ? null : $query->getResult();
  
    }//termina getReclutadores

    public function getReclutadoresVacante($idVacante){

      $query = $this->query("SELECT * FROM vacante_reclutador r WHERE r.id_vacante='$idVacante'");

      return ($query->getNumRows() <= 0) ? null : $query->getResult();

    }//termina getReclutadoresVacante

    public function getReclutador($idReclutador){

      $query = $this->query("SELECT * FROM reclutadores r WHERE r.id_reclutador='$idReclutador';");

      return ($query->getNumRows() <= 0) ? NULL : $query->getRow();

    }//termina getReclutador

    public function reclutadorIdUsuario($idUsuario){

      $query = $this->query("SELECT * FROM reclutadores r WHERE r.id_usuario='$idUsuario';");

      return ($query->getNumRows() <= 0) ? NULL : $query->getRow();

    }//termina reclutadorIdUsuario

    public function getPreguntasVacante($idVacante){

      $query = $this->query("SELECT * FROM pregunta_vacante p WHERE p.id_vacante='$idVacante' AND p.estatus=1
      ORDER BY p.id_pregunta_vacante ASC");

      return ($query->getNumRows() <= 0) ? null : $query->getResult();

    }//termina getPreguntasVacante

    public function opcionesMultiples($id_pregunta_vacante){

      $query = $this->query("SELECT * FROM opciones_multiples o WHERE o.id_pregunta_vacante='$id_pregunta_vacante' ORDER BY o.id_opcion_multiple ASC");

      return ($query->getNumRows() <= 0) ? null : $query->getResult();

    }//termina opcionesMultiples

    public function getNoPostulaciones(){

      $query = $this->query("SELECT np.*, p.fecha_inicio, c.nombre_candidato, c.celular_candidato, v.nombre
      FROM no_continuo_proceso np 
      INNER JOIN candidatos c ON np.id_candidato=c.id_candidato
      INNER JOIN vacantes v ON np.id_vacante=v.id_vacante
      INNER JOIN pregunta p ON p.celular = c.celular_candidato
      ORDER BY np.id_no_continuo_proceso DESC LIMIT 1000;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getNoPostulaciones

    public function getNoPostulacionesFiltrar($inicio, $fin){

      $query = $this->query("SELECT np.*,c.nombre_candidato, p.fecha_inicio, c.celular_candidato, v.nombre FROM no_continuo_proceso np 
      INNER JOIN candidatos c ON np.id_candidato=c.id_candidato
      INNER JOIN vacantes v ON np.id_vacante=v.id_vacante
      INNER JOIN pregunta p ON p.celular = c.celular_candidato
      WHERE DATE(np.fecha_registro) BETWEEN '$inicio' AND '$fin'
      ORDER BY np.id_no_continuo_proceso DESC;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getNoPostulacionesFiltrar

    public function noPostulacionesReclutador($idUsuario){

      $query = $this->query("SELECT np.*,c.nombre_candidato, p.fecha_inicio, c.celular_candidato, v.nombre FROM no_continuo_proceso np 
      INNER JOIN candidatos c ON np.id_candidato=c.id_candidato
      INNER JOIN vacantes v ON np.id_vacante=v.id_vacante
      INNER JOIN pregunta p ON p.celular = c.celular_candidato
      WHERE np.id_vacante IN (SELECT id_vacante FROM vacante_reclutador WHERE id_reclutador =(SELECT id_reclutador FROM reclutadores WHERE id_usuario='$idUsuario'))
      ORDER BY np.id_no_continuo_proceso DESC LIMIT 1000;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina noPostulacionesReclutador

    public function noPostulacionesReclutadorFiltrar($inicio, $fin, $idUsuario){

      $query = $this->query("SELECT np.*,c.nombre_candidato, p.fecha_inicio, c.celular_candidato, v.nombre FROM no_continuo_proceso np 
      INNER JOIN candidatos c ON np.id_candidato=c.id_candidato
      INNER JOIN vacantes v ON np.id_vacante=v.id_vacante
      INNER JOIN pregunta p ON p.celular = c.celular_candidato
      WHERE np.id_vacante IN (SELECT id_vacante FROM vacante_reclutador WHERE id_reclutador =(SELECT id_reclutador FROM reclutadores WHERE id_usuario='$idUsuario'))
      AND DATE(np.fecha_registro) BETWEEN '$inicio' AND '$fin'
      ORDER BY np.id_no_continuo_proceso DESC;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina noPostulacionesReclutadorFiltrar

    public function getPostuladosVacante($idVacante){

      $query = $this->query("SELECT * FROM vacante_candidato_reclutador vc
      INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
      LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
      WHERE vc.id_vacante='$idVacante' ORDER BY vc.id_vacante_candidato_reclutador ASC;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getPostuladosVacante

    public function getPostuladosVacanteReclutador($idVacante, $idUsuario){

       $query = $this->query("SELECT * FROM vacante_candidato_reclutador vc INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
        LEFT JOIN reclutadores r ON vc.id_reclutador=r.id_reclutador
        WHERE vc.id_vacante='$idVacante' AND (vc.id_reclutador=(SELECT id_reclutador FROM reclutadores 
        WHERE id_usuario='$idUsuario') OR vc.id_reclutador IS NULL)
        ORDER BY vc.id_vacante_candidato_reclutador ASC;");

		  return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getPostuladosVacanteReclutador

    public function getPreguntasRespuestasCandidato($idVacante, $idCandidato){

      $query = $this->query("SELECT pv.pregunta, rv.respuesta, IF(om.descarte = 1, 'SI', 'NO') descarte
      FROM respuesta_vacante rv
      INNER JOIN pregunta_vacante pv ON pv.id_pregunta_vacante = rv.id_pregunta_vacante
      LEFT JOIN opciones_multiples om ON om.id_pregunta_vacante = pv.id_pregunta_vacante AND rv.respuesta = om.opcion
      WHERE pv.id_vacante = ? AND rv.id_candidato = ?
      ORDER BY rv.id_respuesta_vacante ASC", array($idVacante, $idCandidato));

		  return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina getPreguntasRespuestasCandidato

    public function getAbandonaronProceso($inicio, $fin){

      $query = $this->query("CALL `sp_candidatos_abandonados`('".$inicio."', '".$fin."');");

      $result = ($query->getNumRows() <= 0) ? null : $query->getResult();

      $query->freeResult();// liberar sp

      return $result;

    }//termina getAbandonaronProceso

    // ========== INSERTS ==========
  
    public function insertarVacante($vacante){

        $query = $this->db->table('vacantes');
        $query->insert($vacante);

        return $this->db->insertID();

    }//termina insertarVacante

    public function insertarPreguntaVacante($insertPregunta){

        $query = $this->db->table('pregunta_vacante');
        $query->insert($insertPregunta);

        return $this->db->insertID();

    }//termina insertarPreguntaVacante

    public function insertarOpcionPregunta($insertOpcion){

        $query = $this->db->table('opciones_multiples');
        $query->insert($insertOpcion);

        return $this->db->insertID();

    }//termina insertarOpcionPregunta

    public function insertarVacanteReclutador($vacanteReclutador){

        $query = $this->db->table('vacante_reclutador');
        $query->insert($vacanteReclutador);

        return $this->db->insertID();

    }//termina insertarVacanteReclutador

    // ========== UPDATES ==========

    public function actualizarVacante($idVacante,$updateVacante){

        $query = $this->db->table('vacantes');
        $query->where('id_vacante', $idVacante);
        $query->update($updateVacante);

        return true;

    }//termina actualizarVacante

    public function updateVacanteReclutador($idVacante, $idReclutador, $updateVacante){

      $query = $this->db->table('vacante_reclutador');
      $query->where('id_vacante', $idVacante);
      $query->where('id_reclutador', $idReclutador);
      $query->update($updateVacante);

      return true;

    }//termina updateVacanteReclutador

    public function actualizarPreguntaVacante($actualizarPregunta, $id_pregunta_vacante){

        $query = $this->db->table('pregunta_vacante');
        $query->where('id_pregunta_vacante', $id_pregunta_vacante);
        $query->update($actualizarPregunta);

        return true;

    }//termina actualizarPreguntaVacante

    public function actualizarVacanteReclutador($url_qr, $idVacante, $idReclutador){

      $this->query("UPDATE vacante_reclutador SET url_qr='$url_qr' WHERE id_vacante='$idVacante' AND id_reclutador='$idReclutador'");

      return true;

    }//termina actualizarVacanteReclutador

    public function updateOpcion($update, $id_opcion){

      $query = $this->db->table('opciones_multiples');
      $query->where('id_opcion_multiple', $id_opcion);
      $query->update($update);

      return true;

    }//termina updateOpcion

    public function eliminarOpcion($id_opcion){

      $this->query("DELETE FROM opciones_multiples WHERE id_opcion_multiple='$id_opcion'");

      return true;

    }//termina eliminarOpcion

    public function eliminarReclutadores($idVacante){

      $this->query("DELETE FROM vacante_reclutador WHERE id_vacante='$idVacante';");

      return true;

    }//termina eliminarReclutadores

}